/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.TicketFiscalTerceiros;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoLoteFabricacaoImpl
extends DaoGenericEntityImpl<LoteFabricacao, Long> {
    public LoteFabricacao findLoteUnico(GradeCor gradeCor) {
        return this.findLoteUnico(gradeCor.getProdutoGrade().getProduto().getIdentificador());
    }

    public LoteFabricacao findLoteUnico(Long idProduto) {
        Criteria criteria = this.criteria();
        criteria.createAlias("produto", "p");
        criteria.add((Criterion)Restrictions.eq((String)"p.identificador", (Object)idProduto));
        criteria.add((Criterion)Restrictions.eq((String)"unico", (Object)1));
        return (LoteFabricacao)this.toUnique(criteria);
    }

    public LoteFabricacao findLoteFabricacao(Produto produto, String loteFabricacao) {
        String query = "select distinct l   from LoteFabricacao l  where l.loteFabricacao = :lote and l.produto = :produto";
        Query q = this.query(query);
        q.setString("lote", loteFabricacao);
        q.setEntity("produto", (Object)produto);
        q.setMaxResults(1);
        return (LoteFabricacao)q.uniqueResult();
    }

    public List<LoteFabricacao> findLoteFabricacao(Long idProduto) {
        Criteria c = this.criteria();
        c.createAlias("produto", "p");
        c.add(this.eq("p.identificador", idProduto));
        return c.list();
    }

    public List<TicketFiscalTerceiros> findTicketFiscalTerceirosVinculado(LoteFabricacao lote) {
        String query = "SELECT t FROM TicketFiscalTerceiros t where t.loteFabricacao = :lote";
        Query q = this.query(query);
        q.setEntity("lote", (Object)lote);
        return q.list();
    }

    public List<LoteFabricacao> getLotes(Long idProduto, String typed, boolean useIlike) {
        Criteria criteria = this.criteria();
        criteria.createAlias("produto", "p");
        criteria.add(this.eq("p.identificador", idProduto));
        if (useIlike) {
            criteria.add(this.ilike("loteFabricacao", typed));
        } else {
            criteria.add(this.likeRight("loteFabricacao", typed));
        }
        return this.toList(criteria);
    }

    public LoteFabricacao getLote(Long idProduto, String loteFabricacao) {
        Criteria criteria = this.criteria();
        criteria.add(this.eq("produto.identificador", idProduto));
        criteria.add(this.eq("loteFabricacao", loteFabricacao));
        return (LoteFabricacao)this.toUnique(criteria);
    }
}

