/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.mdfe.EnumConstMDFeStatus;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ManifestoCteEletronico;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.VersaoManifestoCte;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.centraldocsproprios.DTOCentralDocsPropriosMDFe;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import org.hibernate.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoManifestoCteEletronicoImpl
extends DaoGenericEntityImpl<ManifestoCteEletronico, Long> {
    public List<ManifestoCteEletronico> getManifestoCteEletronicoNaoEncerradosPorEmpresa(Empresa empresa) {
        org.hibernate.query.Query q = this.query("SELECT m FROM ManifestoCteEletronico m WHERE m.empresa = :empresa AND   m.status  = :status ORDER BY m.numero");
        q.setEntity("empresa", (Object)empresa);
        q.setShort("status", (short)100);
        return this.toList((Query)q);
    }

    public List<DTOCentralDocsPropriosMDFe> getMdfes(Integer regsPerPage, Integer page, GrupoEmpresa grupoEmpresa, Pessoa pessoa, Short filtrarData, Date dataInicial, Date dataFinal, Short filtrarNr, Long numero, Short filtrarChave, String chave) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jEmpresa = aux.join("empresa");
        Join jEmpresaDados = aux.join((From)jEmpresa, "empresaDados");
        Join jEmpresaPessoa = aux.join((From)jEmpresa, "pessoa");
        Join jEmpresaPessoaComp = aux.join((From)jEmpresaPessoa, "complemento");
        Join jContratante = aux.joinLeft("manifestoCteContratante");
        Join jClientePessoa = aux.joinLeft((From)jContratante, "pessoa");
        Join jClientePessoaComp = aux.joinLeft((From)jClientePessoa, "complemento");
        Join jNfe = aux.joinLeft("nfe");
        Join jNfeNfe = aux.joinLeft((From)jNfe, "nfe");
        Join jUnidFatCli = aux.joinLeft((From)jNfeNfe, "unidadeFatCliente");
        Join jUnidFatCliCli = aux.joinLeft((From)jUnidFatCli, "cliente");
        Join jCte = aux.joinLeft("cte");
        Join jCteCte = aux.joinLeft((From)jCte, "cte");
        Join jCteCteTomador = aux.joinLeft((From)jCteCte, "clienteTomador");
        Join jCteCteTomadorCli = aux.joinLeft((From)jCteCteTomador, "cliente");
        aux.equal((From)jEmpresaDados, "grupoEmpresa", grupoEmpresa);
        aux.or(aux.getEqual((From)jUnidFatCliCli, "pessoa", pessoa), aux.getEqual((From)jCteCteTomadorCli, "pessoa", pessoa), aux.getEqual((From)jContratante, "pessoa", pessoa));
        LinkedList status = new LinkedList();
        EnumConstMDFeStatus.getStatusFinalList().forEach(i -> status.add((short)i.getValue()));
        aux.inNumber("status", status);
        if (ToolMethods.isAffirmative((Number)filtrarChave)) {
            aux.equal("chaveManifestoCte", chave);
        }
        if (ToolMethods.isAffirmative((Number)filtrarNr)) {
            aux.equal("numero", numero);
        }
        if (ToolMethods.isAffirmative((Number)filtrarData)) {
            aux.between("dataEmissao", dataInicial, (Comparable)ToolDate.getLastDateOnDay((Date)dataFinal));
        }
        aux.setMaxResults(regsPerPage);
        aux.setFirstResult(page * regsPerPage);
        aux.orderDesc("dataEmissao");
        aux.select(AuxCriteriaBuilder.pair("identificador", "F_ID_NOTA_PROPRIA"), AuxCriteriaBuilder.pair("numero", "F_NUMERO"), AuxCriteriaBuilder.pair("serie", "F_SERIE"), AuxCriteriaBuilder.pair("dataEmissao", "F_DATA_EMISSAO"), AuxCriteriaBuilder.pair("chaveManifestoCte", "F_CHAVE"), AuxCriteriaBuilder.pair("status", "F_STATUS"), AuxCriteriaBuilder.pair("motivo", "F_STATUS_STR"), AuxCriteriaBuilder.pair("valorTotalCarga", "F_VALOR"), AuxCriteriaBuilder.pair((From)jEmpresaPessoa, "nome", "F_EMITENTE"), AuxCriteriaBuilder.pair((From)jEmpresaPessoa, "nomeFantasia", "F_EMITENTE_NOME_FANTASIA"), AuxCriteriaBuilder.pair((From)jEmpresaPessoaComp, "cnpj", "F_CNPJ_EMITENTE"), AuxCriteriaBuilder.pair((From)jClientePessoa, "nome", "F_DESTINATARIO"), AuxCriteriaBuilder.pair((From)jClientePessoa, "nomeFantasia", "F_DEST_NOME_FANTASIA"), AuxCriteriaBuilder.pair((From)jClientePessoaComp, "cnpj", "F_CNPJ_DESTINATARIO"));
        List<Map<String, Object>> res = aux.getResultMap();
        LinkedList<DTOCentralDocsPropriosMDFe> ret = new LinkedList<DTOCentralDocsPropriosMDFe>();
        for (Map<String, Object> map : res) {
            DTOCentralDocsPropriosMDFe d = new DTOCentralDocsPropriosMDFe();
            d.setIdentificador((Long)map.get("F_ID_NOTA_PROPRIA"));
            d.setNumeroDoc((Number)map.get("F_NUMERO"));
            d.setSerieDoc((String)map.get("F_SERIE"));
            d.setDataEmissao((Date)map.get("F_DATA_EMISSAO"));
            d.setChave((String)map.get("F_CHAVE"));
            d.setValor((Double)map.get("F_VALOR"));
            d.setEmitente((String)map.get("F_EMITENTE"));
            d.setCnpjEmitente((String)map.get("F_CNPJ_EMITENTE"));
            d.setEmitenteNomeFantasia((String)map.get("F_EMITENTE_NOME_FANTASIA"));
            d.setCnpjContratanteTomador((String)map.get("F_CNPJ_DESTINATARIO"));
            d.setContratante((String)map.get("F_DESTINATARIO"));
            d.setContratanteNomeFantasia((String)map.get("F_DEST_NOME_FANTASIA"));
            d.setStatusSefaz((Short)map.get("F_STATUS"));
            d.setStatusSefazStr((String)map.get("F_STATUS_STR"));
            ret.add(d);
        }
        return ret;
    }

    public VersaoManifestoCte getVersaoEmissao(Long idManifesto) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        aux.equal("identificador", idManifesto);
        aux.select("versaoManifestoCte");
        return (VersaoManifestoCte)aux.getUniqueResult();
    }

    public String getChave(Long idManifesto) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        aux.equal("identificador", idManifesto);
        aux.select("chaveManifestoCte");
        return (String)aux.getUniqueResult();
    }
}

