/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ExamePeriodo;
import com.touchcomp.basementor.model.vo.ManutencaoRotinasPeriodicasPessoas;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Veiculo;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoManutencaoRotinasPeriodicasPessoasImpl
extends DaoGenericEntityImpl<ManutencaoRotinasPeriodicasPessoas, Long> {
    public List pesquisarRotinasPeriodicasSemManutencaoFuncao(ExamePeriodo rotinaPeriodica, Colaborador colaborador, Short filtrarEmpresa, Empresa empresa) {
        Object hql = "SELECT DISTINCT c FROM Colaborador c WHERE c.ativo        = :ativo AND   c.dataDemissao IS NULL";
        if (ToolMethods.isEquals((Object)filtrarEmpresa, (Object)1)) {
            hql = (String)hql + " AND (c.empresa = :empresa)\n";
        }
        hql = (String)hql + " AND EXISTS ( SELECT DISTINCT e FROM ExamePeriodo e INNER JOIN e.funcoes f WHERE e        = :rotinaPeriodica AND   f.funcao = c.funcao) AND NOT EXISTS ( SELECT DISTINCT i FROM ItemManutencaoRotinasPessoas i WHERE i.pessoa = c.pessoa AND   i.rotina = :rotinaPeriodica)";
        if (colaborador != null) {
            hql = (String)hql + " AND c = :colaborador";
        }
        hql = (String)hql + " ORDER BY c.pessoa.nome";
        org.hibernate.query.Query q = this.query((String)hql);
        q.setShort("ativo", EnumConstantsMentorSimNao.SIM.value);
        q.setEntity("rotinaPeriodica", (Object)rotinaPeriodica);
        if (colaborador != null) {
            q.setEntity("colaborador", (Object)colaborador);
        }
        if (ToolMethods.isEquals((Object)filtrarEmpresa, (Object)1)) {
            q.setEntity("empresa", (Object)empresa);
        }
        return this.toList((Query)q);
    }

    public List pesquisarRotinasPeriodicasSemManutencaoPessoa(ExamePeriodo rotinaPeriodica, Pessoa pessoa) {
        Object hql = "SELECT DISTINCT p FROM Pessoa p WHERE p.ativo = :ativo AND EXISTS ( SELECT DISTINCT e FROM ExamePeriodo e INNER JOIN e.pessoas s WHERE e        = :rotinaPeriodica AND   s.pessoa = p) AND NOT EXISTS ( SELECT DISTINCT i FROM ItemManutencaoRotinasPessoas i WHERE i.pessoa = p AND   i.rotina = :rotinaPeriodica)";
        if (pessoa != null) {
            hql = (String)hql + " AND p = :pessoa";
        }
        hql = (String)hql + " ORDER BY p.nome";
        org.hibernate.query.Query q = this.query((String)hql);
        q.setShort("ativo", EnumConstantsMentorSimNao.SIM.value);
        q.setEntity("rotinaPeriodica", (Object)rotinaPeriodica);
        if (pessoa != null) {
            q.setEntity("pessoa", (Object)pessoa);
        }
        return this.toList((Query)q);
    }

    public List pesquisarRotinasPeriodicasSemManutencaoVeiculo(ExamePeriodo rotinaPeriodica, Veiculo veiculo) {
        Object hql = "SELECT DISTINCT v FROM Veiculo v WHERE v.ativo = :ativo AND EXISTS ( SELECT DISTINCT e FROM ExamePeriodo e INNER JOIN e.veiculos s WHERE e        = :rotinaPeriodica AND   s.veiculo = v) AND NOT EXISTS ( SELECT DISTINCT i FROM ItemManutencaoRotinasPessoas i WHERE i.veiculo = v AND   i.rotina = :rotinaPeriodica)";
        if (veiculo != null) {
            hql = (String)hql + " AND v = :veiculo";
        }
        hql = (String)hql + " ORDER BY v.placa";
        org.hibernate.query.Query q = this.query((String)hql);
        q.setShort("ativo", EnumConstantsMentorSimNao.SIM.value);
        q.setEntity("rotinaPeriodica", (Object)rotinaPeriodica);
        if (veiculo != null) {
            q.setEntity("veiculo", (Object)veiculo);
        }
        return this.toList((Query)q);
    }

    public List pesquisarRotinasPeriodicasManutencaoFuncaoVencida(ExamePeriodo rotinaPeriodica, Date dataApuracao, Colaborador colaborador) {
        Object hql = "SELECT i FROM ItemManutencaoRotinasPessoas i INNER JOIN i.rotina r INNER JOIN i.pessoa o WHERE r = :rotinaPeriodica";
        if (colaborador != null) {
            hql = (String)hql + " AND o = :pessoa";
        }
        if (ToolMethods.isEquals((Object)colaborador, null)) {
            hql = (String)hql + " AND i.dataVencimento < :dataApuracao";
        }
        hql = (String)hql + " AND r.nrOcorrencia > ( SELECT COUNT(t) FROM ItemManutencaoRotinasPessoas t WHERE t.pessoa = i.pessoa AND t.rotina = :rotinaPeriodica) AND EXISTS ( SELECT DISTINCT c FROM Colaborador c WHERE c.ativo        = :ativo AND   c.dataDemissao IS NULL";
        if (colaborador != null) {
            hql = (String)hql + " AND c = :colaborador";
        }
        hql = (String)hql + " AND EXISTS ( SELECT DISTINCT e FROM ExamePeriodo e INNER JOIN e.funcoes f WHERE e        = :rotinaPeriodica AND   f.funcao = c.funcao)) AND NOT EXISTS ( SELECT a.identificador FROM ItemManutencaoRotinasPessoas a WHERE a.itemAnterior = i) ORDER BY i.pessoa.nome";
        org.hibernate.query.Query q = this.query((String)hql);
        q.setShort("ativo", EnumConstantsMentorSimNao.SIM.value);
        q.setEntity("rotinaPeriodica", (Object)rotinaPeriodica);
        if (ToolMethods.isEquals((Object)colaborador, null)) {
            q.setDate("dataApuracao", dataApuracao);
        }
        if (colaborador != null) {
            q.setEntity("colaborador", (Object)colaborador);
            q.setEntity("pessoa", (Object)colaborador.getPessoa());
        }
        return this.toList((Query)q);
    }

    public List pesquisarRotinasPeriodicasManutencaoPessoaVencida(ExamePeriodo rotinaPeriodica, Date dataApuracao, Pessoa pessoa) {
        Object hql = "SELECT i FROM ItemManutencaoRotinasPessoas i INNER JOIN i.rotina r INNER JOIN i.pessoa o WHERE r = :rotinaPeriodica";
        if (pessoa != null) {
            hql = (String)hql + " AND o = :pessoa";
        }
        if (ToolMethods.isEquals((Object)pessoa, null)) {
            hql = (String)hql + " AND i.dataVencimento < :dataApuracao";
        }
        hql = (String)hql + " AND r.nrOcorrencia > ( SELECT COUNT(t) FROM ItemManutencaoRotinasPessoas t WHERE t.pessoa = i.pessoa AND t.rotina = :rotinaPeriodica) AND EXISTS ( SELECT DISTINCT p FROM Pessoa p WHERE p.ativo = :ativo";
        if (pessoa != null) {
            hql = (String)hql + " AND p = :pessoa";
        }
        hql = (String)hql + " AND EXISTS ( SELECT DISTINCT e FROM ExamePeriodo e INNER JOIN e.pessoas s WHERE e        = :rotinaPeriodica AND   s.pessoa = p)) AND NOT EXISTS ( SELECT a.identificador FROM ItemManutencaoRotinasPessoas a WHERE a.itemAnterior = i) ORDER BY i.pessoa.nome";
        org.hibernate.query.Query q = this.query((String)hql);
        q.setShort("ativo", EnumConstantsMentorSimNao.SIM.value);
        q.setEntity("rotinaPeriodica", (Object)rotinaPeriodica);
        if (ToolMethods.isEquals((Object)pessoa, null)) {
            q.setDate("dataApuracao", dataApuracao);
        }
        if (pessoa != null) {
            q.setEntity("pessoa", (Object)pessoa);
        }
        return this.toList((Query)q);
    }

    public List pesquisarRotinasPeriodicasManutencaoVeiculoVencida(ExamePeriodo rotinaPeriodica, Date dataApuracao, Veiculo veiculo) {
        Object hql = "SELECT i FROM ItemManutencaoRotinasPessoas i INNER JOIN i.rotina r INNER JOIN i.veiculo u WHERE r = :rotinaPeriodica";
        if (veiculo != null) {
            hql = (String)hql + " AND u = :veiculo";
        }
        if (ToolMethods.isEquals((Object)veiculo, null)) {
            hql = (String)hql + " AND i.dataVencimento < :dataApuracao";
        }
        hql = (String)hql + " AND r.nrOcorrencia > ( SELECT COUNT(t) FROM ItemManutencaoRotinasPessoas t WHERE t.veiculo = i.veiculo AND t.rotina = :rotinaPeriodica) AND EXISTS ( SELECT DISTINCT v FROM Veiculo v WHERE v.ativo = :ativo";
        if (veiculo != null) {
            hql = (String)hql + " AND v = :veiculo";
        }
        hql = (String)hql + " AND EXISTS ( SELECT DISTINCT e FROM ExamePeriodo e INNER JOIN e.veiculos s WHERE e        = :rotinaPeriodica AND   s.veiculo = v)) AND NOT EXISTS ( SELECT a.identificador FROM ItemManutencaoRotinasPessoas a WHERE a.itemAnterior = i) ORDER BY i.veiculo.placa";
        org.hibernate.query.Query q = this.query((String)hql);
        q.setShort("ativo", EnumConstantsMentorSimNao.SIM.value);
        q.setEntity("rotinaPeriodica", (Object)rotinaPeriodica);
        if (ToolMethods.isEquals((Object)veiculo, null)) {
            q.setDate("dataApuracao", dataApuracao);
        }
        if (veiculo != null) {
            q.setEntity("veiculo", (Object)veiculo);
        }
        return this.toList((Query)q);
    }

    public List pesquisarRotinasPeriodicasVencidasPessoa(Pessoa pessoa) {
        org.hibernate.query.Query q = this.query("SELECT MAX(i)             AS ITEM_MANUTENCAO, i.rotina.descricao AS ROTINA_PERIODICA FROM ItemManutencaoRotinasPessoas i WHERE i.pessoa = :pessoa GROUP BY i.rotina.descricao");
        q.setEntity("pessoa", (Object)pessoa);
        return this.toHashList((Query)q);
    }

    public List pesquisarRotinasPeriodicasVencidasVeiculo(Veiculo veiculo) {
        org.hibernate.query.Query q = this.query("SELECT MAX(i)             AS ITEM_MANUTENCAO, i.rotina.descricao AS ROTINA_PERIODICA FROM ItemManutencaoRotinasPessoas i WHERE i.veiculo = :veiculo GROUP BY i.rotina.descricao");
        q.setEntity("veiculo", (Object)veiculo);
        return this.toHashList((Query)q);
    }

    public List pesquisarRotinasPessoa(Pessoa pessoa) {
        org.hibernate.query.Query q = this.query("SELECT i FROM ItemManutencaoRotinasPessoas i WHERE i.pessoa = :pessoa ORDER BY i.rotina.descricao, i.dataRelizacao");
        q.setEntity("pessoa", (Object)pessoa);
        return this.toList((Query)q);
    }
}

