/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.tipopagamentonfe.EnumConstTipoPagamentoNFe;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.constants.EnumConstantsSimNao;
import java.util.List;
import org.hibernate.Criteria;
import org.springframework.stereotype.Repository;

@Repository
public class DaoMeioPagamentoImpl
extends DaoGenericEntityImpl<MeioPagamento, Long> {
    public MeioPagamento getPorTipoPagamento(String codigoTipoPagamento) {
        Criteria crit = this.criteria();
        crit.createAlias("tipoPagamentoNFe", "t");
        return (MeioPagamento)this.toUnique(this.restrictions(crit, this.eq("t.codigo", codigoTipoPagamento)));
    }

    public List<MeioPagamento> getMeiosOrdemAlfabetica() {
        return this.toList(this.order(this.criteria(), "descricao"));
    }

    public List<MeioPagamento> getAllAtivos() {
        Criteria crit = this.criteria();
        this.restrictions(crit, this.eq("ativo", EnumConstantsSimNao.SIM.value));
        this.order(this.criteria(), "descricao");
        return this.toList(crit);
    }

    public List<MeioPagamento> getAllAtivosSemPagamento() {
        Criteria crit = this.criteria();
        crit.createAlias("tipoPagamentoNFe", "t");
        this.restrictions(crit, this.eq("ativo", EnumConstantsSimNao.SIM.value));
        this.restrictions(crit, this.eq("t.codigo", EnumConstTipoPagamentoNFe.SEM_PAGAMENTO.getValue()));
        this.order(this.criteria(), "descricao");
        return this.toList(crit);
    }
}

