/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.MensagemMural;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository
public class DaoMensagemMuralImpl
extends DaoGenericEntityImpl<MensagemMural, Long> {
    public boolean existeMsgChaveAtiva(String chaveMessage) {
        Criteria c = this.criteria();
        c.add(this.eq("chaveMensagem", chaveMessage));
        c.add(this.eq("finalizado", (short)0));
        Long ret = this.countOf(c);
        return ret > 0L;
    }

    public boolean existeMsgChave(String chaveMessage) {
        Criteria c = this.criteria();
        c.add(this.eq("chaveMensagem", chaveMessage));
        Long ret = this.countOf(c);
        return ret > 0L;
    }

    public List<MensagemMural> getMensagensPublicadas(Usuario usuario, Date data) {
        Criteria c = this.criteria();
        c.createAlias("mensagemMuralMsgUsuario", "u", Criteria.LEFT_JOIN);
        c.createAlias("agendamentos", "a", Criteria.LEFT_JOIN);
        c.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"dataVencimento"), (Criterion)Restrictions.ge((String)"dataVencimento", (Object)data)));
        Conjunction conj = Restrictions.conjunction();
        conj.add((Criterion)Restrictions.eq((String)"u.usuario", (Object)usuario));
        conj.add((Criterion)Restrictions.eq((String)"finalizado", (Object)0));
        Conjunction conjAgendamentos = Restrictions.conjunction();
        conjAgendamentos.add((Criterion)Restrictions.ge((String)"a.horario", (Object)data));
        conjAgendamentos.add((Criterion)Restrictions.eq((String)"u.inativarMensagem", (Object)0));
        Disjunction dis = Restrictions.disjunction();
        dis.add((Criterion)conj);
        dis.add((Criterion)conjAgendamentos);
        c.add((Criterion)dis);
        c.setProjection(Projections.distinct((Projection)Projections.property((String)"identificador")));
        c.addOrder(Order.asc((String)"dataVencimento"));
        List ids = c.list();
        LinkedList<MensagemMural> toret = new LinkedList<MensagemMural>();
        for (Long o : ids) {
            toret.add((MensagemMural)this.get(o));
        }
        return toret;
    }
}

