/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsModeloDocFiscal;
import com.touchcomp.basementor.model.vo.CNAE;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IncidenciaIcms;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscalIcms;
import com.touchcomp.basementor.model.vo.ModeloFiscalIpi;
import com.touchcomp.basementor.model.vo.ModeloFiscalPisCofins;
import com.touchcomp.basementor.model.vo.ModeloFiscalProduto;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.ProdutoModeloFaturamento;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.res.DTOEntidadeRes;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.NoResultException;
import org.hibernate.Criteria;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoModeloFiscalImpl
extends DaoGenericEntityImpl<ModeloFiscal, Long> {
    public ModeloFiscal getModeloCondValida(Produto produto, CategoriaPessoa categoriaPessoa, UnidadeFederativa uf, NaturezaOperacao naturezaOperacao, Short tipoInscFederal, Short tipoInscEstadual, Short habilitadoSuframa, Empresa empresa, ModeloFiscal modelo) {
        return this.getFirstInternal(produto, categoriaPessoa, uf, naturezaOperacao, tipoInscFederal, tipoInscEstadual, habilitadoSuframa, empresa, modelo);
    }

    public ModeloFiscal getFirst(Produto produto, CategoriaPessoa categoriaPessoa, UnidadeFederativa uf, NaturezaOperacao naturezaOperacao, Short tipoInscFederal, Short tipoInscEstadual, Short habilitadoSuframa, Empresa empresa) {
        return this.getFirstInternal(produto, categoriaPessoa, uf, naturezaOperacao, tipoInscFederal, tipoInscEstadual, habilitadoSuframa, empresa, null);
    }

    private ModeloFiscal getFirstInternal(Produto produto, CategoriaPessoa categoriaPessoa, UnidadeFederativa uf, NaturezaOperacao naturezaOperacao, Short tipoInscFederal, Short tipoInscEstadual, Short habilitadoSuframa, Empresa empresa, ModeloFiscal modelo) {
        Object query = " select distinct f from ModeloFiscal f  inner join f.unidadeFederativas um inner join f.empresas e inner join f.categoriaPessoa c inner join f.naturezaOperacao n inner join c.categoriaPessoa cat inner join n.naturezaOperacao nat left join f.modeloFiscalProduto mp left join mp.produto prodModFat left join prodModFat.produto p";
        if (empresa.getEmpresaDados().getFiltrarProdutosModeloFiscal().equals((short)0)) {
            query = (String)query + " left join f.ncms ncms left join ncms.ncm ncm";
        }
        query = (String)query + " where  (cat =:categoria and c.ativo=:ativo) and f.suframa=:suframa   and f.ativo = :ativo   and (n.ativo = :ativo and nat = :natureza)   and (f.tipoInscricaoFederal=:tf or f.tipoInscricaoFederal is null OR f.tipoInscricaoFederal=:ambosFederal )   and (   (f.tipoInscricaoEstadual = :ambosEstadual)        or(f.tipoInscricaoEstadual = :isentoNaoContribuinte and (:te = 0 or :te = 2))       or(f.tipoInscricaoEstadual = :isento and  :te = 2)       or(f.tipoInscricaoEstadual = :naoContribuinte and :te = 0)       or(f.tipoInscricaoEstadual = :contribuinte and :te = 1 )     )   and ((p =:produto and prodModFat.ativo=:ativo) ";
        if (empresa.getEmpresaDados().getFiltrarProdutosModeloFiscal().equals((short)0)) {
            query = (String)query + " or (ncm.identificador = :ncm and ncms.ativo=:ativo)";
        }
        query = (String)query + " ) and (um.unidadeFederativa =:uf and um.ativo =:ativo)      and (e.empresa =:emp and e.ativo = :ativo) ";
        if (modelo != null) {
            query = (String)query + " and (f.identificador = :idModelo)";
        }
        query = (String)query + " order by f.identificador";
        Query q = this.query((String)query);
        q.setMaxResults(1);
        q.setEntity("produto", (Object)produto);
        if (empresa.getEmpresaDados().getFiltrarProdutosModeloFiscal().equals((short)0)) {
            if (produto.getNcm() != null) {
                q.setLong("ncm", produto.getNcm().getIdentificador().longValue());
            } else {
                q.setLong("ncm", 0L);
            }
        }
        if (modelo != null) {
            q.setLong("idModelo", modelo.getIdentificador().longValue());
        }
        q.setEntity("uf", (Object)uf);
        q.setEntity("categoria", (Object)categoriaPessoa);
        q.setEntity("natureza", (Object)naturezaOperacao);
        q.setShort("suframa", habilitadoSuframa.shortValue());
        q.setShort("tf", tipoInscFederal.shortValue());
        q.setShort("ativo", (short)1);
        q.setShort("te", tipoInscEstadual.shortValue());
        q.setShort("ambosFederal", (short)2);
        q.setShort("ambosEstadual", (short)2);
        q.setShort("isentoNaoContribuinte", (short)1);
        q.setShort("isento", (short)3);
        q.setShort("naoContribuinte", (short)4);
        q.setShort("contribuinte", (short)0);
        q.setEntity("emp", (Object)empresa);
        return (ModeloFiscal)q.uniqueResult();
    }

    public List<ModeloFiscal> get(Produto produto, CategoriaPessoa categoriaPessoa, UnidadeFederativa uf, NaturezaOperacao naturezaOperacao, Short tipoInscFederal, Short tipoInscEstadual, Short habilitadoSuframa, Empresa empresa) {
        habilitadoSuframa = habilitadoSuframa != null ? habilitadoSuframa : (short)0;
        Object query = " select distinct f from ModeloFiscal f  inner join f.unidadeFederativas um inner join f.empresas e inner join f.categoriaPessoa c inner join f.naturezaOperacao n inner join c.categoriaPessoa cat inner join n.naturezaOperacao nat left join f.modeloFiscalProduto mp left join mp.produto prodModFat left join prodModFat.produto p";
        if (empresa.getEmpresaDados().getFiltrarProdutosModeloFiscal().equals((short)0)) {
            query = (String)query + " left join f.ncms ncms left join ncms.ncm ncm";
        }
        query = (String)query + " where (cat =:categoria and c.ativo =:ativo) and f.suframa=:suframa  and f.ativo = :ativo   and (nat =:natureza and n.ativo=:ativo)   and ((f.tipoInscricaoFederal=:tf or f.tipoInscricaoFederal is null OR f.tipoInscricaoFederal=:ambosFederal ))   and (   (f.tipoInscricaoEstadual = :ambosEstadual)        or(f.tipoInscricaoEstadual = :isentoNaoContribuinte and (:te = 0 or :te = 2))       or(f.tipoInscricaoEstadual = :isento and  :te = 2)       or(f.tipoInscricaoEstadual = :naoContribuinte and :te = 0)       or(f.tipoInscricaoEstadual = :contribuinte and :te = 1 )     )   and ((p =:produto and prodModFat.ativo=:ativo) ";
        if (empresa.getEmpresaDados().getFiltrarProdutosModeloFiscal().equals((short)0)) {
            query = (String)query + " or (ncm.identificador = :ncm and ncms.ativo=:ativo)";
        }
        query = (String)query + " ) and (um.unidadeFederativa =:uf and um.ativo=:ativo) and (e.empresa =:emp and e.ativo = :ativo) order by f.identificador";
        Query q = this.query((String)query);
        q.setEntity("produto", (Object)produto);
        if (empresa.getEmpresaDados().getFiltrarProdutosModeloFiscal().equals((short)0)) {
            if (produto.getNcm() != null) {
                q.setLong("ncm", produto.getNcm().getIdentificador().longValue());
            } else {
                q.setLong("ncm", 0L);
            }
        }
        q.setEntity("uf", (Object)uf);
        q.setEntity("categoria", (Object)categoriaPessoa);
        q.setEntity("natureza", (Object)naturezaOperacao);
        q.setShort("suframa", habilitadoSuframa.shortValue());
        q.setShort("tf", tipoInscFederal.shortValue());
        q.setShort("ativo", (short)1);
        q.setShort("te", tipoInscEstadual.shortValue());
        q.setShort("ambosFederal", (short)2);
        q.setShort("ambosEstadual", (short)2);
        q.setShort("isentoNaoContribuinte", (short)1);
        q.setShort("isento", (short)3);
        q.setShort("naoContribuinte", (short)4);
        q.setShort("contribuinte", (short)0);
        q.setEntity("emp", (Object)empresa);
        List a = q.list();
        return a;
    }

    public List<DTOEntidadeRes> getResumido(Produto produto, CategoriaPessoa categoriaPessoa, UnidadeFederativa uf, NaturezaOperacao naturezaOperacao, Short tipoInscFederal, Short tipoInscEstadual, Short habilitadoSuframa, Empresa empresa) {
        habilitadoSuframa = habilitadoSuframa != null ? habilitadoSuframa : (short)0;
        Object query = " select distinct f.identificador,f.descricao from ModeloFiscal f  inner join f.unidadeFederativas um inner join f.empresas e inner join f.categoriaPessoa c inner join f.naturezaOperacao n inner join c.categoriaPessoa cat inner join n.naturezaOperacao nat left join f.modeloFiscalProduto mp left join mp.produto prodModFat left join prodModFat.produto p";
        if (empresa.getEmpresaDados().getFiltrarProdutosModeloFiscal().equals((short)0)) {
            query = (String)query + " left join f.ncms ncms left join ncms.ncm ncm";
        }
        query = (String)query + " where (cat =:categoria and c.ativo =:ativo) and f.suframa=:suframa  and f.ativo = :ativo   and (nat =:natureza and n.ativo=:ativo)   and ((f.tipoInscricaoFederal=:tf or f.tipoInscricaoFederal is null OR f.tipoInscricaoFederal=:ambosFederal ))   and (   (f.tipoInscricaoEstadual = :ambosEstadual)        or(f.tipoInscricaoEstadual = :isentoNaoContribuinte and (:te = 0 or :te = 2))       or(f.tipoInscricaoEstadual = :isento and  :te = 2)       or(f.tipoInscricaoEstadual = :naoContribuinte and :te = 0)       or(f.tipoInscricaoEstadual = :contribuinte and :te = 1 )     )   and ((p =:produto and prodModFat.ativo=:ativo) ";
        if (empresa.getEmpresaDados().getFiltrarProdutosModeloFiscal().equals((short)0)) {
            query = (String)query + " or (ncm.identificador = :ncm and ncms.ativo=:ativo)";
        }
        query = (String)query + " ) and (um.unidadeFederativa =:uf and um.ativo=:ativo) and (e.empresa =:emp and e.ativo = :ativo) order by f.identificador";
        Query q = this.query((String)query);
        q.setEntity("produto", (Object)produto);
        if (empresa.getEmpresaDados().getFiltrarProdutosModeloFiscal().equals((short)0)) {
            if (produto.getNcm() != null) {
                q.setLong("ncm", produto.getNcm().getIdentificador().longValue());
            } else {
                q.setLong("ncm", 0L);
            }
        }
        q.setEntity("uf", (Object)uf);
        q.setEntity("categoria", (Object)categoriaPessoa);
        q.setEntity("natureza", (Object)naturezaOperacao);
        q.setShort("suframa", habilitadoSuframa.shortValue());
        q.setShort("tf", tipoInscFederal.shortValue());
        q.setShort("ativo", (short)1);
        q.setShort("te", tipoInscEstadual.shortValue());
        q.setShort("ambosFederal", (short)2);
        q.setShort("ambosEstadual", (short)2);
        q.setShort("isentoNaoContribuinte", (short)1);
        q.setShort("isento", (short)3);
        q.setShort("naoContribuinte", (short)4);
        q.setShort("contribuinte", (short)0);
        q.setEntity("emp", (Object)empresa);
        List data = q.list();
        LinkedList<DTOEntidadeRes> ret = new LinkedList<DTOEntidadeRes>();
        for (Object[] objects : data) {
            DTOEntidadeRes r = new DTOEntidadeRes();
            r.setIdentificador((Long)objects[0]);
            r.setDescricao((String)objects[1]);
            ret.add(r);
        }
        return ret;
    }

    public List<ModeloFiscal> get(Produto produto, UnidadeFederativa uf) {
        Query q = this.query("select distinct m FROM ModeloFiscal m inner join m.unidadeFederativas um inner join m.naturezaOperacao n inner join n.naturezaOperacao nat left join m.modeloFiscalProduto mp left join mp.produto prodModFat left join prodModFat.produto p left join m.ncms ncms left join ncms.ncm ncm WHERE m.ativo = :ativo AND (nat.ativo = :ativo and n.ativo=:ativo) AND (um.unidadeFederativa = :uf and um.ativo = :ativo)  and ((p=:p and prodModFat.ativo=:ativo) or (ncm=:ncm and ncms.ativo=:ativo)) and nat.entradaSaida=:saida and m.compoeFluxoVenda = :sim order by m.identificador");
        q.setEntity("uf", (Object)uf);
        q.setEntity("p", (Object)produto);
        q.setEntity("ncm", (Object)produto.getNcm());
        q.setShort("ativo", (short)1);
        q.setShort("sim", (short)1);
        q.setShort("saida", (short)1);
        return q.list();
    }

    public Short movimentacaoFisicaByModelo(Long idModelo) {
        Query q = this.query("select m.movimentacaoFisica FROM ModeloFiscal m where m.identificador = :idModelo");
        q.setLong("idModelo", idModelo.longValue());
        return (Short)q.uniqueResult();
    }

    public ModeloFiscal getFirst(Produto produto, CategoriaPessoa categoriaPessoa, UnidadeFederativa uf, NaturezaOperacao naturezaOperacao, Short tipoInscFederal, Short tipoInscEstadual, Short habilitadoSuframa, Empresa empresa, IncidenciaIcms inc) {
        Object query = " select distinct f from ModeloFiscal f  inner join f.unidadeFederativas um inner join f.empresas e inner join f.categoriaPessoa c inner join f.naturezaOperacao n inner join c.categoriaPessoa cat inner join n.naturezaOperacao nat inner join f.modeloFiscalIcms modIcms left join f.modeloFiscalProduto mp left join mp.produto prodModFat left join prodModFat.produto p";
        if (empresa.getEmpresaDados().getFiltrarProdutosModeloFiscal().equals((short)0)) {
            query = (String)query + " left join f.ncms ncms left join ncms.ncm ncm";
        }
        query = (String)query + " where  (cat =:categoria and c.ativo=:ativo) and (modIcms.incidenciaIcms =:incidenciaIcms) and f.suframa=:suframa   and f.ativo = :ativo   and (n.ativo = :ativo and nat = :natureza)   and ((f.tipoInscricaoFederal=:tf or f.tipoInscricaoFederal is null OR f.tipoInscricaoFederal=:ambosFederal ))   and (   (f.tipoInscricaoEstadual = :ambosEstadual)        or(f.tipoInscricaoEstadual = :isentoNaoContribuinte and (:te = 0 or :te = 2))       or(f.tipoInscricaoEstadual = :isento and  :te = 2)       or(f.tipoInscricaoEstadual = :naoContribuinte and :te = 0)       or(f.tipoInscricaoEstadual = :contribuinte and :te = 1 )     )   and ((p =:produto and prodModFat.ativo=:ativo) ";
        if (empresa.getEmpresaDados().getFiltrarProdutosModeloFiscal().equals((short)0)) {
            query = (String)query + " or (ncm.identificador = :ncm and ncms.ativo=:ativo)";
        }
        query = (String)query + " ) and (um.unidadeFederativa =:uf and um.ativo =:ativo)      and (e.empresa =:emp and e.ativo = :ativo)  order by f.identificador";
        Query q = this.query((String)query);
        q.setMaxResults(1);
        q.setEntity("produto", (Object)produto);
        if (empresa.getEmpresaDados().getFiltrarProdutosModeloFiscal().equals((short)0)) {
            if (produto.getNcm() != null) {
                q.setLong("ncm", produto.getNcm().getIdentificador().longValue());
            } else {
                q.setLong("ncm", 0L);
            }
        }
        q.setEntity("uf", (Object)uf);
        q.setEntity("incidenciaIcms", (Object)inc);
        q.setEntity("categoria", (Object)categoriaPessoa);
        q.setEntity("natureza", (Object)naturezaOperacao);
        q.setShort("suframa", habilitadoSuframa.shortValue());
        q.setShort("tf", tipoInscFederal.shortValue());
        q.setShort("ativo", (short)1);
        q.setShort("te", tipoInscEstadual.shortValue());
        q.setShort("ambosFederal", (short)2);
        q.setShort("ambosEstadual", (short)2);
        q.setShort("isentoNaoContribuinte", (short)1);
        q.setShort("isento", (short)3);
        q.setShort("naoContribuinte", (short)4);
        q.setShort("contribuinte", (short)0);
        q.setEntity("emp", (Object)empresa);
        return (ModeloFiscal)q.uniqueResult();
    }

    public ModeloFiscal getFirstNFCe(Produto produto, NaturezaOperacao naturezaOperacao, Empresa empresa, CategoriaPessoa categoriaPessoa, Short usarPesqCategoria, Short usarPesqNcm, Short usarPesqProduto) {
        Object query = " select distinct f from ModeloFiscal f  inner join f.empresas e inner join f.naturezaOperacao n inner join n.naturezaOperacao nat";
        if (ToolMethods.isEquals((Object)usarPesqProduto, (Object)1)) {
            query = (String)query + " left join f.modeloFiscalProduto mp left join mp.produto prodModFat left join prodModFat.produto p";
        }
        if (ToolMethods.isEquals((Object)usarPesqNcm, (Object)1)) {
            query = (String)query + " left join f.ncms ncms left join ncms.ncm ncm";
        }
        if (ToolMethods.isEquals((Object)usarPesqCategoria, (Object)1) && !ToolMethods.isEquals((Object)categoriaPessoa, null)) {
            query = (String)query + " left join f.categoriaPessoa c left join c.categoriaPessoa cat";
        }
        query = (String)query + " where (nat =:natureza and n.ativo=:ativo and nat.modeloDocFiscal.codigo = :codigoNFCe)";
        query = (String)query + " and (nat =:natureza and n.ativo=:ativo)";
        query = (String)query + " and (e.empresa =:emp and e.ativo = :ativo) ";
        query = (String)query + " and (f.ativo=:ativo) ";
        if (ToolMethods.isEquals((Object)usarPesqProduto, (Object)1) && ToolMethods.isEquals((Object)usarPesqNcm, (Object)1)) {
            query = (String)query + " and ((p =:produto and prodModFat.ativo=:ativo) ";
            query = (String)query + " or (ncm.identificador = :ncm and ncms.ativo=:ativo))";
        } else {
            if (ToolMethods.isEquals((Object)usarPesqProduto, (Object)1)) {
                query = (String)query + " and (p =:produto and prodModFat.ativo=:ativo) ";
            }
            if (ToolMethods.isEquals((Object)usarPesqNcm, (Object)1)) {
                query = (String)query + " and (ncm.identificador = :ncm and ncms.ativo=:ativo)";
            }
        }
        if (ToolMethods.isEquals((Object)usarPesqCategoria, (Object)1) && !ToolMethods.isEquals((Object)categoriaPessoa, null)) {
            query = (String)query + " and (cat =:categoria and c.ativo =:ativo)";
        }
        query = (String)query + " order by f.identificador desc";
        Query q = this.query((String)query);
        if (ToolMethods.isEquals((Object)usarPesqProduto, (Object)1)) {
            q.setParameter("produto", (Object)produto);
        }
        if (ToolMethods.isEquals((Object)usarPesqCategoria, (Object)1) && !ToolMethods.isEquals((Object)categoriaPessoa, null)) {
            q.setParameter("categoria", (Object)categoriaPessoa);
        }
        if (ToolMethods.isEquals((Object)usarPesqNcm, (Object)1)) {
            if (produto.getNcm() != null) {
                q.setParameter("ncm", (Object)produto.getNcm().getIdentificador());
            } else {
                q.setParameter("ncm", (Object)0L);
            }
        }
        q.setParameter("natureza", (Object)naturezaOperacao);
        q.setParameter("ativo", (Object)1);
        q.setParameter("emp", (Object)empresa);
        q.setParameter("codigoNFCe", (Object)EnumConstantsModeloDocFiscal.NFCE_65.getCodigo());
        q.setMaxResults(1);
        try {
            return (ModeloFiscal)q.getSingleResult();
        }
        catch (NoResultException nre) {
            return null;
        }
    }

    public List<ModeloFiscal> get(Produto produto, NaturezaOperacao naturezaOperacao, Empresa empresa, CategoriaPessoa categoriaPessoa, Short usarPesqCategoria, Short usarPesqNcm, Short usarPesqProduto) {
        Object query = " select distinct f from ModeloFiscal f  inner join f.empresas e inner join f.naturezaOperacao n inner join n.naturezaOperacao nat";
        if (ToolMethods.isEquals((Object)usarPesqProduto, (Object)1)) {
            query = (String)query + " left join f.modeloFiscalProduto mp left join mp.produto prodModFat left join prodModFat.produto p";
        }
        if (ToolMethods.isEquals((Object)usarPesqNcm, (Object)1)) {
            query = (String)query + " left join f.ncms ncms left join ncms.ncm ncm";
        }
        if (ToolMethods.isEquals((Object)usarPesqCategoria, (Object)1) && !ToolMethods.isEquals((Object)categoriaPessoa, null)) {
            query = (String)query + " left join f.categoriaPessoa c left join c.categoriaPessoa cat";
        }
        query = (String)query + " where (nat =:natureza and n.ativo=:ativo)";
        query = (String)query + " and (nat =:natureza and n.ativo=:ativo)";
        query = (String)query + " and (e.empresa =:emp and e.ativo = :ativo) ";
        query = (String)query + " and (f.ativo=:ativo) ";
        if (ToolMethods.isEquals((Object)usarPesqProduto, (Object)1) && ToolMethods.isEquals((Object)usarPesqNcm, (Object)1)) {
            query = (String)query + " and ((p =:produto and prodModFat.ativo=:ativo) ";
            query = (String)query + " or (ncm.identificador = :ncm and ncms.ativo=:ativo))";
        } else {
            if (ToolMethods.isEquals((Object)usarPesqProduto, (Object)1)) {
                query = (String)query + " and (p =:produto and prodModFat.ativo=:ativo) ";
            }
            if (ToolMethods.isEquals((Object)usarPesqNcm, (Object)1)) {
                query = (String)query + " and (ncm.identificador = :ncm and ncms.ativo=:ativo)";
            }
        }
        if (ToolMethods.isEquals((Object)usarPesqCategoria, (Object)1) && !ToolMethods.isEquals((Object)categoriaPessoa, null)) {
            query = (String)query + " and (cat =:categoria and c.ativo =:ativo)";
        }
        query = (String)query + " order by f.identificador desc";
        Query q = this.query((String)query);
        if (ToolMethods.isEquals((Object)usarPesqProduto, (Object)1)) {
            q.setParameter("produto", (Object)produto);
        }
        if (ToolMethods.isEquals((Object)usarPesqCategoria, (Object)1) && !ToolMethods.isEquals((Object)categoriaPessoa, null)) {
            q.setParameter("categoria", (Object)categoriaPessoa);
        }
        if (ToolMethods.isEquals((Object)usarPesqNcm, (Object)1)) {
            if (produto.getNcm() != null) {
                q.setParameter("ncm", (Object)produto.getNcm().getIdentificador());
            } else {
                q.setParameter("ncm", (Object)0L);
            }
        }
        q.setParameter("natureza", (Object)naturezaOperacao);
        q.setParameter("ativo", (Object)1);
        q.setParameter("emp", (Object)empresa);
        return q.list();
    }

    public List<DTOEntidadeRes> getResumido(Produto produto, NaturezaOperacao naturezaOperacao, Empresa empresa, CategoriaPessoa categoriaPessoa, Short usarPesqCategoria, Short usarPesqNcm, Short usarPesqProduto) {
        Object query = " select distinct f.identificador, f.descricao from ModeloFiscal f  inner join f.empresas e inner join f.naturezaOperacao n inner join n.naturezaOperacao nat";
        if (ToolMethods.isEquals((Object)usarPesqProduto, (Object)1)) {
            query = (String)query + " left join f.modeloFiscalProduto mp left join mp.produto prodModFat left join prodModFat.produto p";
        }
        if (ToolMethods.isEquals((Object)usarPesqNcm, (Object)1)) {
            query = (String)query + " left join f.ncms ncms left join ncms.ncm ncm";
        }
        if (ToolMethods.isEquals((Object)usarPesqCategoria, (Object)1) && !ToolMethods.isEquals((Object)categoriaPessoa, null)) {
            query = (String)query + " left join f.categoriaPessoa c left join c.categoriaPessoa cat";
        }
        query = (String)query + " where (nat =:natureza and n.ativo=:ativo)";
        query = (String)query + " and (nat =:natureza and n.ativo=:ativo)";
        query = (String)query + " and (e.empresa =:emp and e.ativo = :ativo) ";
        query = (String)query + " and (f.ativo=:ativo) ";
        if (ToolMethods.isEquals((Object)usarPesqProduto, (Object)1) && ToolMethods.isEquals((Object)usarPesqNcm, (Object)1)) {
            query = (String)query + " and ((p =:produto and prodModFat.ativo=:ativo) ";
            query = (String)query + " or (ncm.identificador = :ncm and ncms.ativo=:ativo))";
        } else {
            if (ToolMethods.isEquals((Object)usarPesqProduto, (Object)1)) {
                query = (String)query + " and (p =:produto and prodModFat.ativo=:ativo) ";
            }
            if (ToolMethods.isEquals((Object)usarPesqNcm, (Object)1)) {
                query = (String)query + " and (ncm.identificador = :ncm and ncms.ativo=:ativo)";
            }
        }
        if (ToolMethods.isEquals((Object)usarPesqCategoria, (Object)1) && !ToolMethods.isEquals((Object)categoriaPessoa, null)) {
            query = (String)query + " and (cat =:categoria and c.ativo =:ativo)";
        }
        query = (String)query + " order by f.identificador desc";
        Query q = this.query((String)query);
        if (ToolMethods.isEquals((Object)usarPesqProduto, (Object)1)) {
            q.setParameter("produto", (Object)produto);
        }
        if (ToolMethods.isEquals((Object)usarPesqCategoria, (Object)1) && !ToolMethods.isEquals((Object)categoriaPessoa, null)) {
            q.setParameter("categoria", (Object)categoriaPessoa);
        }
        if (ToolMethods.isEquals((Object)usarPesqNcm, (Object)1)) {
            if (produto.getNcm() != null) {
                q.setParameter("ncm", (Object)produto.getNcm().getIdentificador());
            } else {
                q.setParameter("ncm", (Object)0L);
            }
        }
        q.setParameter("natureza", (Object)naturezaOperacao);
        q.setParameter("ativo", (Object)1);
        q.setParameter("emp", (Object)empresa);
        List data = q.list();
        LinkedList<DTOEntidadeRes> ret = new LinkedList<DTOEntidadeRes>();
        for (Object[] objects : data) {
            DTOEntidadeRes r = new DTOEntidadeRes();
            r.setIdentificador((Long)objects[0]);
            r.setDescricao((String)objects[1]);
            ret.add(r);
        }
        return ret;
    }

    @Override
    public List<ModeloFiscal> get(NaturezaOperacao naturezaOperacao) {
        Criteria crit = this.criteria();
        crit.createAlias("naturezaOperacao", "nt");
        crit.add(this.eq("nt.naturezaOperacao", naturezaOperacao));
        crit.add(this.eq("nt.ativo", (short)1));
        crit.add(this.eq("ativo", (short)1));
        return this.toList(crit);
    }

    public List<ModeloFiscal> pesquisaModeloFiscalAtivoEntrada() {
        Query q = this.query("SELECT DISTINCT m FROM       ModeloFiscal       m INNER JOIN m.naturezaOperacao n INNER JOIN n.naturezaOperacao a WHERE m.ativo        = :ativo AND   a.entradaSaida = :entradaSaida");
        q.setShort("ativo", (short)1);
        q.setShort("entradaSaida", (short)0);
        return q.list();
    }

    public boolean forcarDataAtualizacaoProdutos(ModeloFiscal modeloFiscal) {
        ModeloFiscalProduto p = modeloFiscal.getModeloFiscalProduto();
        String sql = "update MODELO_FISCAL_PRODUTO t set t.data_atualizacao = current_timestamp  where t.ID_MODELO_FISCAL_PROD = :idModFiscal";
        NativeQuery q = this.sqlQuery(sql);
        q.setLong("idModFiscal", p.getIdentificador().longValue());
        q.executeUpdate();
        int i = 1;
        for (ProdutoModeloFaturamento tabProd : p.getProduto()) {
            String sql2 = "update PRODUTO_MOD_FATURAMENTO t set t.data_atualizacao = :dataAtual  where t.ID_PRODUTO_MOD_FATURAMENTO = :idTabProd";
            NativeQuery q2 = this.sqlQuery(sql2);
            q2.setTimestamp("dataAtual", new Date());
            q2.setLong("idTabProd", tabProd.getIdentificador().longValue());
            q2.executeUpdate();
            System.out.println("\n\nContador: " + i);
            ++i;
        }
        return true;
    }

    public boolean existeModeloFiscalAtivoComModFiscalIpi(ModeloFiscalIpi m) {
        String query = "select distinct\n1 as existe\nfrom ModeloFiscal m\n\tinner join m.modeloFiscalIpi d\nwhere d.identificador = :idModeloIpi\nand m.ativo = :sim";
        Query q = this.query(query);
        q.setShort("sim", (short)1);
        q.setLong("idModeloIpi", m.getIdentificador().longValue());
        q.setMaxResults(1);
        Integer d = (Integer)q.uniqueResult();
        return ToolMethods.isEquals((Object)d, (Object)1);
    }

    public boolean existeModeloFiscalAtivoComModFiscalICMS(ModeloFiscalIcms m) {
        String query = "select distinct\n1 as existe\nfrom ModeloFiscal m\n\tinner join m.modeloFiscalIcms d\nwhere d.identificador = :idModeloFiscalIcms\nand m.ativo = :sim";
        Query q = this.query(query);
        q.setShort("sim", (short)1);
        q.setLong("idModeloFiscalIcms", m.getIdentificador().longValue());
        q.setMaxResults(1);
        Integer d = (Integer)q.uniqueResult();
        return ToolMethods.isEquals((Object)d, (Object)1);
    }

    public boolean existeModeloFiscalAtivoComModFiscalPisCofins(ModeloFiscalPisCofins m) {
        String query = "select distinct\n1 as existe\nfrom ModeloFiscal m\n\tinner join m.modeloFiscalPisCofins d\nwhere d.identificador = :idModeloPisCofins\nand m.ativo = :sim";
        Query q = this.query(query);
        q.setShort("sim", (short)1);
        q.setLong("idModeloPisCofins", m.getIdentificador().longValue());
        q.setMaxResults(1);
        Integer d = (Integer)q.uniqueResult();
        return ToolMethods.isEquals((Object)d, (Object)1);
    }

    public ModeloFiscal getModeloFiscalByCnae(CNAE cnae) {
        Criteria criteria = this.criteria();
        criteria.add(this.eq("cnae", cnae));
        this.orderDesc(criteria, "identificador");
        List result = criteria.list();
        if (ToolMethods.isWithData((Collection)result)) {
            return (ModeloFiscal)result.getLast();
        }
        return null;
    }
}

