/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.Cheque;
import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.MovimentoBancario;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.hibernate.Criteria;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoMovimentoBancarioImpl
extends DaoGenericEntityImpl<MovimentoBancario, Long> {
    public List<MovimentoBancario> findPorDataAndContaValor(Date dataInicial, Date dataFinal, ContaValores contaValor) {
        return this.toList(this.restrictions(this.criteria(), this.eq("contaValor", contaValor), this.between("dataCompensacao", dataInicial, dataFinal)));
    }

    public List<MovimentoBancario> findMovimentoPorPeriodo(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        String q = " select b from MovimentoBancario b  left join IntegracaoMovBancarioMovimento i on b = i.movimentoBancario left join b.grupoDeBaixaFormas baixas  left join b.transferenciaValor trans  left join b.centroResultadoContFin centroResultado  where b.dataLancamento between :dataInicial and :dataFinal  and i.loteContabil                         is null  and b.empresa.empresaDados.grupoEmpresa                 = :grupoEmpresa  and baixas                                 is null  and centroResultado                        is not null  and trans                                  is null  and (b.naoContabilizarMov is null or b.naoContabilizarMov = :nao)";
        Query query = this.query(q);
        query.setParameter("dataInicial", (Object)dataInicial);
        query.setParameter("dataFinal", (Object)dataFinal);
        query.setParameter("grupoEmpresa", (Object)grupoEmpresa);
        query.setParameter("nao", (Object)EnumConstantsMentorSimNao.NAO.getValue());
        return query.getResultList();
    }

    public List<MovimentoBancario> findMovimentoPeriodoPaginado(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa, Integer maxResults, Integer first) {
        String q = "select b from MovimentoBancario b left join b.grupoDeBaixaFormas bt  left join b.transferenciaValor trans  left join b.centroResultadoContFin centroResultado  where b.dataLancamento between :dataInicial and :dataFinal  and bt is null  and b.empresa.empresaDados.grupoEmpresa = :grupoEmpresa  and trans is null and centroResultado is not null and (b.naoContabilizarMov is null or b.naoContabilizarMov = :nao) ";
        Query query = this.query(q);
        query.setParameter("dataInicial", (Object)dataInicial);
        query.setParameter("dataFinal", (Object)dataFinal);
        query.setParameter("grupoEmpresa", (Object)grupoEmpresa);
        query.setParameter("nao", (Object)EnumConstantsMentorSimNao.NAO.getValue());
        query.setMaxResults(maxResults.intValue());
        query.setFirstResult(first.intValue());
        return query.getResultList();
    }

    public void deleteIntegracaoVincMovimentoBanc(MovimentoBancario vo) {
        String hql = "update MovimentoBancario m set m.integracaoMovBancarioMovimento = null where m.integracaoMovBancarioMovimento = :i";
        Query query = this.query(hql);
        query.setParameter("i", (Object)vo.getIntegracaoMovBancarioMovimento());
        query.executeUpdate();
    }

    public void updateMovimentoBancario(Cheque cheque, Date dataCompensacao) {
        CriteriaBuilder builder = this.criteriaBuilder(MovimentoBancario.class);
        CriteriaUpdate update = builder.createCriteriaUpdate(MovimentoBancario.class);
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root fromMovimentoBancario = update.from(MovimentoBancario.class);
        update.set("dataCompensacao", (Object)dataCompensacao);
        exps.add(builder.equal((Expression)fromMovimentoBancario.get("cheque"), (Object)cheque));
        update.where(exps.toArray(new Predicate[0]));
        this.getEntityManager().createQuery(update).executeUpdate();
    }

    public List<MovimentoBancario> finsMovimentosByDataCompAndConta(Date dataCompensacao, ContaValores conta) {
        Criteria c = this.criteria();
        c.add(this.eq("dataCompensacao", dataCompensacao));
        c.add(this.eq("contaValor", conta));
        this.order(c, "identificador");
        return c.list();
    }
}

