/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.constants.enums.geracaotitulosfolhapagamento.EnumConstStatusFolhaPagamento;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.EsocItemS1010;
import com.touchcomp.basementor.model.vo.EsocItemS1020;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.TipoCalculo;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.NoResultException;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.hibernate.Criteria;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Repository;

@Repository
public class DaoMovimentoFolhaImpl
extends DaoGenericEntityImpl<MovimentoFolha, Long> {
    public List findFolhaCustoMensal(Date dataInicio, Date dataFinal, Empresa empresa) {
        String hql = " from MovimentoFolha movimentoFolha where movimentoFolha.aberturaPeriodo.dataInicio >= :dataInicial and movimentoFolha.aberturaPeriodo.dataFinal <= :dataFinal and movimentoFolha.empresa = :empresa and (movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento or movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :recisaoComplementar or movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaComplementar) ";
        Query query = this.query(hql);
        query.setParameter("dataInicial", (Object)dataInicio);
        query.setParameter("dataFinal", (Object)dataFinal);
        query.setParameter("empresa", (Object)empresa);
        query.setParameter("folhaPagamento", (Object)0);
        query.setParameter("recisaoComplementar", (Object)8);
        query.setParameter("folhaComplementar", (Object)6);
        return query.list();
    }

    public List<MovimentoFolha> findMovimentosS1200(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        CriteriaBuilder builder = this.criteriaBuilder(MovimentoFolha.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root root = crit.from(MovimentoFolha.class);
        Join jAberturaPeriodo = root.join("aberturaPeriodo", JoinType.INNER);
        Join jTipoCalculo = jAberturaPeriodo.join("tipoCalculo", JoinType.INNER);
        Join jColaborador = root.join("colaborador", JoinType.INNER);
        Join jEmpresa = root.join("empresa", JoinType.INNER);
        Join jEmpresaDados = jEmpresa.join("empresaDados", JoinType.INNER);
        exps.add(builder.or((Expression)builder.isNull((Expression)jColaborador.get("dataDemissao")), (Expression)builder.greaterThan((Expression)jColaborador.get("dataDemissao"), (Comparable)dataFinal)));
        exps.add(builder.equal((Expression)jEmpresaDados.get("grupoEmpresa"), (Object)grupoEmpresa));
        exps.add(builder.and((Expression)builder.notEqual((Expression)jTipoCalculo.get("tipoFolha"), (Object)EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue()), (Expression)builder.notEqual((Expression)jTipoCalculo.get("tipoFolha"), (Object)EnumConstTipoCalculoEvento.CALCULO_FOLHA_COMPLEMENTAR_DEC.getValue())));
        exps.add(builder.between((Expression)jAberturaPeriodo.get("dataInicio"), (Comparable)dataInicial, (Comparable)dataFinal));
        Subquery subquery = crit.subquery(EsocItemS1010.class);
        Root fromEsocItem = subquery.from(EsocItemS1010.class);
        Join jMovimentoFolha = fromEsocItem.join("movimentoFolha", JoinType.INNER);
        subquery.where((Expression)builder.equal((Expression)jMovimentoFolha.get("identificador"), (Expression)root.get("identificador")));
        subquery.select((Expression)fromEsocItem);
        exps.add(builder.not((Expression)builder.exists(subquery)));
        crit.select((Selection)root);
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }

    public List<MovimentoFolha> findMovimentosS1200DecTerc(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        CriteriaBuilder builder = this.criteriaBuilder(MovimentoFolha.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root root = crit.from(MovimentoFolha.class);
        Join jEmpresa = root.join("empresa", JoinType.INNER);
        Join jEmpresaDados = jEmpresa.join("empresaDados", JoinType.INNER);
        Join jAberturaPeriodo = root.join("aberturaPeriodo", JoinType.INNER);
        Join jTipoCalculo = jAberturaPeriodo.join("tipoCalculo", JoinType.INNER);
        exps.add(builder.equal((Expression)jEmpresaDados.get("grupoEmpresa"), (Object)grupoEmpresa));
        exps.add(builder.equal((Expression)jTipoCalculo.get("tipoFolha"), (Object)EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue()));
        exps.add(builder.between((Expression)jAberturaPeriodo.get("dataInicio"), (Comparable)dataInicial, (Comparable)dataFinal));
        Subquery subquery = crit.subquery(EsocItemS1010.class);
        Root fromEsocItem = subquery.from(EsocItemS1010.class);
        Join jMovimentoFolha = fromEsocItem.join("movimentoFolha", JoinType.INNER);
        subquery.where((Expression)builder.equal((Expression)jMovimentoFolha.get("identificador"), (Expression)root.get("identificador")));
        subquery.select((Expression)fromEsocItem);
        exps.add(builder.not((Expression)builder.exists(subquery)));
        crit.select((Selection)root);
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }

    public List<MovimentoFolha> findMovimentosS1210(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        CriteriaBuilder builder = this.criteriaBuilder(MovimentoFolha.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root root = crit.from(MovimentoFolha.class);
        Join jAberturaPeriodo = root.join("aberturaPeriodo", JoinType.INNER);
        Join jTipoCalculo = jAberturaPeriodo.join("tipoCalculo", JoinType.INNER);
        Join jColaborador = root.join("colaborador", JoinType.INNER);
        Join jEsocCategoriaTrabalhador = jColaborador.join("esocCategoriaTrabalhador", JoinType.INNER);
        Join jEmpresa = root.join("empresa", JoinType.INNER);
        Join jEmpresaDados = jEmpresa.join("empresaDados", JoinType.INNER);
        exps.add(builder.or((Expression)builder.or(new Predicate[]{builder.isNull((Expression)jColaborador.get("dataDemissao")), builder.greaterThan((Expression)jColaborador.get("dataDemissao"), (Expression)jAberturaPeriodo.get("dataFinal")), builder.equal((Expression)jTipoCalculo.get("tipoFolha"), (Object)EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue())}), (Expression)builder.and(new Predicate[]{builder.isNotNull((Expression)jColaborador.get("dataDemissao")), builder.between((Expression)jColaborador.get("dataDemissao"), (Comparable)dataInicial, (Comparable)dataFinal), builder.greaterThan((Expression)root.get("vrIrrfSalario"), (Comparable)Integer.valueOf(0))})));
        exps.add(builder.equal((Expression)jEmpresaDados.get("grupoEmpresa"), (Object)grupoEmpresa));
        exps.add(builder.between((Expression)jAberturaPeriodo.get("dataPagamento"), (Comparable)dataInicial, (Comparable)dataFinal));
        Subquery subquery = crit.subquery(EsocItemS1020.class);
        Root fromEsocItem = subquery.from(EsocItemS1020.class);
        Join jMovimentoFolha = fromEsocItem.join("movimentoFolha", JoinType.INNER);
        subquery.where((Expression)builder.equal((Expression)jMovimentoFolha.get("identificador"), (Expression)root.get("identificador")));
        subquery.select((Expression)fromEsocItem);
        exps.add(builder.not((Expression)builder.exists(subquery)));
        crit.select((Selection)root);
        crit.where(exps.toArray(new Predicate[0]));
        ArrayList<Order> orderList = new ArrayList<Order>();
        orderList.add(builder.desc((Expression)jAberturaPeriodo.get("dataPagamento")));
        orderList.add(builder.asc((Expression)jEsocCategoriaTrabalhador.get("codigo")));
        crit.orderBy(orderList);
        return this.getEntityManager().createQuery(crit).getResultList();
    }

    public List<MovimentoFolha> findMovimentosByAberturaPeriodo(Long aberturaPeriodo) {
        CriteriaBuilder builder = this.criteriaBuilder(MovimentoFolha.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root fromMovimentoFolha = crit.from(MovimentoFolha.class);
        Join jAberturaPeriodo = fromMovimentoFolha.join("aberturaPeriodo", JoinType.INNER);
        Join jStatusFolha = fromMovimentoFolha.join("statusFolha", JoinType.INNER);
        crit.select((Selection)fromMovimentoFolha);
        exps.add(builder.equal((Expression)jAberturaPeriodo.get("identificador"), (Object)aberturaPeriodo));
        exps.add(builder.equal((Expression)fromMovimentoFolha.get("finalizado"), (Object)EnumConstantsMentorSimNao.NAO.getValue()));
        exps.add(builder.notEqual((Expression)jStatusFolha.get("codigo"), (Object)EnumConstStatusFolhaPagamento.FOLHA_RESCISAO.getEnumId()));
        exps.add(builder.gt((Expression)fromMovimentoFolha.get("vrSalarioLiquido"), (Number)0.0));
        exps.add(builder.equal((Expression)fromMovimentoFolha.get("gerarFinanceiro"), (Object)EnumConstantsMentorSimNao.SIM.getValue()));
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }

    public void fecharFolhasPagamento(Long aberturaPeriodo) {
        CriteriaBuilder builder = this.criteriaBuilder(MovimentoFolha.class);
        CriteriaUpdate update = builder.createCriteriaUpdate(MovimentoFolha.class);
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root fromMovimentoFolha = update.from(MovimentoFolha.class);
        Join jAberturaPeriodo = fromMovimentoFolha.join("aberturaPeriodo", JoinType.INNER);
        update.set("finalizado", (Object)EnumConstantsMentorSimNao.SIM.getValue());
        exps.add(builder.equal((Expression)jAberturaPeriodo.get("identificador"), (Object)aberturaPeriodo));
        update.where(exps.toArray(new Predicate[0]));
        this.getEntityManager().createQuery(update).executeUpdate();
    }

    public MovimentoFolha getMovimentoFolhaAdd(Colaborador colaborador, Date dataAfastamento, EmpresaRh empresaRh) {
        Criteria crit = this.criteria();
        crit.createAlias("aberturaPeriodo", "ap");
        crit.createAlias("ap.tipoCalculo", "tc");
        crit.add(this.eq("colaborador", colaborador));
        crit.add(this.eq("tc.tipoFolha", EnumConstTipoCalculoEvento.CALCULO_ADIANTAMENTO_SALARIO.getValue()));
        crit.add(this.between("ap.dataInicio", ToolDate.getDateFirstMonthDay((Date)dataAfastamento), ToolDate.getDateLastMonthDay((Date)dataAfastamento)));
        crit.setMaxResults(1);
        return (MovimentoFolha)crit.uniqueResult();
    }

    public List<MovimentoFolha> findFolhaAbertaColaborador(Long colaborador, Long empresa, Date dataFinal) {
        Criteria crit = this.criteria();
        crit.createAlias("colaborador", "col");
        crit.createAlias("empresa", "emp");
        crit.createAlias("aberturaPeriodo", "abp");
        crit.add(this.eq("col.identificador", colaborador));
        crit.add(this.eq("emp.identificador", empresa));
        crit.add(this.between("abp.dataFinal", ToolDate.getDateFirstMonthDay((Date)dataFinal), ToolDate.getDateLastMonthDay((Date)dataFinal)));
        crit.setMaxResults(1);
        return crit.list();
    }

    public List<HashMap> findMovimentoFolhaPorDataPagamentoEmpresa(Date dataPagamento, Empresa empresa) {
        return this.query("SELECT COALESCE(SUM(m.vrFgtsSalario + m.vrFgtsFerias + m.vrFgts13Sal), 0) AS FGTS, a.dataFinal AS DATA_FINAL, a.identificador AS ID , t.tipoFolha AS TIPO_FOLHA  FROM MovimentoFolha m INNER JOIN m.aberturaPeriodo a INNER JOIN a.tipoCalculo t WHERE a.dataPagamento = :dataPagamento AND m.empresa = :empresa AND not exists (select i from ItemOutrosTitulosFolha i where i.aberturaPeriodoFgts = a)  GROUP BY a.identificador, a.dataFinal, t.tipoFolha").setParameter("dataPagamento", (Object)dataPagamento).setParameter("empresa", (Object)empresa).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
    }

    public List<HashMap> findMovimentoFolhaPorDataPagamentoEmpresaTipoCalculo(Date dataPagamento, Empresa empresa, Short tipoCalculo) {
        return this.query("SELECT COALESCE(SUM(m.vrIrrfSalario + m.vrIrrf13Sal ),0) AS IRRF, a.identificador AS ID, a.dataFinal AS DATA_FINAL  FROM MovimentoFolha m INNER JOIN m.aberturaPeriodo a INNER JOIN m.statusFolha s WHERE a.dataPagamento = :dataPagamento AND m.empresa = :empresa AND s.codigo != :tipoCalculo AND not exists (select i from ItemOutrosTitulosFolha i where i.aberturaPeriodoIrrf = a)  GROUP BY a.identificador, a.dataFinal").setParameter("dataPagamento", (Object)dataPagamento).setParameter("empresa", (Object)empresa).setParameter("tipoCalculo", (Object)tipoCalculo).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
    }

    public double getQuantidadeFaltasPeriodo(Colaborador colaborador, Date periodoInicial, Date periodoFinal, TipoCalculoEvento tipoEventoFaltas) {
        String queryStr = " select\n sum(item.referencia) as REFERENCIA\n from ItemMovimentoFolha item\n where\n item.movimentoFolha.colaborador = :colaborador\n and\n((item.movimentoFolha.aberturaPeriodo.dataInicio >= :dataInicio\nand\nitem.movimentoFolha.aberturaPeriodo.dataFinal <= :dataFim)\n or\n(item.movimentoFolha.aberturaPeriodo.dataInicio < :dataFim\n and\n item.movimentoFolha.aberturaPeriodo.dataFinal > :dataFim\n and\n (extract(day from item.movimentoFolha.aberturaPeriodo.dataFinal) - :diaPeriodoFinal <= 15 )\n and\n (:dataFimInicioPeriodo - :diaPeriodoInicial+1) < 15 )\n  or\n  (item.movimentoFolha.aberturaPeriodo.dataInicio < :dataInicio\n and\n item.movimentoFolha.aberturaPeriodo.dataFinal > :dataInicio\n  and\n (extract(day from item.movimentoFolha.aberturaPeriodo.dataFinal) - :diaPeriodoInicial >= 15 )))\n and\n item.eventoColaborador.tipoCalculoEvento = :evtFaltas";
        Query query = this.query(queryStr);
        int diaPeriodoIn = ToolDate.getDayFromDate((Date)periodoInicial);
        int diaPeriodoFim = ToolDate.getDayFromDate((Date)periodoFinal);
        int ultimoDiaMes = ToolDate.getLastDayOnMonth((Date)periodoInicial);
        query.setParameter("colaborador", (Object)colaborador).setParameter("dataInicio", (Object)periodoInicial).setParameter("dataFim", (Object)periodoFinal).setParameter("diaPeriodoFinal", (Object)diaPeriodoFim).setParameter("diaPeriodoInicial", (Object)diaPeriodoIn).setParameter("dataFimInicioPeriodo", (Object)ultimoDiaMes).setParameter("evtFaltas", (Object)tipoEventoFaltas);
        try {
            Double referenciaFaltas = (Double)query.getSingleResult();
            return ToolMethods.isNulThen((Number)referenciaFaltas, (Double)0.0);
        }
        catch (NoResultException ex) {
            return 0.0;
        }
    }

    public List<Map<String, Object>> getValorItemMovFolha(Empresa empresa, Date periodo, TipoCalculoEvento tpPensao, TipoCalculo tipoFolha) {
        AuxCriteriaBuilder builder = this.queryBuilder();
        Join jItem = builder.join("itensMovimentoFolha");
        Join jAbert = builder.join("aberturaPeriodo");
        Join evt = builder.join("eventoColaborador");
        builder.equal((From)evt, "tipoCalculoEvento", tpPensao);
        builder.equal((From)jAbert, "tipoCalculo", tipoFolha);
        builder.equal((From)jAbert, "dataFinal", periodo);
        builder.equal("empresa", empresa);
        builder.select(AuxCriteriaBuilder.pair("colaborador", "F_COLABORADOR"));
        builder.select(AuxCriteriaBuilder.pair((From)jItem, "valor", "F_VALOR"));
        List<Map<String, Object>> itens = builder.getResultMap();
        return itens;
    }

    public List<Map<String, Object>> getValorItemMovFolha(Empresa empresa, Date periodo, TipoCalculoEvento tipoCalculo) {
        AuxCriteriaBuilder builder = this.queryBuilder();
        Join jItem = builder.join("itensMovimentoFolha");
        Join jAbert = builder.join("aberturaPeriodo");
        Join evt = builder.join("eventoColaborador");
        builder.equal((From)evt, "tipoCalculoEvento", tipoCalculo);
        builder.equal((From)jAbert, "dataFinal", periodo);
        builder.equal("empresa", empresa);
        builder.select(AuxCriteriaBuilder.pair("colaborador", "F_COLABORADOR"));
        builder.select(AuxCriteriaBuilder.pair((From)jItem, "valor", "F_VALOR"));
        List<Map<String, Object>> itens = builder.getResultMap();
        return itens;
    }

    public List<HashMap> findItemMovimentoFolhaPorDataPagamentoEmpresa(Date dataPagamento, Empresa empresa) {
        return this.query("select sum(item.valor) as VALOR, item.eventoColaborador.tipoCalculoEvento.identificador as ID_EVENTO, item.eventoColaborador.tipoCalculoEvento.evento.descricao as DESCRICAO, item.movimentoFolha.aberturaPeriodo.dataFinal as DATA_FINAL from ItemMovimentoFolha item where exists ( select guia.identificador           from ItemEventoGuiaFolha guia           where guia.tipoCalculo = item.eventoColaborador.tipoCalculoEvento ) and item.movimentoFolha.aberturaPeriodo.dataPagamento = :dataPagamento and exists(select inss.identificador          from CalculoInssEmpresa inss          inner join inss.aberturasPeriodo abr          where          abr.aberturaPeriodo = item.movimentoFolha.aberturaPeriodo) and item.movimentoFolha.aberturaPeriodo.empresa = :empresa group by item.eventoColaborador.tipoCalculoEvento.identificador, item.eventoColaborador.tipoCalculoEvento.evento.descricao, item.movimentoFolha.aberturaPeriodo.dataFinal").setParameter("dataPagamento", (Object)dataPagamento).setParameter("empresa", (Object)empresa).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
    }
}

