/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.ConstantsTipoPreAbastecimento;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.NFCe;
import com.touchcomp.basementor.model.vo.NFCeControleCaixa;
import com.touchcomp.basementor.model.vo.NFCePreAbastecimento;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.model.genericmap.GenericMapValues;
import com.touchcomp.basementorservice.model.genericmap.impl.GenMapResumoImpostosNFCe;
import com.touchcomp.basementorservice.model.genericmap.impl.GenMapResumoVendas;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoNFCeControleCaixaImpl
extends DaoGenericEntityImpl<NFCeControleCaixa, Long> {
    public NFCeControleCaixa getBySerialForSinc(String serialForSinc) {
        return (NFCeControleCaixa)this.toUnique(this.restrictions(this.eq("serialForSinc", serialForSinc)));
    }

    public List<GenericMapValues<GenMapResumoVendas>> getValoresAgrupadosPorMeioPagamentoNFCe(NFCeControleCaixa ... controles) {
        LinkedList status = new LinkedList();
        EnumConstNFeStatus.getStatusNFeAnuladas().forEach(s -> status.add(s.getValue()));
        LinkedList<Long> identificadores = new LinkedList<Long>();
        for (NFCeControleCaixa s2 : controles) {
            identificadores.add(s2.getIdentificador());
        }
        String query = "select sum(p.valorLiquido) as " + String.valueOf(GenMapResumoVendas.VALOR_LIQUIDO) + " , m.identificador as " + String.valueOf(GenMapResumoVendas.ID_MEIO_PAGAMENTO) + " , cp.identificador as " + String.valueOf(GenMapResumoVendas.CATEGORIA_PESSOA) + " , cla.identificador as " + String.valueOf(GenMapResumoVendas.CLASSIFICACAO_PESSOA) + " from NFCePagamento p  inner join p.meioPagamento m inner join p.nfce n inner join n.nfCeControleCaixa cc left join n.unidadeFatCliente u left join u.cliente c left join c.faturamento f left join f.categoriaPessoa cp left join c.classificacaoClientes cla where cc.identificador in(:controleCaixa)  and n.status not in(:status) and p.status = :ativo group by m.identificador,cp.identificador,cla.identificador";
        Query q = this.query(query);
        q.setParameterList("controleCaixa", identificadores);
        q.setParameterList("status", status);
        q.setShort("ativo", (short)1);
        return this.toGenMapList(q, GenMapResumoVendas.class);
    }

    public List<GenericMapValues<GenMapResumoVendas>> getValoresAgrupadosPorMeioPagamentoNFe(NFCeControleCaixa ... controles) {
        LinkedList status = new LinkedList();
        EnumConstNFeStatus.getStatusNFeAnuladas().forEach(s -> status.add(s.getValue().shortValue()));
        LinkedList<Long> identificadores = new LinkedList<Long>();
        for (NFCeControleCaixa s2 : controles) {
            identificadores.add(s2.getIdentificador());
        }
        String query = "select sum(p.valor) as " + String.valueOf(GenMapResumoVendas.VALOR_LIQUIDO) + " , m.identificador as " + String.valueOf(GenMapResumoVendas.ID_MEIO_PAGAMENTO) + " , cp.identificador as " + String.valueOf(GenMapResumoVendas.CATEGORIA_PESSOA) + " , cla.identificador as " + String.valueOf(GenMapResumoVendas.CLASSIFICACAO_PESSOA) + " from InfPagamentoNfPropria p  inner join p.meioPagamento m inner join p.notaFiscalPropria n inner join n.nfceControleCaixa cc left join n.unidadeFatCliente u left join u.cliente c left join c.faturamento f left join f.categoriaPessoa cp left join c.classificacaoClientes cla where cc.identificador in(:controleCaixa)  and n.status not in(:status) and n.naturezaOperacao.contabilizarPorIntegracao = :nao group by m.identificador,cp.identificador,cla.identificador ";
        Query q = this.query(query);
        q.setParameterList("controleCaixa", identificadores);
        q.setParameterList("status", status);
        q.setShort("nao", (short)0);
        return this.toGenMapList(q, GenMapResumoVendas.class);
    }

    public List<GenericMapValues<GenMapResumoImpostosNFCe>> getValoresImpostosNFe(NFCeControleCaixa ... controles) {
        LinkedList<Short> status = new LinkedList<Short>();
        for (NFCeControleCaixa[] s : EnumConstNFeStatus.getStatusNFeAnuladas()) {
            status.add(s.getValue().shortValue());
        }
        LinkedList<Long> identificadores = new LinkedList<Long>();
        for (NFCeControleCaixa s : controles) {
            identificadores.add(s.getIdentificador());
        }
        String query = "select sum(il.vrIcms) as " + String.valueOf(GenMapResumoImpostosNFCe.VALOR_ICMS) + " , sum(il.vrCofins) as " + String.valueOf(GenMapResumoImpostosNFCe.VALOR_COFINS) + " , sum(il.vrPis) as " + String.valueOf(GenMapResumoImpostosNFCe.VALOR_PIS) + " , sum(il.vrIpiIndustria) as " + String.valueOf(GenMapResumoImpostosNFCe.VALOR_IPI) + " , sum(il.vrIrrf) as " + String.valueOf(GenMapResumoImpostosNFCe.VALOR_IRRF) + " , cp.identificador as " + String.valueOf(GenMapResumoImpostosNFCe.ID_CATEGORIA) + " , cl.identificador as " + String.valueOf(GenMapResumoImpostosNFCe.ID_CLASSIFICACAO) + " from NotaFiscalPropria n  inner join n.nfceControleCaixa cc inner join n.itensNotaPropria i inner join n.naturezaOperacao nt inner join i.itemNotaLivroFiscal il left join n.unidadeFatCliente u left join u.cliente c left join c.faturamento f left join n.categoriaPessoa cp left join n.classificacaoCliente cl where cc.identificador in(:controleCaixa)  and n.status not in(:status) and nt.contabilizarPorIntegracao=:nao  group by cp.identificador,cl.identificador ";
        Query q = this.query(query);
        q.setShort("nao", (short)0);
        q.setParameterList("controleCaixa", identificadores);
        q.setParameterList("status", status);
        return this.toGenMapList(q, GenMapResumoImpostosNFCe.class);
    }

    public List<GenericMapValues<GenMapResumoImpostosNFCe>> getValoresImpostosNFCe(NFCeControleCaixa ... controles) {
        LinkedList<Integer> status = new LinkedList<Integer>();
        for (NFCeControleCaixa[] s : EnumConstNFeStatus.getStatusNFeAnuladas()) {
            status.add(s.getValue());
        }
        LinkedList<Long> identificadores = new LinkedList<Long>();
        for (NFCeControleCaixa s : controles) {
            identificadores.add(s.getIdentificador());
        }
        String query = "select sum(t.valorTotalICMS) as " + String.valueOf(GenMapResumoImpostosNFCe.VALOR_ICMS) + " , sum(t.valorTotalCOFINS) as " + String.valueOf(GenMapResumoImpostosNFCe.VALOR_COFINS) + " , sum(t.valorTotalPIS) as " + String.valueOf(GenMapResumoImpostosNFCe.VALOR_PIS) + " , sum(t.valorTotalIPI) as " + String.valueOf(GenMapResumoImpostosNFCe.VALOR_IPI) + " , cp.identificador as " + String.valueOf(GenMapResumoImpostosNFCe.ID_CATEGORIA) + " , cl.identificador as " + String.valueOf(GenMapResumoImpostosNFCe.ID_CLASSIFICACAO) + " from NFCe n  inner join n.totalizadores t inner join n.nfCeControleCaixa cc left join n.unidadeFatCliente u left join u.cliente c left join c.faturamento f left join n.categoriaPessoa cp left join n.classificacaoCliente cl where cc.identificador in(:controleCaixa)  and n.status not in(:status) group by cp.identificador,cl.identificador ";
        Query q = this.query(query);
        q.setEntity("controleCaixa", (Object)controles);
        q.setParameterList("status", status);
        q.setParameterList("controleCaixa", identificadores);
        return this.toGenMapList(q, GenMapResumoImpostosNFCe.class);
    }

    public List<NFCeControleCaixa> get(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        Criteria c = this.criteria();
        c.createAlias("nfceCaixa", "c");
        c.createAlias("c.empresa", "e");
        c.createAlias("e.empresaDados", "ed");
        return this.toList(this.restrictions(c, this.eq("ed.grupoEmpresa", grupoEmpresa), this.eq("realizado", (short)1), this.between("dataFechamento", dataInicial, ToolDate.dataUltHora((Date)dataFinal))));
    }

    public List<NFCeControleCaixa> getControles(Date dataInicial, Date dataFinal, Empresa empresa) {
        Criteria c = this.criteria();
        c.createAlias("nfceCaixa", "c");
        return this.toList(this.restrictions(c, this.eq("c.empresa", empresa), this.eq("realizado", (short)1), this.between("dataFechamento", dataInicial, ToolDate.dataUltHora((Date)dataFinal))));
    }

    public List<NFCe> getNFCeAutorizadasPorNFCeControleCaixa(NFCeControleCaixa nFCeControleCaixa) {
        Query q = this.query(" FROM NFCe n WHERE n.nfCeControleCaixa = :nFCeControleCaixa AND n.status = :status");
        q.setEntity("nFCeControleCaixa", (Object)nFCeControleCaixa);
        q.setInteger("status", EnumConstNFeStatus.AUTORIZADA.getValue().intValue());
        return q.list();
    }

    public List<NFCe> getNFCeCanceladasPorNFCeControleCaixa(NFCeControleCaixa nFCeControleCaixa) {
        Query q = this.query(" FROM NFCe n WHERE n.nfCeControleCaixa = :nFCeControleCaixa AND n.status = :status");
        q.setEntity("nFCeControleCaixa", (Object)nFCeControleCaixa);
        q.setInteger("status", EnumConstNFeStatus.CANCELADA.getValue().intValue());
        return q.list();
    }

    public List<NFCe> getNFCeRejeitadasPorNFCeControleCaixa(NFCeControleCaixa nFCeControleCaixa) {
        Query q = this.query(" FROM NFCe n WHERE n.nfCeControleCaixa = :nFCeControleCaixa AND n.status = :status");
        q.setEntity("nFCeControleCaixa", (Object)nFCeControleCaixa);
        q.setInteger("status", EnumConstNFeStatus.DENEGADA.getValue().intValue());
        return q.list();
    }

    public List<NFCe> getNFCeInutilizadasPorNFCeControleCaixa(NFCeControleCaixa nFCeControleCaixa) {
        Query q = this.query(" FROM NFCe n WHERE n.nfCeControleCaixa = :nFCeControleCaixa AND n.status = :status");
        q.setEntity("nFCeControleCaixa", (Object)nFCeControleCaixa);
        q.setInteger("status", EnumConstNFeStatus.INUTILIZADA.getValue().intValue());
        return q.list();
    }

    public List<NotaFiscalPropria> getNFeAutorizadasPorNFCeControleCaixa(NFCeControleCaixa nFCeControleCaixa) {
        Query q = this.query(" FROM NotaFiscalPropria n WHERE n.nfceControleCaixa = :nfceControleCaixa AND n.status = :status");
        q.setEntity("nfceControleCaixa", (Object)nFCeControleCaixa);
        q.setInteger("status", EnumConstNFeStatus.AUTORIZADA.getValue().intValue());
        return q.list();
    }

    public List<NotaFiscalPropria> getNFeCanceladasPorNFCeControleCaixa(NFCeControleCaixa nFCeControleCaixa) {
        Query q = this.query(" FROM NotaFiscalPropria n WHERE n.nfceControleCaixa = :nfceControleCaixa AND n.status = :status");
        q.setEntity("nfceControleCaixa", (Object)nFCeControleCaixa);
        q.setInteger("status", EnumConstNFeStatus.CANCELADA.getValue().intValue());
        return q.list();
    }

    public List<NotaFiscalPropria> getNFeRejeitadasPorNFCeControleCaixa(NFCeControleCaixa nFCeControleCaixa) {
        Query q = this.query(" FROM NotaFiscalPropria n WHERE n.nfceControleCaixa = :nfceControleCaixa AND n.status = :status");
        q.setEntity("nfceControleCaixa", (Object)nFCeControleCaixa);
        q.setInteger("status", EnumConstNFeStatus.DENEGADA.getValue().intValue());
        return q.list();
    }

    public List<NotaFiscalPropria> getNFeInutilizadasPorNFCeControleCaixa(NFCeControleCaixa nFCeControleCaixa) {
        Query q = this.query(" FROM NotaFiscalPropria n WHERE n.nfceControleCaixa = :nfceControleCaixa AND n.status = :status");
        q.setEntity("nfceControleCaixa", (Object)nFCeControleCaixa);
        q.setInteger("status", EnumConstNFeStatus.INUTILIZADA.getValue().intValue());
        return q.list();
    }

    public List<NFCePreAbastecimento> findPreAbastecimentoByControleCaixa(NFCeControleCaixa nfceControleCaixa, Date dataInicial, Date dataFinal, Short tipo) {
        boolean filtrarData = false;
        if (dataInicial != null && dataFinal != null) {
            filtrarData = true;
        }
        if (tipo.equals(ConstantsTipoPreAbastecimento.TODOS)) {
            Object hql = " from NFCePreAbastecimento p ";
            if (filtrarData) {
                hql = (String)hql + " where p.dataAbastecimento between :dataInicial and :dataFinal";
            }
            Query q = this.query((String)hql);
            if (filtrarData) {
                q.setDate("dataInicial", dataInicial);
                q.setDate("dataFinal", dataFinal);
            }
            return q.list();
        }
        if (tipo.equals(ConstantsTipoPreAbastecimento.SEM_NOTAS)) {
            Object hql = " from NFCePreAbastecimento p where not exists (select i.identificador from NFCeItem i where i.preAbastecimento.identificador = p.identificador)";
            if (filtrarData) {
                hql = (String)hql + " and p.dataAbastecimento between :dataInicial and :dataFinal";
            }
            Query q = this.query((String)hql);
            if (filtrarData) {
                q.setDate("dataInicial", dataInicial);
                q.setDate("dataFinal", dataFinal);
            }
            return q.list();
        }
        if (tipo.equals(ConstantsTipoPreAbastecimento.NOTAS_NAO_ENVIADAS)) {
            Object hql = " from NFCePreAbastecimento p where exists (select i.identificador                      from NFCeItem i                      where i.preAbastecimento.identificador = p.identificador                     and i.nfce.status <> :autorizada                     and i.nfce.status <> :autorizadaForaPrazo                     and i.nfce.status <> :cancelada                     and i.nfce.status <> :canceladaForaPrazo                     and i.nfce.status <> :denegada                     and i.nfce.status <> :denegadaSefaz)";
            if (filtrarData) {
                hql = (String)hql + " and p.dataAbastecimento between :dataInicial and :dataFinal";
            }
            Query q = this.query((String)hql);
            if (filtrarData) {
                q.setDate("dataInicial", dataInicial);
                q.setDate("dataFinal", dataFinal);
            }
            q.setInteger("autorizada", EnumConstNFeStatus.AUTORIZADA.getValue().intValue());
            q.setInteger("autorizadaForaPrazo", EnumConstNFeStatus.AUTORIZADA_FORA_PRAZO.getValue().intValue());
            q.setInteger("cancelada", EnumConstNFeStatus.CANCELADA.getValue().intValue());
            q.setInteger("canceladaForaPrazo", EnumConstNFeStatus.CANCELADA_FORA_DO_PRAZO.getValue().intValue());
            q.setInteger("denegada", EnumConstNFeStatus.DENEGADA.getValue().intValue());
            q.setInteger("denegadaSefaz", EnumConstNFeStatus.REJ_NFE_DENEGADA_SEFAZ.getValue().intValue());
            return q.list();
        }
        if (tipo.equals(ConstantsTipoPreAbastecimento.NOTAS_INUTILIZADAS)) {
            Object hql = " from NFCePreAbastecimento p where exists (select i.identificador                      from NFCeItem i                      where i.preAbastecimento.identificador = p.identificador                     and i.nfce.inutilizacaoNFe.status = :inutilizada)";
            if (filtrarData) {
                hql = (String)hql + " and p.dataAbastecimento between :dataInicial and :dataFinal";
            }
            Query q = this.query((String)hql);
            if (filtrarData) {
                q.setDate("dataInicial", dataInicial);
                q.setDate("dataFinal", dataFinal);
            }
            q.setInteger("inutilizada", EnumConstNFeStatus.INUTILIZADA.getValue().intValue());
            return q.list();
        }
        if (tipo.equals(ConstantsTipoPreAbastecimento.NOTAS_CANCELADAS)) {
            Object hql = " from NFCePreAbastecimento p where exists (select i.identificador                      from NFCeItem i                      where i.preAbastecimento.identificador = p.identificador and (i.nfce.status = :cancelada or i.nfce.status = :canceladaForaPrazo  or i.nfce.status = :denegada or i.nfce.status = :denegadaSefaz))";
            if (filtrarData) {
                hql = (String)hql + " and p.dataAbastecimento between :dataInicial and :dataFinal";
            }
            Query q = this.query((String)hql);
            if (filtrarData) {
                q.setDate("dataInicial", dataInicial);
                q.setDate("dataFinal", dataFinal);
            }
            q.setInteger("cancelada", EnumConstNFeStatus.CANCELADA.getValue().intValue());
            q.setInteger("canceladaForaPrazo", EnumConstNFeStatus.CANCELADA_FORA_DO_PRAZO.getValue().intValue());
            q.setInteger("denegada", EnumConstNFeStatus.DENEGADA.getValue().intValue());
            q.setInteger("denegadaSefaz", EnumConstNFeStatus.REJ_NFE_DENEGADA_SEFAZ.getValue().intValue());
            return q.list();
        }
        if (tipo.equals(ConstantsTipoPreAbastecimento.NOTAS_ENVIADAS)) {
            Object hql = " from NFCePreAbastecimento p where exists (select i.identificador                      from NFCeItem i                      where i.preAbastecimento.identificador = p.identificador                     and (i.nfce.status = :autorizada  or i.nfce.status = :autorizadaForaPrazo))";
            if (filtrarData) {
                hql = (String)hql + " and p.dataAbastecimento between :dataInicial and :dataFinal";
            }
            Query q = this.query((String)hql);
            if (filtrarData) {
                q.setDate("dataInicial", dataInicial);
                q.setDate("dataFinal", dataFinal);
            }
            q.setInteger("autorizada", EnumConstNFeStatus.AUTORIZADA.getValue().intValue());
            q.setInteger("autorizadaForaPrazo", EnumConstNFeStatus.AUTORIZADA_FORA_PRAZO.getValue().intValue());
            return q.list();
        }
        if (tipo.equals(ConstantsTipoPreAbastecimento.AFERICAO)) {
            Object hql = " from NFCePreAbastecimento p where exists (select i.identificador                      from NFCeAfericaoPreAbastecimento i                      where i.preAbastecimento.identificador = p.identificador                     and i.nfCeControleCaixa.identificador = :idControleCaixa )";
            if (filtrarData) {
                hql = (String)hql + " and p.dataAbastecimento between :dataInicial and :dataFinal";
            }
            Query q = this.query((String)hql);
            if (filtrarData) {
                q.setDate("dataInicial", dataInicial);
                q.setDate("dataFinal", dataFinal);
            }
            q.setLong("idControleCaixa", nfceControleCaixa.getIdentificador().longValue());
            return q.list();
        }
        return new ArrayList<NFCePreAbastecimento>();
    }
}

