/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstAbertoFechado;
import com.touchcomp.basementor.model.vo.NFCeControleCaixa;
import com.touchcomp.basementor.model.vo.NFCeEncerranteAbastecimento;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoNFCeEncerranteAbastecimentoImpl
extends DaoGenericEntityImpl<NFCeEncerranteAbastecimento, Long> {
    public List<NFCeEncerranteAbastecimento> findEncerrantesAbastecimentoByControleCaixa(NFCeControleCaixa nfceControleCaixa) {
        Criteria crit = this.criteria();
        return this.toList(this.restrictions(crit, this.eq("controleCaixa", nfceControleCaixa)));
    }

    public NFCeEncerranteAbastecimento findEncerramentoPosterior(NFCeEncerranteAbastecimento n) {
        String query = "select\nn\nfrom NFCeEncerranteAbastecimento n\n\tinner join n.controleCaixa cc\n\t\tinner join cc.nfceCaixa nc\nwhere n.bico = :pBico\nand nc.caixaSlave = 0\nand n.status = :pStatus\nand n.dataEncerramento > :pDataEncerramento\norder by n.dataEncerramento";
        Query q = this.query(query);
        q.setLong("pStatus", (long)EnumConstAbertoFechado.ABERTO.getValue());
        q.setDate("pDataEncerramento", n.getDataEncerramento());
        q.setEntity("pBico", (Object)n.getBico());
        q.setMaxResults(1);
        return (NFCeEncerranteAbastecimento)q.uniqueResult();
    }

    public NFCeEncerranteAbastecimento findEncerramentoAnterior(NFCeEncerranteAbastecimento n) {
        String query = "select\nn\nfrom NFCeEncerranteAbastecimento n\n\tinner join n.controleCaixa cc\n\t\tinner join cc.nfceCaixa nc\nwhere n.bico = :pBico\nand nc.caixaSlave = 0\nand n.status = :pStatus\nand n.dataEncerramento < :pDataEncerramento\norder by n.dataEncerramento desc";
        Query q = this.query(query);
        q.setLong("pStatus", (long)EnumConstAbertoFechado.FECHADO.getValue());
        q.setDate("pDataEncerramento", n.getDataEncerramento());
        q.setEntity("pBico", (Object)n.getBico());
        q.setMaxResults(1);
        return (NFCeEncerranteAbastecimento)q.uniqueResult();
    }
}

