/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.constants.enums.statusobjeto.EnumConstStatusObjeto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.NFCe;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.VersaoNFe;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.centraldocsproprios.DTOCentralDocsPropriosNFCe;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoNFCeImpl
extends DaoGenericEntityImpl<NFCe, Long> {
    public NFCe getBySerialForSinc(String serialForSinc) {
        return (NFCe)this.toUnique(this.restrictions(this.eq("serialForSinc", serialForSinc)));
    }

    public NFCe get(Long numero, String serie, Long modeloDocFiscalIdentificador, Long empresaIdentificador) {
        String query = " from NFCe n  where n.numero = :numero and n.serie = :serie  and n.modeloDocFiscal.identificador = :modeloDocFiscalIdentificador and n.empresa.identificador = :empresaIdentificador order by n.identificador desc";
        Query q = this.query(query);
        q.setLong("numero", (long)numero.intValue());
        q.setString("serie", serie);
        q.setLong("modeloDocFiscalIdentificador", modeloDocFiscalIdentificador.longValue());
        q.setLong("empresaIdentificador", empresaIdentificador.longValue());
        List listNFCe = q.list();
        return ToolMethods.isWithData((Collection)listNFCe) ? (NFCe)listNFCe.get(0) : null;
    }

    public void atualizarNatRecPisCofinsItens(Date dataIn, Date dataFim) {
        String query = "update NFCeItemPis pis set pis.natReceitaPisCofins= (select pn.naturezaReceitaPisCofins from NFCeItem i  inner join i.pis pis1  inner join i.produto p  inner join p.naturezasReceita pn  inner join pn.paramReceitaPisCofinsCST par  where pis = pis1  and pis.incidenciaPisCofins = par.incidenciaPisCofins)  where exists(  select i.identificador from NFCeItem i  inner join i.pis pis2  inner join i.nfce n  where pis2 = pis  and cast(n.dataEmissao as date) between :data_inicial and :data_final)";
        Query q = this.query(query);
        q.setDate("data_inicial", dataIn);
        q.setDate("data_final", dataFim);
        q.executeUpdate();
        query = "update NFCeItemCofins cofins set cofins.natReceitaPisCofins= (select pn.naturezaReceitaPisCofins from NFCeItem i  inner join i.cofins cofins1  inner join i.produto p  inner join p.naturezasReceita pn  inner join pn.paramReceitaPisCofinsCST par  where cofins = cofins1  and cofins.incidenciaPisCofins = par.incidenciaPisCofins)  where exists(  select i.identificador from NFCeItem i  inner join i.cofins cofins2  inner join i.nfce n  where cofins2 = cofins  and cast(n.dataEmissao as date) between :data_inicial and :data_final)";
        q = this.query(query);
        q.setDate("data_inicial", dataIn);
        q.setDate("data_final", dataFim);
        q.executeUpdate();
    }

    public List<NFCe> pesquisarNFCeSemLivroFiscal(Empresa empresa, Date dataInicial, Date dataFinal) {
        String query = " select distinct n from NFCe n  where n.status = 100 and n.empresa = :empresa and n.dataEmissao between :dataInicial and :dataFinal and not exists(select nf.identificador                from NFCe nf                 inner join nf.livrosFiscais lv                 where nf.identificador = n.identificador)";
        Query q = this.query(query);
        q.setEntity("empresa", (Object)empresa);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        return q.list();
    }

    public List<NFCe> pesquisarNFCeFlagReprocessado(Short flagReprocessado) {
        String query = " select distinct n from NFCe n  where n.status = 100 and n.reprocessado = :flag";
        Query q = this.query(query);
        q.setShort("flag", flagReprocessado.shortValue());
        return q.list();
    }

    public NFCe getUltimaNotaByPessoa(String cnpj) {
        String hql = "select   \n n\n from NFCe n  \n      inner join n.unidadeFatCliente uf   \n          inner join uf.cliente c   \n where c.pessoa.complemento.cnpj = :cnpj\n and n.status = 100\n order by n.dataPrevSaida desc\n";
        Query q = this.query(hql);
        q.setString("cnpj", cnpj);
        q.setMaxResults(1);
        return (NFCe)q.uniqueResult();
    }

    public List<DTOCentralDocsPropriosNFCe> getNFCes(Integer regsPerPage, Integer page, GrupoEmpresa grupoEmpresa, Pessoa pessoa, Short filtrarData, Date dataInicial, Date dataFinal, Short filtrarNumero, Long numero, Short filtrarChave, String chaveNFe) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jEmpresa = aux.join("empresa");
        Join jEmpresaDados = aux.join((From)jEmpresa, "empresaDados");
        Join jEmpresaPessoa = aux.join((From)jEmpresa, "pessoa");
        Join jEmpresaPessoaComp = aux.join((From)jEmpresaPessoa, "complemento");
        Join jtotais = aux.join("totalizadores");
        Join jNFCePessoa = aux.joinLeft("nfcePessoa");
        Join jUnidadeFatCliente = aux.joinLeft("unidadeFatCliente");
        Join jCliente = aux.joinLeft((From)jUnidadeFatCliente, "cliente");
        Join jClientePessoa = aux.joinLeft((From)jCliente, "pessoa");
        Join jClientePessoaComp = aux.joinLeft((From)jClientePessoa, "complemento");
        aux.equal((From)jEmpresaDados, "grupoEmpresa", grupoEmpresa);
        aux.or(aux.getEqual((From)jCliente, "pessoa", pessoa), aux.getEqual((From)jNFCePessoa, "cpfCnpj", pessoa.getComplemento().getCnpj()));
        LinkedList status = new LinkedList();
        EnumConstNFeStatus.getStatusFinalList().forEach(i -> status.add(i.getValue()));
        aux.inNumber("status", status);
        if (ToolMethods.isAffirmative((Number)filtrarChave)) {
            aux.equal("chaveNFCe", chaveNFe);
        }
        if (ToolMethods.isAffirmative((Number)filtrarNumero)) {
            aux.equal("numero", numero);
        }
        if (ToolMethods.isAffirmative((Number)filtrarData)) {
            aux.between("dataEmissao", dataInicial, (Comparable)ToolDate.getLastDateOnDay((Date)dataFinal));
        }
        aux.setMaxResults(regsPerPage);
        aux.setFirstResult(page * regsPerPage);
        aux.select(AuxCriteriaBuilder.pair("identificador", "F_ID_NOTA_PROPRIA"), AuxCriteriaBuilder.pair("numero", "F_NUMERO"), AuxCriteriaBuilder.pair("serie", "F_SERIE"), AuxCriteriaBuilder.pair("dataEmissao", "F_DATA_EMISSAO"), AuxCriteriaBuilder.pair("chaveNFCe", "F_CHAVE"), AuxCriteriaBuilder.pair("status", "F_STATUS"), AuxCriteriaBuilder.pair("motivo", "F_STATUS_STR"), AuxCriteriaBuilder.pair((From)jtotais, "valorTotalNFe", "F_VALOR"), AuxCriteriaBuilder.pair((From)jEmpresaPessoa, "nome", "F_EMITENTE"), AuxCriteriaBuilder.pair((From)jEmpresaPessoa, "nomeFantasia", "F_EMITENTE_NOME_FANTASIA"), AuxCriteriaBuilder.pair((From)jEmpresaPessoaComp, "cnpj", "F_CNPJ_EMITENTE"), AuxCriteriaBuilder.pair((From)jClientePessoa, "nome", "F_DESTINATARIO"), AuxCriteriaBuilder.pair((From)jClientePessoa, "nomeFantasia", "F_DEST_NOME_FANTASIA"), AuxCriteriaBuilder.pair((From)jClientePessoaComp, "cnpj", "F_CNPJ_DESTINATARIO"));
        List<Map<String, Object>> res = aux.getResultMap();
        LinkedList<DTOCentralDocsPropriosNFCe> ret = new LinkedList<DTOCentralDocsPropriosNFCe>();
        for (Map<String, Object> map : res) {
            DTOCentralDocsPropriosNFCe d = new DTOCentralDocsPropriosNFCe();
            d.setIdentificador((Long)map.get("F_ID_NOTA_PROPRIA"));
            d.setNumeroDoc((Number)map.get("F_NUMERO"));
            d.setSerieDoc((String)map.get("F_SERIE"));
            d.setDataEmissao((Date)map.get("F_DATA_EMISSAO"));
            d.setChave((String)map.get("F_CHAVE"));
            d.setValor((Double)map.get("F_VALOR"));
            d.setEmitente((String)map.get("F_EMITENTE"));
            d.setCnpjEmitente((String)map.get("F_CNPJ_EMITENTE"));
            d.setEmitenteNomeFantasia((String)map.get("F_EMITENTE_NOME_FANTASIA"));
            d.setCnpjDestinatarioTomador((String)map.get("F_CNPJ_DESTINATARIO"));
            d.setDestinatario((String)map.get("F_DESTINATARIO"));
            d.setDestinatarioNomeFantasia((String)map.get("F_DEST_NOME_FANTASIA"));
            d.setStatusSefaz((Integer)map.get("F_STATUS"));
            d.setStatusSefazStr((String)map.get("F_STATUS_STR"));
            ret.add(d);
        }
        return ret;
    }

    public VersaoNFe getVersaoEmissaoNFe(Long idNota) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        aux.equal("identificador", idNota);
        aux.select("versaoNfe");
        return (VersaoNFe)aux.getUniqueResult();
    }

    public String getChaveNFe(Long idNota) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        aux.equal("identificador", idNota);
        aux.select("chaveNFCe");
        return (String)aux.getUniqueResult();
    }

    public List findProdutosValorDataNFCe(Date data, Empresa empresa) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jNaturezaOp = aux.join("naturezaOperacao");
        Join jCategoriaPessoa = aux.joinLeft("categoriaPessoa");
        Join jClassificacaoCli = aux.joinLeft("classificacaoCliente");
        Join jSituacaoDoc = aux.join("situacaoDocumento");
        Join jItens = aux.join("itens");
        Join jModeloFiscal = jItens.join("modeloFiscal");
        Join jProduto = jItens.join("produto");
        Join jSubespecie = jProduto.join("subEspecie");
        Join jUnidadeFatCliente = aux.joinLeft("unidadeFatCliente");
        Join jPessoa = jUnidadeFatCliente.join("pessoa", JoinType.LEFT);
        Join jEndereco = jPessoa.join("endereco", JoinType.LEFT);
        Join jCidade = jEndereco.join("cidade", JoinType.LEFT);
        Join jUF = jCidade.join("uf", JoinType.LEFT);
        aux.select(AuxCriteriaBuilder.pair((From)jProduto, "identificador", "ID_PRODUTO"));
        aux.select(AuxCriteriaBuilder.pair((From)jNaturezaOp, "identificador", "ID_NATUREZA_OPERACAO"));
        aux.select(AuxCriteriaBuilder.pair((From)jModeloFiscal, "identificador", "ID_MODELO_FISCAL"));
        aux.select(AuxCriteriaBuilder.pair((From)jCategoriaPessoa, "identificador", "ID_CATEGORIA_PESSOA"));
        aux.select(AuxCriteriaBuilder.pair((From)jClassificacaoCli, "identificador", "ID_CLASSIFICACAO_CLIENTE"));
        aux.select(AuxCriteriaBuilder.pair((From)jSubespecie, "identificador", "ID_SUB_ESPECIE"));
        aux.select(AuxCriteriaBuilder.pair((From)jUF, "identificador", "ID_UNIDADE_FEDERATIVA"));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair((From)jItens, "quantidadeComercial", "QUANTIDADE")));
        aux.equal("dataEmissao", data);
        aux.equal("empresa", empresa);
        aux.and(aux.notEqual((From)jSituacaoDoc, "codigo", "02"), aux.notEqual((From)jSituacaoDoc, "codigo", "03"), aux.notEqual((From)jSituacaoDoc, "codigo", "04"));
        aux.equal((From)jModeloFiscal, "opcaoContabilizacaoCPV", EnumConstantsMentorSimNao.SIM.getValue());
        aux.equal((From)jItens, "status", EnumConstStatusObjeto.ATIVO.getValue());
        aux.groupBy(aux.getExpression((From)jProduto, "identificador"), aux.getExpression((From)jNaturezaOp, "identificador"), aux.getExpression((From)jModeloFiscal, "identificador"), aux.getExpression((From)jCategoriaPessoa, "identificador"), aux.getExpression((From)jClassificacaoCli, "identificador"), aux.getExpression((From)jSubespecie, "identificador"), aux.getExpression((From)jUF, "identificador"));
        return aux.getResultMap();
    }
}

