/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.naturezaoperacao.EnumConstNatOpEntSaidaFaturamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoNaturezaOperacaoImpl
extends DaoGenericEntityImpl<NaturezaOperacao, Long> {
    public List<NaturezaOperacao> getNaturezasOperacaoEntrada() {
        return this.toList(this.restrictions(this.eq("entradaSaida", EnumConstNatOpEntSaidaFaturamento.ENT_SAI_ENTRADA.getValue())));
    }

    public List<NaturezaOperacao> getNaturezasPedAlmox(Empresa empresa) {
        Criteria crit = this.criteria();
        crit.createAlias("empresas", "emps");
        this.restrictions(crit, this.eq("emps.empresa", empresa), this.eq("natOperacaoDispPedAlmox", (short)1));
        return this.toList(crit);
    }

    public List<NaturezaOperacao> getNaturezasNecCompra(Empresa empresa) {
        Criteria crit = this.criteria();
        crit.createAlias("empresas", "emps");
        this.restrictions(crit, this.eq("emps.empresa", empresa), this.eq("natOperacaoDispNecCompra", (short)1));
        return this.toList(crit);
    }

    public NaturezaOperacao getNaturezaNecCompra(Long identificador, Empresa empresa) {
        Criteria crit = this.criteria();
        crit.createAlias("empresas", "emps");
        this.restrictions(crit, this.eq("identificador", identificador), this.eq("emps.empresa", empresa), this.eq("natOperacaoDispNecCompra", (short)1));
        return (NaturezaOperacao)this.toUnique(crit);
    }

    public List getNatOpEntAtivaDev(Empresa empresa) {
        Query q = this.query("select distinct n    from NaturezaOperacao n   inner join n.empresas e  where n.ativo=:ativo and n.natOperacaoDevolucao=:natOperacaoDevolucao and e.empresa = :empresa and (n.entradaSaida=:op1)  order by n.descricaoAuxiliar");
        q.setShort("ativo", (short)1);
        q.setShort("op1", (short)0);
        q.setShort("natOperacaoDevolucao", (short)1);
        q.setEntity("empresa", (Object)empresa);
        return q.list();
    }

    public List getNatOpSaiAtivaDev(Empresa empresa) {
        Query q = this.query("select distinct n    from NaturezaOperacao n   inner join n.empresas e  where n.ativo=:ativo and n.natOperacaoDevolucao=:natOperacaoDevolucao and e.empresa = :empresa and (n.entradaSaida=:op1)  order by n.descricaoAuxiliar");
        q.setShort("ativo", (short)1);
        q.setShort("op1", (short)1);
        q.setShort("natOperacaoDevolucao", (short)1);
        q.setEntity("empresa", (Object)empresa);
        return q.list();
    }

    public List getNatOpSaiAtiva(Empresa empresa) {
        Query q = this.query("select distinct n    from NaturezaOperacao n   inner join n.empresas e  where n.ativo=:ativo and e.empresa = :empresa and (n.entradaSaida=:op1)  order by n.descricaoAuxiliar");
        q.setParameter("ativo", (Object)1);
        q.setParameter("op1", (Object)1);
        q.setParameter("empresa", (Object)empresa);
        return q.list();
    }

    public List getNatOpFatEntAtivaDev(Empresa empresa) {
        Query q = this.query("select distinct n    from NaturezaOperacao n   inner join n.empresas e  where n.ativo=:ativo and n.natOperacaoDevolucao=:natOperacaoDevolucao and e.empresa = :empresa and (n.entradaSaida=:op1)  order by n.descricaoAuxiliar");
        q.setShort("ativo", (short)1);
        q.setShort("op1", (short)2);
        q.setShort("natOperacaoDevolucao", (short)1);
        q.setEntity("empresa", (Object)empresa);
        return q.list();
    }
}

