/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.CotacaoCompra;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OrdemCompra;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.Criteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.query.Query;
import org.hibernate.sql.JoinType;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Repository;

@Repository
public class DaoNecessidadeCompraImpl
extends DaoGenericEntityImpl<NecessidadeCompra, Long> {
    public List<NecessidadeCompra> findNecessidadesCompraAbertasLiberadas(Usuario usuario, Empresa empresa, OpcoesCompraSuprimentos opcoesCompraSuprimentos) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jItemCotCompraGerada = aux.joinLeft("itemCotacaoCompraGerada");
        Join jLiberacaoNecCompraItem = aux.join("liberacaoNecCompraItem");
        LinkedList<Predicate> where = new LinkedList<Predicate>();
        if (!TMethods.isAffirmative((Number)opcoesCompraSuprimentos.getExibirNecCompraOutrosUs())) {
            where.add(aux.or(aux.equal("usuarioComprador", usuario), aux.isNull("usuarioComprador")));
        }
        where.add(aux.isNull((From)jItemCotCompraGerada, "identificador"));
        where.add(aux.isNotNull((From)jLiberacaoNecCompraItem, "identificador"));
        where.add(aux.equal("empresa", empresa));
        where.add(aux.or(aux.notEqual("desativarNecessidade", EnumConstantsMentorSimNao.SIM.getValue()), aux.isNull("desativarNecessidade")));
        aux.where(where);
        return aux.getResult();
    }

    public List<NecessidadeCompra> findNecessidadesCompraAbertas(Usuario usuario, Empresa empresa, OpcoesCompraSuprimentos opcoesCompraSuprimentos) {
        Object hql = " SELECT nc  FROM NecessidadeCompra nc  WHERE nc.itemCotacaoCompraGerada IS NULL  AND nc.empresa = :empresa  AND (nc.desativarNecessidade <> :desativarnecessidade OR nc.desativarNecessidade IS NULL)";
        if (ToolMethods.isEquals((Object)opcoesCompraSuprimentos.getExibirNecCompraOutrosUs(), (Object)EnumConstantsMentorSimNao.NAO.getValue())) {
            hql = (String)hql + " AND (nc.usuarioComprador = :usuario OR nc.usuarioComprador IS NULL )";
        }
        Query q = this.query((String)hql);
        if (ToolMethods.isEquals((Object)opcoesCompraSuprimentos.getExibirNecCompraOutrosUs(), (Object)EnumConstantsMentorSimNao.NAO.getValue())) {
            q.setEntity("usuario", (Object)usuario);
        }
        q.setEntity("empresa", (Object)empresa);
        q.setShort("desativarnecessidade", EnumConstantsMentorSimNao.SIM.getValue());
        return q.list();
    }

    public List getAtendPedAlmox(NecessidadeCompra necessidadeCompra) {
        String hql = "SELECT pa.identificador as ItemPa  FROM NecessidadeCompra nc  INNER JOIN nc.atendPedAlmoxNecCompra ac  INNER JOIN ac.atendPedidoAlmoxItemGrade ag  INNER JOIN ag.atendPedidoAlmoxItem ai  INNER JOIN ai.itemPedidoAlmoxarifado ia  INNER JOIN ia.pedidoAlmoxarifado pa  WHERE nc.identificador = :necessidadeCompra ";
        Query q = this.query(hql);
        q.setLong("necessidadeCompra", necessidadeCompra.getIdentificador().longValue());
        return q.list();
    }

    public List<NecessidadeCompra> getNecessidadesByItemCotacao(Long identificadorItem) {
        return this.toList(this.restrictions(this.isNotNull("itemCotacaoCompraGerada"), this.eq("itemCotacaoCompraGerada.identificador", identificadorItem)));
    }

    public List<NecessidadeCompra> getNecessidadesCompraNaoLiberadas(Date dataInicial, Date dataFinal, Long idEmpresa, Short filtrarGrupoNecessidadeCompra, Long idGrupoNecessidadeCompra, Short filtrarUsuarioSolicitante, Long idUsuarioSolicitante, Short filtrarCentroCusto, Long idCentroCusto, Long idUsuarioLiberacao) {
        CriteriaBuilder builder = this.criteriaBuilder(NecessidadeCompra.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root fromNecessidadeCompra = crit.from(NecessidadeCompra.class);
        Join jEmpresa = fromNecessidadeCompra.join("empresa", javax.persistence.criteria.JoinType.INNER);
        Join jLiberacaoNecCompraItem = fromNecessidadeCompra.join("liberacaoNecCompraItem", javax.persistence.criteria.JoinType.LEFT);
        Join jUsuarioLiberacao = fromNecessidadeCompra.join("usuarioLiberacao", javax.persistence.criteria.JoinType.LEFT);
        if (ToolMethods.isEquals((Object)filtrarGrupoNecessidadeCompra, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            Join jGrupoNecCompra = fromNecessidadeCompra.join("grupoNecCompra", javax.persistence.criteria.JoinType.INNER);
            exps.add(builder.equal((Expression)jGrupoNecCompra.get("identificador"), (Object)idGrupoNecessidadeCompra));
        }
        if (ToolMethods.isEquals((Object)filtrarUsuarioSolicitante, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            Join jUsuarioSolicitante = fromNecessidadeCompra.join("usuarioSolicitante", javax.persistence.criteria.JoinType.INNER);
            exps.add(builder.equal((Expression)jUsuarioSolicitante.get("identificador"), (Object)idUsuarioSolicitante));
        }
        if (ToolMethods.isEquals((Object)filtrarCentroCusto, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            Join jCentroCusto = fromNecessidadeCompra.join("centroCusto", javax.persistence.criteria.JoinType.INNER);
            exps.add(builder.equal((Expression)jCentroCusto.get("identificador"), (Object)idCentroCusto));
        }
        crit.select((Selection)fromNecessidadeCompra);
        Predicate equalUsuarioLiberacao = builder.equal((Expression)jUsuarioLiberacao.get("identificador"), (Object)idUsuarioLiberacao);
        Predicate isNullUsuarioLiberacao = builder.isNull((Expression)jUsuarioLiberacao);
        exps.add(builder.or((Expression)equalUsuarioLiberacao, (Expression)isNullUsuarioLiberacao));
        exps.add(builder.isNull((Expression)jLiberacaoNecCompraItem.get("identificador")));
        exps.add(builder.between((Expression)fromNecessidadeCompra.get("dataNecessidade"), (Comparable)dataInicial, (Comparable)dataFinal));
        exps.add(builder.equal((Expression)jEmpresa.get("identificador"), (Object)idEmpresa));
        Predicate equalDesativarNecessidade = builder.equal((Expression)fromNecessidadeCompra.get("desativarNecessidade"), (Object)EnumConstantsMentorSimNao.NAO.getValue());
        Predicate isNullDesativarNecessidade = builder.isNull((Expression)fromNecessidadeCompra.get("desativarNecessidade"));
        exps.add(builder.or((Expression)equalDesativarNecessidade, (Expression)isNullDesativarNecessidade));
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }

    public Double findSaldoCompraAbertoGradeCor(GradeCor gradeCor) {
        Double saldoCompraAberto = 0.0;
        saldoCompraAberto = saldoCompraAberto + this.findSaldoCompraAbertoNecessidadeCompra(gradeCor);
        saldoCompraAberto = saldoCompraAberto + this.findSaldoCompraAbertoCotacaoCompra(gradeCor);
        saldoCompraAberto = saldoCompraAberto + this.findSaldoCompraAbertoOrdemCompra(gradeCor);
        return saldoCompraAberto;
    }

    public Double findSaldoCompraAbertoNecessidadeCompra(GradeCor gradeCor) {
        Criteria criteria = this.criteria();
        criteria.createAlias("gradeCor", "gradeCor");
        criteria.setProjection((Projection)Projections.sum((String)"quantidadeNecessidade"));
        criteria.add(this.isNull("itemCotacaoCompraGerada"));
        criteria.add(this.eq("gradeCor.identificador", gradeCor.getIdentificador()));
        criteria.add(this.notEqual("desativarNecessidade", EnumConstantsMentorSimNao.SIM.getValue()));
        Double ret = (Double)criteria.uniqueResult();
        return ret != null ? ret : 0.0;
    }

    public Double findSaldoCompraAbertoCotacaoCompra(GradeCor gradeCor) {
        Criteria criteria = this.criteria(CotacaoCompra.class);
        criteria.createAlias("itensCotacaoCompra", "itemCotacaoCompra");
        criteria.createAlias("itemCotacaoCompra.gradeCor", "gradeCor");
        criteria.setProjection((Projection)Projections.sum((String)"itemCotacaoCompra.quantidade"));
        criteria.add(this.isEmpty("ordensCompra"));
        criteria.add(this.eq("fechada", EnumConstantsMentorSimNao.NAO.getValue()));
        criteria.add(this.eq("gradeCor.identificador", gradeCor.getIdentificador()));
        Double ret = (Double)criteria.uniqueResult();
        return ret != null ? ret : 0.0;
    }

    public Double findSaldoCompraAbertoOrdemCompra(GradeCor gradeCor) {
        Double quantidadeRecebida;
        Criteria criteria = this.criteria(OrdemCompra.class);
        criteria.createAlias("itemOrdemCompra", "itemOrdemCompra");
        criteria.createAlias("itemOrdemCompra.gradeItemOrdemCompra", "gradeItemOrdemCompra");
        criteria.createAlias("gradeItemOrdemCompra.gradeCor", "gradeCor");
        criteria.createAlias("itemOrdemCompra.itemRecepcaoMercadorias", "itemRecepcaoMercadorias", JoinType.LEFT_OUTER_JOIN);
        criteria.createAlias("itemRecepcaoMercadorias.gradeItemRecMercadorias", "gradeItemRecMercadorias", JoinType.LEFT_OUTER_JOIN);
        criteria.createAlias("statusOrdemCompra", "statusOrdemCompra");
        ProjectionList projections = Projections.projectionList();
        projections.add(Projections.sum((String)"itemOrdemCompra.quantidadeTotal").as("quantidadeTotal"));
        projections.add(Projections.sum((String)"gradeItemRecMercadorias.quantidade").as("quantidadeRecebida"));
        criteria.setProjection((Projection)projections);
        criteria.add(this.eq("statusOrdemCompra.status", EnumConstantsMentorSimNao.NAO.getValue()));
        criteria.add(this.eq("itemOrdemCompra.fechado", EnumConstantsMentorSimNao.NAO.getValue()));
        criteria.add(this.eq("gradeCor.identificador", gradeCor.getIdentificador()));
        criteria.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        HashMap ret = (HashMap)criteria.uniqueResult();
        Double quantidadeTotal = (Double)ret.get("quantidadeTotal");
        if (quantidadeTotal == null) {
            quantidadeTotal = 0.0;
        }
        if ((quantidadeRecebida = (Double)ret.get("quantidadeRecebida")) == null) {
            quantidadeRecebida = 0.0;
        }
        return quantidadeTotal - quantidadeRecebida;
    }

    public List<NecessidadeCompra> pesqusarNecessidadeCompra(GradeCor gradeCor) {
        String hql = "SELECT nc FROM NecessidadeCompra nc  INNER JOIN nc.gradeCor g  WHERE g = :gradeCor AND nc.itemCotacaoCompraGerada IS NULL AND nc.desativarNecessidade = :nao";
        Query q = this.query(hql);
        q.setParameter("gradeCor", (Object)gradeCor);
        q.setParameter("nao", (Object)EnumConstantsMentorSimNao.NAO.getValue());
        return q.list();
    }
}

