/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoNodoImpl
extends DaoGenericEntityImpl<Nodo, Long> {
    public List<Map<String, Object>> getNodosByName(String name) {
        Criteria c = this.criteria();
        this.fields(c, "identificador", "descricao");
        this.order(c, "descricao");
        this.restrictions(c, Restrictions.ilike((String)"descricao", (Object)("%" + name + "%")));
        return this.toHashList(c);
    }

    public Nodo getNodoByVoClass(String classe) {
        Criteria c = this.criteria();
        this.restrictions(c, new Criterion[]{Restrictions.eq((String)"voClasses", (Object)classe)});
        return (Nodo)this.toUnique(c);
    }

    public List<Nodo> getNodosMenuLiberados() {
        Criteria c = this.criteria();
        c.add((Criterion)Restrictions.eq((String)"bloqueado", (Object)EnumConstantsMentorSimNao.NAO.getValue()));
        c.addOrder(Order.asc((String)"idChild"));
        c.addOrder(Order.asc((String)"descricao"));
        return c.list();
    }

    public List<Nodo> getNodosMenu() {
        Criteria c = this.criteria();
        c.addOrder(Order.asc((String)"idChild"));
        c.addOrder(Order.asc((String)"descricao"));
        return c.list();
    }

    public List<Nodo> getNodosRecursos() {
        String query = "from Nodo n where (n.frameClass is not null or n.pathWeb is not null) order by n.descricao";
        Query q = this.query(query);
        return q.getResultList();
    }

    public List<Nodo> getNodosUtilizaCertificadoDigital() {
        Criteria c = this.criteria();
        c.add((Criterion)Restrictions.eq((String)"utilizaCertificadoDigital", (Object)EnumConstantsMentorSimNao.SIM.getValue()));
        c.addOrder(Order.asc((String)"identificador"));
        return c.list();
    }
}

