/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.model.impl.CustoProdutoUltimaNF;
import com.touchcomp.basementor.model.vo.AjusteEstoque;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.DadosTransNfPropria;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Especie;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemReinfNotas2020;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementor.model.vo.VersaoNFe;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchvomodel.vo.centraldocsproprios.DTOCentralDocsPropriosNFe;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.sql.JoinType;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Repository;

@Repository
public class DaoNotaFiscalPropriaImpl
extends DaoGenericEntityImpl<NotaFiscalPropria, Long> {
    public Date getDataUltimaCompraCliente(Cliente cliente) {
        Query q = this.query(" select max(n.dataEmissaoNota)  from NotaFiscalPropria n  where n.unidadeFatCliente.cliente  = :cliente  and n.status IN(:aprovado)");
        q.setEntity("cliente", (Object)cliente);
        q.setParameter("aprovado", (Object)EnumConstNFeStatus.getStatusAutorizadaShort());
        q.setMaxResults(1);
        return (Date)q.uniqueResult();
    }

    public List<NotaFiscalPropria> findNotasTransferenciasNaoTransferidas(String naturezaOperacao, Date dataInicial, Date dataFinal, int page, int maxRes) {
        String[] naturezas;
        Criteria crit = this.criteria();
        crit.createAlias("naturezaOperacao", "nat");
        crit.add(this.in("status", EnumConstNFeStatus.getStatusAutorizadaShort()));
        crit.add(this.eq("transferidaFilial", (short)0));
        if (dataInicial != null) {
            crit.add(this.greatherEqual("dataEmissaoNota", ToolDate.dataSemHora((Date)dataInicial)));
        }
        if (dataFinal != null) {
            crit.add(this.lessEqual("dataEmissaoNota", ToolDate.dataUltHora((Date)dataFinal)));
        }
        crit.add(this.or(this.isNull("dataEntradaSaida"), this.lessEqual("dataEntradaSaida", ToolDate.dataUltHora((Date)new Date()))));
        Disjunction dis = Restrictions.disjunction();
        for (String natureza : naturezas = naturezaOperacao.split(";")) {
            dis.add(this.eq("nat.identificador", Long.valueOf(natureza)));
        }
        crit.add((Criterion)dis);
        crit.addOrder(Order.asc((String)"identificador"));
        crit.setMaxResults(maxRes);
        crit.setFirstResult(page);
        return crit.list();
    }

    public DadosTransNfPropria getUltDadosTranspInf(Transportador transportador) {
        Criteria crit = this.criteria();
        crit.createAlias("dadosTransNfPropria", "d");
        this.restrictions(crit, this.eq("transportador", transportador));
        this.orderDesc(crit, "numeroNota");
        crit.setMaxResults(1);
        return (DadosTransNfPropria)crit.uniqueResult();
    }

    public NotaFiscalPropria getPorNumeroSerieEmpresa(Integer nrNota, String serie, Empresa empresa) {
        Query q = this.query(" select n from NotaFiscalPropria n  where n.numeroNota = :numero and n.serie = :serie and n.empresa = :empresa");
        q.setEntity("empresa", (Object)empresa);
        q.setString("serie", serie);
        q.setInteger("numero", nrNota.intValue());
        q.setMaxResults(1);
        return (NotaFiscalPropria)q.uniqueResult();
    }

    public List findProdutosNotas(Date dataInicial) {
        Query q = this.query(" select distinct i.produto  from NotaFiscalPropria n  inner join n.itensNotaPropria i  where n.dataEmissaoNota >= :dataInicial  and n.status IN(:aprovado)");
        q.setDate("dataInicial", dataInicial);
        q.setParameter("aprovado", (Object)EnumConstNFeStatus.getStatusAutorizadaShort());
        return q.list();
    }

    public List findProdutosTransferencias(Date dataInicial) {
        Query q = this.query(" select distinct i.produto  from TransferenciaCentroEstoque n  inner join n.itemTransfCentroEstoque i  where n.dataTransferencia >= :dataInicial ");
        q.setDate("dataInicial", dataInicial);
        return q.list();
    }

    public NotaFiscalPropria getBySerialForSync(String serial) {
        return (NotaFiscalPropria)this.toUnique(this.restrictions(this.eq("serialForSinc", serial)));
    }

    public CustoProdutoUltimaNF getUltimoCustoProd(Long idProduto, Long idEmpresa) {
        String query = "select n.dataEntradaSaida as DATA_ENTRADA, n.serie as SERIE, n.numeroNota as NUMERO, coalesce(g.valorCusto,0) as VALOR_CUSTO, pu.nome as FORNECEDOR, it.valorUnitario/g.fatorConversao as ULT_VALOR_COMPRA, (it.valorUnitario + il.vrIpiIndustria + il.vrIcmsSt)/g.fatorConversao as ULT_PRECO_COMPRA from NotaFiscalPropria n  inner join n.empresa e  inner join n.unidadeFatCliente u  inner join u.pessoa pu  inner join n.itensNotaPropria it  inner join it.itemNotaLivroFiscal il inner join il.cfop cf inner join n.naturezaOperacao nat inner join it.gradesNotaFiscalPropria g where e.identificador=:empresa and it.produto.identificador=:produto and cf.cfopCompra=:sim  and nat.entradaSaida = :fatEntrada and (n.status IN(:autorizado))";
        Query q = this.query(query);
        q.setLong("produto", idProduto.longValue());
        q.setShort("sim", (short)1);
        q.setParameter("autorizado", (Object)EnumConstNFeStatus.getStatusAutorizadaShort());
        q.setShort("fatEntrada", (short)2);
        q.setLong("empresa", idEmpresa.longValue());
        q.setMaxResults(1);
        Object[] r = (Object[])q.uniqueResult();
        return this.converter(r);
    }

    public CustoProdutoUltimaNF getUltimoCustoProd(Long idProduto) {
        Object query = "select n.dataEntradaSaida as DATA_ENTRADA, n.serie as SERIE, n.numeroNota as NUMERO, coalesce(g.valorCusto,0) as VALOR_CUSTO, pu.nome as FORNECEDOR, it.valorUnitario/g.fatorConversao as ULT_VALOR_COMPRA, (it.valorUnitario + il.vrIpiIndustria + il.vrIcmsSt)/g.fatorConversao as ULT_PRECO_COMPRA from NotaFiscalPropria n  inner join n.empresa e  inner join n.unidadeFatCliente u  inner join u.pessoa pu  inner join n.itensNotaPropria it  inner join it.itemNotaLivroFiscal il inner join il.cfop cf inner join n.naturezaOperacao nat inner join it.gradesNotaFiscalPropria g where it.produto.identificador=:produto and cf.cfopCompra = :sim  and nat.entradaSaida = :fatEntrada and (n.status IN(:autorizado))";
        query = (String)query + " order by g.dataEntradaSaida desc, g.identificador desc";
        Query q = this.query((String)query);
        q.setLong("produto", idProduto.longValue());
        q.setShort("sim", (short)1);
        q.setParameter("autorizado", (Object)EnumConstNFeStatus.getStatusAutorizadaShort());
        q.setShort("fatEntrada", (short)2);
        q.setMaxResults(1);
        Object[] r = (Object[])q.uniqueResult();
        return this.converter(r);
    }

    private CustoProdutoUltimaNF converter(Object[] r) {
        Double valor = 0.0;
        Date data = ToolDate.strToDate((String)"01/01/1900");
        String serie = null;
        Integer numero = 0;
        if (r != null) {
            data = (Date)r[0];
            serie = (String)r[1];
            numero = (Integer)r[2];
            valor = (Double)r[3];
        }
        CustoProdutoUltimaNF c = new CustoProdutoUltimaNF(valor, data, serie, Long.valueOf(numero.longValue()));
        return c;
    }

    public void atualizarNatRecPisCofinsItens(Date dataIn, Date dataFim) {
        String query = "update ItemNotaFiscalPropria item set item.natReceitaPisCofins= (select pn.naturezaReceitaPisCofins from ItemNotaFiscalPropria i  inner join i.produto p  inner join p.naturezasReceita pn  inner join pn.paramReceitaPisCofinsCST par  where item.identificador = i.identificador  and item.incidenciaPisCofins = par.incidenciaPisCofins)  where exists(  select i.identificador from ItemNotaFiscalPropria i  inner join i.notaFiscalPropria n  where i.identificador = item.identificador  and cast(n.dataEmissaoNota as date) between :data_inicial and :data_final)";
        Query q = this.query(query);
        q.setDate("data_inicial", dataIn);
        q.setDate("data_final", dataFim);
        q.executeUpdate();
    }

    public NotaFiscalPropria findNotaPropriaPorNrAndSerieAndCNPJEmpresa(Integer nrNota, String serieNota, String cnpjEmpresa) {
        Criteria crit = this.criteria();
        crit.createAlias("empresa", "emp");
        crit.createAlias("emp.pessoa", "pes");
        crit.createAlias("pes.complemento", "comp");
        crit.add(this.eq("comp.cnpj", cnpjEmpresa));
        crit.add(this.eq("numeroNota", nrNota));
        crit.add(this.eq("serie", serieNota));
        crit.setMaxResults(1);
        return (NotaFiscalPropria)this.toUnique(crit);
    }

    public List<HashMap> findNotaPropriaVendasPorPeriodoAndEmpresa(Date dataInicial, Date dataFinal, Empresa empresa, Especie especie) {
        String query = "select sum(i.itemNotaLivroFiscal.valorTotal) as VALOR_SUBESPECIE, i.produto.subEspecie.nome as NOME_SUBESPECIE, i.produto.subEspecie.identificador as ID_SUBESPECIE, n.identificador as ID_NOTA, n.dataEmissaoNota as DATA_EMISSAO, n.valoresNfPropria.valorTotal as VALOR_NOTA,  n.unidadeFatCliente.cliente.identificador as ID_CLIENTE from NotaFiscalPropria n  inner join n.itensNotaPropria i  where n.dataEmissaoNota between :dataInicial and :dataFinal  and n.empresa=:empresa and (n.situacaoDocumento.codigo <> :cod1 and n.situacaoDocumento.codigo <> :cod2 and n.situacaoDocumento.codigo <> :cod3) and (i.itemNotaLivroFiscal.cfop.cfopReceitaVenda= :sim) and i.produto.especie = :especie group by i.produto.subEspecie.nome, i.produto.subEspecie.identificador, n.identificador, n.dataEmissaoNota, n.valoresNfPropria.valorTotal, n.unidadeFatCliente.cliente.identificador";
        Query q = this.query(query);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setString("cod1", "02");
        q.setString("cod2", "03");
        q.setString("cod3", "04");
        q.setShort("sim", (short)1);
        q.setEntity("especie", (Object)especie);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public List<HashMap> findNotaPropriaVendasPorPeriodoAndEmpresaAndCliente(Date dataInicial, Date dataFinal, Empresa empresa, Especie especie, Cliente cliente) {
        String query = "select sum(i.itemNotaLivroFiscal.valorTotal) as VALOR_SUBESPECIE, i.produto.subEspecie.nome as NOME_SUBESPECIE, i.produto.subEspecie.identificador as ID_SUBESPECIE, n.identificador as ID_NOTA, n.dataEmissaoNota as DATA_EMISSAO, n.valoresNfPropria.valorTotal as VALOR_NOTA,  n.unidadeFatCliente.cliente.identificador as ID_CLIENTE from NotaFiscalPropria n  inner join n.itensNotaPropria i  where n.dataEmissaoNota between :dataInicial and :dataFinal  and n.empresa=:empresa and (n.situacaoDocumento.codigo <> :cod1 and n.situacaoDocumento.codigo <> :cod2 and n.situacaoDocumento.codigo <> :cod3) and (i.itemNotaLivroFiscal.cfop.cfopReceitaVenda= :sim) and i.produto.especie = :especie and n.unidadeFatCliente.cliente = :cliente group by i.produto.subEspecie.nome, i.produto.subEspecie.identificador, n.identificador, n.dataEmissaoNota, n.valoresNfPropria.valorTotal, n.unidadeFatCliente.cliente.identificador";
        Query q = this.query(query);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setEntity("cliente", (Object)cliente);
        q.setString("cod1", "02");
        q.setString("cod2", "03");
        q.setString("cod3", "04");
        q.setShort("sim", (short)1);
        q.setEntity("especie", (Object)especie);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public NotaFiscalPropria getNotaProria(String idNotaFiscal) {
        Query q = this.query(" select n from NotaFiscalPropria n  where n.identificador = :idNotaFiscal");
        q.setString("idNotaFiscal", idNotaFiscal);
        return (NotaFiscalPropria)q.uniqueResult();
    }

    public List<NotaFiscalPropria> pesquisarNotaPropriaAjusteEstoque(AjusteEstoque ajusteEstoque) {
        Query q = this.query("SELECT DISTINCT n FROM NotaFiscalPropria n INNER JOIN n.itensNotaPropria i WHERE i.ajusteEstoque = :ajusteEstoque");
        q.setEntity("ajusteEstoque", (Object)ajusteEstoque);
        return q.list();
    }

    public NotaFiscalPropria getultimaNotaByPessoa(String cnpj) {
        String hql = "SELECT n FROM NotaFiscalPropria n INNER JOIN n.unidadeFatCliente uf INNER JOIN uf.cliente c WHERE c.pessoa.complemento.cnpj = :cnpj AND n.status IN(:aprovado) ORDER BY n.dataEntradaSaida DESC";
        Query q = this.query(hql);
        q.setMaxResults(1);
        q.setString("cnpj", cnpj);
        q.setParameter("aprovado", (Object)EnumConstNFeStatus.getStatusAutorizadaShort());
        return (NotaFiscalPropria)q.uniqueResult();
    }

    public HashMap atualizarDigitoVerificador(NotaFiscalPropria np) {
        NativeQuery q = this.sqlQuery(" select gr.chave as CHAVE,gr.digito_verificador as DIGITO from gera_chavenfe  (:cod_uf,:data_emissao,:cnpj,:serie,:numero_nota,:cod_acesso,   :cod_mod,:tipo_emissao) gr ");
        q.setParameter("cod_uf", (Object)np.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getCodIbge());
        q.setParameter("data_emissao", (Object)np.getDataEmissaoNota());
        q.setParameter("cnpj", (Object)ToolString.refina((String)np.getEmpresa().getPessoa().getComplemento().getCnpj()));
        q.setParameter("serie", (Object)np.getSerie());
        q.setParameter("numero_nota", (Object)np.getNumeroNota());
        q.setParameter("cod_acesso", (Object)np.getCodChaveAcesso());
        q.setParameter("cod_mod", (Object)np.getModeloDocFiscal().getCodigo());
        q.setParameter("tipo_emissao", (Object)np.getPeriodoEmissaoNFe().getTipoEmissaoNfe().getCodigo());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return (HashMap)q.uniqueResult();
    }

    public void salvarDigitoVerificador(String chave, Integer digito, Long idNotaPropria) {
        NativeQuery q = this.sqlQuery("UPDATE nota_propria n SET n.chave_nfe = :chave, n.digito_verificador = :digito WHERE n.id_nota_propria = :idNotaPropria");
        q.setParameter("chave", (Object)chave);
        q.setParameter("digito", (Object)digito);
        q.setParameter("idNotaPropria", (Object)idNotaPropria);
        q.executeUpdate();
    }

    public List<NotaFiscalPropria> findNotasPeriodoAndNumeroNota(Date dataIn, Date dataFim, Short filtrarNumeracao, Integer numeroInicial, Integer numeroFinal) {
        Criteria criteria = this.restrictions(this.between("dataEmissaoNota", dataIn, dataFim), this.in("status", EnumConstNFeStatus.getStatusAutorizadaShort()));
        if (filtrarNumeracao.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
            criteria.add(this.between("numeroNota", numeroInicial, numeroFinal));
        }
        return this.toList(this.order(criteria, new String[0]));
    }

    public List<DTOCentralDocsPropriosNFe> getNotasFiscaisDestinatario(Integer page, Integer regsPage, GrupoEmpresa grupoEmpresa, Pessoa pessoa, Short filtrarData, Date dataIn, Date dataFim, Short filtrarNr, Long numero, Short filtrarChave, String chaveNFe) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jEmpresa = aux.join("empresa");
        Join jEmpresaDados = aux.join((From)jEmpresa, "empresaDados");
        Join jEmpresaPessoa = aux.join((From)jEmpresa, "pessoa");
        Join jEmpresaPessoaComp = aux.join((From)jEmpresaPessoa, "complemento");
        Join jUnidadeFatCliente = aux.join("unidadeFatCliente");
        Join jCliente = aux.join((From)jUnidadeFatCliente, "cliente");
        Join jClientePessoa = aux.join((From)jCliente, "pessoa");
        Join jClientePessoaComp = aux.join((From)jClientePessoa, "complemento");
        Join jtotais = aux.join("valoresNfPropria");
        aux.equal((From)jEmpresaDados, "grupoEmpresa", grupoEmpresa);
        aux.equal((From)jCliente, "pessoa", pessoa);
        LinkedList status = new LinkedList();
        EnumConstNFeStatus.getStatusFinalList().forEach(i -> status.add(i.getValue().shortValue()));
        aux.inNumber("status", status);
        if (ToolMethods.isAffirmative((Number)filtrarChave)) {
            aux.equal("chaveNFE", chaveNFe);
        }
        if (ToolMethods.isAffirmative((Number)filtrarData)) {
            aux.between("dataEmissaoNota", dataIn, (Comparable)dataFim);
        }
        if (ToolMethods.isAffirmative((Number)filtrarNr) && numero != null) {
            aux.equal("numeroNota", numero.intValue());
        }
        aux.setMaxResults(regsPage);
        aux.setFirstResult(page * regsPage);
        aux.select(AuxCriteriaBuilder.pair("identificador", "F_ID_NOTA_PROPRIA"), AuxCriteriaBuilder.pair("numeroNota", "F_NUMERO"), AuxCriteriaBuilder.pair("serie", "F_SERIE"), AuxCriteriaBuilder.pair("dataEmissaoNota", "F_DATA_EMISSAO"), AuxCriteriaBuilder.pair("chaveNFE", "F_CHAVE"), AuxCriteriaBuilder.pair("status", "F_STATUS"), AuxCriteriaBuilder.pair("motivo", "F_STATUS_STR"), AuxCriteriaBuilder.pair((From)jtotais, "valorTotal", "F_VALOR"), AuxCriteriaBuilder.pair((From)jEmpresaPessoa, "nome", "F_EMITENTE"), AuxCriteriaBuilder.pair((From)jEmpresaPessoa, "nomeFantasia", "F_EMITENTE_NOME_FANTASIA"), AuxCriteriaBuilder.pair((From)jEmpresaPessoaComp, "cnpj", "F_CNPJ_EMITENTE"), AuxCriteriaBuilder.pair((From)jClientePessoa, "nome", "F_DESTINATARIO"), AuxCriteriaBuilder.pair((From)jClientePessoa, "nomeFantasia", "F_DEST_NOME_FANTASIA"), AuxCriteriaBuilder.pair((From)jClientePessoaComp, "cnpj", "F_CNPJ_DESTINATARIO"));
        List<Map<String, Object>> res = aux.getResultMap();
        LinkedList<DTOCentralDocsPropriosNFe> ret = new LinkedList<DTOCentralDocsPropriosNFe>();
        for (Map<String, Object> map : res) {
            DTOCentralDocsPropriosNFe d = new DTOCentralDocsPropriosNFe();
            d.setIdentificador((Long)map.get("F_ID_NOTA_PROPRIA"));
            d.setNumeroDoc((Number)map.get("F_NUMERO"));
            d.setSerieDoc((String)map.get("F_SERIE"));
            d.setDataEmissao((Date)map.get("F_DATA_EMISSAO"));
            d.setChave((String)map.get("F_CHAVE"));
            d.setValor((Double)map.get("F_VALOR"));
            d.setEmitente((String)map.get("F_EMITENTE"));
            d.setCnpjEmitente((String)map.get("F_CNPJ_EMITENTE"));
            d.setEmitenteNomeFantasia((String)map.get("F_EMITENTE_NOME_FANTASIA"));
            d.setCnpjDestinatarioTomador((String)map.get("F_CNPJ_DESTINATARIO"));
            d.setDestinatario((String)map.get("F_DESTINATARIO"));
            d.setDestinatarioNomeFantasia((String)map.get("F_DEST_NOME_FANTASIA"));
            d.setStatusSefaz((Short)map.get("F_STATUS"));
            d.setStatusSefazStr((String)map.get("F_STATUS_STR"));
            ret.add(d);
        }
        return ret;
    }

    public List<NotaFiscalPropria> findNotasPorPeriodoSemControleCaixaNFCe(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        String q = "select distinct b from NotaFiscalPropria b  left join b.integracaoNotaPropriaNotas integracao where (b.dataEmissaoNota between :dataInicial and :dataFinal) and (b.situacaoDocumento.codigo = '00' or   b.situacaoDocumento.codigo = '01' or  b.situacaoDocumento.codigo = '06' or  b.situacaoDocumento.codigo = '07' or  b.situacaoDocumento.codigo = '08')  and (integracao.loteContabil is null)  and (b.empresa.empresaDados.grupoEmpresa = :grupoEmpresa) and (b.nfceControleCaixa is null or b.naturezaOperacao.contabilizarPorIntegracao = :sim)";
        Query query = this.query(q);
        query.setParameter("dataInicial", (Object)dataInicial);
        query.setParameter("dataFinal", (Object)dataFinal);
        query.setParameter("grupoEmpresa", (Object)grupoEmpresa);
        query.setParameter("sim", (Object)EnumConstantsMentorSimNao.SIM.getValue());
        return query.list();
    }

    public List findNotasPeriodoPaginado(Date dataIn, Date dataFim, Integer i, Integer firstResult, Short filtrarNumeroSerie, String serie, Integer numeroInicial, Integer numeroFinal, GrupoEmpresa grupoEmpresa) {
        Object hql = "select p from NotaFiscalPropria p  where p.dataEmissaoNota between :dataIn and :dataFim  and p.empresa.empresaDados.grupoEmpresa = :grupoEmpresa  and (p.situacaoDocumento.codigo <> :codSit1 and       p.situacaoDocumento.codigo <> :codSit2 and       p.situacaoDocumento.codigo <> :codSit3 )";
        Boolean informarSerie = false;
        if (filtrarNumeroSerie != null && filtrarNumeroSerie.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
            if (ToolMethods.isStrWithData((String)serie)) {
                informarSerie = true;
                hql = (String)hql + " and p.serie = :serie and p.numeroNota between :numeroInicial and :numeroFinal";
            } else {
                hql = (String)hql + " and p.numeroNota between :numeroInicial and :numeroFinal";
            }
        }
        Query q = this.query((String)hql);
        q.setParameter("dataIn", (Object)dataIn);
        q.setParameter("dataFim", (Object)dataFim);
        q.setParameter("grupoEmpresa", (Object)grupoEmpresa);
        q.setParameter("codSit1", (Object)"02");
        q.setParameter("codSit2", (Object)"03");
        q.setParameter("codSit3", (Object)"04");
        if (informarSerie.booleanValue()) {
            q.setParameter("serie", (Object)serie);
        }
        if (filtrarNumeroSerie != null && filtrarNumeroSerie.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
            q.setParameter("numeroInicial", (Object)numeroInicial);
            q.setParameter("numeroFinal", (Object)numeroFinal);
        }
        q.setMaxResults(i.intValue());
        q.setFirstResult(firstResult.intValue());
        return q.list();
    }

    public List findNotasOrigemDevolucaoPeriodoPaginado(Date dataIn, Date dataFim, int i, int firstResult, GrupoEmpresa grupoEmpresa) {
        String hql = "select distinct p  from DevolucaoVendas d inner join d.notaPropriaGerada p  where p.dataEmissaoNota between :dataIn and :dataFim  and p.empresa.empresaDados.grupoEmpresa = :grupoEmpresa  and (p.situacaoDocumento.codigo <> :codSit1 and       p.situacaoDocumento.codigo <> :codSit2 and       p.situacaoDocumento.codigo <> :codSit3 )";
        Query q = this.query(hql);
        q.setParameter("dataIn", (Object)dataIn);
        q.setParameter("dataFim", (Object)dataFim);
        q.setParameter("grupoEmpresa", (Object)grupoEmpresa);
        q.setParameter("codSit1", (Object)"02");
        q.setParameter("codSit2", (Object)"03");
        q.setParameter("codSit3", (Object)"04");
        q.setMaxResults(i);
        q.setFirstResult(firstResult);
        return q.list();
    }

    public VersaoNFe getVersaoEmissaoNFe(Long idNota) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        aux.equal("identificador", idNota);
        aux.select("versaoNfe");
        return (VersaoNFe)aux.getUniqueResult();
    }

    public String getChaveNFe(Long idNota) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        aux.equal("identificador", idNota);
        aux.select("chaveNFE");
        return (String)aux.getUniqueResult();
    }

    public List findProdutosValorDataNFPropria(Date data, Empresa empresa) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jNaturezaOp = aux.join("naturezaOperacao");
        Join jSituacaoDoc = aux.join("situacaoDocumento");
        Join jCategoriaPessoa = aux.joinLeft("categoriaPessoa");
        Join jClassificacaoCli = aux.joinLeft("classificacaoCliente");
        Join jItemNotaPropria = aux.join("itensNotaPropria");
        Join jModeloFiscal = jItemNotaPropria.join("modeloFiscal");
        Join jGradeNotaPropria = jItemNotaPropria.join("gradesNotaFiscalPropria");
        Join jProduto = jItemNotaPropria.join("produto");
        Join jSubespecie = jProduto.join("subEspecie");
        Join jUnidadeFatCliente = aux.join("unidadeFatCliente");
        Join jPessoa = jUnidadeFatCliente.join("pessoa");
        Join jEndereco = jPessoa.join("endereco");
        Join jCidade = jEndereco.join("cidade");
        Join jUF = jCidade.join("uf");
        aux.select(AuxCriteriaBuilder.pair((From)jProduto, "identificador", "ID_PRODUTO"));
        aux.select(AuxCriteriaBuilder.pair((From)jNaturezaOp, "identificador", "ID_NATUREZA_OPERACAO"));
        aux.select(AuxCriteriaBuilder.pair((From)jModeloFiscal, "identificador", "ID_MODELO_FISCAL"));
        aux.select(AuxCriteriaBuilder.pair((From)jCategoriaPessoa, "identificador", "ID_CATEGORIA_PESSOA"));
        aux.select(AuxCriteriaBuilder.pair((From)jClassificacaoCli, "identificador", "ID_CLASSIFICACAO_CLIENTE"));
        aux.select(AuxCriteriaBuilder.pair((From)jSubespecie, "identificador", "ID_SUB_ESPECIE"));
        aux.select(AuxCriteriaBuilder.pair((From)jUF, "identificador", "ID_UNIDADE_FEDERATIVA"));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair((From)jGradeNotaPropria, "quantidade", "QUANTIDADE")));
        aux.equal("dataEmissaoNota", data);
        aux.equal("empresa", empresa);
        aux.and(aux.notEqual((From)jSituacaoDoc, "codigo", "02"), aux.notEqual((From)jSituacaoDoc, "codigo", "03"), aux.notEqual((From)jSituacaoDoc, "codigo", "04"));
        aux.equal((From)jModeloFiscal, "opcaoContabilizacaoCPV", EnumConstantsMentorSimNao.SIM.getValue());
        aux.groupBy(aux.getExpression((From)jProduto, "identificador"), aux.getExpression((From)jNaturezaOp, "identificador"), aux.getExpression((From)jModeloFiscal, "identificador"), aux.getExpression((From)jCategoriaPessoa, "identificador"), aux.getExpression((From)jClassificacaoCli, "identificador"), aux.getExpression((From)jSubespecie, "identificador"), aux.getExpression((From)jUF, "identificador"));
        return aux.getResultMap();
    }

    public List<NotaFiscalPropria> getNotaFiscalPropriaRPA(Long geracaoReciboRpa) {
        CriteriaBuilder builder = this.criteriaBuilder(NotaFiscalPropria.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root fromNotaFiscalPropria = crit.from(NotaFiscalPropria.class);
        Join jNotaPropriaFreteCtrc = fromNotaFiscalPropria.join("notaPropriaFreteCtrc", javax.persistence.criteria.JoinType.INNER);
        Join jGeracaoReciboRpa = jNotaPropriaFreteCtrc.join("geracaoReciboRpa", javax.persistence.criteria.JoinType.INNER);
        crit.select((Selection)fromNotaFiscalPropria).distinct(true);
        exps.add(builder.equal((Expression)jGeracaoReciboRpa.get("identificador"), (Object)geracaoReciboRpa));
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }

    public NotaFiscalPropria findNotaPropriaPorChave(String chave) {
        String query = "SELECT n FROM NotaFiscalPropria n WHERE n.chaveNFE = :chave";
        Query q = this.query(query);
        q.setString("chave", chave);
        return (NotaFiscalPropria)q.uniqueResult();
    }

    public List<NotaFiscalPropria> findNotasEnvioBoletoEmMassa(Long[] empresa, Date dataInicial, Date dataFinal, Long[] ramo, Long[] meiosPag, CarteiraCobranca carteira, Integer intervaloDias) {
        Criteria c = this.criteria();
        c.createAlias("infPagamentoNfPropria", "infPag");
        c.createAlias("infPag.titulos", "tit");
        c.createAlias("unidadeFatCliente", "un");
        c.createAlias("un.cliente", "cli");
        c.createAlias("infPag.meioPagamento", "meioPag");
        if (ramo != null) {
            c.createAlias("cli.faturamento", "cliFat");
            c.createAlias("cliFat.ramoAtividade", "ramo", JoinType.LEFT_OUTER_JOIN);
            c.add(this.in("ramo.identificador", ramo));
        }
        c.add(this.in("empresa.identificador", empresa));
        c.add(this.between("dataEmissaoNota", ToolDate.dataPrimHora((Date)dataInicial), ToolDate.dataUltHora((Date)dataFinal)));
        c.add(this.in("meioPag.identificador", meiosPag));
        c.add(this.eq("tit.carteiraCobranca", carteira));
        c.add(this.eq("tit.dataVencimento", ToolDate.nextDays((Date)dataInicial, (int)intervaloDias)));
        return c.list();
    }

    public List<NotaFiscalPropria> findNotasNaoApuradasReinf2020(GrupoEmpresa grupo, Date periodo, Boolean filtrarNotasRetidas) {
        CriteriaBuilder builder = this.criteriaBuilder(NotaFiscalPropria.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root root = crit.from(NotaFiscalPropria.class);
        Join jSituacaoDocumento = root.join("situacaoDocumento", javax.persistence.criteria.JoinType.INNER);
        Join jModeloDocFiscal = root.join("modeloDocFiscal", javax.persistence.criteria.JoinType.INNER);
        Join jValoresNfPropria = root.join("valoresNfPropria", javax.persistence.criteria.JoinType.INNER);
        Join jEmpresa = root.join("empresa", javax.persistence.criteria.JoinType.INNER);
        Join jEmpresaDados = jEmpresa.join("empresaDados", javax.persistence.criteria.JoinType.INNER);
        Join jUnidadeFatCliente = root.join("unidadeFatCliente", javax.persistence.criteria.JoinType.INNER);
        Join jCliente = jUnidadeFatCliente.join("cliente", javax.persistence.criteria.JoinType.INNER);
        Join jPessoa = jCliente.join("pessoa", javax.persistence.criteria.JoinType.INNER);
        Join jComplemento = jPessoa.join("complemento", javax.persistence.criteria.JoinType.INNER);
        exps.add(builder.between((Expression)root.get("dataEmissaoNota"), (Comparable)ToolDate.getDataInicial((Date)periodo), (Comparable)ToolDate.getDataFinal((Date)periodo)));
        exps.add(builder.equal((Expression)jEmpresaDados.get("grupoEmpresa"), (Object)grupo));
        exps.add(builder.and(new Predicate[]{builder.notEqual((Expression)jSituacaoDocumento.get("codigo"), (Object)"02"), builder.notEqual((Expression)jSituacaoDocumento.get("codigo"), (Object)"03"), builder.notEqual((Expression)jSituacaoDocumento.get("codigo"), (Object)"04")}));
        exps.add(builder.equal((Expression)jModeloDocFiscal.get("modeloServico"), (Object)EnumConstantsMentorSimNao.SIM.getValue()));
        exps.add(builder.and((Expression)builder.isNotNull((Expression)jComplemento.get("cnpj")), (Expression)builder.equal(builder.function("char_length", String.class, new Expression[]{jComplemento.get("cnpj")}), (Object)14)));
        if (filtrarNotasRetidas.booleanValue()) {
            exps.add(builder.greaterThan((Expression)jValoresNfPropria.get("valorInss"), (Comparable)Double.valueOf(0.0)));
        }
        Subquery subqueryReinf = crit.subquery(ItemReinfNotas2020.class);
        Root fromItemReinf = subqueryReinf.from(ItemReinfNotas2020.class);
        Join jNotaPropria = fromItemReinf.join("notaPropria", javax.persistence.criteria.JoinType.INNER);
        subqueryReinf.where((Expression)builder.equal((Expression)jNotaPropria.get("identificador"), (Expression)root.get("identificador")));
        subqueryReinf.select((Expression)fromItemReinf);
        exps.add(builder.not((Expression)builder.exists(subqueryReinf)));
        crit.select((Selection)root);
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }
}

