/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.EnumConstantsModeloDocFiscal;
import com.touchcomp.basementor.constants.enums.confnfterceiros.EnumConstTipoConfNFTercItens;
import com.touchcomp.basementor.constants.enums.liberacaonotaterceiros.EnumLiberacaoNFTerceiros;
import com.touchcomp.basementor.constants.enums.modelodocfiscal.EnumConstModDocFiscal;
import com.touchcomp.basementor.constants.enums.notasfiscais.EnumConstStatLancNFTerceiros;
import com.touchcomp.basementor.constants.enums.relacionamentopessoa.EnumConstTipoConfNFProduto;
import com.touchcomp.basementor.model.impl.CustoProdutoUltimaNF;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Especie;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.ItemReinfNotas2010;
import com.touchcomp.basementor.model.vo.ItemReinfNotas4010;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.sql.JoinType;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Repository;

@Repository
public class DaoNotaFiscalTerceirosImpl
extends DaoGenericEntityImpl<NotaFiscalTerceiros, Long> {
    public Double getMenorCustoProd(Long idProduto, Empresa empresa) {
        String query = "select min(coalesce(g.valorCusto,0)) as ULT_VALOR_CUSTO from NotaFiscalTerceiros n  inner join n.empresa e  inner join n.itemNotaTerceiros it  inner join it.itemNotaLivroFiscal il inner join il.cfop cf inner join it.grade g where  e.identificador=:empresa and it.produto.identificador=:produto and cf.cfopCompra=:sim ";
        org.hibernate.query.Query q = this.query(query);
        q.setLong("produto", idProduto.longValue());
        q.setLong("empresa", empresa.getIdentificador().longValue());
        q.setShort("sim", (short)1);
        q.setMaxResults(1);
        Double d = (Double)q.uniqueResult();
        return d != null ? d : 0.0;
    }

    public Double getCustoMedioProd(Long idProduto, Empresa empresa) {
        String query = "select avg(coalesce(g.valorCusto,0)) as ULT_VALOR_CUSTO from NotaFiscalTerceiros n  inner join n.empresa e  inner join n.itemNotaTerceiros it  inner join it.itemNotaLivroFiscal il inner join il.cfop cf inner join it.grade g where  e.identificador=:empresa and it.produto.identificador=:produto and cf.cfopCompra =:sim ";
        org.hibernate.query.Query q = this.query(query);
        q.setLong("produto", idProduto.longValue());
        q.setLong("empresa", empresa.getIdentificador().longValue());
        q.setShort("sim", (short)1);
        q.setMaxResults(1);
        Double d = (Double)q.uniqueResult();
        return d != null ? d : 0.0;
    }

    private Query getQueryUltEntradas(Long idProduto, Long idEmpresa) {
        Object query = "select n.dataEntrada as DATA_ENTRADA, n.serie as SERIE, n.numeroNota as NUMERO, avg(coalesce(g.valorCusto,0)) as VALOR_CUSTO, pu.nome as FORNECEDOR, it.valorUnitario/g.fatorConversao as ULT_VALOR_COMPRA, (it.valorUnitario + il.vrIpiIndustria + il.vrIcmsSt)/g.fatorConversao as ULT_PRECO_COMPRA, it.centroEstoque.descricao as CENTRO_CUSTO, it.quantidadeTotal as QTDE,  it.identificador as ID_ITEM from NotaFiscalTerceiros n  inner join n.unidadeFatFornecedor u  inner join u.pessoa pu  inner join n.empresa e  inner join n.itemNotaTerceiros it  inner join it.itemNotaLivroFiscal il inner join il.cfop cf inner join it.grade g  where  (:empresa is null or e.identificador=:empresa) and it.produto.identificador=:produto and cf.cfopCompra = :sim  group by  n.dataEntrada, n.serie, n.numeroNota, pu.nome, it.valorUnitario/g.fatorConversao, (it.valorUnitario + il.vrIpiIndustria + il.vrIcmsSt)/g.fatorConversao, it.centroEstoque.descricao, it.quantidadeTotal,  it.identificador";
        query = (String)query + " order by n.dataEntrada desc, it.identificador desc";
        org.hibernate.query.Query q = this.query((String)query);
        q.setLong("produto", idProduto.longValue());
        q.setParameter("empresa", (Object)idEmpresa);
        q.setShort("sim", (short)1);
        return q;
    }

    public List<CustoProdutoUltimaNF> getUltimasEntradasProd(Long idProduto, Empresa logedEmpresa, Integer nrReg) {
        Query q = this.getQueryUltEntradas(idProduto, logedEmpresa.getIdentificador());
        if (nrReg != null && nrReg > 0) {
            q.setMaxResults(nrReg.intValue());
        }
        List r = q.list();
        LinkedList<CustoProdutoUltimaNF> ret = new LinkedList<CustoProdutoUltimaNF>();
        for (Object[] a : r) {
            ret.add(this.converter(a));
        }
        return ret;
    }

    public CustoProdutoUltimaNF getUltimoCustoProd(Long idProduto, Long idEmpresa) {
        Query q = this.getQueryUltEntradas(idProduto, idEmpresa);
        q.setMaxResults(1);
        Object[] r = (Object[])q.uniqueResult();
        return this.converter(r);
    }

    public Double getAliquotaICMS(UnidadeFederativa ufOrigem, UnidadeFederativa ufDestino) {
        String query = "select coalesce(m.aliquotaICMS, 0)   from UnidadeFederativaOrigDest m  where m.unidadeFedOrigem = :ufOrigem  and m.unidadeFedDestino = :ufDestino ";
        org.hibernate.query.Query q = this.query(query);
        q.setEntity("ufOrigem", (Object)ufOrigem);
        q.setEntity("ufDestino", (Object)ufDestino);
        q.setMaxResults(1);
        return (Double)q.uniqueResult();
    }

    public List<Produto> findProdutosNotas(Date dataInicial) {
        org.hibernate.query.Query q = this.query(" select distinct i.produto  from NotaFiscalTerceiros n  inner join n.itemNotaTerceiros i  where n.dataEntrada >= :dataInicial ");
        q.setDate("dataInicial", dataInicial);
        return q.list();
    }

    public NotaFiscalTerceiros findNotaByChaveNFe(String chaveNFe) {
        org.hibernate.query.Query q = this.query(" select distinct n  from NotaFiscalTerceiros n  where n.chaveNFE = :chaveNFe ");
        q.setString("chaveNFe", chaveNFe);
        q.setMaxResults(1);
        return (NotaFiscalTerceiros)q.uniqueResult();
    }

    private CustoProdutoUltimaNF converter(Object[] r) {
        Double valor = 0.0;
        Double ultValorCompra = 0.0;
        Double ultPrecoCompra = 0.0;
        Date data = ToolDate.strToDate((String)"01/01/1900");
        String serie = null;
        String fornecedor = null;
        Integer numero = 0;
        String centroCusto = "";
        Double qtde = 0.0;
        if (r != null) {
            data = (Date)r[0];
            serie = (String)r[1];
            numero = (Integer)r[2];
            valor = (Double)r[3];
            fornecedor = (String)r[4];
            ultValorCompra = (Double)r[5];
            ultPrecoCompra = (Double)r[6];
            centroCusto = (String)r[7];
            qtde = (Double)r[8];
        }
        CustoProdutoUltimaNF c = new CustoProdutoUltimaNF(valor, data, serie, Long.valueOf(numero.longValue()));
        c.setFornecedor(fornecedor);
        c.setValorUltPrecoCompra(ultPrecoCompra);
        c.setValorUltVlrCompra(ultValorCompra);
        c.setCentroEstoque(centroCusto);
        c.setQtde(qtde);
        return c;
    }

    public List<CustoProdutoUltimaNF> getUltimasEntradasProd(Long idProduto, Integer nrReg, Short filtraFonrDifGrupoEmp, GrupoEmpresa grupoEmp) {
        String query = "select n.dataEntrada as DATA_ENTRADA, n.serie as SERIE, n.numeroNota as NUMERO, coalesce(g.valorCusto,0) as VALOR_CUSTO, pu.nome as FORNECEDOR, it.valorUnitario/g.fatorConversao as ULT_VALOR_COMPRA, (it.valorUnitario + il.vrIpiIndustria + il.vrIcmsSt)/g.fatorConversao as ULT_PRECO_COMPRA, it.centroEstoque.descricao as CENTRO_CUSTO, (it.quantidadeTotal*it.fatorConversao) as QTDE from NotaFiscalTerceiros n  inner join n.empresa e  inner join n.unidadeFatFornecedor u  inner join u.pessoa pu  inner join n.itemNotaTerceiros it  inner join it.itemNotaLivroFiscal il inner join il.cfop cf inner join it.grade g  left join Empresa emp on(emp.pessoa = pu) left join emp.empresaDados ed where it.produto.identificador=:produto  and (cf.cfopCompra = :sim or cf.cfopTransferencia = :sim)  and (:filtraFonrDifGrupoEmp<>1 or (ed.grupoEmpresa<>:grupoEmp or ed is null)) order by n.dataEntrada desc, g.identificador desc";
        org.hibernate.query.Query q = this.query(query);
        q.setLong("produto", idProduto.longValue());
        q.setShort("sim", (short)1);
        q.setShort("filtraFonrDifGrupoEmp", filtraFonrDifGrupoEmp.shortValue());
        q.setEntity("grupoEmp", (Object)grupoEmp);
        if (nrReg != null && nrReg > 0) {
            q.setMaxResults(nrReg.intValue());
        }
        List r = q.list();
        LinkedList<CustoProdutoUltimaNF> ret = new LinkedList<CustoProdutoUltimaNF>();
        for (Object[] a : r) {
            ret.add(this.converter(a));
        }
        return ret;
    }

    public List<HashMap> findNotaTerceirosPorPeriodoAndEmpresa(Date dataInicial, Date dataFinal, Empresa empresa, Especie especie) {
        String query = "select sum(i.itemNotaLivroFiscal.valorTotal) as VALOR_SUBESPECIE, i.produto.subEspecie.nome as NOME_SUBESPECIE, i.produto.subEspecie.identificador as ID_SUBESPECIE from NotaFiscalTerceiros n  inner join n.itemNotaTerceiros i  where n.dataEntrada between :dataInicial and :dataFinal  and n.empresa=:empresa and i.produto.especie = :especie group by i.produto.subEspecie.nome, i.produto.subEspecie.identificador";
        org.hibernate.query.Query q = this.query(query);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setEntity("especie", (Object)especie);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public NotaFiscalTerceiros findNotaTerceirosPorChave(String chave) {
        String query = "SELECT n FROM NotaFiscalTerceiros n WHERE n.chaveNFE = :chave";
        org.hibernate.query.Query q = this.query(query);
        q.setString("chave", chave);
        return (NotaFiscalTerceiros)q.uniqueResult();
    }

    public List<NotaFiscalTerceiros> pesquisarNotaTerceirosPeriodoDataEntradaUnidadeFatFornecedorNaoTicketFiscalEntrada(Empresa empresa, Short filtrarDataEntrada, Date dataEntradaInicial, Date dataEntradaFinal, Short filtrarFornecedor, UnidadeFatFornecedor unidadeFatFornecedor) {
        Object hql = "SELECT DISTINCT n FROM       NotaFiscalTerceiros n INNER JOIN n.modeloDocFiscal   m WHERE (n.empresa = :empresa) AND   (:filtrarDataEntrada <> 1 OR n.dataEntrada BETWEEN :dataEntradaInicial AND :dataEntradaFinal) AND   (m.codigo = '55') AND NOT EXISTS(FROM TicketFiscalTerceiros t WHERE t.notaTerceiros = n)";
        if (ToolMethods.isEquals((Object)filtrarFornecedor, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            hql = (String)hql + " AND (n.unidadeFatFornecedor = :unidadeFatFornecedor)";
        }
        org.hibernate.query.Query q = this.query((String)hql);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("filtrarDataEntrada", filtrarDataEntrada.shortValue());
        q.setDate("dataEntradaInicial", dataEntradaInicial);
        q.setDate("dataEntradaFinal", dataEntradaFinal);
        if (ToolMethods.isEquals((Object)filtrarFornecedor, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            q.setEntity("unidadeFatFornecedor", (Object)unidadeFatFornecedor);
        }
        return q.list();
    }

    public List<NotaFiscalTerceiros> getNotasSemConfirmarOperacao(Empresa empresa, Date dataBase, Integer delayDiasLancamento, Integer maxRegsPerTime, Integer page) {
        String hql = "select distinct n from       NotaFiscalTerceiros n inner join n.modeloDocFiscal m left join n.consultaNFeDestDocDist cs where (n.empresa = :empresa) and   m.codigo=:nfe AND   (n.dataCadastro<= :dataLimite) AND   (n.dataEntrada>= :dataBase) and (cs.identificador is null or (cs.statusSistema < :confirmadoOperacaoStat and cs.statusSistema>:statusMin)) order by n.identificador";
        org.hibernate.query.Query q = this.query(hql);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("confirmadoOperacaoStat", EnumConstStatLancNFTerceiros.STAT_INTER_CONFIRMADA_OPERACAO.getValue());
        q.setShort("statusMin", EnumConstStatLancNFTerceiros.STAT_INICIAL_DOWNLOAD_RESUMIDO.getValue());
        q.setDate("dataLimite", ToolDate.previousDays((Date)new Date(), (int)delayDiasLancamento));
        q.setDate("dataBase", dataBase);
        q.setString("nfe", EnumConstModDocFiscal.NFE.getCodigo());
        q.setMaxResults(maxRegsPerTime.intValue());
        q.setFirstResult(page.intValue());
        return q.list();
    }

    public List<NotaFiscalTerceiros> getNotasSemConfirmarOperacaoLiberadas(Empresa empresa, Date dataBase, Integer delayDiasLancamento, Integer maxRegsPerTime, Integer page) {
        String hql = "select distinct n from       NotaFiscalTerceiros n inner join n.modeloDocFiscal m inner join n.liberacaoNFTerceiros l left join n.consultaNFeDestDocDist cs where (n.empresa = :empresa) and   m.codigo=:nfe and   (cs.identificador is null or (cs.statusSistema < :confirmadoOperacaoStat and cs.statusSistema>:statusMin)) AND   (cast(l.dataConferenciaTotal as date) <= :dataLimite) AND   (l.conferidaTotalmente = :sim) AND   (l.dataConferenciaTotal>= :dataBase) order by n.identificador";
        org.hibernate.query.Query q = this.query(hql);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("sim", (short)1);
        q.setShort("confirmadoOperacaoStat", EnumConstStatLancNFTerceiros.STAT_INTER_CONFIRMADA_OPERACAO.getValue());
        q.setShort("statusMin", EnumConstStatLancNFTerceiros.STAT_INICIAL_DOWNLOAD_RESUMIDO.getValue());
        q.setDate("dataLimite", ToolDate.previousDays((Date)new Date(), (int)delayDiasLancamento));
        q.setDate("dataBase", dataBase);
        q.setString("nfe", EnumConstModDocFiscal.NFE.getCodigo());
        q.setMaxResults(maxRegsPerTime.intValue());
        q.setFirstResult(page.intValue());
        return q.list();
    }

    public List<NotaFiscalTerceiros> findNotasPeriodoAndNumeroNota(Date dataIn, Date dataFim, Short filtrarNumeracao, Integer numeroInicial, Integer numeroFinal) {
        Criteria criteria = this.restrictions(this.between("dataEntrada", dataIn, dataFim));
        if (filtrarNumeracao.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
            criteria.add(this.between("numeroNota", numeroInicial, numeroFinal));
        }
        return this.toList(this.order(criteria, new String[0]));
    }

    public List<NotaFiscalTerceiros> findNotasNaoLiberadasQualidade(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesCompraSuprimentos opcoesCompras) {
        Object hql = "select n FROM NotaFiscalTerceiros n  LEFT JOIN n.liberacaoNFTerceiros l  WHERE n.dataEntrada between :dataInicial and :dataFinal  AND (l is null or l.liberacaoQualidade is null) ";
        if (opcoesCompras.getTipoConfNFTerceirosItens().equals(EnumConstTipoConfNFTercItens.CONF_CADASTRO_PROD.getValue())) {
            hql = (String)hql + " AND EXISTS (select i.identificador  from ItemNotaTerceiros i  inner join i.produto p  where i.notaFiscalTerceiros = n  and p.tipoConfNFTerceirosProduto.tipo = :conferir)";
        }
        hql = (String)hql + " AND n.empresa = :empresa ";
        org.hibernate.query.Query q = this.query((String)hql);
        q.setParameter("dataInicial", (Object)dataInicial);
        q.setParameter("dataFinal", (Object)dataFinal);
        q.setParameter("empresa", (Object)empresa);
        if (opcoesCompras.getTipoConfNFTerceirosItens().equals(EnumConstTipoConfNFTercItens.CONF_CADASTRO_PROD.getValue())) {
            q.setParameter("conferir", (Object)EnumConstTipoConfNFProduto.CONFERIR.getValue());
        }
        return q.list();
    }

    public List<NotaFiscalTerceiros> findNotasNaoLiberadasFinanceiro(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesCompraSuprimentos opcoesCompras) {
        Object hql = "select n FROM NotaFiscalTerceiros n  LEFT JOIN n.liberacaoNFTerceiros l  WHERE n.dataEntrada between :dataInicial and :dataFinal  AND (l is null or l.liberacaoFinanceira is null) ";
        if (opcoesCompras.getTipoConfNFTerceirosItens().equals(EnumConstTipoConfNFTercItens.CONF_CADASTRO_PROD.getValue())) {
            hql = (String)hql + " AND EXISTS (select i.identificador  from ItemNotaTerceiros i  inner join i.produto p  where i.notaFiscalTerceiros = n  and p.tipoConfNFTerceirosProduto.tipo = :conferir)";
        }
        hql = (String)hql + " AND n.empresa = :empresa ";
        org.hibernate.query.Query q = this.query((String)hql);
        q.setParameter("dataInicial", (Object)dataInicial);
        q.setParameter("dataFinal", (Object)dataFinal);
        q.setParameter("empresa", (Object)empresa);
        if (opcoesCompras.getTipoConfNFTerceirosItens().equals(EnumConstTipoConfNFTercItens.CONF_CADASTRO_PROD.getValue())) {
            q.setParameter("conferir", (Object)EnumConstTipoConfNFProduto.CONFERIR.getValue());
        }
        return q.list();
    }

    public List<NotaFiscalTerceiros> findNotasNaoLiberadasEstoque(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesCompraSuprimentos opcoesCompras) {
        Object hql = "select n FROM NotaFiscalTerceiros n  LEFT JOIN n.liberacaoNFTerceiros l  WHERE n.dataEntrada between :dataInicial and :dataFinal  AND (l is null or l.liberacaoEstoque is null) ";
        if (opcoesCompras.getTipoConfNFTerceirosItens().equals(EnumConstTipoConfNFTercItens.CONF_CADASTRO_PROD.getValue())) {
            hql = (String)hql + " AND EXISTS (select i.identificador  from ItemNotaTerceiros i  inner join i.produto p  where i.notaFiscalTerceiros = n  and p.tipoConfNFTerceirosProduto.tipo = :conferir)";
        }
        hql = (String)hql + " AND n.empresa = :empresa ";
        org.hibernate.query.Query q = this.query((String)hql);
        q.setParameter("dataInicial", (Object)dataInicial);
        q.setParameter("dataFinal", (Object)dataFinal);
        q.setParameter("empresa", (Object)empresa);
        if (opcoesCompras.getTipoConfNFTerceirosItens().equals(EnumConstTipoConfNFTercItens.CONF_CADASTRO_PROD.getValue())) {
            q.setParameter("conferir", (Object)EnumConstTipoConfNFProduto.CONFERIR.getValue());
        }
        return q.list();
    }

    public List<NotaFiscalTerceiros> findNotasNaoLiberadasFiscal(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesCompraSuprimentos opcoesCompras) {
        Object hql = "select n FROM NotaFiscalTerceiros n  LEFT JOIN n.liberacaoNFTerceiros l  WHERE n.dataEntrada between :dataInicial and :dataFinal  AND (l is null or l.liberacaoFiscal is null) ";
        if (opcoesCompras.getTipoConfNFTerceirosItens().equals(EnumConstTipoConfNFTercItens.CONF_CADASTRO_PROD.getValue())) {
            hql = (String)hql + " AND EXISTS (select i.identificador  from ItemNotaTerceiros i  inner join i.produto p  where i.notaFiscalTerceiros = n  and p.tipoConfNFTerceirosProduto.tipo = :conferir)";
        }
        hql = (String)hql + " AND n.empresa = :empresa ";
        org.hibernate.query.Query q = this.query((String)hql);
        q.setParameter("dataInicial", (Object)dataInicial);
        q.setParameter("dataFinal", (Object)dataFinal);
        q.setParameter("empresa", (Object)empresa);
        if (opcoesCompras.getTipoConfNFTerceirosItens().equals(EnumConstTipoConfNFTercItens.CONF_CADASTRO_PROD.getValue())) {
            q.setParameter("conferir", (Object)EnumConstTipoConfNFProduto.CONFERIR.value);
        }
        return q.list();
    }

    public List<NotaFiscalTerceiros> findNotasPorPeriodo(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        Criteria crit = this.criteria();
        crit.createAlias("empresa", "e");
        crit.createAlias("integracaoNotaTerceiros", "i", JoinType.LEFT_OUTER_JOIN);
        crit.createAlias("e.empresaDados", "ed");
        crit.add(this.between("dataEntrada", dataInicial, dataFinal));
        crit.add(this.eq("ed.grupoEmpresa", grupoEmpresa));
        crit.add(this.isNull("i.loteContabil"));
        crit.addOrder(Order.asc((String)"identificador"));
        return crit.list();
    }

    public List<NotaFiscalTerceiros> findNotasPorPeriodoPaginado(Date dataInicial, Date dataFinal, Integer i, Integer first, Short filtrarNumeroSerie, String serie, Integer numeroInicial, Integer numeroFinal) {
        Object hql = "from NotaFiscalTerceiros p where p.dataEntrada between :dataIn and :dataFim";
        Boolean informarSerie = false;
        if (filtrarNumeroSerie != null && filtrarNumeroSerie.equals((short)1)) {
            if (ToolMethods.isStrWithData((String)serie)) {
                informarSerie = true;
                hql = (String)hql + " and p.serie = :serie and p.numeroNota between :numeroInicial and :numeroFinal";
            } else {
                hql = (String)hql + " and p.numeroNota between :numeroInicial and :numeroFinal";
            }
        }
        org.hibernate.query.Query q = this.query((String)hql);
        q.setParameter("dataIn", (Object)dataInicial);
        q.setParameter("dataFim", (Object)dataFinal);
        if (informarSerie.booleanValue()) {
            q.setParameter("serie", (Object)serie);
        }
        if (filtrarNumeroSerie != null && filtrarNumeroSerie.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
            q.setParameter("numeroInicial", (Object)numeroInicial);
            q.setParameter("numeroFinal", (Object)numeroFinal);
        }
        q.setMaxResults(i.intValue());
        q.setFirstResult(first.intValue());
        return q.list();
    }

    public List<NotaFiscalTerceiros> getNotaFiscalTerceirosRPA(Long geracaoReciboRpa) {
        CriteriaBuilder builder = this.criteriaBuilder(NotaFiscalTerceiros.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root fromNotaFiscalTerceiros = crit.from(NotaFiscalTerceiros.class);
        Join jNotaTerceirosFreteCtrc = fromNotaFiscalTerceiros.join("notaTerceirosFreteCtrc", javax.persistence.criteria.JoinType.INNER);
        Join jGeracaoReciboRpa = jNotaTerceirosFreteCtrc.join("geracaoReciboRpa", javax.persistence.criteria.JoinType.INNER);
        crit.select((Selection)fromNotaFiscalTerceiros).distinct(true);
        exps.add(builder.equal((Expression)jGeracaoReciboRpa.get("identificador"), (Object)geracaoReciboRpa));
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }

    public List<NotaFiscalTerceiros> findNotasByTipoLiberacao(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesCompraSuprimentos opcoesCompra, Short tipoLiberacao) {
        CriteriaBuilder builder = this.criteriaBuilder(NotaFiscalTerceiros.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root fromNotaFiscalTerceiros = crit.from(NotaFiscalTerceiros.class);
        Join jLiberacaoNFTerceiros = fromNotaFiscalTerceiros.join("liberacaoNFTerceiros", javax.persistence.criteria.JoinType.LEFT);
        exps.add(builder.between((Expression)fromNotaFiscalTerceiros.get("dataEntrada"), (Comparable)dataInicial, (Comparable)dataFinal));
        if (ToolMethods.isEquals((Object)tipoLiberacao, (Object)EnumLiberacaoNFTerceiros.LIBERACAO_ESTOQUE.getValue())) {
            exps.add(builder.or((Expression)builder.isNull((Expression)fromNotaFiscalTerceiros.get("liberacaoNFTerceiros")), (Expression)builder.isNull((Expression)jLiberacaoNFTerceiros.get("liberacaoEstoque"))));
        } else if (ToolMethods.isEquals((Object)tipoLiberacao, (Object)EnumLiberacaoNFTerceiros.LIBERACAO_QUALIDADE.getValue())) {
            exps.add(builder.or((Expression)builder.isNull((Expression)fromNotaFiscalTerceiros.get("liberacaoNFTerceiros")), (Expression)builder.isNull((Expression)jLiberacaoNFTerceiros.get("liberacaoQualidade"))));
        } else if (ToolMethods.isEquals((Object)tipoLiberacao, (Object)EnumLiberacaoNFTerceiros.LIBERACAO_FINANCEIRA.getValue())) {
            exps.add(builder.or((Expression)builder.isNull((Expression)fromNotaFiscalTerceiros.get("liberacaoNFTerceiros")), (Expression)builder.isNull((Expression)jLiberacaoNFTerceiros.get("liberacaoFinanceira"))));
        } else if (ToolMethods.isEquals((Object)tipoLiberacao, (Object)EnumLiberacaoNFTerceiros.LIBERACAO_FISCAL.getValue())) {
            exps.add(builder.or((Expression)builder.isNull((Expression)fromNotaFiscalTerceiros.get("liberacaoNFTerceiros")), (Expression)builder.isNull((Expression)jLiberacaoNFTerceiros.get("liberacaoFiscal"))));
        }
        exps.add(builder.equal((Expression)fromNotaFiscalTerceiros.get("empresa"), (Object)empresa));
        if (ToolMethods.isEquals((Object)opcoesCompra.getTipoConfNFTerceirosItens(), (Object)EnumConstTipoConfNFTercItens.CONF_CADASTRO_PROD.value)) {
            Subquery subquery = crit.subquery(ItemNotaTerceiros.class);
            Root fromItemNotaTerceiros = subquery.from(ItemNotaTerceiros.class);
            Join jProduto = fromItemNotaTerceiros.join("produto", javax.persistence.criteria.JoinType.INNER);
            Join jTipoConfNFTerceirosProduto = jProduto.join("tipoConfNFTerceirosProduto", javax.persistence.criteria.JoinType.INNER);
            subquery.where((Expression)builder.and((Expression)builder.equal((Expression)fromItemNotaTerceiros.get("notaFiscalTerceiros"), (Expression)fromNotaFiscalTerceiros), (Expression)builder.equal((Expression)jTipoConfNFTerceirosProduto.get("tipo"), (Object)EnumConstTipoConfNFProduto.CONFERIR.value)));
            subquery.select((Expression)fromItemNotaTerceiros);
            exps.add(builder.exists(subquery));
        }
        crit.select((Selection)fromNotaFiscalTerceiros).distinct(true);
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }

    public List<Object[]> findNotasNaoVinculadasXML(Date dataInicial, Date dataFinal) {
        Criteria crit = this.criteria();
        crit.createAlias("modeloDocFiscal", "mdf");
        crit.add(this.greatherEqual("dataEntrada", dataInicial));
        crit.add(this.lessEqual("dataEntrada", dataFinal));
        crit.add(this.or(this.eq("mdf.codigo", EnumConstantsModeloDocFiscal.NFE_55.getCodigo()), this.eq("mdf.codigo", EnumConstantsModeloDocFiscal.CTE_57.getCodigo()), this.eq("mdf.codigo", EnumConstantsModeloDocFiscal.NFCE_65.getCodigo())));
        ProjectionList select = Projections.projectionList();
        select.add((Projection)Projections.property((String)"identificador"), "identificador");
        select.add((Projection)Projections.property((String)"chaveNFE"), "chaveNFE");
        crit.setProjection((Projection)select);
        return crit.list();
    }

    public List<NotaFiscalTerceiros> findNotasNaoApuradasReinf2010(GrupoEmpresa grupo, Date periodo, Boolean filtrarNotasRetidas) {
        CriteriaBuilder builder = this.criteriaBuilder(NotaFiscalTerceiros.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root root = crit.from(NotaFiscalTerceiros.class);
        Join jModeloDocFiscal = root.join("modeloDocFiscal", javax.persistence.criteria.JoinType.INNER);
        Join jValoresNfTerceiros = root.join("valoresNfTerceiros", javax.persistence.criteria.JoinType.INNER);
        Join jEmpresa = root.join("empresa", javax.persistence.criteria.JoinType.INNER);
        Join jEmpresaDados = jEmpresa.join("empresaDados", javax.persistence.criteria.JoinType.INNER);
        Join jUnidadeFatFornecedor = root.join("unidadeFatFornecedor", javax.persistence.criteria.JoinType.INNER);
        Join jFornecedor = jUnidadeFatFornecedor.join("fornecedor", javax.persistence.criteria.JoinType.INNER);
        Join jPessoa = jFornecedor.join("pessoa", javax.persistence.criteria.JoinType.INNER);
        Join jComplemento = jPessoa.join("complemento", javax.persistence.criteria.JoinType.INNER);
        exps.add(builder.equal((Expression)jEmpresaDados.get("grupoEmpresa"), (Object)grupo));
        exps.add(builder.equal((Expression)jModeloDocFiscal.get("modeloServico"), (Object)EnumConstantsMentorSimNao.SIM.getValue()));
        exps.add(builder.between((Expression)root.get("dataEntrada"), (Comparable)ToolDate.getDataInicial((Date)periodo), (Comparable)ToolDate.getDataFinal((Date)periodo)));
        exps.add(builder.and((Expression)builder.isNotNull((Expression)jComplemento.get("cnpj")), (Expression)builder.equal(builder.function("char_length", String.class, new Expression[]{jComplemento.get("cnpj")}), (Object)14)));
        if (filtrarNotasRetidas.booleanValue()) {
            exps.add(builder.greaterThan((Expression)jValoresNfTerceiros.get("valorInss"), (Comparable)Double.valueOf(0.0)));
        }
        Subquery subqueryReinf = crit.subquery(ItemReinfNotas2010.class);
        Root fromItemReinf = subqueryReinf.from(ItemReinfNotas2010.class);
        Join jNotaTerceiros = fromItemReinf.join("notaTerceiros", javax.persistence.criteria.JoinType.INNER);
        subqueryReinf.where((Expression)builder.equal((Expression)jNotaTerceiros.get("identificador"), (Expression)root.get("identificador")));
        subqueryReinf.select((Expression)fromItemReinf);
        exps.add(builder.not((Expression)builder.exists(subqueryReinf)));
        crit.select((Selection)root);
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }

    public List<NotaFiscalTerceiros> findNotasNaoApuradasReinf4010(GrupoEmpresa grupo, Date periodo) {
        CriteriaBuilder builder = this.criteriaBuilder(NotaFiscalTerceiros.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root root = crit.from(NotaFiscalTerceiros.class);
        Join jInfPagamentoNfTerceiros = root.join("infPagamentoNfTerceiros", javax.persistence.criteria.JoinType.INNER);
        Join jTitulos = jInfPagamentoNfTerceiros.join("titulos", javax.persistence.criteria.JoinType.INNER);
        Join jModeloDocFiscal = root.join("modeloDocFiscal", javax.persistence.criteria.JoinType.INNER);
        Join jValoresNfTerceiros = root.join("valoresNfTerceiros", javax.persistence.criteria.JoinType.INNER);
        Join jEmpresa = root.join("empresa", javax.persistence.criteria.JoinType.INNER);
        Join jEmpresaDados = jEmpresa.join("empresaDados", javax.persistence.criteria.JoinType.INNER);
        Join jUnidadeFatFornecedor = root.join("unidadeFatFornecedor", javax.persistence.criteria.JoinType.INNER);
        Join jFornecedor = jUnidadeFatFornecedor.join("fornecedor", javax.persistence.criteria.JoinType.INNER);
        Join jPessoa = jFornecedor.join("pessoa", javax.persistence.criteria.JoinType.INNER);
        Join jComplemento = jPessoa.join("complemento", javax.persistence.criteria.JoinType.INNER);
        exps.add(builder.lessThan((Expression)root.get("dataEntrada"), (Comparable)ToolDate.getDataInicial((Date)periodo)));
        exps.add(builder.equal((Expression)jEmpresaDados.get("grupoEmpresa"), (Object)grupo));
        exps.add(builder.equal((Expression)jModeloDocFiscal.get("modeloServico"), (Object)EnumConstantsMentorSimNao.SIM.getValue()));
        exps.add(builder.and((Expression)builder.between((Expression)jTitulos.get("dataVencimento"), (Comparable)ToolDate.getDataInicial((Date)periodo), (Comparable)ToolDate.getDataFinal((Date)periodo)), (Expression)builder.equal((Expression)jTitulos.get("pessoa"), (Expression)jFornecedor.get("pessoa"))));
        exps.add(builder.greaterThan((Expression)jValoresNfTerceiros.get("valorIrrf"), (Comparable)Double.valueOf(0.0)));
        exps.add(builder.equal((Expression)jComplemento.get("tipoPessoa"), (Object)0.0));
        Subquery subqueryReinf = crit.subquery(ItemReinfNotas4010.class);
        Root fromItemReinf = subqueryReinf.from(ItemReinfNotas4010.class);
        Join jNotaTerceiros = fromItemReinf.join("notaTerceiros", javax.persistence.criteria.JoinType.INNER);
        subqueryReinf.where((Expression)builder.equal((Expression)jNotaTerceiros.get("identificador"), (Expression)root.get("identificador")));
        subqueryReinf.select((Expression)fromItemReinf);
        exps.add(builder.not((Expression)builder.exists(subqueryReinf)));
        crit.select((Selection)root);
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }

    public List<NotaFiscalTerceiros> findNotasOutrasRetencoesReinf4020(GrupoEmpresa grupo, Date periodo) {
        String hql = " select distinct nt From NotaFiscalTerceiros nt  inner join nt.infPagamentoNfTerceiros inf  inner join inf.titulos titulo where   (  nt.valoresNfTerceiros.valorLei10833 > 0 or nt.valoresNfTerceiros.valorContSoc > 0 ) and nt.empresa.empresaDados.grupoEmpresa = :grupoEmpresa  and (titulo is not null and titulo.dataVencimento between :dataInicial and :dataFinal and  titulo.pessoa = nt.unidadeFatFornecedor.fornecedor.pessoa) and nt.modeloDocFiscal.modeloServico = :modeloServico  and nt.unidadeFatFornecedor.pessoa.complemento.tipoPessoa != 0  and not exists(select i.identificador                from ItemReinfNotas4020 i                 where i.notaTerceiros.identificador = nt.identificador                 and i.itemReinf.apuracaoReinf.periodo between :dataInicial and :dataFinal )";
        org.hibernate.query.Query query = this.query(hql);
        query.setParameter("dataInicial", (Object)ToolDate.getDataInicial((Date)periodo));
        query.setParameter("dataFinal", (Object)ToolDate.getDataFinal((Date)periodo));
        query.setParameter("grupoEmpresa", (Object)grupo);
        query.setParameter("modeloServico", (Object)EnumConstantsMentorSimNao.SIM.getValue());
        return query.list();
    }

    public List<NotaFiscalTerceiros> findNotasNaoApuradasReinf4020(GrupoEmpresa grupo, Date periodo) {
        String hqlIrrf = " select distinct nt From NotaFiscalTerceiros nt  inner join nt.infPagamentoNfTerceiros inf  inner join inf.titulos titulo inner join nt.unidadeFatFornecedor uff inner join uff.pessoa p inner join p.complemento c inner join uff.fornecedor f inner join nt.itemNotaTerceiros int inner join int.modeloFiscal mf inner join nt.modeloDocFiscal mdf where   ((nt.valoresNfTerceiros.valorIrrf > 0 ) and ( nt.dataEmissao between :dataInicial and :dataFinal  ) and nt.empresa.empresaDados.grupoEmpresa = :grupoEmpresa  and nt.modeloDocFiscal.modeloServico = :modeloServico  and nt.unidadeFatFornecedor.pessoa.complemento.tipoPessoa != 0  and not exists(select i.identificador                from ItemReinfNotas4020 i                 where i.notaTerceiros.identificador = nt.identificador                 and i.itemReinf.apuracaoReinf.periodo between :dataInicial and :dataFinal )) or ((nt.valoresNfTerceiros.valorIrrf = 0 )  and ( nt.dataEmissao between :dataInicial and :dataFinal  ) and nt.empresa.empresaDados.grupoEmpresa = :grupoEmpresa  and nt.modeloDocFiscal.modeloServico = :modeloServico  and nt.unidadeFatFornecedor.pessoa.complemento.tipoPessoa != 0  and CHAR_LENGTH(c.cnpj) = 14  and (f.tipoEpp = :nao) and mf.reinfNaturezaRendimento is not null  and ((mf.tipoIRRF = :tipoIrrfCalcular) or (mf.tipoIRRF = :tipoIrrfHabilitar))  and not exists(select i.identificador                from ItemReinfNotas4020 i                 where i.notaTerceiros.identificador = nt.identificador                 and i.itemReinf.apuracaoReinf.periodo between :dataInicial and :dataFinal )) ";
        org.hibernate.query.Query query = this.query(hqlIrrf);
        query.setParameter("dataInicial", (Object)ToolDate.getDataInicial((Date)periodo));
        query.setParameter("dataFinal", (Object)ToolDate.getDataFinal((Date)periodo));
        query.setParameter("grupoEmpresa", (Object)grupo);
        query.setParameter("modeloServico", (Object)EnumConstantsMentorSimNao.SIM.getValue());
        query.setParameter("nao", (Object)EnumConstantsMentorSimNao.NAO.getValue());
        query.setParameter("tipoIrrfCalcular", (Object)1);
        query.setParameter("tipoIrrfHabilitar", (Object)2);
        return query.list();
    }
}

