/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.ordemcompra.EnumConstOrdemCompraStatus;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.OrdemCompra;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoOrdemCompraImpl
extends DaoGenericEntityImpl<OrdemCompra, Long> {
    public List<OrdemCompra> findOrdensByCotacao(Long cotacao) {
        return this.toList(this.restrictions(this.eq("cotacaoCompra.identificador", cotacao)));
    }

    public List<OrdemCompra> findOrdensComprasAbertasPorProdutoSemFornecedor(Long produto, Empresa empresa) {
        Criteria c = this.criteria();
        c.createAlias("itemOrdemCompra", "i");
        c.createAlias("statusOrdemCompra", "s");
        c.createAlias("i.produto", "p");
        c.createAlias("empresa", "e");
        c.add(this.eq("p.identificador", produto));
        if (empresa != null) {
            c.add(this.eq("e.identificador", empresa.getIdentificador()));
        }
        c.add(this.eq("s.status", EnumConstOrdemCompraStatus.ABERTO.value));
        return c.list();
    }

    public List<Map<String, Object>> findQuantidadeCompradaItem(Long idGradeCor) {
        String query = " select   i.identificador as ID_GRADE,  ioc.fatorConversao AS FATOR_CONVERSAO, coalesce(i.quantidade - coalesce(sum(g.quantidade),0),0) as QUANTIDADE_COMPRADA  from GradeItemOrdemCompra i   left join i.gradeItemRecepcaoMercadorias g  inner join i.itemOrdemCompra ioc where i.gradeCor.identificador=:id_grade_cor  and ioc.ordemCompra.statusOrdemCompra.status = :status  group by  i.identificador ,  i.quantidade, ioc.fatorConversao having  coalesce(i.quantidade - coalesce(sum(g.quantidade),0),0)>0 ";
        org.hibernate.query.Query q = this.query(query);
        q.setParameter("id_grade_cor", (Object)idGradeCor);
        q.setParameter("status", (Object)EnumConstOrdemCompraStatus.ABERTO.value);
        return this.toHashList((Query)q);
    }
}

