/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.OrdemServicoProdLinhaProd;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.SubdivisaoOSProdLinhaProd;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.hibernate.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoOrdemServicoProdLinhaProdImpl
extends DaoGenericEntityImpl<OrdemServicoProdLinhaProd, Long> {
    public SubdivisaoOSProdLinhaProd findSubdivisaoOsSobEncPorProdutoAndLote(Produto produto, String loteFab) {
        String query = "select distinct s  from SubdivisaoOSProdLinhaProd s inner join s.ordemServicoProdLinhaProd o where s.gradeCor.produtoGrade.produto = :produto and s.loteFabricacao.loteFabricacao = :lote and s.dataFechamento is null order by s.identificador desc";
        org.hibernate.query.Query q = this.query(query);
        q.setEntity("produto", (Object)produto);
        q.setString("lote", loteFab);
        q.setMaxResults(1);
        return (SubdivisaoOSProdLinhaProd)q.uniqueResult();
    }

    public CentroEstoque findCentroEstoqueUltApt(Produto p, OrdemServicoProdLinhaProd os) {
        String query = "select distinct ii.centroEstoque from EventoOsProducaoLinhaProd o inner join o.comunicadoProducao i inner join i.itemComunicadoProducao ii where ii.produto = :prod  and o.subdivisaoOSProd.ordemServicoProdLinhaProd = :os";
        org.hibernate.query.Query q = this.query(query);
        q.setEntity("prod", (Object)p);
        q.setEntity("os", (Object)os);
        q.setMaxResults(1);
        return (CentroEstoque)q.uniqueResult();
    }

    public List<Map<String, Object>> getFormProdPOSLinha(Short filtraProduto, Long prodInicial, Long prodFinal, Short filtraData, Date dataInicial, Date dataFinal, Short filtraEspecie, Long especieInicial, Long especieFinal, Short filtraSubEspecie, Long subEspecieInicial, Long subEspecieFinal, Short filtraFabricante, Long fabricanteInicial, Long fabricanteFinal, Long periodoProducao) {
        Object st = "select itemForm.gradeCor.produtoGrade.produto.identificador as ID_PRODUTO, itemForm.gradeCor.produtoGrade.produto.codigoAuxiliar as CODIGO_AUXILIAR, itemForm.gradeCor.produtoGrade.produto.nome as PRODUTO, itemForm.gradeCor.cor.nome as GRADE, itemForm.gradeCor.identificador as ID_GRADE_COR, itemForm.gradeCor.produtoGrade.produto.especie.nome as ESPECIE, itemForm.gradeCor.produtoGrade.produto.subEspecie.nome as SUB_ESPECIE, sum(((itemForm.percAdicional/100 * itemForm.quantidade)+itemForm.quantidade) *  s.quantidadeRefPrevProd) as QUANTIDADE, itemForm.gradeCor.produtoGrade.produto.qtdMin as QTD_MIN, itemForm.gradeCor.produtoGrade.produto.qtdMax as QTD_MAX, itemForm.gradeCor.produtoGrade.produto.pontoRessupEstoque as PTO_RESSUPRIMENTO, itemForm.gradeCor.produtoGrade.produto.unidadeMedida.sigla as UNIDADE_MEDIDA, s.pessoaParceiro.identificador as PARCEIRO from OrdemServicoProdLinhaProd s inner join s.gradeFormulaProduto form inner join form.itemGradeFormulaProduto itemForm where  s.periodoProducao.identificador = :periodo";
        if (TMethods.isAffirmative((Number)filtraData)) {
            st = (String)st + " and s.dataPrevisao between :dataInicial and :dataFinal";
        }
        if (TMethods.isAffirmative((Number)filtraProduto)) {
            st = (String)st + " and itemForm.gradeCor.produtoGrade.produto.identificador between :idInicial and :idFinal";
        }
        if (TMethods.isAffirmative((Number)filtraEspecie)) {
            st = (String)st + " and itemForm.gradeCor.produtoGrade.produto.especie.identificador between :idEspecieInicial and :idEspecieFinal";
        }
        if (TMethods.isAffirmative((Number)filtraSubEspecie)) {
            st = (String)st + " and itemForm.gradeCor.produtoGrade.produto.subEspecie.identificador between :idSubEspecieInicial and :idSubEspecieFinal";
        }
        if (TMethods.isAffirmative((Number)filtraFabricante)) {
            st = (String)st + " and s.gradeCor.produtoGrade.produto.fabricante.identificador between :idFabricanteInicial and :idFabricanteFinal";
        }
        st = (String)st + " group by itemForm.gradeCor.produtoGrade.produto.identificador, itemForm.gradeCor.produtoGrade.produto.codigoAuxiliar, itemForm.gradeCor.produtoGrade.produto.nome, itemForm.gradeCor.cor.nome, itemForm.gradeCor.identificador, itemForm.gradeCor.produtoGrade.produto.qtdMin, itemForm.gradeCor.produtoGrade.produto.qtdMax, itemForm.gradeCor.produtoGrade.produto.pontoRessupEstoque, itemForm.gradeCor.produtoGrade.produto.especie.nome, itemForm.gradeCor.produtoGrade.produto.subEspecie.nome, itemForm.gradeCor.produtoGrade.produto.unidadeMedida.sigla, s.pessoaParceiro.identificador";
        st = (String)st + " order by itemForm.gradeCor.produtoGrade.produto.nome ";
        org.hibernate.query.Query q = this.query((String)st);
        q.setParameter("periodo", (Object)periodoProducao);
        if (TMethods.isAffirmative((Number)filtraData)) {
            q.setParameter("dataInicial", (Object)dataInicial);
            q.setParameter("dataFinal", (Object)dataFinal);
        }
        if (TMethods.isAffirmative((Number)filtraProduto)) {
            q.setParameter("idInicial", (Object)prodInicial);
            q.setParameter("idFinal", (Object)prodFinal);
        }
        if (TMethods.isAffirmative((Number)filtraEspecie)) {
            q.setParameter("idEspecieInicial", (Object)especieInicial);
            q.setParameter("idEspecieFinal", (Object)especieFinal);
        }
        if (TMethods.isAffirmative((Number)filtraSubEspecie)) {
            q.setParameter("idSubEspecieInicial", (Object)subEspecieInicial);
            q.setParameter("idSubEspecieFinal", (Object)subEspecieFinal);
        }
        if (TMethods.isAffirmative((Number)filtraFabricante)) {
            q.setParameter("idFabricanteInicial", (Object)fabricanteInicial);
            q.setParameter("idFabricanteFinal", (Object)fabricanteFinal);
        }
        return this.toHashList((Query)q);
    }

    public List<Map<String, Object>> getPrevQtdProdFormProdPOSLinha(Short filtraProduto, Long prodInicial, Long prodFinal, Short filtraData, Date dataInicial, Date dataFinal, Short filtraEspecie, Long especieInicial, Long especieFinal, Short filtraSubEspecie, Long subEspecieInicial, Long subEspecieFinal, Short filtraFabricante, Long fabricanteInicial, Long fabricanteFinal, Long periodoProducao) {
        Object st = "select s.gradeCor.produtoGrade.produto.identificador as ID_PRODUTO, s.gradeCor.produtoGrade.produto.codigoAuxiliar as CODIGO_AUXILIAR, s.gradeCor.produtoGrade.produto.nome as PRODUTO, s.gradeCor.cor.nome as GRADE, s.gradeCor.identificador as ID_GRADE_COR, s.gradeCor.produtoGrade.produto.especie.nome as ESPECIE, s.gradeCor.produtoGrade.produto.subEspecie.nome as SUB_ESPECIE, sum(s.quantidadeRefPrevProd) as QTD_PREV_PRODUCAO, s.gradeCor.produtoGrade.produto.qtdMin as QTD_MIN, s.gradeCor.produtoGrade.produto.qtdMax as QTD_MAX, s.gradeCor.produtoGrade.produto.pontoRessupEstoque as PTO_RESSUPRIMENTO, s.gradeCor.produtoGrade.produto.unidadeMedida.sigla as UNIDADE_MEDIDA from OrdemServicoProdLinhaProd s where  s.periodoProducao.identificador = :periodo";
        if (TMethods.isAffirmative((Number)filtraData)) {
            st = (String)st + " and s.dataPrevisao between :dataInicial and :dataFinal";
        }
        if (TMethods.isAffirmative((Number)filtraProduto)) {
            st = (String)st + " and s.gradeCor.produtoGrade.produto.identificador between :idInicial and :idFinal";
        }
        if (TMethods.isAffirmative((Number)filtraEspecie)) {
            st = (String)st + " and s.gradeCor.produtoGrade.produto.especie.identificador between :idEspecieInicial and :idEspecieFinal";
        }
        if (TMethods.isAffirmative((Number)filtraSubEspecie)) {
            st = (String)st + " and s.gradeCor.produtoGrade.produto.subEspecie.identificador between :idSubEspecieInicial and :idSubEspecieFinal";
        }
        if (TMethods.isAffirmative((Number)filtraFabricante)) {
            st = (String)st + " and s.gradeCor.produtoGrade.produto.fabricante.identificador between :idFabricanteInicial and :idFabricanteFinal";
        }
        st = (String)st + " group by s.gradeCor.produtoGrade.produto.identificador, s.gradeCor.produtoGrade.produto.codigoAuxiliar, s.gradeCor.produtoGrade.produto.nome, s.gradeCor.cor.nome, s.gradeCor.identificador, s.gradeCor.produtoGrade.produto.qtdMin, s.gradeCor.produtoGrade.produto.qtdMax, s.gradeCor.produtoGrade.produto.pontoRessupEstoque, s.gradeCor.produtoGrade.produto.especie.nome, s.gradeCor.produtoGrade.produto.subEspecie.nome, s.gradeCor.produtoGrade.produto.unidadeMedida.sigla";
        st = (String)st + " order by s.gradeCor.identificador";
        org.hibernate.query.Query q = this.query((String)st);
        q.setParameter("periodo", (Object)periodoProducao);
        if (TMethods.isAffirmative((Number)filtraData)) {
            q.setParameter("dataInicial", (Object)dataInicial);
            q.setParameter("dataFinal", (Object)dataFinal);
        }
        if (TMethods.isAffirmative((Number)filtraProduto)) {
            q.setParameter("idInicial", (Object)prodInicial);
            q.setParameter("idFinal", (Object)prodFinal);
        }
        if (TMethods.isAffirmative((Number)filtraEspecie)) {
            q.setParameter("idEspecieInicial", (Object)especieInicial);
            q.setParameter("idEspecieFinal", (Object)especieFinal);
        }
        if (TMethods.isAffirmative((Number)filtraSubEspecie)) {
            q.setParameter("idSubEspecieInicial", (Object)subEspecieInicial);
            q.setParameter("idSubEspecieFinal", (Object)subEspecieFinal);
        }
        if (TMethods.isAffirmative((Number)filtraFabricante)) {
            q.setParameter("idFabricanteInicial", (Object)fabricanteInicial);
            q.setParameter("idFabricanteFinal", (Object)fabricanteFinal);
        }
        return this.toHashList((Query)q);
    }
}

