/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ParamContabilNFCe;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoParamContabilNFCeImpl
extends DaoGenericEntityImpl<ParamContabilNFCe, Long> {
    public List<ParamContabilNFCe> getForEmpresa(Empresa empresa) {
        String query = "select distinct p  from ParamContabilNFCe p  inner join p.empresas e  where e.empresa = :empresa";
        Query q = this.query(query);
        q.setEntity("empresa", (Object)empresa);
        return q.list();
    }

    public ParamContabilNFCe getByEmpGeral(Empresa emp) {
        Criteria c = this.criteria();
        c.createAlias("empresas", "ep");
        this.restrictions(c, this.eq("contabilizacaoGeral", (short)1), this.eq("ep.empresa", emp));
        return (ParamContabilNFCe)this.toUnique(c);
    }

    public ParamContabilNFCe getByCatPessoaEmp(CategoriaPessoa cat, Empresa emp) {
        Criteria c = this.criteria();
        c.createAlias("empresas", "ep");
        c.createAlias("categorias", "c");
        this.restrictions(c, this.eq("contabilizacaoGeral", (short)0), this.eq("c.categoriaPessoa", cat), this.eq("ep.empresa", emp));
        return (ParamContabilNFCe)this.toUnique(c);
    }

    public ParamContabilNFCe getByCatPessoaEmp(CategoriaPessoa cat, Empresa emp, ClassificacaoClientes classificacao) {
        Criteria c = this.criteria();
        c.createAlias("empresas", "ep");
        c.createAlias("categorias", "c");
        c.createAlias("classificacoes", "cl");
        this.restrictions(c, this.eq("contabilizacaoGeral", (short)0), this.eq("c.categoriaPessoa", cat), this.eq("cl.classificacaoPessoa", classificacao), this.eq("ep.empresa", emp));
        return (ParamContabilNFCe)this.toUnique(c);
    }
}

