/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemParamCreditoLoja;
import com.touchcomp.basementor.model.vo.ParamCreditoLoja;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.Date;
import java.util.LinkedList;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.stereotype.Repository;

@Repository
public class DaoParamCreditoLojaImpl
extends DaoGenericEntityImpl<ParamCreditoLoja, Long> {
    public ItemParamCreditoLoja get(ClassificacaoClientes classificacao, Empresa empresa, Date dataEmissao) {
        String hql = " select distinct i from ItemParamCreditoLoja i where i.classificacaoClientes.identificador = :idClassificacao and i.paramCreditoLoja.empresa.identificador = :idEmpresa and i.dataFinalCompra >= :dataEmissao order by i.dataFinalCompra ";
        return (ItemParamCreditoLoja)this.query(hql).setLong("idClassificacao", classificacao.getIdentificador().longValue()).setLong("idEmpresa", empresa.getIdentificador().longValue()).setDate("dataEmissao", dataEmissao).setMaxResults(1).uniqueResult();
    }

    public ParamCreditoLoja findByEmpresa(Long idEmpresa) {
        try {
            CriteriaBuilder builder = this.criteriaBuilder(ParamCreditoLoja.class);
            CriteriaQuery crit = builder.createQuery();
            LinkedList<Predicate> exps = new LinkedList<Predicate>();
            Root fromParamCreditoLoja = crit.from(ParamCreditoLoja.class);
            Join jEmpresa = fromParamCreditoLoja.join("empresa", JoinType.INNER);
            crit.select((Selection)fromParamCreditoLoja);
            exps.add(builder.equal((Expression)jEmpresa.get("identificador"), (Object)idEmpresa));
            crit.where(exps.toArray(new Predicate[0]));
            return (ParamCreditoLoja)this.getEntityManager().createQuery(crit).setMaxResults(1).getSingleResult();
        }
        catch (Exception e) {
            return null;
        }
    }
}

