/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoParamFolha;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.ParametrizacaoContabilizacaoFolha;
import com.touchcomp.basementor.model.vo.TipoCalculo;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementor.model.vo.TipoColaborador;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoParametrizacaoContabilizacaoFolhaImpl
extends DaoGenericEntityImpl<ParametrizacaoContabilizacaoFolha, Long> {
    public List<TipoCalculoEvento> findEventosProventosParamFolha() {
        Query q = this.query(" from TipoCalculoEvento tipo  where tipo.evento.tipoEvento = :provento  order by tipo.evento.codigo ");
        q.setParameter("provento", (Object)EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue());
        return q.getResultList();
    }

    public List<TipoCalculoEvento> findEventosDescontosParamFolha() {
        Query q = this.query("from TipoCalculoEvento tipo  where tipo.evento.tipoEvento = :desconto  order by tipo.evento.codigo");
        q.setParameter("desconto", (Object)EnumConstEventoParamFolha.EVENTO_DESCONTO.getValue());
        return q.getResultList();
    }

    public List<ParametrizacaoContabilizacaoFolha> findParamFolha(CentroCusto cc, TipoColaborador tipoColaborador, TipoCalculo tipoCalculo, TipoCalculoEvento tipoEvento) {
        String hql = " select p  from ParametrizacaoContabilizacaoFolha p  inner join p.paramCentroCusto itemCC  inner join p.paramEventos itemEvento  inner join p.paramTipoCalculo itemTipoCalculo  inner join p.paramTipoColaborador  itemTipoColaborador  where itemCC.centroCusto = :centroCusto and itemEvento.tipoCalculo = :tipoEvento and itemTipoCalculo.tipoCalculo = :tipoCalculo and itemTipoColaborador.tipoColaborador = :tipoColaborador ";
        Query q = this.query(hql);
        q.setParameter("centroCusto", (Object)cc);
        q.setParameter("tipoEvento", (Object)tipoEvento);
        q.setParameter("tipoCalculo", (Object)tipoCalculo);
        q.setParameter("tipoColaborador", (Object)tipoColaborador);
        return q.list();
    }

    public List<ParametrizacaoContabilizacaoFolha> getParamPorTipoColaboradorCentroCustoTipoFolhaTipoCalculo(Long centroCusto, Long tipoCalculo, Short tipoFolha, Long tipoColaborador) {
        try {
            CriteriaBuilder builder = this.criteriaBuilder(ParametrizacaoContabilizacaoFolha.class);
            CriteriaQuery crit = builder.createQuery();
            LinkedList<Predicate> exps = new LinkedList<Predicate>();
            Root fromParametrizacaoContabilizacaoFolha = crit.from(ParametrizacaoContabilizacaoFolha.class);
            Join jParamContabilizacaoFolhaCentroCusto = fromParametrizacaoContabilizacaoFolha.join("paramCentroCusto", JoinType.INNER);
            Join jCentroCusto = jParamContabilizacaoFolhaCentroCusto.join("centroCusto", JoinType.INNER);
            Join jParamContabilizacaoFolhaEventos = fromParametrizacaoContabilizacaoFolha.join("paramEventos", JoinType.INNER);
            Join jTipoCalculoEvento = jParamContabilizacaoFolhaEventos.join("tipoCalculo", JoinType.INNER);
            Join jParamContabilizacaoFolhaTipoCalculo = fromParametrizacaoContabilizacaoFolha.join("paramTipoCalculo", JoinType.INNER);
            Join jTipoCalculo = jParamContabilizacaoFolhaTipoCalculo.join("tipoCalculo", JoinType.INNER);
            Join jParamContabilizacaoTipoColaborador = fromParametrizacaoContabilizacaoFolha.join("paramTipoColaborador", JoinType.INNER);
            Join jTipoColaborador = jParamContabilizacaoTipoColaborador.join("tipoColaborador", JoinType.INNER);
            crit.select((Selection)fromParametrizacaoContabilizacaoFolha);
            exps.add(builder.equal((Expression)jCentroCusto.get("identificador"), (Object)centroCusto));
            exps.add(builder.equal((Expression)jTipoCalculoEvento.get("identificador"), (Object)tipoCalculo));
            exps.add(builder.equal((Expression)jTipoCalculo.get("tipoFolha"), (Object)tipoFolha));
            exps.add(builder.equal((Expression)jTipoColaborador.get("identificador"), (Object)tipoColaborador));
            crit.where(exps.toArray(new Predicate[0]));
            return this.getEntityManager().createQuery(crit).getResultList();
        }
        catch (Exception e) {
            return new ArrayList<ParametrizacaoContabilizacaoFolha>();
        }
    }
}

