/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.Funcao;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemControleEquipamento;
import com.touchcomp.basementor.model.vo.ItemEquipamento;
import com.touchcomp.basementor.model.vo.ParametrizacaoEquipamentoSeguranca;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoParametrizacaoEquipamentoSegurancaImpl
extends DaoGenericEntityImpl<ParametrizacaoEquipamentoSeguranca, Long> {
    public ItemEquipamento pesquisarItemEquipamentoFuncaoGradeCor(Funcao funcao, GradeCor gradeCor) {
        Query q = this.query("SELECT i FROM ItemEquipamento i INNER JOIN i.parametrizacaoEquipamentoSeguranca p INNER JOIN p.funcao pf INNER JOIN pf.funcao f WHERE f = :funcao AND i.gradeCor = :gradeCor");
        q.setEntity("gradeCor", (Object)gradeCor);
        q.setEntity("funcao", (Object)funcao);
        q.setMaxResults(1);
        return (ItemEquipamento)q.uniqueResult();
    }

    public List<ItemEquipamento> buscarEquipamentosSemEntrega(Long idColaborador, Long idFuncaoColaborador, Long idEmpresaColaborador, Date dataEntrega) {
        CriteriaBuilder builder = this.criteriaBuilder(ParametrizacaoEquipamentoSeguranca.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root fromParametrizacaoEquipamentoSeguranca = crit.from(ParametrizacaoEquipamentoSeguranca.class);
        Join jItemEquipamento = fromParametrizacaoEquipamentoSeguranca.join("itemEquipamento", JoinType.INNER);
        Join jParamEquipFuncao = fromParametrizacaoEquipamentoSeguranca.join("funcao", JoinType.INNER);
        Join jFuncao = jParamEquipFuncao.join("funcao", JoinType.INNER);
        Join jParamEquipSegurancaEmpresa = fromParametrizacaoEquipamentoSeguranca.join("paramEquipSegurancaEmpresa", JoinType.INNER);
        Join jEmpresa = jParamEquipSegurancaEmpresa.join("empresa", JoinType.INNER);
        crit.select((Selection)jItemEquipamento).distinct(true);
        exps.add(builder.equal((Expression)jFuncao.get("identificador"), (Object)idFuncaoColaborador));
        exps.add(builder.equal((Expression)jEmpresa.get("identificador"), (Object)idEmpresaColaborador));
        Subquery subquery = crit.subquery(ItemControleEquipamento.class);
        LinkedList<Predicate> expsSub = new LinkedList<Predicate>();
        Root fromItemControleEquipamentoSub = subquery.from(ItemControleEquipamento.class);
        Join jItemEquipamentoSub = fromItemControleEquipamentoSub.join("itemEquipamento", JoinType.INNER);
        Join jControleEntregaEquipamentoSub = fromItemControleEquipamentoSub.join("controleEntregaEquipamento", JoinType.INNER);
        Join jColaboradorSub = jControleEntregaEquipamentoSub.join("colaborador", JoinType.INNER);
        Join jFuncaoSub = jColaboradorSub.join("funcao", JoinType.INNER);
        subquery.select((Expression)fromItemControleEquipamentoSub);
        expsSub.add(builder.equal((Expression)jItemEquipamentoSub.get("identificador"), (Expression)jItemEquipamento.get("identificador")));
        expsSub.add(builder.equal((Expression)jColaboradorSub.get("identificador"), (Object)idColaborador));
        expsSub.add(builder.equal((Expression)jFuncaoSub.get("identificador"), (Object)idFuncaoColaborador));
        subquery.where(expsSub.toArray(new Predicate[0]));
        exps.add(builder.not((Expression)builder.exists(subquery)));
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }
}

