/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.manutencaositpedidos.EnumConstFiltroGrupoSituacaoRota;
import com.touchcomp.basementor.constants.enums.manutencaositpedidos.EnumConstIntervaloDatasManutencaoSitPedidos;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoDeSituacoes;
import com.touchcomp.basementor.model.vo.GrupoPessoas;
import com.touchcomp.basementor.model.vo.OpcoesPCP;
import com.touchcomp.basementor.model.vo.OrdemServicoProdLinhaProd;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.RamoAtividade;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.SituacaoPedidos;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchvomodel.vo.pedido.web.auxiliar.TempManutencaoSituacaoPedidos;
import java.math.BigInteger;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.hibernate.sql.JoinType;
import org.springframework.stereotype.Repository;

@Repository
public class DaoPedidoImpl
extends DaoGenericEntityImpl<Pedido, Long> {
    public Double getValorPedidoAberto(Cliente cliente) {
        Query q = this.query(" select coalesce(sum(p.valorTotal),0) as totalPedidosAbertos from Pedido p  left join p.expedicao e where e is null  and p.unidadeFatCliente.cliente = :cliente and p.situacaoPedido.cancelarTitulos = :nao");
        q.setEntity("cliente", (Object)cliente);
        q.setShort("nao", (short)0);
        return (Double)q.uniqueResult();
    }

    public Double getValorMedioPedidos(Cliente cliente) {
        Query q = this.query(" select  avg(p.valorTotal) as VALOR_MEDIO_PEDIDO from Pedido p  inner join p.unidadeFatCliente u inner join u.cliente c inner join p.situacaoPedido s where c.identificador =:cliente and s.cancelarTitulos<>:sim");
        q.setEntity("cliente", (Object)cliente);
        q.setShort("sim", (short)1);
        q.setMaxResults(1);
        return (Double)q.uniqueResult();
    }

    public Pedido getPedidoMobile(Long idMobile, Long usuario) {
        BigInteger b = new BigInteger(String.valueOf(idMobile));
        Criteria c = this.criteria();
        c.createAlias("usuario", "usu");
        c.add((Criterion)Restrictions.eq((String)"usu.identificador", (Object)usuario));
        c.add((Criterion)Restrictions.eq((String)"idPedidoMobile", (Object)b));
        c.setMaxResults(1);
        c.addOrder(Order.desc((String)"identificador"));
        return (Pedido)c.uniqueResult();
    }

    public Double getValorGrSituacaoCliente(Long idGrSituacao, Long idCliente) {
        Query q = this.query(" select sum(p.valorTotal) as VALOR_TOTAL from Pedido p  inner join p.situacaoPedido s inner join s.grupoDeSituacoes gs inner join p.unidadeFatCliente u inner join u.cliente c inner join gs.grupoDeSituacoes g where g.identificador =:idGrSituacao and c.identificador=:idCliente");
        q.setLong("idGrSituacao", idGrSituacao.longValue());
        q.setLong("idCliente", idCliente.longValue());
        return (Double)q.uniqueResult();
    }

    public Double getValorSituacaoCliente(Long idSituacao, Long idCliente) {
        Query q = this.query(" select sum(p.valorTotal) as VALOR_TOTAL from Pedido p  inner join p.situacaoPedido s inner join p.unidadeFatCliente u inner join u.cliente c where s.identificador =:idSituacao and c.identificador=:idCliente");
        q.setLong("idSituacao", idSituacao.longValue());
        q.setLong("idCliente", idCliente.longValue());
        return (Double)q.uniqueResult();
    }

    public Double getValorGrSituacaoGrPessoas(Long idGrSituacao, Long idGrPessoas) {
        Query q = this.query(" select sum(p.valorTotal) as VALOR_TOTAL from Pedido p  inner join p.situacaoPedido s inner join s.grupoDeSituacoes gs inner join p.unidadeFatCliente u inner join u.cliente c inner join c.pessoa pes inner join pes.grupoPessoas gp inner join gs.grupoDeSituacoes g where g.identificador =:idGrSituacao and gp.identificador=:idGrPessoas");
        q.setLong("idGrSituacao", idGrSituacao.longValue());
        q.setLong("idGrPessoas", idGrPessoas.longValue());
        return (Double)q.uniqueResult();
    }

    public Double getValorSituacaoGrPessoas(Long idSituacao, Long idGrPessoas) {
        Query q = this.query(" select sum(p.valorTotal) as VALOR_TOTAL from Pedido p  inner join p.situacaoPedido s inner join p.unidadeFatCliente u inner join u.cliente c inner join c.pessoa pes inner join pes.grupoPessoas gp where s.identificador =:idSituacao and gp.identificador=:idGrPessoas");
        q.setLong("idSituacao", idSituacao.longValue());
        q.setLong("idGrPessoas", idGrPessoas.longValue());
        return (Double)q.uniqueResult();
    }

    public Double getValorPedidoAbertoGrPessoas(GrupoPessoas grupoPessoas) {
        Query q = this.query(" select coalesce(sum(p.valorTotal),0) as totalPedidosAbertos from Pedido p  left join p.expedicao e where e is null  and p.unidadeFatCliente.cliente.pessoa.grupoPessoas = :grupoPessoas and p.situacaoPedido.cancelarTitulos = :nao");
        q.setEntity("grupoPessoas", (Object)grupoPessoas);
        q.setShort("nao", (short)0);
        return (Double)q.uniqueResult();
    }

    public Pedido getBySerialForSinc(String serialForSinc) {
        if (!TMethods.isStrWithData((String)serialForSinc)) {
            serialForSinc = null;
        }
        if (serialForSinc == null) {
            return null;
        }
        return (Pedido)this.toUnique(this.restrictions(this.eq("serialForSync", serialForSinc)));
    }

    public List<Pedido> getAllPedidosPreVenda(Long idSituacaoPedido, Long idEmpresa) {
        Query q = this.query(" select p from Pedido p  where p.situacaoPedido.identificador = :idSituacao  and p.empresa.identificador = :idEmpresa ");
        q.setLong("idSituacao", idSituacaoPedido.longValue());
        q.setLong("idEmpresa", idEmpresa.longValue());
        return q.list();
    }

    public boolean updateSituacaoPedidoSerialForSync(Long idSituacao, String serialForSync) {
        Query q = this.query(" update Pedido p  set p.situacaoPedido.identificador = :idSituacao  where p.serialForSync = :serialForSync ");
        q.setString("serialForSync", serialForSync);
        q.setLong("idSituacao", idSituacao.longValue());
        int res = q.executeUpdate();
        return res > 0;
    }

    public boolean updateSituacaoPedidoIdentificador(Long idSituacao, Long idPedido) {
        Query q = this.query(" update Pedido p  set p.situacaoPedido.identificador = :idSituacao  where p.identificador = :idPedido ");
        q.setLong("idPedido", idPedido.longValue());
        q.setLong("idSituacao", idSituacao.longValue());
        int res = q.executeUpdate();
        return res > 0;
    }

    public void atualizarSitPedidoSubOSLinha(SituacaoPedidos sitOld, SituacaoPedidos sitNew, OrdemServicoProdLinhaProd ordemServicoProdLinhaProd) {
        Query q = this.query("select p.identificador from Pedido p  where exists (select s.identificador from SubdivisaoOSProdLinhaProd s inner join s.ordemServicoProdLinhaProd os inner join os.itemPlanProducaoOSLinProd i inner join i.itemPlanejamentoProducao ipp inner join ipp.gradeItemPedido gr inner join gr.gradeItemPedido.itemPedido i where i.pedido.identificador = p.identificador and os = :ordemServicoProdLinhaProd) and p.situacaoPedido =:old");
        q.setParameter("old", (Object)sitOld);
        q.setParameter("ordemServicoProdLinhaProd", (Object)ordemServicoProdLinhaProd);
        List idPedidos = q.list();
        if (ToolMethods.isNull((Object)idPedidos).booleanValue()) {
            return;
        }
        Query q2 = this.query("update Pedido p set p.situacaoPedido = :sit  where not exists (select s.identificador from SubdivisaoOSProdLinhaProd s inner join s.ordemServicoProdLinhaProd os inner join os.itemPlanProducaoOSLinProd i inner join i.itemPlanejamentoProducao ipp inner join ipp.gradeItemPedido gr inner join gr.gradeItemPedido.itemPedido i where i.pedido.identificador = p.identificador and s.dataFechamento = null) and p.identificador = :idPedido");
        for (Long idPedido : idPedidos) {
            q2.setParameter("sit", (Object)sitNew);
            q2.setParameter("idPedido", (Object)idPedido);
            q2.executeUpdate();
        }
    }

    public List<Pedido> getAllPedidosVendasFinanceiras(Long idEmpresa, Date dataInicial, Date dataFinal) {
        Query q = this.query("select distinct p  from Pedido p  inner join p.itemPedido item  inner join item.gradeItemPedido gr  where  p.empresa.identificador = :idEmpresa and p.dataEmissao between :dataInicial and :dataFinal and p.situacaoPedido.gerarFinanceiroNFCe = :sim  and p.situacaoPedido.bloqueioReservaEstoque = :sim  and gr.movimentacaoFisica = :nao");
        q.setShort("nao", (short)0);
        q.setShort("sim", (short)1);
        q.setLong("idEmpresa", idEmpresa.longValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        List ret = q.list();
        q = this.query("select distinct p  from Pedido p  inner join p.itemPedido item  inner join item.gradeItemPedido gr  where  p.empresa.identificador = :idEmpresa and p.dataEmissao between :dataInicial and :dataFinal and p.situacaoPedido.gerarFinanceiroNFCe = :sim  and p.situacaoPedido.bloqueioReservaEstoque = :nao  and p.reservarEstoque = :sim  and gr.movimentacaoFisica = :nao");
        q.setShort("nao", (short)0);
        q.setShort("sim", (short)1);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setLong("idEmpresa", idEmpresa.longValue());
        List temp = q.list();
        temp.forEach(i -> {
            if (!ret.contains(i)) {
                ret.add(i);
            }
        });
        q = this.query("select distinct p.identificador as ID_PEDIDO  from Pedido p  inner join p.itemPedido item  inner join item.gradeItemPedido gr  where  p.empresa.identificador = :idEmpresa and p.dataEmissao between :dataInicial and :dataFinal and p.situacaoPedido.gerarFinanceiroNFCe = :sim  and p.situacaoPedido.cancelarTitulos <> :sim  group by p.identificador,item.identificador,item.quantidadeTotal having sum(gr.quantidade)<> item.quantidadeTotal ");
        q.setLong("idEmpresa", idEmpresa.longValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setShort("sim", (short)1);
        List ids = q.list();
        ids.forEach(i -> {
            Optional<Pedido> found = ret.stream().filter(j -> TMethods.isEquals((Object)j.getIdentificador(), (Object)i)).findFirst();
            if (!found.isPresent()) {
                ret.add((Pedido)this.get(i));
            }
        });
        return ret;
    }

    public List<Pedido> getPedidosByIdentificador(Long idEmpresa, Long idPedido, Long idSituacaoPedido) {
        Criteria c = this.criteria();
        c.createAlias("situacaoPedido", "sit");
        c.createAlias("empresa", "emp");
        c.add(this.eq("identificador", idPedido));
        if (idSituacaoPedido != null) {
            c.add(this.eq("sit.identificador", idSituacaoPedido));
        }
        c.add(this.eq("emp.identificador", idEmpresa));
        c.addOrder(Order.desc((String)"dataEmissao"));
        return this.toList(c);
    }

    public List<Pedido> getPedidosByValor(Long idEmpresa, Double valor, Long idSituacaoPedido) {
        Criteria c = this.criteria();
        c.createAlias("situacaoPedido", "sit");
        c.createAlias("empresa", "emp");
        c.add(this.eq("valorTotal", valor));
        if (idSituacaoPedido != null) {
            c.add(this.eq("sit.identificador", idSituacaoPedido));
        }
        c.add(this.eq("emp.identificador", idEmpresa));
        c.addOrder(Order.desc((String)"dataEmissao"));
        return this.toList(c);
    }

    public List<Pedido> getPedidosByDateEmissao(Long idEmpresa, Date data, Long idSituacaoPedido) {
        Criteria c = this.criteria();
        c.createAlias("situacaoPedido", "sit");
        c.createAlias("empresa", "emp");
        c.add(this.eq("dataEmissao", data));
        if (idSituacaoPedido != null) {
            c.add(this.eq("sit.identificador", idSituacaoPedido));
        }
        c.add(this.eq("emp.identificador", idEmpresa));
        c.addOrder(Order.desc((String)"dataEmissao"));
        return this.toList(c);
    }

    public List<Pedido> getPedidossByCliente(Long idEmpresa, String aux, Long idSituacaoPedido, int maxReg) {
        Criteria c = this.criteria();
        c.createAlias("situacaoPedido", "sit");
        c.createAlias("empresa", "emp");
        c.createAlias("unidadeFatCliente", "uniFat");
        c.createAlias("uniFat.pessoa", "pes");
        c.createAlias("pes.complemento", "comp");
        c.createAlias("uniFat.cliente", "cli");
        c.createAlias("nfceConsumidor", "nfCon", JoinType.LEFT_OUTER_JOIN);
        if (ToolString.isAIntegerNumber((String)aux)) {
            Disjunction orC = (Disjunction)this.or(new Criterion[0]);
            if (aux.length() < 5) {
                orC.add(this.eq("cli.identificador", Long.valueOf(aux)));
            }
            orC.add(this.eq("cli.codigoCliente", aux));
            orC.add(this.eq("comp.cnpj", aux));
            c.add((Criterion)orC);
        } else {
            c.add(this.or(this.ilike("pes.nome", aux), this.ilike("pes.nomeFantasia", aux), this.or(this.ilike("nfCon.nome", aux))));
        }
        if (idSituacaoPedido != null) {
            c.add(this.eq("sit.identificador", idSituacaoPedido));
        }
        if (maxReg > 0) {
            c.setMaxResults(maxReg);
        }
        c.add(this.eq("emp.identificador", idEmpresa));
        c.addOrder(Order.desc((String)"dataEmissao"));
        return this.toList(c);
    }

    public List<Pedido> getPedidossByRepresentante(Long idEmpresa, String aux, Long idSituacaoPedido, int maxReg) {
        Criteria c = this.criteria();
        c.createAlias("situacaoPedido", "sit");
        c.createAlias("empresa", "emp");
        c.createAlias("representante", "rep");
        c.createAlias("rep.pessoa", "pes");
        if (ToolString.isAIntegerNumber((String)aux)) {
            c.add(this.eq("rep.identificador", Long.valueOf(aux)));
        } else {
            c.add(this.or(this.ilike("pes.nome", aux), this.ilike("pes.nomeFantasia", aux)));
        }
        if (idSituacaoPedido != null) {
            c.add(this.eq("sit.identificador", idSituacaoPedido));
        }
        c.add(this.eq("emp.identificador", idEmpresa));
        c.addOrder(Order.desc((String)"dataEmissao"));
        if (maxReg > 0) {
            c.setMaxResults(maxReg);
        }
        return this.toList(c);
    }

    public List<Pedido> getPedidossByObs(Long idEmpresa, String aux, Long idSituacaoPedido, int maxReg) {
        Criteria c = this.criteria();
        c.createAlias("situacaoPedido", "sit");
        c.createAlias("empresa", "emp");
        c.add(this.ilike("observacao", aux));
        if (idSituacaoPedido != null) {
            c.add(this.eq("sit.identificador", idSituacaoPedido));
        }
        c.add(this.eq("emp.identificador", idEmpresa));
        c.addOrder(Order.desc((String)"dataEmissao"));
        if (maxReg > 0) {
            c.setMaxResults(maxReg);
        }
        return this.toList(c);
    }

    public Pedido getPedidoEmpresaNumeroPedidoCliente(Empresa empresa, UnidadeFatCliente unidadeFatCliente, String numeroPedidoCliente) {
        Query q = this.query("select p  from Pedido p WHERE p.empresa         = :empresa AND p.unidadeFatCliente = :unidadeFatCliente AND p.nrPedidoCliente   = :numeroPedidoCliente");
        q.setEntity("empresa", (Object)empresa);
        q.setEntity("unidadeFatCliente", (Object)unidadeFatCliente);
        q.setString("numeroPedidoCliente", numeroPedidoCliente);
        q.setMaxResults(1);
        return (Pedido)q.uniqueResult();
    }

    public void atualizaSitPedido(Pedido pedido, SituacaoPedidos situacaoPedidos) {
        this.updateSituacaoPedidoIdentificador(situacaoPedidos.getIdentificador(), pedido.getIdentificador());
    }

    public List<Pedido> pesquisarHistoricoVendasUltimosPedidos(Empresa empresa, Long idPedido, UnidadeFatCliente unidadeFatCliente, Integer numeroPedidosAvaliados) {
        Object hql = "SELECT p FROM       Pedido           p INNER JOIN p.situacaoPedido s WHERE p.empresa           = :empresa AND   p.unidadeFatCliente = :unidadeFatCliente AND   s.cancelarTitulos   = :cancelado";
        if (idPedido != null && idPedido > 0L) {
            hql = (String)hql + " AND   p.identificador < :idPedido";
        }
        hql = (String)hql + " ORDER BY p.identificador DESC";
        Query q = this.query((String)hql);
        q.setEntity("empresa", (Object)empresa);
        if (idPedido != null && idPedido > 0L) {
            q.setLong("idPedido", idPedido.longValue());
        }
        q.setEntity("unidadeFatCliente", (Object)unidadeFatCliente);
        q.setShort("cancelado", EnumConstantsMentorSimNao.NAO.getValue());
        q.setMaxResults(numeroPedidosAvaliados.intValue());
        return q.list();
    }

    public SituacaoPedidos getSituacaoAtualPedido(Long idPedido) {
        Query q = this.query("select p.situacaoPedido from Pedido p where p.identificador=:idPedido");
        q.setLong("idPedido", idPedido.longValue());
        return (SituacaoPedidos)q.uniqueResult();
    }

    public double getValorPedidosEmAberto(Long idPessoa) {
        double totalErp = this.getValorPedidos(idPessoa);
        double totalNFCe = this.getValorPedidosNFCe(idPessoa);
        return totalErp + totalNFCe;
    }

    private double getValorPedidos(Long idPessoa) {
        Query q = this.query(" select coalesce(sum(p.valorTotal),0) as totalPedidosAbertos from Pedido p  left join p.expedicao e where e is null  and (p.serialForSync is null or p.serialForSync='') and p.unidadeFatCliente.cliente.pessoa.identificador = :idPessoa and p.situacaoPedido.cancelarTitulos = :nao");
        q.setLong("idPessoa", idPessoa.longValue());
        q.setShort("nao", (short)0);
        Double res = (Double)q.uniqueResult();
        return res != null ? res : 0.0;
    }

    private double getValorPedidosNFCe(Long idPessoa) {
        Query q = this.query(" select coalesce(sum(p.valorTotal),0) as totalPedidosAbertos from Pedido p  inner join NFCeOpcoes n on n.empresa = p.empresa where (n.situacaoPedidosCad = p.situacaoPedido and n.utilizarPreVenda=:sim)  and p.serialForSync is not null and p.unidadeFatCliente.cliente.pessoa.identificador = :idPessoa and p.situacaoPedido.cancelarTitulos = :nao");
        q.setParameter("idPessoa", (Object)idPessoa);
        q.setParameter("nao", (Object)EnumConstantsMentorSimNao.NAO.getValue());
        q.setParameter("sim", (Object)EnumConstantsMentorSimNao.SIM.getValue());
        Double res = (Double)q.uniqueResult();
        return res != null ? res : 0.0;
    }

    public Pedido getPedido(Empresa empresa, Long identificador) {
        return (Pedido)this.toUnique(this.restrictions(this.eq("empresa", empresa), this.eq("identificador", identificador)));
    }

    public List<TempManutencaoSituacaoPedidos> findManutencaoPed(Date dataInicial, Date dataFinal, EnumConstFiltroGrupoSituacaoRota filter, Object filterValue, Short tipoData, Empresa empresa, Representante representante, Short filtrarData, Transportador transportadorInicial, Transportador transportadorFinal, RamoAtividade ramoAtividadeInicial, RamoAtividade ramoAtividadeFinal, Long idPedidoCodBarras) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jUnidadeFatCliente = aux.join("unidadeFatCliente");
        Join jSituacaoPedido = aux.join("situacaoPedido");
        Join jCliente = jUnidadeFatCliente.join("cliente");
        Join jFaturamento = jCliente.join("faturamento");
        Join jRamoAtividade = jFaturamento.join("ramoAtividade", javax.persistence.criteria.JoinType.LEFT);
        Join jPessoa = jCliente.join("pessoa");
        Join jLiberacaoPedidoPed = aux.joinLeft("liberacaoPedidoPed");
        Join jTransportador = aux.joinLeft("transportador");
        if (ToolMethods.isEquals((Object)filter, (Object)EnumConstFiltroGrupoSituacaoRota.GRUPO_DE_SITUACAO)) {
            Join jGrupoDeSituacoes = jSituacaoPedido.join("grupoDeSituacoes");
            aux.equal((From)jGrupoDeSituacoes, "grupoDeSituacoes", (GrupoDeSituacoes)filterValue);
        } else if (ToolMethods.isEquals((Object)filter, (Object)EnumConstFiltroGrupoSituacaoRota.SITUACAO_PEDIDO)) {
            aux.equal("situacaoPedido", (SituacaoPedidos)filterValue);
        }
        aux.equal("empresa", empresa);
        aux.isNull("unificacaoPedido");
        if (TMethods.isEquals((Object)filtrarData, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            if (TMethods.isEquals((Object)tipoData, (Object)EnumConstIntervaloDatasManutencaoSitPedidos.DATA_EMISSAO.getEnumId())) {
                aux.between("dataEmissao", dataInicial, (Comparable)dataFinal);
            } else if (TMethods.isEquals((Object)tipoData, (Object)EnumConstIntervaloDatasManutencaoSitPedidos.DATA_SAIDA.getEnumId())) {
                aux.between("dataPrevisaoSaida", dataInicial, (Comparable)dataFinal);
            } else {
                aux.between("dataPrevisaoFat", dataInicial, (Comparable)dataFinal);
            }
        }
        if (representante != null) {
            aux.equal("representante", representante);
        }
        if (transportadorInicial != null && transportadorFinal != null) {
            aux.between((From)jTransportador, "identificador", transportadorInicial.getIdentificador(), (Comparable)transportadorFinal.getIdentificador());
        }
        if (ramoAtividadeInicial != null && ramoAtividadeFinal != null) {
            aux.between((From)jRamoAtividade, "identificador", ramoAtividadeInicial.getIdentificador(), (Comparable)ramoAtividadeFinal.getIdentificador());
        }
        if (!TMethods.isEquals((Object)idPedidoCodBarras, null) && !TMethods.isEquals((Object)idPedidoCodBarras, (Object)0L)) {
            aux.equal("identificador", idPedidoCodBarras);
        }
        aux.select(AuxCriteriaBuilder.pair("identificador", "ID_PEDIDO"), AuxCriteriaBuilder.pair("nrPedidoCliente", "NR_PEDIDO"), AuxCriteriaBuilder.pair((From)jCliente, "identificador", "ID_CLIENTE"), AuxCriteriaBuilder.pair((From)jPessoa, "nome", "NOME_CLIENTE"), AuxCriteriaBuilder.pair("dataPrevisaoSaida", "DATA_PREV_SAIDA"), AuxCriteriaBuilder.pair((From)jSituacaoPedido, "identificador", "ID_SITUACAO_PEDIDO"), AuxCriteriaBuilder.pair((From)jLiberacaoPedidoPed, "liberado", "LIBERADO"), AuxCriteriaBuilder.pair("dataPrevisaoFat", "DATA_PREV_FATURAMENTO"));
        List<Map<String, Object>> res = aux.getResultMap();
        LinkedList<TempManutencaoSituacaoPedidos> lista = new LinkedList<TempManutencaoSituacaoPedidos>();
        for (Map<String, Object> map : res) {
            TempManutencaoSituacaoPedidos temp = new TempManutencaoSituacaoPedidos();
            temp.setNrPedido((String)map.get("NR_PEDIDO"));
            temp.setNomeCliente((String)map.get("NOME_CLIENTE"));
            temp.setDataPrevSaida((Date)map.get("DATA_PREV_SAIDA"));
            temp.setDataPrevSaidaOld((Date)map.get("DATA_PREV_SAIDA"));
            temp.setIdentificador((Long)map.get("ID_PEDIDO"));
            temp.setIdentificadorCliente((Long)map.get("ID_CLIENTE"));
            temp.setIdentificadorSituacaoPedido((Long)map.get("ID_SITUACAO_PEDIDO"));
            temp.setLiberado((Short)map.get("LIBERADO"));
            temp.setDataPrevisaoFat((Date)map.get("DATA_PREV_FATURAMENTO"));
            lista.add(temp);
        }
        return lista;
    }

    public void atualizarSitPedidoConfOSLinhaFechada(OrdemServicoProdLinhaProd entity, OpcoesPCP opcoesPCP) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

