/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementorservice.model.genericmap.GenericMapValues;
import com.touchcomp.basementorservice.model.genericmap.impl.GenMapResumoInfoPessoa;
import java.util.List;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import org.hibernate.Criteria;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoPessoaImpl
extends DaoGenericEntityImpl<Pessoa, Long> {
    public Pessoa getByCPFCNPJ(String cpfCnpj) {
        Criteria crit = this.criteria();
        crit.createAlias("complemento", "c");
        return (Pessoa)this.toUnique(this.orderDesc(this.restrictions(crit, this.eq("c.cnpj", cpfCnpj)), "ativo"));
    }

    public Pessoa getByInscricaoEstadualUf(String inscEst, String sigla) {
        if (sigla != null) {
            sigla = sigla.toUpperCase();
        }
        Criteria crit = this.criteria();
        crit.createAlias("complemento", "c");
        crit.createAlias("endereco", "e");
        crit.createAlias("e.cidade", "ci");
        crit.createAlias("ci.uf", "uf");
        return (Pessoa)this.toUnique(this.orderDesc(this.restrictions(crit, this.eq("c.inscEst", inscEst), this.eq("uf.sigla", sigla)), "ativo"));
    }

    public Pessoa getByCPFCNPJAtiva(String cpfCnpj) {
        Criteria crit = this.criteria();
        crit.createAlias("complemento", "c");
        return (Pessoa)this.toUnique(this.restrictions(crit, this.eq("c.cnpj", cpfCnpj), this.eq("ativo", (short)1)));
    }

    public Pessoa getByCPFCNPJInativa(String cnpj) {
        Criteria crit = this.criteria();
        crit.createAlias("complemento", "c");
        return (Pessoa)this.toUnique(this.restrictions(crit, this.eq("c.cnpj", cnpj), this.eq("ativo", (short)0)));
    }

    public Pessoa get(String inscEst, String cpfCnpj) {
        Criteria crit = this.criteria();
        crit.createAlias("complemento", "comp");
        this.restrictions(crit, this.eq("comp.cnpj", cpfCnpj), this.eq("comp.inscEst", inscEst));
        return (Pessoa)this.toUnique(crit);
    }

    public GenericMapValues<GenMapResumoInfoPessoa> getEstatisticasFinanceiras(Long idPessoa) {
        Query q = this.query("select pf.diasCarenciaSaldoVenc as " + GenMapResumoInfoPessoa.DIAS_TOLERANCIA_SALDO_VENC.getValue() + " ,f.habilParaCompra as " + GenMapResumoInfoPessoa.HABILITAR_COMPRAS.getValue() + " ,f.limiteCredito as " + GenMapResumoInfoPessoa.LIMITE_CREDITO_PEDIDO.getValue() + " ,f.limiteCreditoFinanceiro as " + GenMapResumoInfoPessoa.LIMITE_CREDITO_FINANCEIRO.getValue() + " ,f.dataLiberacaoCredito as " + GenMapResumoInfoPessoa.DATA_LIBERACAO_LIMITE.getValue() + " ,f.diasVigorLimiteCred as " + GenMapResumoInfoPessoa.DIAS_LIBERACAO_LIMITE.getValue() + " ,f.naoAvaliarFinanceiro as " + GenMapResumoInfoPessoa.NAO_AVALIAR_FINANCEIRO.getValue() + " from Pessoa p left join p.pessoaDadosFinanceiros pf left join Cliente c on(c.pessoa = p) left join c.financeiro f where p.identificador = :idPessoa");
        q.setLong("idPessoa", idPessoa.longValue());
        return this.toGenMap(q, GenMapResumoInfoPessoa.class);
    }

    public List<Pessoa> getListCPFCNPJAtiva(String cpfCnpj) {
        Criteria crit = this.criteria();
        crit.createAlias("complemento", "c");
        return this.toList(this.restrictions(crit, this.eq("c.cnpj", cpfCnpj), this.eq("ativo", (short)1)));
    }

    public Pessoa getByCnpjInscricaoEstadualAtiva(String cnpjCpf, String ie) {
        Criteria crit = this.criteria();
        crit.createAlias("complemento", "c");
        return (Pessoa)this.toUnique(this.restrictions(crit, this.eq("c.cnpj", cnpjCpf), this.eq("c.inscEst", ie), this.eq("ativo", (short)1)));
    }

    public List<String> getCnpjPessoasAtivos() {
        AuxCriteriaBuilder builder = this.queryBuilder();
        Join jComplemento = builder.join("complemento");
        builder.equal("ativo", (short)1);
        builder.select((From)jComplemento, "cnpj");
        return builder.getResult();
    }
}

