/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.CelulaProdutiva;
import com.touchcomp.basementor.model.vo.DiaPlanejTempoTrabalhoPCP;
import com.touchcomp.basementor.model.vo.PlanejTempoTrabalhoPCP;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import java.util.Date;
import java.util.List;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import org.springframework.stereotype.Repository;

@Repository
public class DaoPlanejTempoTrabalhoPCPImpl
extends DaoGenericEntityImpl<PlanejTempoTrabalhoPCP, Long> {
    public List<DiaPlanejTempoTrabalhoPCP> getDiasTrabalhoPlanejados(CelulaProdutiva celula, Date dataInicial, Date dataFinal) {
        AuxCriteriaBuilder aux = this.queryBuilder(DiaPlanejTempoTrabalhoPCP.class);
        Join jPlanejamento = aux.join("planejTempoTrabalhoPCP");
        Join jCelulas = jPlanejamento.join("celulasProdutivas");
        Join jCelula = jCelulas.join("celulaProdutiva");
        aux.equal((From)jCelula, "identificador", celula.getIdentificador());
        aux.between("dia", dataInicial, (Comparable)dataFinal);
        return aux.getResultEnt();
    }

    public List<DiaPlanejTempoTrabalhoPCP> getDiasTrabalhoPlanejados(Long idEquipamento, Date dataInicial, Date dataFinal) {
        AuxCriteriaBuilder aux = this.queryBuilder(DiaPlanejTempoTrabalhoPCP.class);
        Join jPlanejamento = aux.join("planejTempoTrabalhoPCP");
        Join jCelulas = jPlanejamento.join("celulasProdutivas");
        Join jCelula = jCelulas.join("celulaProdutiva");
        Join jCelulaEquipamento = jCelula.join("equipamentos");
        Join jEquipamento = jCelulaEquipamento.join("equipamento");
        aux.equal((From)jEquipamento, "identificador", idEquipamento);
        aux.between("dia", dataInicial, (Comparable)dataFinal);
        return aux.getResultEnt();
    }
}

