/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.IntervaloControleGer;
import com.touchcomp.basementor.model.vo.IntervaloControleGerPer;
import com.touchcomp.basementor.model.vo.PlanejamentoOrcamentario;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import org.hibernate.Criteria;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoPlanejamentoOrcamentarioImpl
extends DaoGenericEntityImpl<PlanejamentoOrcamentario, Long> {
    public Double getValorOrcado(IntervaloControleGerPer intervaloControleGerPer, PlanoContaGerencial pc) {
        Query q = this.query("select sum(per.valorOrcado) from PlanejamentoOrcamentario p inner join p.itens i inner join i.periodos per where i.planoContaGerencial = :pc and per.intervaloControleGerPer=:intervalo");
        q.setEntity("intervalo", (Object)intervaloControleGerPer);
        q.setEntity("pc", (Object)pc);
        Double ret = (Double)q.uniqueResult();
        return ret != null ? ret : 0.0;
    }

    public Double getValorOrcado(IntervaloControleGerPer intervaloControleGerPer, PlanoContaGerencial pc, CentroCusto cc) {
        Query q = this.query("select sum(per.valorOrcado) from PlanejamentoOrcamentario p inner join p.itens i inner join i.periodos per where i.planoContaGerencial = :pc and i.centroCusto=:cc and per.intervaloControleGerPer=:intervalo");
        q.setEntity("intervalo", (Object)intervaloControleGerPer);
        q.setEntity("pc", (Object)pc);
        q.setEntity("cc", (Object)cc);
        Double ret = (Double)q.uniqueResult();
        return ret != null ? ret : 0.0;
    }

    public Long validarInconsistenciasAltIntervalo(IntervaloControleGer intervaloControleGer) {
        Query q = this.query("select count(p.identificador) from PlanejamentoOrcamentario p inner join p.intervalorControleGer inter where inter = :intervalo and p.dataAtualizacao<inter.dataAtualizacao");
        q.setEntity("intervalo", (Object)intervaloControleGer);
        Long ret = (Long)q.uniqueResult();
        return ret != null ? ret : 0L;
    }

    public Long validarInconsistenciasAltPacote(IntervaloControleGer intervaloControleGer) {
        Query q = this.query("select count(p.identificador) from PlanejamentoOrcamentario p inner join p.pacoteOrcamentario pac inner join p.intervalorControleGer inter where inter = :intervalo and p.dataAtualizacao<pac.dataAtualizacao");
        q.setEntity("intervalo", (Object)intervaloControleGer);
        Long ret = (Long)q.uniqueResult();
        return ret != null ? ret : 0L;
    }

    public PlanejamentoOrcamentario getByPacoteOrcamentario(Long idPacoteOrcamentario, Long intervalo) {
        Criteria crit = this.criteria();
        crit.createAlias("pacoteOrcamentario", "p");
        crit.createAlias("intervalorControleGer", "icg");
        crit.createAlias("icg.intervalos", "i");
        return (PlanejamentoOrcamentario)this.toUnique(this.restrictions(crit, this.eq("p.identificador", idPacoteOrcamentario), this.eq("i.identificador", intervalo)));
    }
}

