/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstSinteticoAnalitico;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.query.NativeQuery;
import org.springframework.stereotype.Repository;

@Repository
public class DaoPlanoContaImpl
extends DaoGenericEntityImpl<PlanoConta, Long> {
    public PlanoConta findByCodigo(String codigo) {
        return (PlanoConta)this.toUnique(this.restrictions(this.criteria(), this.eq("codigo", codigo)));
    }

    public String findNextReduzida(String codigoPlanoConta) {
        org.hibernate.query.Query q = this.query("select max(P.reduzida) from PlanoConta P");
        Object obj = q.uniqueResult();
        if (obj == null) {
            return "00001";
        }
        return String.valueOf(obj.toString());
    }

    public String findNextSequencial(String grupo) {
        if (grupo == null) {
            return "00001";
        }
        String cod1 = grupo.substring(0, 5);
        org.hibernate.query.Query q = this.query("select max(P.codigo) from PlanoConta P where P.codigo like :codigo");
        q.setParameter("codigo", (Object)(cod1 + "%"));
        Object obj = q.uniqueResult();
        return obj != null ? obj.toString() : cod1 + "00000";
    }

    public String getNextCodigoConta(String codigoPlanoConta) {
        Long codigo1 = Long.valueOf(codigoPlanoConta);
        Long codigo2 = Long.valueOf(codigoPlanoConta.substring(0, 5) + "99999");
        String hql = "select max(cast(pc.codigo as numeric(10,0))+1) from plano_conta pc where cast(pc.codigo as numeric(10,0)) between :codigo1 and :codigo2";
        NativeQuery q = this.sqlQuery(hql);
        q.setLong("codigo1", codigo1.longValue());
        q.setLong("codigo2", codigo2.longValue());
        Number ret = (Number)q.uniqueResult();
        return String.valueOf(ret.longValue());
    }

    public List<PlanoConta> findContasAnaliticaResultado() {
        String hql = "from PlanoConta p where p.naturezaOperacaoPC.codigo=:resultado";
        org.hibernate.query.Query q = this.query(hql);
        q.setString("resultado", "04");
        return this.toList((Query)q);
    }

    public List<PlanoConta> findContasSinteticasNivel1() {
        return this.toList(this.order(this.restrictions(this.eq("marca", EnumConstSinteticoAnalitico.SINTETICO.getValueInt()), this.likeLeft("codigo", "000000000")), "codigo"));
    }

    public List<PlanoConta> findContasSinteticasNivel2(String start) {
        return this.toList(this.order(this.restrictions(this.eq("marca", EnumConstSinteticoAnalitico.SINTETICO.getValueInt()), this.notEqual("codigo", start + "000000000"), this.likeLeft("codigo", "00000000"), this.likeRight("codigo", start)), "codigo"));
    }

    public List<PlanoConta> findContasSinteticasNivel3(String start) {
        return this.toList(this.order(this.restrictions(this.eq("marca", EnumConstSinteticoAnalitico.SINTETICO.getValueInt()), this.notEqual("codigo", start + "00000000"), this.likeLeft("codigo", "0000000"), this.likeRight("codigo", start)), "codigo"));
    }

    public List<PlanoConta> findContasSinteticasNivel4(String start) {
        return this.toList(this.order(this.restrictions(this.eq("marca", EnumConstSinteticoAnalitico.SINTETICO.getValueInt()), this.notEqual("codigo", start + "0000000"), this.likeLeft("codigo", "00000"), this.likeRight("codigo", start)), "codigo"));
    }

    public List<PlanoConta> findContasSinteticasNivel5(String start) {
        return this.toList(this.order(this.restrictions(this.eq("marca", EnumConstSinteticoAnalitico.SINTETICO.getValueInt()), this.notEqual("codigo", start + "00000"), this.likeLeft("codigo", "00000"), this.likeRight("codigo", start)), "codigo"));
    }

    public List<PlanoConta> findContasAnaliticasGrupo(String codigo) {
        return this.toList(this.order(this.restrictions(this.eq("marca", EnumConstSinteticoAnalitico.ANALITICO.getValueInt()), this.ilikeRight("codigo", codigo)), "codigo"));
    }

    public List<PlanoConta> findContasReduzidas(String reduzida) {
        return this.toList(this.restrictions(this.eq("reduzida", reduzida)));
    }
}

