/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.PreEventoOsLinhaProducao;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.Criteria;
import org.hibernate.criterion.Order;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoPreEventoOsLinhaProducaoImpl
extends DaoGenericEntityImpl<PreEventoOsLinhaProducao, Long> {
    public PreEventoOsLinhaProducao getUltimoPreEventoColaborador(Colaborador colaborador) {
        Criteria crit = this.criteria();
        crit.addOrder(Order.desc((String)"identificador"));
        crit.setMaxResults(1);
        return (PreEventoOsLinhaProducao)this.toUnique(this.restrictions(crit, this.eq("colaborador", colaborador)));
    }

    public List getPreEventoNaoApontado(Date dataProcessamento, CentroCusto centroCusto, Empresa empresa, Produto produto) {
        Integer filtrarCC = 1;
        if (centroCusto == null) {
            filtrarCC = 0;
        }
        Query q = this.query("SELECT distinct p  FROM PreEventoOsLinhaProducao p  WHERE p.apontado = :nao  AND CAST(p.dataEvento AS date)  = :dataProcessamento  AND (:filtrarCC = 0 OR p.centroCusto = :centroCusto) AND (:filtrarProd= 0 OR p.produto.identificador = :idProduto) AND p.empresa = :empresa");
        q.setParameter("centroCusto", (Object)centroCusto);
        q.setShort("nao", (short)0);
        q.setInteger("filtrarCC", filtrarCC.intValue());
        q.setParameter("empresa", (Object)empresa);
        q.setParameter("idProduto", (Object)(produto != null ? produto.getIdentificador() : 0L));
        q.setParameter("filtrarProd", (Object)(produto != null ? 1 : 0));
        q.setDate("dataProcessamento", dataProcessamento);
        return q.list();
    }

    public PreEventoOsLinhaProducao getPreEventoOsLinhaProducaoByCodigoBarras(String codigoBarras) {
        CriteriaBuilder builder = this.criteriaBuilder(PreEventoOsLinhaProducao.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root fromPreEventoOsLinhaProducao = crit.from(PreEventoOsLinhaProducao.class);
        crit.select((Selection)fromPreEventoOsLinhaProducao);
        exps.add(builder.equal((Expression)fromPreEventoOsLinhaProducao.get("codigoBarras"), (Object)codigoBarras));
        crit.where(exps.toArray(new Predicate[0]));
        return (PreEventoOsLinhaProducao)this.getEntityManager().createQuery(crit).getSingleResult();
    }
}

