/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.entsaida.EnumConstEntSaida;
import com.touchcomp.basementor.constants.enums.receitaagronomica.EnumConstProvedorRecAgro;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.ParamCodAuxProduto;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.SubEspecie;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementorservice.service.impl.produto.DTOProdutoInfoColetorEstoque;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.TString;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchvomodel.res.DTOEntidadeCodigoRes;
import com.touchcomp.touchvomodel.res.DTOProdutoRes;
import com.touchcomp.touchvomodel.temp.informacoescomerciais.DTOInfoComercialProdutoSug;
import com.touchcomp.touchvomodel.vo.fabricante.DTOFabricanteRes;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.NoResultException;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.NativeQuery;
import org.hibernate.sql.JoinType;
import org.springframework.stereotype.Repository;

@Repository
public class DaoProdutoImpl
extends DaoGenericEntityImpl<Produto, Long> {
    public Map<String, Object> getDadosProdutoPontoEstoque(Long idProduto) {
        String query = "select p.pontoRessupEstoque as PONTO_RESSUPRIMENTO, p.qtdMin as QTD_MIN, p.qtdMax as QTD_MAX  from Produto p  where p.identificador = :idProduto";
        org.hibernate.query.Query q = this.query(query);
        q.setLong("idProduto", idProduto.longValue());
        return this.toHashUnique((Query)q);
    }

    public Produto getByCodigoAuxiliar(String codAux) {
        return (Produto)this.toUnique(this.restrictions(this.eq("codigoAuxiliar", codAux)));
    }

    public Produto getByCodSincronizacao(String codSincronizacao) {
        return (Produto)this.toUnique(this.restrictions(this.eq("codSincronizacao", codSincronizacao)));
    }

    public Produto getByCodigoBarras(String codigo) {
        Criteria crit = this.criteria();
        crit.createAlias("codigoBarras", "cod");
        return (Produto)this.toUnique(this.restrictions(crit, this.eq("cod.codigoBarras", codigo), this.eq("ativo", (short)1)));
    }

    public List<Produto> getListByCodigoBarras(String codigo) {
        Criteria crit = this.criteria();
        crit.createAlias("codigoBarras", "cod");
        return this.toList(this.restrictions(crit, this.eq("cod.codigoBarras", codigo), this.eq("ativo", (short)1)));
    }

    public List<Produto> getByCodSincronizacao(String codSincronizacao, EnumConstProvedorRecAgro enumConstProvedorRecAgro) {
        return this.toList(this.restrictions(this.eq("codSincronizacao", codSincronizacao), this.eq("codProvServicoRec", enumConstProvedorRecAgro.getValue())));
    }

    public List<Produto> getAllCodSincronizacao(EnumConstProvedorRecAgro enumConstProvedorRecAgro) {
        return this.toList(this.restrictions(this.eq("codProvServicoRec", enumConstProvedorRecAgro.getValue())));
    }

    public Produto getByIdentificadorCastLong(Long idProd) {
        String query = "from Produto p  where cast (p.identificador as long) = :idProduto";
        org.hibernate.query.Query q = this.query(query);
        q.setLong("idProduto", idProd.longValue());
        return (Produto)this.toUnique((Query)q);
    }

    public List<Produto> getProdutosAltCriadas(Date lastDateSync, Long idGrupoProdutos) {
        String query = "select distinct p from Produto p inner join p.gradesProduto pg inner join pg.gradesCores gc";
        String exists = " where exists( select ii from ItemGradeFormulaProduto ii  inner join ii.gradeFormulaProduto gf where (ii.gradeCor = gc or gf.gradeCor=gc)) and p.dataAtualizacao>=:data_atualizacao";
        org.hibernate.query.Query q = this.query(query + exists);
        q.setDate("data_atualizacao", lastDateSync);
        return q.list();
    }

    public List<DTOProdutoRes> getProdutos(String strTyped, Short usarId, Short usarCodAux, boolean useIlike) {
        Criteria c = this.criteria();
        c.createAlias("unidadeMedida", "u");
        c.add(this.eq("ativo", (short)1));
        Disjunction d1 = Restrictions.disjunction();
        Disjunction d2 = Restrictions.disjunction();
        if (ToolMethods.isAffirmative((Number)usarId) && ToolString.stringIsANumberInteger((String)strTyped).booleanValue() && strTyped.length() < 10) {
            d1.add(this.eq("identificador", Long.valueOf(strTyped)));
        } else if (useIlike) {
            d2.add(this.ilike("nome", strTyped));
        } else {
            d2.add(this.likeRight("nome", strTyped));
        }
        if (ToolMethods.isAffirmative((Number)usarCodAux) && strTyped.length() < 60) {
            d1.add(this.eq("codigoAuxiliar", strTyped));
            d2.add(this.eq("codigoAuxiliar", strTyped));
        }
        c.add((Criterion)d1);
        c.add((Criterion)d2);
        ProjectionList fields = Projections.projectionList();
        fields.add((Projection)Projections.property((String)"identificador"));
        fields.add((Projection)Projections.property((String)"nome"));
        fields.add((Projection)Projections.property((String)"codigoAuxiliar"));
        fields.add((Projection)Projections.property((String)"u.sigla"));
        c.setProjection((Projection)fields);
        List res = c.list();
        return this.buildResp(res);
    }

    private List<DTOProdutoRes> buildResp(List<Object[]> res) {
        LinkedList<DTOProdutoRes> ret = new LinkedList<DTOProdutoRes>();
        res.forEach(i -> {
            DTOProdutoRes a = new DTOProdutoRes();
            Long id = (Long)i[0];
            String nome = (String)i[1];
            String codAuxiliar = (String)i[2];
            String sigla = (String)i[3];
            Long idFabricante = (Long)i[4];
            String fabricante = (String)i[5];
            Long ncmIdentificador = (Long)i[6];
            String ncmCodigo = (String)i[7];
            String ncm = (String)i[8];
            a.setIdentificador(id);
            a.setNome(nome);
            a.setCodigoAuxiliar(codAuxiliar);
            a.setUnidadeMedidaSigla(sigla);
            a.setFabricante(new DTOFabricanteRes());
            a.getFabricante().setIdentificador(idFabricante);
            a.getFabricante().setNome(fabricante);
            a.setNcm(new DTOEntidadeCodigoRes());
            a.getNcm().setCodigo(ncmCodigo);
            a.getNcm().setIdentificador(ncmIdentificador);
            a.getNcm().setDescricao(ncm);
            ret.add(a);
        });
        return ret;
    }

    public List<Produto> getByCodSincronizacaoLike(String codSincronizacao) {
        return this.toList(this.restrictions(this.like("codSincronizacao", codSincronizacao)));
    }

    public List<DTOProdutoRes> getProdutos(String text, EnumConstEntSaida entSai) {
        Criteria c = this.criteria();
        c.createAlias("unidadeMedida", "u");
        c.createAlias("ncm", "n", JoinType.LEFT_OUTER_JOIN);
        c.createAlias("fabricante", "f", JoinType.LEFT_OUTER_JOIN);
        c.createAlias("codigoBarras", "c", JoinType.LEFT_OUTER_JOIN);
        c.add(this.eq("ativo", EnumConstantsMentorSimNao.SIM.getValue()));
        if (entSai != null) {
            c.add(this.eq("entradaSaida", entSai.getValue()));
        }
        Disjunction disjunction = Restrictions.disjunction();
        if (TString.isALongNumber((String)text)) {
            disjunction.add(this.eq("c.codigoBarras", text));
            disjunction.add(this.eq("identificador", Long.valueOf(text)));
        } else if (TString.isAIntegerNumber((String)text)) {
            disjunction.add(this.eq("c.codigoBarras", text));
        }
        disjunction.add(this.eq("codigoAuxiliar", text));
        if (text.startsWith(" ")) {
            disjunction.add(this.ilike("nome", text));
        } else {
            disjunction.add(this.ilikeRight("nome", text));
        }
        c.add((Criterion)disjunction);
        ProjectionList fields = Projections.projectionList();
        fields.add(Projections.distinct((Projection)Projections.property((String)"identificador")));
        fields.add((Projection)Projections.property((String)"nome"));
        fields.add((Projection)Projections.property((String)"codigoAuxiliar"));
        fields.add((Projection)Projections.property((String)"u.sigla"));
        fields.add((Projection)Projections.property((String)"f.identificador"));
        fields.add((Projection)Projections.property((String)"f.nome"));
        fields.add((Projection)Projections.property((String)"n.identificador"));
        fields.add((Projection)Projections.property((String)"n.codigo"));
        fields.add((Projection)Projections.property((String)"n.descricao"));
        c.setProjection((Projection)fields);
        List res = c.list();
        return this.buildResp(res);
    }

    public List<Produto> getByIdentificadorProdutoAndCodigoAuxiliar(Long idProd, String codAux) {
        String query = "from Produto p  where p.identificador = :idProduto OR (p.codigoAuxiliar = :codAuxiliar)";
        org.hibernate.query.Query q = this.query(query);
        q.setLong("idProduto", idProd.longValue());
        q.setString("codAuxiliar", codAux);
        return q.list();
    }

    public DTOProdutoInfoColetorEstoque getInfoProdGradeLoteFabColetor(String informacoesProd, Long idGradeCor, Long idLoteFab, Short usarIdProd, Short usaCodAux) {
        CriteriaBuilder builder = this.criteriaBuilder(this.getEntityClass());
        CriteriaQuery crit = builder.createQuery();
        Root fromProd = crit.from(Produto.class);
        Join jUn = fromProd.join("unidadeMedida", javax.persistence.criteria.JoinType.INNER);
        Join jProdGrade = fromProd.join("gradesProduto", javax.persistence.criteria.JoinType.INNER);
        Join jProdGradeGrade = jProdGrade.join("gradesCores", javax.persistence.criteria.JoinType.INNER);
        Join jProdGradeCor = jProdGradeGrade.join("cor", javax.persistence.criteria.JoinType.INNER);
        Root fromLote = crit.from(LoteFabricacao.class);
        Join jLoteProd = fromLote.join("produto");
        crit.multiselect(new Selection[]{fromProd.get("identificador"), fromProd.get("codigoAuxiliar"), fromProd.get("nome"), jUn.get("sigla"), jProdGradeGrade.get("identificador"), jProdGradeCor.get("nome"), fromLote.get("identificador"), fromLote.get("dataFabricacao"), fromLote.get("dataValidade"), fromLote.get("loteFabricacao")});
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        LinkedList<Predicate> expsProd = new LinkedList<Predicate>();
        exps.add(builder.equal((Expression)fromProd.get("identificador"), (Expression)jLoteProd.get("identificador")));
        if (TMethods.isWithData((Number)idGradeCor)) {
            expsProd.add(builder.equal((Expression)jProdGradeGrade.get("identificador"), (Object)idGradeCor));
        }
        if (TMethods.isWithData((Number)idLoteFab)) {
            expsProd.add(builder.equal((Expression)fromLote.get("identificador"), (Object)idLoteFab));
        }
        if (ToolMethods.isAffirmative((Number)usaCodAux) && informacoesProd.length() < 50) {
            expsProd.add(builder.equal((Expression)fromProd.get("codigoAuxiliar"), (Object)informacoesProd));
        }
        if (informacoesProd.length() >= 7 && informacoesProd.length() <= 25) {
            Join jCod = fromProd.join("codigoBarras", javax.persistence.criteria.JoinType.INNER);
            exps.add(builder.equal((Expression)jCod.get("codigoBarras"), (Object)informacoesProd));
        } else if (ToolMethods.isAffirmative((Number)usarIdProd) && TString.isAIntegerNumber((String)informacoesProd)) {
            expsProd.add(builder.equal((Expression)fromProd.get("identificador"), (Object)Long.valueOf(informacoesProd)));
        }
        crit.where(exps.toArray(new Predicate[0]));
        List data = this.getEntityManager().createQuery(crit).setMaxResults(1).getResultList();
        if (!TMethods.isWithData((Collection)data)) {
            return null;
        }
        Object[] aux = (Object[])data.get(0);
        DTOProdutoInfoColetorEstoque ret = new DTOProdutoInfoColetorEstoque();
        ret.setProdutoIdentificador((Long)aux[0]);
        ret.setProdutoCodigoAuxiliar((String)aux[1]);
        ret.setProdutoNome((String)aux[2]);
        ret.setProdutoUnidadeMedida((String)aux[3]);
        ret.setGradeCorIdentificador((Long)aux[4]);
        ret.setGradeCorDescricao((String)aux[5]);
        ret.setLoteFabricacaoIdentificador((Long)aux[6]);
        ret.setLoteFabricacaoDataFabricacao((Date)aux[7]);
        ret.setLoteFabricacaoDataValidade((Date)aux[8]);
        ret.setLoteFabricacaoLote((String)aux[9]);
        return ret;
    }

    public String getMaxSeqCodAuxiliarProd(String prefixo, String sufixo, Integer qtdeCasas, ParamCodAuxProduto p) {
        String query = "select cast(max(cast(substring(p.codigo_auxiliar from " + (prefixo.length() + 1) + " for " + qtdeCasas + " ) as integer)) as varchar(100))  from Produto p  inner join PARAM_COD_AUX_PROD PP on PP.ID_PARAM_COD_AUX_PROD = p.ID_PARAM_COD_AUX_PROD where upper(p.codigo_auxiliar) like upper(:prefixo) and upper(p.codigo_auxiliar) like upper(:sufixo) and pp.ID_PARAM_COD_AUX_PROD = :idParam ";
        NativeQuery q = this.sqlQuery(query);
        q.setParameter("prefixo", (Object)(prefixo + "%"));
        q.setParameter("sufixo", (Object)("%" + sufixo));
        q.setParameter("idParam", (Object)p.getIdentificador());
        try {
            return (String)q.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public String getMaxSeqCodAuxiliarProd(String prefixo, String sufixo, Integer qtdeCasas) {
        String query = "select max(substring(p.codigo_auxiliar from " + (prefixo.length() + 1) + " for " + qtdeCasas + " )) from Produto p  where upper(p.codigo_auxiliar) like upper(:prefixo) and upper(p.codigo_auxiliar) like upper(:sufixo)";
        NativeQuery q = this.sqlQuery(query);
        q.setParameter("prefixo", (Object)(prefixo + "%"));
        q.setParameter("sufixo", (Object)("%" + sufixo));
        try {
            return (String)q.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public void limparCodAuxProdutos() {
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        CriteriaUpdate update = cb.createCriteriaUpdate(Produto.class);
        Root e = update.from(Produto.class);
        update.set("codigoAuxiliar", null);
        update.where((Expression)cb.equal((Expression)e.get("ativo"), (Object)1));
        this.getEntityManager().createQuery(update).executeUpdate();
    }

    @Override
    public List<Produto> get(SubEspecie sub) {
        return this.toList(this.restrictions(this.eq("subEspecie", sub), this.eq("ativo", (short)1)));
    }

    public List<DTOInfoComercialProdutoSug> getProdutosSugeridos(List<Long> ids) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join unid = aux.join("unidadeMedida");
        aux.select("identificador", "nome", "codigoAuxiliar");
        aux.select((From)unid, "sigla");
        aux.inNumber("identificador", ids);
        List data = aux.getResult();
        LinkedList<DTOInfoComercialProdutoSug> ret = new LinkedList<DTOInfoComercialProdutoSug>();
        for (Object[] ob : data) {
            DTOInfoComercialProdutoSug d = new DTOInfoComercialProdutoSug();
            d.setIdentificador((Long)ob[0]);
            d.setNome((String)ob[1]);
            d.setCodigoAuxiliar((String)ob[2]);
            d.setUnidadeMedidaSigla((String)ob[3]);
            ret.add(d);
        }
        return ret;
    }

    public List<String> getCodigosAuxProdSalvos() {
        AuxCriteriaBuilder aux = this.queryBuilder();
        aux.select("codigoAuxiliar");
        return aux.getResult();
    }
}

