/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.ProdutosSimilares;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.CriteriaSpecification;
import org.springframework.stereotype.Repository;

@Repository
public class DaoProdutosSimilaresImpl
extends DaoGenericEntityImpl<ProdutosSimilares, Long> {
    public List<ProdutosSimilares> get(Produto prod, Empresa empresa) {
        return this.toList(this.getCriteriaPesqProd(prod, empresa));
    }

    public ProdutosSimilares getOne(Produto prod, Empresa empresa) {
        return (ProdutosSimilares)this.toUnique(this.getCriteriaPesqProd(prod, empresa));
    }

    private Criteria getCriteriaPesqProd(Produto prod, Empresa empresa) {
        Criteria c = this.criteria();
        c.createAlias("produtosSimilaresItens", "prod");
        c.createAlias("produtosSimilaresEmp", "pEmp");
        this.restrictions(c, this.eq("prod.produto", prod), this.eq("pEmp.empresa", empresa));
        c.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return c;
    }
}

