/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoParamFolha;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ProvisaoDec;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Repository;

@Repository
public class DaoProvisaoDecImpl
extends DaoGenericEntityImpl<ProvisaoDec, Long> {
    public List<Colaborador> findColaboradoresProvisaoDecCentroCusto(Date dataInicial, Date dataFinal, Empresa empresaFiltrada) {
        Query q = this.query(" SELECT c      From Colaborador c      INNER JOIN c.tipoColaborador tc      WHERE      c.ativo = 1      and     (tc.identificador = 0      and     c.dataAdmissao <= :dataFinal )      and     c.dataDemissao is null or c.dataDemissao > :dataFinal       and      not exists ( SELECT af.colaborador                  From AfastamentoColaborador af                  INNER JOIN af.afastamentoSefip afs                  WHERE                  af.colaborador = c                  and                   afs.codigo != :cod1                  and                   afs.codigo != :cod2                  and                   afs.codigo != :cod3                  and                 (af.dataRetorno is null or af.dataRetorno > :dataFinal)                  and                  af.dataAfastamento < :dataInicial )  and  c.empresa = :grupoEmpresa ");
        q.setDate("dataInicial", dataInicial);
        q.setString("cod1", "Z1");
        q.setString("cod2", "Q1");
        q.setString("cod3", "U1");
        q.setEntity("grupoEmpresa", (Object)empresaFiltrada);
        q.setDate("dataFinal", dataFinal);
        List colaboradores = q.list();
        return colaboradores;
    }

    public List<Colaborador> findColaboradoresProvisaoDec(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        Query q = this.query(" SELECT c      From Colaborador c      INNER JOIN c.tipoColaborador tc      INNER JOIN c.empresa e      INNER JOIN e.empresaDados ed      WHERE      c.ativo = 1      and     (tc.identificador = 0      and     c.dataAdmissao <= :dataFinal )      and     c.dataDemissao is null or c.dataDemissao > :dataFinal       and      not exists ( SELECT af.colaborador                  From AfastamentoColaborador af                  INNER JOIN af.afastamentoSefip afs                  WHERE                  af.colaborador = c                  and                   afs.codigo != :cod1                  and                   afs.codigo != :cod2                  and                   afs.codigo != :cod3                  and                 (af.dataRetorno is null or af.dataRetorno > :dataFinal)                  and                  af.dataAfastamento < :dataInicial )  and  ed.grupoEmpresa = :grupoEmpresa ");
        q.setDate("dataInicial", dataInicial);
        q.setString("cod1", "Z1");
        q.setString("cod2", "Q1");
        q.setString("cod3", "U1");
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setDate("dataFinal", dataFinal);
        List colaboradores = q.list();
        return colaboradores;
    }

    public List afastamentoColaborador(Colaborador colaborador, Date dataProvisao) {
        List ret = new ArrayList();
        Integer ano = ToolDate.yearFromDate((Object)dataProvisao);
        Query q = this.query(" SELECT af.dataAfastamento as DATA_AFASTAMENTO      FROM AfastamentoColaborador af      INNER JOIN af.afastamentoSefip afs     WHERE      af.colaborador = :colaborador      and      extract(year from af.dataAfastamento) = :ano      and      af.dataAfastamento < :dataProvisao      and      (af.dataRetorno is null or af.dataRetorno > :dataProvisao)      and     afs.codigo != :cod1 and afs.codigo != :cod3 ");
        q.setInteger("ano", ano.intValue());
        q.setDate("dataProvisao", dataProvisao);
        q.setEntity("colaborador", (Object)colaborador);
        q.setString("cod1", "Q1");
        q.setString("cod3", "U1");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        ret = q.list();
        if (ret != null && !ret.isEmpty()) {
            for (Object obj : ret) {
                HashMap retorno = (HashMap)obj;
                retorno.put("TIPO_AFASTAMENTO", "SAIDA_ANO_SEM_RETORNO");
            }
            return ret;
        }
        q = this.query(" SELECT af.dataAfastamento as DATA_AFASTAMENTO, af.dataRetorno as DATA_RETORNO  FROM AfastamentoColaborador af  INNER JOIN af.afastamentoSefip afs WHERE  af.colaborador = :colaborador  and extract(year from af.dataAfastamento) = :ano  and af.dataAfastamento < :dataProvisao  and af.dataRetorno < :dataProvisao  and afs.codigo != :cod1 and afs.codigo != :cod3");
        q.setInteger("ano", ano.intValue());
        q.setDate("dataProvisao", dataProvisao);
        q.setEntity("colaborador", (Object)colaborador);
        q.setString("cod1", "Q1");
        q.setString("cod3", "U1");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        ret = q.list();
        if (ret != null && !ret.isEmpty()) {
            for (Object obj : ret) {
                HashMap retorno = (HashMap)obj;
                retorno.put("TIPO_AFASTAMENTO", "SAIDA_ANO_COM_RETORNO");
            }
            return ret;
        }
        q = this.query(" SELECT af.dataRetorno as DATA_RETORNO  FROM AfastamentoColaborador af INNER JOIN af.afastamentoSefip afs  WHERE  af.colaborador = :colaborador  and  extract(year from af.dataAfastamento) < :ano  and  extract(year from af.dataRetorno) = :ano  and  af.dataRetorno < :dataProvisao  and  afs.codigo != :cod1 and afs.codigo != :cod3 ");
        q.setEntity("colaborador", (Object)colaborador);
        q.setString("cod1", "Q1");
        q.setString("cod3", "U1");
        q.setDate("dataProvisao", dataProvisao);
        q.setInteger("ano", ano.intValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        ret = q.list();
        if (ret != null && !ret.isEmpty()) {
            for (Object obj : ret) {
                HashMap retorno = (HashMap)obj;
                retorno.put("TIPO_AFASTAMENTO", "SAIDA_ANO_ANTERIOR_COM_RETORNO");
            }
            return ret;
        }
        return null;
    }

    public Double vlrMediaProvDecimoTerceiro(Colaborador colaborador, Date dataInicial) {
        Query q = this.query(" SELECT      coalesce(sum(item.valor),0) as VALOR      FROM ItemMovimentoFolha item      INNER JOIN item.eventoColaborador ec      INNER JOIN ec.tipoCalculoEvento tce      INNER JOIN tce.evento ev      INNER JOIN item.movimentoFolha mf      INNER JOIN mf.aberturaPeriodo ap      INNER JOIN ap.tipoCalculo tc     WHERE      (tce.media13Salario = :referencia      or     (tce.media13Salario = :valor ))     and      mf.colaborador = :colaborador      and      ev.tipoEvento = :provento      and      (extract(year from ap.dataInicio) = :ano)      and      ap.dataInicio <= :dataInicio      and      tc.tipoFolha = :tipoFolha ");
        q.setEntity("colaborador", (Object)colaborador);
        q.setShort("referencia", (short)1);
        q.setShort("valor", (short)2);
        q.setInteger("ano", ToolDate.yearFromDate((Object)dataInicial).intValue());
        q.setShort("provento", EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue().shortValue());
        q.setShort("tipoFolha", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue());
        q.setDate("dataInicio", dataInicial);
        return (Double)q.uniqueResult();
    }

    public Boolean verificarExistenciaIntegContFolha(Date periodo) {
        Query q = this.query(" SELECT coalesce(count(i.identificador),0)       FROM IntegracaoMovimentoFolha i        INNER JOIN i.abertura a        INNER JOIN a.tipoCalculo tc       WHERE        a.dataInicio = :periodo        AND        tc.tipoFolha = :folhaPagamento ");
        q.setDate("periodo", periodo);
        q.setShort("folhaPagamento", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue());
        return ToolMethods.isWithData((Number)((Long)q.uniqueResult()));
    }
}

