/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoParamFolha;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ProvisaoFerias;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Repository;

@Repository
public class DaoProvisaoFeriasImpl
extends DaoGenericEntityImpl<ProvisaoFerias, Long> {
    public Boolean verificarFolhaPagamentoContabilizada(Date periodo) {
        Query q = this.query("SELECT COUNT(i.identificador) FROM       IntegracaoMovimentoFolha i INNER JOIN i.abertura               a INNER JOIN a.tipoCalculo            t WHERE a.dataInicio = :periodo AND t.tipoFolha = :folhaPagamento");
        q.setDate("periodo", periodo);
        q.setShort("folhaPagamento", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue());
        return ToolMethods.isWithData((Number)((Long)q.uniqueResult()));
    }

    public List<Colaborador> findColaboradoresProvisaoFeriasCentroCusto(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa, Empresa empresa) {
        Query q = this.query(" select c  from Colaborador c  where  c.ativo = :sim  and  (c.tipoColaborador.identificador = 0  and  c.dataAdmissao <= :dataFinal )  and   (c.dataDemissao is null or c.dataDemissao > :dataFinal )  and  c.empresa= :empresa");
        q.setEntity("empresa", (Object)empresa);
        q.setDate("dataFinal", dataFinal);
        q.setShort("sim", EnumConstantsMentorSimNao.SIM.getValue());
        return q.list();
    }

    public List<Colaborador> findColaboradoresProvisaoFerias(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa, Empresa empresa) {
        Object hql = " select c  from Colaborador c  where  c.ativo = :sim  and  (c.tipoColaborador.identificador = 0  and  c.dataAdmissao <= :dataFinal )  and   (c.dataDemissao is null or c.dataDemissao > :dataFinal )  and  c.empresa.empresaDados.grupoEmpresa = :grupoEmpresa";
        if (empresa != null) {
            hql = (String)hql + " and c.empresa = :empresa ";
        }
        Query q = this.query((String)hql);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setDate("dataFinal", dataFinal);
        q.setShort("sim", EnumConstantsMentorSimNao.SIM.getValue());
        if (empresa != null) {
            q.setEntity("empresa", (Object)empresa);
        }
        return q.list();
    }

    public Double findMediaFerias(Date dataInicio, Date dataFinal, Colaborador colaborador) {
        Query q = this.query("          select coalesce(sum(item.valor),0)         from ItemMovimentoFolha item         where         item.eventoColaborador.tipoCalculoEvento.evento.tipoEvento = :provento         and         (item.eventoColaborador.tipoCalculoEvento.mediaFerias = :referencia or (item.eventoColaborador.tipoCalculoEvento.mediaFerias = :valor))        and         item.movimentoFolha.colaborador = :colaborador         and        ((item.movimentoFolha.aberturaPeriodo.dataInicio >= :dataInicio        and        item.movimentoFolha.aberturaPeriodo.dataFinal <= :dataFim)         or       (item.movimentoFolha.aberturaPeriodo.dataInicio < :dataFim         and         item.movimentoFolha.aberturaPeriodo.dataFinal > :dataFim         and         (extract(day from item.movimentoFolha.aberturaPeriodo.dataFinal) - :diaPeriodoFinal <= 15 )        and         (:dataFimInicioPeriodo - :diaPeriodoInicial+1) < 15 )         or         (item.movimentoFolha.aberturaPeriodo.dataInicio < :dataInicio         and         item.movimentoFolha.aberturaPeriodo.dataFinal > :dataInicio          and         (extract(day from item.movimentoFolha.aberturaPeriodo.dataFinal) - :diaPeriodoInicial >= 15 )))        and         item.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento ");
        return (Double)q.setDate("dataInicio", dataInicio).setDate("dataFim", dataFinal).setInteger("diaPeriodoFinal", ToolDate.dayFromDate((Date)dataFinal).intValue()).setInteger("diaPeriodoInicial", ToolDate.dayFromDate((Date)dataInicio).intValue()).setEntity("colaborador", (Object)colaborador).setShort("folhaPagamento", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue()).setInteger("dataFimInicioPeriodo", ToolDate.getCalendar((Date)dataInicio).getActualMaximum(5)).setShort("valor", (short)2).setShort("referencia", (short)1).setShort("provento", EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue().shortValue()).uniqueResult();
    }

    public List<Colaborador> findCentroCustos(ProvisaoFerias vo) {
        Query q = this.query("select distinct i.colaborador  from ItemProvisaoFerias i where i.provisao = :provisao");
        q.setEntity("provisao", (Object)vo);
        return q.list();
    }

    public HashMap findValoresProvisaoAnterior(Date periodo, Colaborador c) {
        Query q = this.query("select coalesce(sum(i.vlrFerias),0)   as VR_FERIAS,    coalesce(sum(i.vlrFerias13),0)        as VR_UM_TERC_FERIAS ,   coalesce(sum(i.vlrInssEmpresa),0)     as VR_INSS_EMPRESA,    coalesce(sum(i.vlrInssTerceiros),0)   as VR_INSS_TERCEIROS,    coalesce(sum(i.vlrFgts),0)            as VR_FGTS ,    coalesce(sum(i.vlrRat),0)             as VR_RAT,    coalesce(sum(i.vlrAposentadoria25),0) as VR_APOSENTADORIA    from ItemProvisaoFerias i   where i.provisao.periodo = :periodo   and i.colaborador = :colaborador");
        q.setDate("periodo", periodo);
        q.setEntity("colaborador", (Object)c);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return (HashMap)q.uniqueResult();
    }
}

