/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.AfastamentoColaborador;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocItemS1020;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemOutrosTitulosFolha;
import com.touchcomp.basementor.model.vo.ItemRemessaFolhaCnab;
import com.touchcomp.basementor.model.vo.ItemSaneamentoDadosColaborador;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementorclientwebservices.ponto.model.demissao.DTOPontoDemissao;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.hibernate.Criteria;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoRecisaoImpl
extends DaoGenericEntityImpl<Recisao, Long> {
    public Integer findAfastamentoMedidaProvisoria(Colaborador colaborador, Date dataInicial, Date dataFinal) {
        Integer diasAfastamento = 0;
        List ret = new ArrayList();
        Query q = this.query(" SELECT a  FROM AfastamentoColaborador a  INNER JOIN a.esocMotivoAfastamento ema  WHERE      a.dataAfastamento != null  and ema.codigo = :medida  and a.colaborador = :colaborador  and (a.dataRetorno between :dataInicio and :dataFinal  or a.dataAfastamento between :dataInicio and :dataFinal )");
        q.setEntity("colaborador", (Object)colaborador);
        q.setDate("dataInicio", dataInicial);
        q.setString("medida", "37");
        q.setDate("dataFinal", dataFinal).list();
        ret = q.list();
        for (Object object : ret) {
            AfastamentoColaborador afastamentoColaborador = (AfastamentoColaborador)object;
            if (afastamentoColaborador == null) continue;
            if (afastamentoColaborador.getDataAfastamento().before(dataInicial) && afastamentoColaborador.getDataRetorno().before(dataFinal)) {
                diasAfastamento = diasAfastamento + ToolDate.diferenceDayBetweenDatesExclusive((Date)dataInicial, (Date)afastamentoColaborador.getDataRetorno());
                continue;
            }
            if (afastamentoColaborador.getDataAfastamento().after(dataInicial) && afastamentoColaborador.getDataRetorno().before(dataFinal)) {
                diasAfastamento = diasAfastamento + ToolDate.diferenceDayBetweenDatesExclusive((Date)afastamentoColaborador.getDataAfastamento(), (Date)afastamentoColaborador.getDataRetorno());
                continue;
            }
            diasAfastamento = diasAfastamento + ToolDate.diferenceDayBetweenDatesExclusive((Date)afastamentoColaborador.getDataAfastamento(), (Date)dataFinal);
        }
        return diasAfastamento;
    }

    public List<Recisao> getRecisaoPorColaborador(Long idColaborador) {
        CriteriaBuilder builder = this.criteriaBuilder(Recisao.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root fromRecisao = crit.from(Recisao.class);
        Join jColaborador = fromRecisao.join("colaborador", JoinType.INNER);
        crit.select((Selection)fromRecisao);
        exps.add(builder.equal((Expression)jColaborador.get("identificador"), (Object)idColaborador));
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }

    public Recisao pesquisarRecisaoPorColaboradorNumeroRegistro(String numeroRegistro) {
        CriteriaBuilder builder = this.criteriaBuilder(Recisao.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root fromRecisao = crit.from(Recisao.class);
        Join jColaborador = fromRecisao.join("colaborador", JoinType.INNER);
        crit.select((Selection)fromRecisao);
        exps.add(builder.equal((Expression)jColaborador.get("numeroRegistro"), (Object)numeroRegistro));
        crit.where(exps.toArray(new Predicate[0]));
        return (Recisao)this.getEntityManager().createQuery(crit).setMaxResults(1).getSingleResult();
    }

    public List<HashMap> getDetalhamentoImpostoByPeriodoGrupoEmpresa(Date dataPeriodo, Long grupoEmpresa) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jEmpresa = aux.join("empresa");
        Join jEmpresaDados = jEmpresa.join("empresaDados");
        Join jGrupoEmpresa = jEmpresaDados.join("grupoEmpresa");
        aux.select(aux.getSum(AuxCriteriaBuilder.pair(aux.from(), "vlrTotalGrrf", "vlrTotalGrrf")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair(aux.from(), "vrlIrrf", "vrlIrrf")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair(aux.from(), "vlrIrrf13", "vlrIrrf13")));
        aux.between("dataAfastamento", ToolDate.getDataInicial((Date)dataPeriodo), (Comparable)ToolDate.getDataFinal((Date)dataPeriodo));
        aux.equal((From)jGrupoEmpresa, "identificador", grupoEmpresa);
        return aux.getResultMap();
    }

    public Recisao getRecisaoByAvisoTrabalhado(Long identificador) {
        Criteria c = this.criteria();
        c.createAlias("emissaoAviso", "ea");
        c.add(this.eq("ea.identificador", identificador));
        return (Recisao)c.uniqueResult();
    }

    public List<Recisao> findRecisoesSemEventosESocial(OpcoesESocial opcoes, GrupoEmpresa grupo) {
        CriteriaBuilder builder = this.criteriaBuilder(Colaborador.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root root = crit.from(Recisao.class);
        Join jEmpresa = root.join("empresa", JoinType.INNER);
        Join jEmpresaDados = jEmpresa.join("empresaDados", JoinType.INNER);
        exps.add(builder.equal((Expression)root.get("recisaoComplementar"), (Object)EnumConstantsMentorSimNao.NAO.getValue()));
        exps.add(builder.greaterThanOrEqualTo((Expression)root.get("dataAfastamento"), (Comparable)opcoes.getDataInicio()));
        exps.add(builder.equal((Expression)jEmpresaDados.get("grupoEmpresa"), (Object)grupo));
        Subquery subquery = crit.subquery(ItemSaneamentoDadosColaborador.class);
        Root fromItemSaneamentoColab = subquery.from(ItemSaneamentoDadosColaborador.class);
        Join jRecisao = fromItemSaneamentoColab.join("recisao", JoinType.INNER);
        subquery.where(new Predicate[]{builder.equal((Expression)jRecisao.get("identificador"), (Expression)root.get("identificador")), builder.equal((Expression)fromItemSaneamentoColab.get("liberado"), (Object)EnumConstantsMentorSimNao.SIM.getValue())});
        exps.add(builder.not((Expression)builder.in((Expression)root.get("identificador")).value((Expression)subquery.select((Expression)jRecisao.get("identificador")))));
        crit.select((Selection)root);
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }

    public List<Recisao> findMovimentosS1210(Date dataInicial, Date dataFinal, GrupoEmpresa grupo) {
        CriteriaBuilder builder = this.criteriaBuilder(Recisao.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root root = crit.from(Recisao.class);
        Join jEmpresa = root.join("empresa", JoinType.INNER);
        Join jEmpresaDados = jEmpresa.join("empresaDados", JoinType.INNER);
        exps.add(builder.or((Expression)builder.equal((Expression)root.get("recisaoComplementar"), (Object)EnumConstantsMentorSimNao.NAO.getValue()), (Expression)builder.isNotNull((Expression)root.get("recisaoComplementarAc"))));
        exps.add(builder.between((Expression)root.get("dataPagamento"), (Comparable)dataInicial, (Comparable)dataFinal));
        exps.add(builder.equal((Expression)jEmpresaDados.get("grupoEmpresa"), (Object)grupo));
        Subquery subquery = crit.subquery(EsocItemS1020.class);
        Root fromEsocItemS1020 = subquery.from(EsocItemS1020.class);
        Join jRecisao = fromEsocItemS1020.join("rescisao", JoinType.INNER);
        subquery.where((Expression)builder.equal((Expression)jRecisao.get("identificador"), (Expression)root.get("identificador")));
        subquery.select((Expression)fromEsocItemS1020);
        exps.add(builder.not((Expression)builder.exists(subquery)));
        crit.select((Selection)root);
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }

    public List<DTOPontoDemissao> findRescisoesPonto(Date dataBaseSincSistemaPonto, Date dataUltimaSincronizacao) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jColaborador = aux.join("colaborador");
        Join jEmpresa = aux.join("empresa");
        aux.select((From)jColaborador, "numeroRegistro");
        aux.select("dataAfastamento");
        aux.select("identificador");
        aux.select((From)jEmpresa, "identificador");
        LinkedList<Predicate> where = new LinkedList<Predicate>();
        where.add(aux.and(aux.isNotNull("dataCadastro"), aux.gt("dataCadastro", dataBaseSincSistemaPonto)));
        if (TMethods.isNotNull((Object)dataUltimaSincronizacao).booleanValue()) {
            where.add(aux.gt("dataAtualizacao", dataUltimaSincronizacao));
        }
        aux.where(where);
        List data = aux.getResult();
        LinkedList<DTOPontoDemissao> result = new LinkedList<DTOPontoDemissao>();
        for (Object[] obj : data) {
            DTOPontoDemissao dto = new DTOPontoDemissao();
            dto.setMatricula((String)obj[0]);
            dto.setDtDemissao((Date)obj[1]);
            dto.setIdentificador((Long)obj[2]);
            dto.setIdEmpresa((Long)obj[3]);
            result.add(dto);
        }
        return result;
    }

    public List<Recisao> findRecisaoPorDataPagamentoEmpresa(Date dataPagamento, Empresa empresa) {
        CriteriaBuilder builder = this.criteriaBuilder(Recisao.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root root = crit.from(Recisao.class);
        exps.add(builder.equal((Expression)root.get("empresa"), (Object)empresa));
        exps.add(builder.equal((Expression)root.get("dataPagamento"), (Object)dataPagamento));
        Subquery subqueryRecisao = crit.subquery(ItemOutrosTitulosFolha.class);
        Root fromItemOutrosTitulosFolha = subqueryRecisao.from(ItemOutrosTitulosFolha.class);
        Join jRecisao = fromItemOutrosTitulosFolha.join("recisao", JoinType.INNER);
        subqueryRecisao.where((Expression)builder.and(new Predicate[]{builder.equal((Expression)jRecisao.get("identificador"), (Expression)root.get("identificador"))}));
        subqueryRecisao.select((Expression)fromItemOutrosTitulosFolha);
        Subquery subqueryCnab = crit.subquery(ItemRemessaFolhaCnab.class);
        Root fromItemRemessaFolhaCnab = subqueryCnab.from(ItemRemessaFolhaCnab.class);
        Join jRecisaoCnab = fromItemRemessaFolhaCnab.join("recisao", JoinType.INNER);
        subqueryCnab.where((Expression)builder.and(new Predicate[]{builder.equal((Expression)jRecisaoCnab.get("identificador"), (Expression)root.get("identificador"))}));
        subqueryCnab.select((Expression)fromItemRemessaFolhaCnab);
        exps.add(builder.not((Expression)builder.exists(subqueryRecisao)));
        exps.add(builder.not((Expression)builder.exists(subqueryCnab)));
        crit.select((Selection)root);
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }
}

