/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.ReinfAquisicaoProdRural;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.Date;
import java.util.List;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoReinfAquisicaoProdRuralImpl
extends DaoGenericEntityImpl<ReinfAquisicaoProdRural, Long> {
    public List<NotaFiscalTerceiros> findNotasTerceirosProdRural(Date inicialPeriodo, Date finalPeriodo, Empresa emp) {
        String query = " from NotaFiscalTerceiros nt  where  (nt.valoresNfTerceiros.valorInss > 0  or  nt.valoresNfTerceiros.valorRat > 0  or  nt.valoresNfTerceiros.valorSenar > 0 or  nt.valoresNfTerceiros.valorFunrural > 0) and  nt.dataEntrada between :periodoInicial and :periodoFinal  and  nt.empresa = :empresa  and  exists (             from ItemNotaTerceiros i             inner join i.itemNotaLivroFiscal il            inner join il.cfop cf             where cf.cfopNotaProdutorRural=:sim             and             i.modeloFiscal.compoeAquisicaoRural = :sim             and i.notaFiscalTerceiros = nt )  and  not exists (from NotaAquisicaoProdRural nn where nn.notaTerceiros = nt )";
        Query q = this.query(query);
        q.setShort("sim", EnumConstantsMentorSimNao.SIM.value);
        q.setDate("periodoInicial", inicialPeriodo);
        q.setDate("periodoFinal", finalPeriodo);
        q.setEntity("empresa", (Object)emp);
        List list = q.getResultList();
        return list;
    }

    public List<NotaFiscalPropria> findNotasPropriaProdRural(Date inicialPeriodo, Date finalPeriodo, Empresa emp) {
        String query = " select distinct np  from NotaFiscalPropria np  where  np.dataEntradaSaida between :periodoInicial and :periodoFinal  and  np.empresa = :empresa  and  np.situacaoDocumento.codigo != 02  and  exists (             from ItemNotaFiscalPropria i             inner join i.itemNotaLivroFiscal il            inner join il.cfop cf            where cf.cfopNotaProdutorRural=:sim             and i.modeloFiscal.compoeAquisicaoRural = :sim             and i.notaFiscalPropria = np )  and  not exists (from NotaPropriaAquisicaoProdRural nn where nn.notaPropria = np )";
        Query q = this.query(query);
        q.setShort("sim", EnumConstantsMentorSimNao.SIM.value);
        q.setDate("periodoInicial", inicialPeriodo);
        q.setDate("periodoFinal", finalPeriodo);
        q.setEntity("empresa", (Object)emp);
        List list = q.getResultList();
        return list;
    }
}

