/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.reinf.EnumConstTipoEventoReinf;
import com.touchcomp.basementor.constants.enums.reinf.EnumReinfTipoEvento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ReinfEvento;
import com.touchcomp.basementor.model.vo.ReinfIdentificacaoAmbiente;
import com.touchcomp.basementor.model.vo.ReinfPreEvento;
import com.touchcomp.basementor.model.vo.TipoEventoReinf;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.query.Query;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository
public class DaoReinfPreEventoImpl
extends DaoGenericEntityImpl<ReinfPreEvento, Long> {
    public List<ReinfPreEvento> getPreEventosNaoEnviados(Empresa empresa, ReinfIdentificacaoAmbiente tipoAmbiente, TipoEventoReinf tipoEvento) {
        return this.toList(this.restrictions(this.isNull("reinfEvento"), this.eq("empresa", empresa), this.eq("tipoAmbiente", tipoAmbiente), this.eq("tipoEventoReinf", tipoEvento)));
    }

    public List<ReinfPreEvento> getPreEventosNaoEnviados(Empresa empresa, ReinfIdentificacaoAmbiente tipoAmbiente, TipoEventoReinf tipoEvento, Date periodo, Pageable page) {
        CriteriaBuilder builder = this.criteriaBuilder(ReinfPreEvento.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root fromReinfPreEvento = crit.from(ReinfPreEvento.class);
        Join jEmpresa = fromReinfPreEvento.join("empresa", JoinType.INNER);
        Join jReinfIdentificacaoAmbiente = fromReinfPreEvento.join("tipoAmbiente", JoinType.INNER);
        Join jTipoEventoReinf = fromReinfPreEvento.join("tipoEventoReinf", JoinType.INNER);
        EnumConstTipoEventoReinf tipo = EnumConstTipoEventoReinf.get((Object)tipoEvento.getCodigo());
        switch (tipo) {
            case R2010: 
            case R2020: 
            case R4010: 
            case R4040: {
                String path = switch (tipo) {
                    case EnumConstTipoEventoReinf.R2010 -> "itemReinf2010";
                    case EnumConstTipoEventoReinf.R2020 -> "itemReinf2020";
                    case EnumConstTipoEventoReinf.R4010 -> "itemReinf4010";
                    case EnumConstTipoEventoReinf.R4040 -> "itemReinf4040";
                    default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(tipo));
                };
                Join itemJoin = fromReinfPreEvento.join(path, JoinType.INNER);
                Join apuracaoJoin = itemJoin.join("apuracaoReinf", JoinType.INNER);
                exps.add(builder.equal((Expression)apuracaoJoin.get("periodo"), (Object)periodo));
                break;
            }
            case R4020: {
                Join item4020 = fromReinfPreEvento.join("itemReinf4020", JoinType.INNER);
                Join apuracao4020 = item4020.join("apuracaoReinf", JoinType.INNER);
                exps.add(builder.equal((Expression)apuracao4020.get("periodo"), (Object)periodo));
                Join item4020NI = fromReinfPreEvento.join("itemReinfNaoId", JoinType.LEFT);
                Join apuracao4020NI = item4020NI.join("apuracao", JoinType.LEFT);
                exps.add(builder.or((Expression)builder.isNull((Expression)apuracao4020NI.get("periodo")), (Expression)builder.equal((Expression)apuracao4020NI.get("periodo"), (Object)periodo)));
                break;
            }
            case R1000: {
                Join r1000 = fromReinfPreEvento.join("r1000", JoinType.INNER);
                exps.add(builder.equal((Expression)r1000.get("inicioValidade"), (Object)periodo));
                break;
            }
            case R1070: {
                Join r1070 = fromReinfPreEvento.join("r1070", JoinType.INNER);
                exps.add(builder.between(builder.literal((Object)periodo), (Expression)r1070.get("inicioValidade"), (Expression)r1070.get("fimValidade")));
                break;
            }
            case R2060: {
                Join r2060 = fromReinfPreEvento.join("r2060", JoinType.INNER);
                exps.add(builder.equal((Expression)r2060.get("periodo"), (Object)periodo));
                break;
            }
            case R2099: {
                Join r2099 = fromReinfPreEvento.join("r2099", JoinType.INNER);
                exps.add(builder.equal((Expression)r2099.get("periodo"), (Object)periodo));
                break;
            }
            case R9000: 
            case R2098: 
            case R4099: {
                Join eventoJoin = fromReinfPreEvento.join("reinfEvento", JoinType.INNER);
                exps.add(builder.equal((Expression)eventoJoin.get("dataGeracao"), (Object)periodo));
                break;
            }
        }
        exps.add(builder.isNull((Expression)fromReinfPreEvento.get("reinfEvento")));
        exps.add(builder.equal((Expression)jEmpresa.get("identificador"), (Object)empresa.getIdentificador()));
        exps.add(builder.equal((Expression)jReinfIdentificacaoAmbiente.get("identificador"), (Object)tipoAmbiente.getIdentificador()));
        exps.add(builder.equal((Expression)jTipoEventoReinf.get("identificador"), (Object)tipoEvento.getIdentificador()));
        crit.select((Selection)fromReinfPreEvento);
        crit.where(exps.toArray(new Predicate[0]));
        TypedQuery query = this.getEntityManager().createQuery(crit);
        if (ToolMethods.isNotNull((Object)page).booleanValue()) {
            query.setMaxResults(page.getPageSize());
            query.setFirstResult(page.getPageNumber() * page.getPageSize());
        }
        return query.getResultList();
    }

    public List<ReinfEvento> findEventosGeradosEnviados(Empresa logedEmpresa, ReinfIdentificacaoAmbiente ambiente, TipoEventoReinf tipoEvento, Date periodo, Pageable page) {
        CriteriaBuilder builder = this.criteriaBuilder(ReinfPreEvento.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root fromReinfPreEvento = crit.from(ReinfPreEvento.class);
        Join jReinfEvento = fromReinfPreEvento.join("reinfEvento", JoinType.INNER);
        Join jEmpresa = fromReinfPreEvento.join("empresa", JoinType.INNER);
        Join jReinfIdentificacaoAmbiente = fromReinfPreEvento.join("tipoAmbiente", JoinType.INNER);
        Join jTipoEventoReinf = fromReinfPreEvento.join("tipoEventoReinf", JoinType.INNER);
        EnumConstTipoEventoReinf tipo = EnumConstTipoEventoReinf.get((Object)tipoEvento.getCodigo());
        switch (tipo) {
            case R2010: 
            case R2020: 
            case R4010: 
            case R4040: {
                String path = switch (tipo) {
                    case EnumConstTipoEventoReinf.R2010 -> "itemReinf2010";
                    case EnumConstTipoEventoReinf.R2020 -> "itemReinf2020";
                    case EnumConstTipoEventoReinf.R4010 -> "itemReinf4010";
                    case EnumConstTipoEventoReinf.R4040 -> "itemReinf4040";
                    default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(tipo));
                };
                Join itemJoin = fromReinfPreEvento.join(path, JoinType.INNER);
                Join apuracaoJoin = itemJoin.join("apuracaoReinf", JoinType.INNER);
                exps.add(builder.equal((Expression)apuracaoJoin.get("periodo"), (Object)periodo));
                break;
            }
            case R4020: {
                Join item4020 = fromReinfPreEvento.join("itemReinf4020", JoinType.INNER);
                Join apuracao4020 = item4020.join("apuracaoReinf", JoinType.INNER);
                exps.add(builder.equal((Expression)apuracao4020.get("periodo"), (Object)periodo));
                Join item4020NI = fromReinfPreEvento.join("itemReinfNaoId", JoinType.LEFT);
                Join apuracao4020NI = item4020NI.join("apuracao", JoinType.LEFT);
                exps.add(builder.or((Expression)builder.isNull((Expression)apuracao4020NI.get("periodo")), (Expression)builder.equal((Expression)apuracao4020NI.get("periodo"), (Object)periodo)));
                break;
            }
            case R1000: {
                Join r1000 = fromReinfPreEvento.join("r1000", JoinType.INNER);
                exps.add(builder.equal((Expression)r1000.get("inicioValidade"), (Object)periodo));
                break;
            }
            case R1070: {
                Join r1070 = fromReinfPreEvento.join("r1070", JoinType.INNER);
                exps.add(builder.between(builder.literal((Object)periodo), (Expression)r1070.get("inicioValidade"), (Expression)r1070.get("fimValidade")));
                break;
            }
            case R2060: {
                Join r2060 = fromReinfPreEvento.join("r2060", JoinType.INNER);
                exps.add(builder.equal((Expression)r2060.get("periodo"), (Object)periodo));
                break;
            }
            case R2099: {
                Join r2099 = fromReinfPreEvento.join("r2099", JoinType.INNER);
                exps.add(builder.equal((Expression)r2099.get("periodo"), (Object)periodo));
                break;
            }
            case R9000: 
            case R2098: 
            case R4099: {
                Join eventoJoin = fromReinfPreEvento.join("reinfEvento", JoinType.INNER);
                exps.add(builder.equal((Expression)eventoJoin.get("dataGeracao"), (Object)periodo));
                break;
            }
            default: {
                throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.2007.001"));
            }
        }
        exps.add(builder.isNotNull((Expression)jReinfEvento.get("nrRecibo")));
        exps.add(builder.equal((Expression)jEmpresa.get("identificador"), (Object)logedEmpresa.getIdentificador()));
        exps.add(builder.equal((Expression)jReinfIdentificacaoAmbiente.get("identificador"), (Object)ambiente.getIdentificador()));
        exps.add(builder.equal((Expression)jTipoEventoReinf.get("identificador"), (Object)tipoEvento.getIdentificador()));
        exps.add(builder.equal((Expression)fromReinfPreEvento.get("tipoEvento"), (Object)EnumReinfTipoEvento.TIPO_EVENTO_INCLUSAO.getValue()));
        exps.add(builder.equal((Expression)jReinfEvento.get("status"), (Object)0L));
        crit.select((Selection)jReinfEvento);
        crit.where((Predicate[])exps.toArray(Predicate[]::new));
        TypedQuery query = this.getEntityManager().createQuery(crit);
        if (ToolMethods.isNotNull((Object)page).booleanValue()) {
            query.setMaxResults(page.getPageSize());
            query.setFirstResult(page.getPageNumber() * page.getPageSize());
        }
        return query.getResultList();
    }

    public List<ReinfPreEvento> findTodosEventosProducaoRestrita(GrupoEmpresa grupoEmpresa, ReinfIdentificacaoAmbiente tipoAmbiente) {
        String query = "select distinct m from ReinfPreEvento m  where m.empresa.empresaDados.grupoEmpresa = :grupoEmpresa and m.tipoAmbiente = :tipoAmbiente";
        Query q = this.query(query);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setEntity("tipoAmbiente", (Object)tipoAmbiente);
        return q.list();
    }
}

