/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.procedenciasolicitacao.EnumProcedenciaSolicitacao;
import com.touchcomp.basementor.constants.enums.relpessoacontato.EnumConstRelPessoaContStatus;
import com.touchcomp.basementor.model.vo.ClienteContSistemas;
import com.touchcomp.basementor.model.vo.LogConsultaAtendimentos;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.RelPessoaContato;
import com.touchcomp.basementor.model.vo.RelPessoaContatoLog;
import com.touchcomp.basementor.model.vo.SetorUsuario;
import com.touchcomp.basementor.model.vo.StatusRelPessoaContato;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementor.model.vo.UsuarioBasico;
import com.touchcomp.basementor.model.vo.UsuarioClienteContSistemas;
import com.touchcomp.basementor.model.vo.VersaoMentor;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementorservice.model.genericmap.GenericMapValues;
import com.touchcomp.basementorservice.model.genericmap.impl.GenMapMuralAtendDetail;
import com.touchcomp.basementortools.tools.date.TDate;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.TString;
import com.touchcomp.touchvomodel.temp.centralticketstouch.DTORelPessoaTouchRes;
import java.math.BigInteger;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.query.NativeQuery;
import org.springframework.stereotype.Repository;

@Repository
public class DaoRelPessoaContatoImpl
extends DaoGenericEntityImpl<RelPessoaContato, Long> {
    public RelPessoaContato getByNrProtocolo(Long nrProtocolo) {
        return (RelPessoaContato)this.toUnique(this.restrictions(this.eq("nrProtocolo", nrProtocolo)));
    }

    public List<Map<String, Object>> getAtendimentos(UsuarioClienteContSistemas user, LogConsultaAtendimentos log) {
        Date data = ToolDate.strToDate((String)"01/01/2000");
        if (log != null) {
            data = log.getDataConsulta();
        }
        String query = "select l.identificador as ID_ATENDIMENTO, l.nrProtocolo as NR_PROTOCOLO, l.dataPrevFinalizacao as DATA_PREVISTA, l.dataFinalizacao as DATA_FECHAMENTO, pr.nome as USUARIO_RESPONSAVEL, usfbp.nome as USUARIO_FINALIZACAO, l.finalizado as FINALIZADO, l.status as STATUS, l.assunto as ASSUNTO, l.solucao as SOLUCAO, l.descricaoTecnica as SOLUCAO_TECNICA, n.identificador as ID_NODO, l.dataRelacionamento as DATA_ATENDIMENTO from RelPessoaContato l inner join l.usuarioResponsavel ur inner join ur.usuarioBasico urb inner join urb.pessoa pr left join l.usuarioFinalizacao usf left join usf.usuarioBasico usfb left join usfb.pessoa usfbp left join l.nodo n where l.usuarioCliContSistemas = :usuarioClienteContSistemas and (l.dataAtualizacao >= :dataConsulta  or l.finalizado = :nao)";
        org.hibernate.query.Query q = this.query(query);
        q.setEntity("usuarioClienteContSistemas", (Object)user);
        q.setDate("dataConsulta", data);
        q.setShort("nao", (short)0);
        List<Map<String, Object>> temp = this.toHashList((Query)q);
        return temp;
    }

    public Long findProximoNrProtocolo() {
        NativeQuery q = this.sqlQuery("select gen_id(gen_numero_protocolo_contato,1) from rdb$database");
        BigInteger b = (BigInteger)q.uniqueResult();
        return b.longValue();
    }

    public List<Map<String, Object>> getLogAtendimentos(Long nrProtocolo) {
        String query = "select r.identificador as ID_LOG_ATENDIMENTO, r.dataAgendamento as DATA_AGENDAMENTO, r.finalizado as FINALIZADO, r.tempoDispendiado as TEMPO_DISPENDIDO,  r.dataInicial as DATA_INICIAL, r.dataFinal as DATA_FINAL, u.identificador as ID_USUARIO, p.nome as USUARIO, ua.identificador as ID_USUARIO_AGENDAMENTO, pa.nome as USUARIO_AGENDAMENTO, r.observacao as OBSERVACAO from RelPessoaContatoLog r  inner join r.usuario u  inner join u.usuarioBasico ub  inner join ub.pessoa p inner join r.relPessoaContato rp  left join r.usuarioAgendamento ua left join ua.usuarioBasico uab left join uab.pessoa pa where rp.nrProtocolo=:nrProtocolo";
        org.hibernate.query.Query q = this.query(query);
        q.setLong("nrProtocolo", nrProtocolo.longValue());
        List<Map<String, Object>> aux = this.toHashList((Query)q);
        return aux;
    }

    public List<Map<String, Object>> getReagendamentos(Long nrProtocolo) {
        String query = "select r.identificador as ID_REAGENDAMENTO, r.infoAdicional as INFO_ADICIONAL, r.dataPrevista as DATA_PREVISTA, m.descricao as MOTIVO,  m.identificador as ID_MOTIVO, u.identificador as ID_USUARIO,  p.nome as USUARIO from RelPessoaContatoPrev r  inner join r.usuario u  inner join u.usuarioBasico ub  inner join ub.pessoa p  inner join r.motivo m inner join r.relPessoaContato rp where rp.nrProtocolo=:nrProtocolo";
        org.hibernate.query.Query q = this.query(query);
        q.setLong("nrProtocolo", nrProtocolo.longValue());
        List<Map<String, Object>> aux = this.toHashList((Query)q);
        return aux;
    }

    public List<GenericMapValues<GenMapMuralAtendDetail>> getAtendimentosMural(SetorUsuario setor, Usuario user, Short tipoData, Date dataPrevIn, Date dataPrevFim, ClienteContSistemas cliente, Pessoa pessoaUsuarioCliente, StatusRelPessoaContato statusRelPessoaContato) {
        String query = "select r.identificador as " + GenMapMuralAtendDetail.ID_ATENDIMENTO.getValue() + ", r.nrProtocolo as " + GenMapMuralAtendDetail.NR_PROTOCOLO.getValue() + ", p.identificador as " + GenMapMuralAtendDetail.ID_PROCEDENCIA.getValue() + ", p.descricao as " + GenMapMuralAtendDetail.PROCEDENCIA.getValue() + ", pc.nome as " + GenMapMuralAtendDetail.CLIENTE.getValue() + ", puc.nome as " + GenMapMuralAtendDetail.USUARIO.getValue() + ", puAg.nome as " + GenMapMuralAtendDetail.USUARIO_AGENDADO.getValue() + ", r.dataRelacionamento as " + GenMapMuralAtendDetail.DATA_ABERTURA.getValue() + ", r.assunto as " + GenMapMuralAtendDetail.DESC_ATENDIMENTO.getValue() + ", a.dataAgendamento as " + GenMapMuralAtendDetail.DATA_AGENDAMENTO.getValue() + ", r.dataPrevFinalizacao as " + GenMapMuralAtendDetail.DATA_PREVISAO.getValue() + ", r.dataPrevFinalizacaoInterna as " + GenMapMuralAtendDetail.DATA_PREVISAO_INTERNA.getValue() + ", count(ra.identificador) as " + GenMapMuralAtendDetail.NR_REAGENDAMENTOS.getValue() + ", v.descricao as " + GenMapMuralAtendDetail.VERSAO_PREVISTA_ATEND.getValue() + ", v.codigo as " + GenMapMuralAtendDetail.VERSAO_PREVISTA_ATEND_CODIGO.getValue() + ", cc.identificador as " + GenMapMuralAtendDetail.ID_CLIENTE.getValue() + ", ufbp.nome as " + GenMapMuralAtendDetail.USUARIO_FINALIZACAO.getValue() + ", pr.identificador as " + GenMapMuralAtendDetail.PRIORIDADE.getValue() + " from RelPessoaContato r  inner join r.agendamentos a  inner join r.reagendamentos ra  inner join a.usuarioAgendamento u  inner join u.usuarioBasico ubAg  inner join ubAg.pessoa puAg  inner join r.procedenciaSolicitacaoContato p left join r.prioridadeAtendimento pr inner join r.clienteContSistemas cc inner join cc.tomadorPrestadorRps t inner join t.pessoa pc inner join r.usuarioCliContSistemas ut left join r.versaoSerDisponibilizada v left join r.versaoAtual va left join ut.pessoa puc left join r.usuarioFinalizacao uf left join uf.usuarioBasico ufb left join ufb.pessoa ufbp";
        Object where = " where r.finalizado = :nao and a.finalizado=:nao and p.sugestao = :nao";
        if (setor != null) {
            where = (String)where + " and u.setorUsuario=:setor";
        }
        if (statusRelPessoaContato != null) {
            where = (String)where + " and r.statusRelPessoaContato=:statusRelPessoaContato";
        }
        if (cliente != null) {
            where = (String)where + " and cc=:cliente";
        }
        if (pessoaUsuarioCliente != null) {
            where = (String)where + " and puc=:usuarioCliente";
        }
        if (user != null) {
            where = (String)where + " and u=:user";
        }
        if (ToolMethods.isEqualsNumber((Number)tipoData, (Number)1)) {
            where = (String)where + " and r.dataPrevFinalizacao between :dataPrevIn and :dataPrevFim";
        }
        if (ToolMethods.isEqualsNumber((Number)tipoData, (Number)2)) {
            where = (String)where + " and r.dataPrevFinalizacaoInterna between :dataPrevIn and :dataPrevFim";
        }
        String groupBy = " group by r.identificador, r.nrProtocolo, r.assunto, p.identificador, p.descricao, pc.nome, puc.nome, puAg.nome, r.dataRelacionamento, a.dataAgendamento, r.dataPrevFinalizacao, v.codigo, v.descricao, cc.identificador, r.dataPrevFinalizacaoInterna, ufbp.nome, pr.identificador ";
        org.hibernate.query.Query q = this.query(query + (String)where + groupBy);
        q.setShort("nao", (short)0);
        if (user != null) {
            q.setEntity("user", (Object)user);
        }
        if (cliente != null) {
            q.setEntity("cliente", (Object)cliente);
        }
        if (pessoaUsuarioCliente != null) {
            q.setEntity("usuarioCliente", (Object)pessoaUsuarioCliente);
        }
        if (setor != null) {
            q.setEntity("setor", (Object)setor);
        }
        if (statusRelPessoaContato != null) {
            q.setEntity("statusRelPessoaContato", (Object)statusRelPessoaContato);
        }
        if (tipoData >= 1) {
            q.setDate("dataPrevIn", dataPrevIn);
            q.setDate("dataPrevFim", dataPrevFim);
        }
        List<GenericMapValues<GenMapMuralAtendDetail>> aux = this.toGenMapList(q, GenMapMuralAtendDetail.class);
        this.processarValores(aux);
        return aux;
    }

    public List<GenericMapValues<GenMapMuralAtendDetail>> getAtendimentosMuralEmAtraso(SetorUsuario setor, Usuario user, ClienteContSistemas cliente, Pessoa pessoaUsuarioCliente, StatusRelPessoaContato statusRelPessoaContato) {
        String query = "select r.identificador as " + GenMapMuralAtendDetail.ID_ATENDIMENTO.getValue() + ", r.nrProtocolo as " + GenMapMuralAtendDetail.NR_PROTOCOLO.getValue() + ", p.identificador as " + GenMapMuralAtendDetail.ID_PROCEDENCIA.getValue() + ", p.descricao as " + GenMapMuralAtendDetail.PROCEDENCIA.getValue() + ", pc.nome as " + GenMapMuralAtendDetail.CLIENTE.getValue() + ", puc.nome as " + GenMapMuralAtendDetail.USUARIO.getValue() + ", puAg.nome as " + GenMapMuralAtendDetail.USUARIO_AGENDADO.getValue() + ", r.dataRelacionamento as " + GenMapMuralAtendDetail.DATA_ABERTURA.getValue() + ", a.dataAgendamento as " + GenMapMuralAtendDetail.DATA_AGENDAMENTO.getValue() + ", r.dataPrevFinalizacao as " + GenMapMuralAtendDetail.DATA_PREVISAO.getValue() + ", r.dataPrevFinalizacaoInterna as " + GenMapMuralAtendDetail.DATA_PREVISAO_INTERNA.getValue() + ", r.assunto as " + GenMapMuralAtendDetail.DESC_ATENDIMENTO.getValue() + ", count(ra.identificador) as " + GenMapMuralAtendDetail.NR_REAGENDAMENTOS.getValue() + ", v.descricao as " + GenMapMuralAtendDetail.VERSAO_PREVISTA_ATEND.getValue() + ", v.codigo as " + GenMapMuralAtendDetail.VERSAO_PREVISTA_ATEND_CODIGO.getValue() + ", cc.identificador as " + GenMapMuralAtendDetail.ID_CLIENTE.getValue() + ", ufbp.nome as " + GenMapMuralAtendDetail.USUARIO_FINALIZACAO.getValue() + ", pr.identificador as " + GenMapMuralAtendDetail.PRIORIDADE.getValue() + " from RelPessoaContato r  inner join r.agendamentos a  left join r.reagendamentos ra  left join a.usuarioAgendamento u  left join u.usuarioBasico ubAg  left join ubAg.pessoa puAg  left join r.procedenciaSolicitacaoContato p left join r.prioridadeAtendimento pr left join r.clienteContSistemas cc left join cc.tomadorPrestadorRps t left join t.pessoa pc left join r.usuarioCliContSistemas ut left join r.versaoSerDisponibilizada v left join r.versaoAtual va left join ut.pessoa puc left join r.usuarioFinalizacao uf left join uf.usuarioBasico ufb left join ufb.pessoa ufbp";
        Object where = " where r.finalizado = :nao and a.finalizado=:nao and r.dataPrevFinalizacao<:data_atual and p.sugestao = :nao";
        if (setor != null) {
            where = (String)where + " and u.setorUsuario=:setor";
        }
        if (cliente != null) {
            where = (String)where + " and cc=:cliente";
        }
        if (pessoaUsuarioCliente != null) {
            where = (String)where + " and puc=:usuarioCliente";
        }
        if (user != null) {
            where = (String)where + " and u=:user";
        }
        if (statusRelPessoaContato != null) {
            where = (String)where + " and r.statusRelPessoaContato=:statusRelPessoaContato";
        }
        String groupBy = " group by r.identificador, r.nrProtocolo, p.identificador, r.assunto, p.descricao, pc.nome, puc.nome, puAg.nome, r.dataRelacionamento, a.dataAgendamento, r.dataPrevFinalizacao, v.codigo, v.descricao, cc.identificador, r.dataPrevFinalizacaoInterna, ufbp.nome, pr.identificador";
        org.hibernate.query.Query q = this.query(query + (String)where + groupBy);
        q.setShort("nao", (short)0);
        q.setDate("data_atual", new Date());
        if (user != null) {
            q.setEntity("user", (Object)user);
        }
        if (cliente != null) {
            q.setEntity("cliente", (Object)cliente);
        }
        if (pessoaUsuarioCliente != null) {
            q.setEntity("usuarioCliente", (Object)pessoaUsuarioCliente);
        }
        if (setor != null) {
            q.setEntity("setor", (Object)setor);
        }
        if (statusRelPessoaContato != null) {
            q.setEntity("statusRelPessoaContato", (Object)statusRelPessoaContato);
        }
        List<GenericMapValues<GenMapMuralAtendDetail>> aux = this.toGenMapList(q, GenMapMuralAtendDetail.class);
        this.processarValores(aux);
        return aux;
    }

    private Date getDataUltAbert(Long idRel) {
        org.hibernate.query.Query q = this.query("select max(r.dataReabertura) from RelPessoaContatoReabert r inner join r.relPessoaContato rp where rp.identificador=:idRel");
        q.setLong("idRel", idRel.longValue());
        return (Date)q.uniqueResult();
    }

    private void processarValores(List<GenericMapValues<GenMapMuralAtendDetail>> aux) {
        for (GenericMapValues<GenMapMuralAtendDetail> gen : aux) {
            Long idRel = gen.getLong(GenMapMuralAtendDetail.ID_ATENDIMENTO);
            Date dataUltAbert = this.getDataUltAbert(idRel);
            Integer tempoUltInteracao = ToolDate.diferenceDayBetweenDates((Date)gen.getDate(GenMapMuralAtendDetail.DATA_ABERTURA), (Date)new Date());
            if (dataUltAbert != null) {
                tempoUltInteracao = ToolDate.diferenceDayBetweenDates((Date)dataUltAbert, (Date)new Date());
            }
            gen.addValue(GenMapMuralAtendDetail.TEMPO_DESDE_ULT_INTERACAO, tempoUltInteracao);
        }
    }

    public List<RelPessoaContato> getAtendimentos(VersaoMentor versao, EnumProcedenciaSolicitacao ... tipo) {
        LinkedList<Short> procs = new LinkedList<Short>();
        for (EnumProcedenciaSolicitacao tp : tipo) {
            procs.add(tp.getValue());
        }
        Criteria crit = this.criteria();
        crit.createAlias("procedenciaSolicitacaoContato", "p");
        return this.toList(this.restrictions(crit, this.in("p.tipoProcedencia", procs), this.eq("versaoAtual", versao)));
    }

    public List<DTORelPessoaTouchRes> getAtendimentosRes(String codigoCliente, UsuarioBasico usuario, Short filtrarDataAbertura, Date dataAbertIn, Date dataAbertFim, Short filtrarPrevisao, Date dataPrevIn, Date dataPrevFim, Short filtrarSolucao, Date dataSolucaoIn, Date dataSolucaoFim, Short filtrarProtocolo, Long nrProtocolo, Short filtrarStatus, Short status, Long page, Long maxRes) {
        AuxCriteriaBuilder builder = this.queryBuilder();
        if (TMethods.isAffirmative((Number)filtrarDataAbertura)) {
            builder.between("dataRelacionamento", dataAbertIn, (Comparable)ToolDate.getLastDateOnDay((Date)dataAbertFim));
            builder.orderDesc("dataRelacionamento");
        }
        if (TMethods.isAffirmative((Number)filtrarPrevisao)) {
            builder.between("dataPrevFinalizacao", dataPrevIn, (Comparable)ToolDate.getLastDateOnDay((Date)dataPrevFim));
            builder.orderDesc("dataPrevFinalizacao");
        }
        if (TMethods.isAffirmative((Number)filtrarSolucao)) {
            builder.between("dataFinalizacao", dataSolucaoIn, (Comparable)ToolDate.getLastDateOnDay((Date)dataSolucaoFim));
            builder.orderDesc("dataFinalizacao");
        }
        if (TMethods.isAffirmative((Number)filtrarProtocolo)) {
            builder.equal("nrProtocolo", nrProtocolo);
            builder.orderDesc("nrProtocolo");
        }
        if (TMethods.isAffirmative((Number)filtrarStatus)) {
            builder.equal("finalizado", status);
            builder.orderDesc("dataFinalizacao");
        }
        return this.setAndConvertAtendimentosRes(builder, codigoCliente, usuario, page, maxRes);
    }

    public List<DTORelPessoaTouchRes> getAtendimentosRes(UsuarioBasico usuario, String codigoCliente, String text, Long page, Long maxRes) {
        AuxCriteriaBuilder builder = this.queryBuilder();
        if (TString.isALongNumber((String)text)) {
            builder.equal("nrProtocolo", Long.valueOf(text));
        } else if (TString.isADateClassic((String)text, (String)"dd-MM-yyyy")) {
            builder.equal("dataRelacionamento", TDate.strToDate((String)text));
        } else {
            builder.ilike("assunto", text);
        }
        return this.setAndConvertAtendimentosRes(builder, codigoCliente, usuario, page, maxRes);
    }

    private List<DTORelPessoaTouchRes> setAndConvertAtendimentosRes(AuxCriteriaBuilder<RelPessoaContato> builder, String codigoCliente, UsuarioBasico usuario, Long page, Long maxRes) {
        Join jUsuarioCli = builder.join("usuarioCliContSistemas");
        Join jCli = builder.join("clienteContSistemas");
        Join jUsuarioNodo = builder.joinLeft("nodo");
        Join jVerAtual = builder.joinLeft("versaoAtual");
        Join jVerDisp = builder.joinLeft("versaoSerDisponibilizada");
        Join jProcedencia = builder.joinLeft("procedenciaSolicitacaoContato");
        builder.equal((From)jCli, "codigoCliente", codigoCliente);
        builder.setMaxResults(maxRes.intValue());
        builder.setFirstResult(page.intValue());
        builder.equal((From)jUsuarioCli, "pessoa", usuario.getPessoa());
        builder.orderDesc("dataAtualizacao");
        builder.select("assunto", "dataFinalizacao", "dataPrevFinalizacao", "dataRelacionamento", "finalizado", "identificador", "nrProtocolo", "solucao", "dataAtualizacao");
        builder.select((From)jUsuarioNodo, "identificador");
        builder.select((From)jUsuarioNodo, "descricao");
        builder.select((From)jVerAtual, "codigo");
        builder.select((From)jVerDisp, "codigo");
        builder.select((From)jProcedencia, "identificador", "descricao");
        List aux = builder.getResult();
        LinkedList<DTORelPessoaTouchRes> ret = new LinkedList<DTORelPessoaTouchRes>();
        for (Object[] obj : aux) {
            DTORelPessoaTouchRes dto = new DTORelPessoaTouchRes();
            dto.setAssunto((String)obj[0]);
            dto.setDataFinalizacao((Date)obj[1]);
            dto.setDataPrevFinalizacao((Date)obj[2]);
            dto.setDataRelacionamento((Date)obj[3]);
            dto.setFinalizado((Short)obj[4]);
            dto.setIdentificador((Long)obj[5]);
            dto.setNrProtocolo((Long)obj[6]);
            dto.setSolucao((String)obj[7]);
            dto.setDataAtualizacao((Date)obj[8]);
            dto.setNodoIdentificador((Long)obj[9]);
            dto.setNodoDescricao((String)obj[10]);
            dto.setVersaoAtual((Long)obj[11]);
            dto.setVersaoPrevDispon((Long)obj[12]);
            dto.setProcedenciaSolicitacaoContatoIdentificador((Long)obj[13]);
            dto.setProcedenciaSolicitacaoContatoDescricao((String)obj[14]);
            ret.add(dto);
        }
        return ret;
    }

    public List<RelPessoaContato> getAtendimentosAbertoTicket() {
        AuxCriteriaBuilder builder = this.queryBuilder();
        builder.equal("status", EnumConstRelPessoaContStatus.ABERTO_ATEND_TOUCH_TICKET.getValue());
        return builder.getResultEnt();
    }

    public List<RelPessoaContatoLog> getAtendimentosAgendados(Usuario user, Date dataAgend) {
        AuxCriteriaBuilder builder = this.queryBuilder(RelPessoaContatoLog.class);
        builder.equal("usuarioAgendamento", user);
        builder.between("dataAgendamento", ToolDate.dataSemHora((Date)dataAgend), (Comparable)ToolDate.getLastDateOnDay((Date)dataAgend));
        builder.equal("finalizado", (short)0);
        builder.orderAsc("dataAgendamento", "identificador");
        return builder.getResultEnt();
    }

    public double getHorasApontadas(Usuario user, Date dataAgend) {
        AuxCriteriaBuilder builder = this.queryBuilder(RelPessoaContatoLog.class);
        builder.equal("usuarioAgendamento", user);
        builder.between("dataAgendamento", ToolDate.dataSemHora((Date)dataAgend), (Comparable)ToolDate.getLastDateOnDay((Date)dataAgend));
        builder.equal("finalizado", (short)0);
        builder.sum(AuxCriteriaBuilder.pair("tempoDispendiado", "F_TEMPO_TOTAL"));
        Double ret = (Double)builder.getUniqueGenericResult();
        return ret != null ? ret : 0.0;
    }
}

