/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoRepresentanteImpl
extends DaoGenericEntityImpl<Representante, Long> {
    public Representante findByPessoa(Long idPessoa) {
        Criteria c = this.criteria();
        c.createAlias("pessoa", "p");
        c.add(this.eq("p.identificador", idPessoa));
        c.setMaxResults(1);
        return (Representante)c.uniqueResult();
    }

    public Representante getRepresentanteCpfCpnj(String cnpj) {
        Criteria crit = this.criteria();
        crit.createAlias("pessoa", "p");
        crit.createAlias("p.complemento", "c");
        crit.setMaxResults(1);
        return (Representante)this.toUnique(this.restrictions(crit, this.eq("c.cnpj", cnpj)));
    }

    public Representante findRepresentantePorPessoa(Pessoa pessoa) {
        Criteria c = this.criteria();
        c.add(this.eq("pessoa", pessoa));
        c.setMaxResults(1);
        return (Representante)c.uniqueResult();
    }

    public List<Representante> get(Pessoa pessoa, Short ativo) {
        return this.toList(this.restrictions(this.eq("pessoa", pessoa), this.eq("ativo", ativo)));
    }

    public Representante findByIdUsuario(Long idUsuario) {
        String query = "select r from Representante r inner join r.pessoa p inner join UsuarioBasico u on (u.pessoa = p) inner join u.usuario uu where uu.identificador=:idUsuario";
        org.hibernate.query.Query q = this.query(query);
        q.setParameter("idUsuario", (Object)idUsuario);
        return (Representante)this.toUnique((Query)q);
    }

    public Representante findByEmpresa(Long idEmpresa) {
        String query = "select r from Representante r inner join r.pessoa p inner join Empresa e on (e.pessoa = p) where e.identificador=:idEmpresa";
        org.hibernate.query.Query q = this.query(query);
        q.setParameter("idEmpresa", (Object)idEmpresa);
        return (Representante)this.toUnique((Query)q);
    }
}

