/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IntegracaoRequisicaoEspecie;
import com.touchcomp.basementor.model.vo.IntegracaoRequisicaoNaturezaRequisicao;
import com.touchcomp.basementor.model.vo.IntegracaoRequisicaoSubespecie;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.touchvomodel.vo.lotefabricacao.web.DTORastreioLoteFabricacao;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Repository;

@Repository
public class DaoRequisicaoImpl
extends DaoGenericEntityImpl<Requisicao, Long> {
    public List<Requisicao> getRequisicosPorPeriodo(Date dataInicial, Date dataFinal, List<IntegracaoRequisicaoEspecie> especies, List<IntegracaoRequisicaoSubespecie> subespecies, Empresa empresa, List<IntegracaoRequisicaoNaturezaRequisicao> naturezasRequisicao) {
        Criteria c = this.criteria();
        c.createAlias("empresa", "e");
        c.createAlias("e.empresaDados", "ed");
        c.createAlias("itensRequisicao", "i");
        c.createAlias("i.produto", "p");
        c.add(Restrictions.between((String)"dataRequisicao", (Object)dataInicial, (Object)dataFinal));
        c.add((Criterion)Restrictions.eq((String)"empresa", (Object)empresa));
        Disjunction subDis = Restrictions.or((Criterion[])new Criterion[0]);
        for (IntegracaoRequisicaoSubespecie integracaoRequisicaoSubespecie : subespecies) {
            subDis.add((Criterion)Restrictions.eq((String)"p.subEspecie", (Object)integracaoRequisicaoSubespecie.getSubEspecie()));
        }
        c.add((Criterion)subDis);
        Disjunction espDis = Restrictions.or((Criterion[])new Criterion[0]);
        for (IntegracaoRequisicaoEspecie especie : especies) {
            espDis.add((Criterion)Restrictions.eq((String)"p.especie", (Object)especie.getEspecie()));
        }
        c.add((Criterion)espDis);
        Disjunction disjunction = Restrictions.or((Criterion[])new Criterion[0]);
        for (IntegracaoRequisicaoNaturezaRequisicao nat : naturezasRequisicao) {
            disjunction.add((Criterion)Restrictions.eq((String)"i.naturezaRequisicao", (Object)nat.getNaturezaRequisicao()));
        }
        c.add((Criterion)disjunction);
        c.addOrder(Order.asc((String)"dataRequisicao"));
        c.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return c.list();
    }

    public void atualizarCustoMedio(Empresa empresa, Date dataInicial, Date dataFinal) {
        NativeQuery q = this.sqlQuery("execute procedure ATUALIZAR_PRECO_MEDIO_ITEM_REQ(:id_empresa,:data_inicial,:data_final)");
        q.setLong("id_empresa", empresa.getIdentificador().longValue());
        q.setDate("data_inicial", dataInicial);
        q.setDate("data_final", dataFinal);
        q.executeUpdate();
    }

    public List<DTORastreioLoteFabricacao> rastreioLotesRequisicao(Date dataInicial, Date dataFinal, List loteFabricacao, Long produtoInicial, Long produtoFinal) {
        Criteria c = this.criteria();
        c.createAlias("itensRequisicao", "i");
        c.createAlias("i.gradeItemRequisicao", "g");
        c.createAlias("g.loteFabricacao", "lf");
        c.createAlias("g.gradeCor", "gc");
        c.createAlias("gc.cor", "cor");
        c.createAlias("gc.produtoGrade", "pg");
        c.createAlias("pg.produto", "p");
        ProjectionList select = Projections.projectionList();
        select.add((Projection)Projections.property((String)"identificador"), "identificador");
        select.add((Projection)Projections.property((String)"dataRequisicao"), "dataEntradaSaida");
        select.add((Projection)Projections.property((String)"dataCadastro"), "dataCadastro");
        select.add((Projection)Projections.property((String)"g.quantidade"), "quantidade");
        select.add((Projection)Projections.property((String)"lf.loteFabricacao"), "loteFabricacao");
        select.add((Projection)Projections.property((String)"p.identificador"), "produtoIdentificador");
        select.add((Projection)Projections.property((String)"p.nome"), "produto");
        select.add((Projection)Projections.property((String)"cor.nome"), "cor");
        c.setProjection((Projection)select);
        if (dataInicial != null && dataFinal != null) {
            c.add(this.greatherEqual("dataRequisicao", dataInicial));
            c.add(this.lessEqual("dataRequisicao", dataFinal));
        }
        if (produtoInicial != null && produtoFinal != null) {
            c.add(this.greatherEqual("p.identificador", produtoInicial));
            c.add(this.lessEqual("p.identificador", produtoFinal));
        }
        c.add(this.in("lf.identificador", loteFabricacao));
        c.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(DTORastreioLoteFabricacao.class));
        return c.list();
    }
}

