/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.RamoAtividade;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.RotaClientePedido;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.vo.pedido.web.auxiliar.TempManutencaoSituacaoPedidos;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import org.springframework.stereotype.Repository;

@Repository
public class DaoRotaClientePedidoImpl
extends DaoGenericEntityImpl<RotaClientePedido, Long> {
    public List<TempManutencaoSituacaoPedidos> findManutencaoPed(RotaClientePedido rota, Representante representante, Transportador transportadorInicial, Transportador transportadorFinal, RamoAtividade ramoAtividadeInicial, RamoAtividade ramoAtividadeFinal, Long idPedidoCodBarras) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jRotaClientePedPed = aux.join("rotaClientePedidoPedido");
        Join jPedido = jRotaClientePedPed.join("pedido");
        Join jUnidadeFatCliente = jPedido.join("unidadeFatCliente");
        Join jSituacaoPedido = jPedido.join("situacaoPedido");
        Join jCliente = jUnidadeFatCliente.join("cliente");
        Join jFaturamento = jCliente.join("faturamento");
        Join jRamoAtividade = jFaturamento.join("ramoAtividade", JoinType.LEFT);
        Join jPessoa = jCliente.join("pessoa");
        Join jLiberacaoPedidoPed = jPedido.join("liberacaoPedidoPed", JoinType.LEFT);
        Join jTransportador = jPedido.join("transportador", JoinType.LEFT);
        aux.equal("identificador", rota.getIdentificador());
        if (representante != null) {
            aux.equal((From)jPedido, "representante", representante);
        }
        if (transportadorInicial != null && transportadorFinal != null) {
            aux.between((From)jTransportador, "identificador", transportadorInicial.getIdentificador(), (Comparable)transportadorFinal.getIdentificador());
        }
        if (ramoAtividadeInicial != null && ramoAtividadeFinal != null) {
            aux.between((From)jRamoAtividade, "identificador", ramoAtividadeInicial.getIdentificador(), (Comparable)ramoAtividadeFinal.getIdentificador());
        }
        if (!TMethods.isEquals((Object)idPedidoCodBarras, null) && !TMethods.isEquals((Object)idPedidoCodBarras, (Object)0L)) {
            aux.equal((From)jPedido, "identificador", idPedidoCodBarras);
        }
        aux.select(AuxCriteriaBuilder.pair((From)jPedido, "identificador", "ID_PEDIDO"), AuxCriteriaBuilder.pair((From)jPedido, "nrPedidoCliente", "NR_PEDIDO"), AuxCriteriaBuilder.pair((From)jCliente, "identificador", "ID_CLIENTE"), AuxCriteriaBuilder.pair((From)jPessoa, "nome", "NOME_CLIENTE"), AuxCriteriaBuilder.pair((From)jPedido, "dataPrevisaoSaida", "DATA_PREV_SAIDA"), AuxCriteriaBuilder.pair((From)jSituacaoPedido, "identificador", "ID_SITUACAO_PEDIDO"), AuxCriteriaBuilder.pair((From)jLiberacaoPedidoPed, "liberado", "LIBERADO"), AuxCriteriaBuilder.pair((From)jPedido, "dataPrevisaoFat", "DATA_PREV_FATURAMENTO"));
        List<Map<String, Object>> res = aux.getResultMap();
        LinkedList<TempManutencaoSituacaoPedidos> lista = new LinkedList<TempManutencaoSituacaoPedidos>();
        for (Map<String, Object> map : res) {
            TempManutencaoSituacaoPedidos temp = new TempManutencaoSituacaoPedidos();
            temp.setNrPedido((String)map.get("NR_PEDIDO"));
            temp.setNomeCliente((String)map.get("NOME_CLIENTE"));
            temp.setDataPrevSaida((Date)map.get("DATA_PREV_SAIDA"));
            temp.setDataPrevSaidaOld((Date)map.get("DATA_PREV_SAIDA"));
            temp.setIdentificador((Long)map.get("ID_PEDIDO"));
            temp.setIdentificadorCliente((Long)map.get("ID_CLIENTE"));
            temp.setIdentificadorSituacaoPedido((Long)map.get("ID_SITUACAO_PEDIDO"));
            temp.setLiberado((Short)map.get("LIBERADO"));
            temp.setDataPrevisaoFat((Date)map.get("DATA_PREV_FATURAMENTO"));
            lista.add(temp);
        }
        return lista;
    }
}

