/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.statusobjeto.EnumConstStatusObjeto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.RoteiroProducao;
import com.touchcomp.basementor.model.vo.TipoProducaoSped;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.sql.JoinType;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Repository;

@Repository
public class DaoRoteiroProducaoImpl
extends DaoGenericEntityImpl<RoteiroProducao, Long> {
    public List<Map<String, Object>> getFasesProdRoteiroMap(Long idRoteiro) {
        org.hibernate.query.Query q = this.query("select r.identificador as ID_ROTEIRO_PRODUCAO ,c.identificador as ID_CELULA_PRODUTIVA ,f.qtdePorHora as CAPACIDADE_PRODUTIVA ,f.qtdePorHora as CAPACIDADE_PRODUTIVA_ROTEIRO ,f.descricaoAuxiliar as FASE_PRODUTIVA ,f.qtdePorHora  as QTDE_POR_HORA ,c.descricao as CELULA from RoteiroProducao r  inner join r.fasesProdutivas f inner join f.celulaProdutiva c where r.identificador=:roteiro");
        q.setLong("roteiro", idRoteiro.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return this.toHashList((Query)q);
    }

    public RoteiroProducao getByIdGradeAtivo(Long idGradeCor) {
        org.hibernate.query.Query q = this.query("select r from RoteiroProducao r  inner join r.roteiroProducaoGrCor rp inner join rp.gradeCor gc where gc.identificador=:grade and r.ativo = :ativo order by r.identificador");
        q.setLong("grade", idGradeCor.longValue());
        q.setShort("ativo", (short)1);
        q.setMaxResults(1);
        return (RoteiroProducao)this.toUnique((Query)q);
    }

    public Long getIDRoteiroByIdGradeAtivo(Long idGradeCor) {
        org.hibernate.query.Query q = this.query("select r.identificador from RoteiroProducao r  inner join r.roteiroProducaoGrCor rp inner join rp.gradeCor gc where gc.identificador=:grade and r.ativo = :ativo order by r.identificador");
        q.setLong("grade", idGradeCor.longValue());
        q.setShort("ativo", (short)1);
        q.setMaxResults(1);
        return (Long)q.uniqueResult();
    }

    public RoteiroProducao get(TipoProducaoSped tipoProducaoSped, GradeCor gradeCor) {
        org.hibernate.query.Query q = this.query("select r from RoteiroProducao r  inner join r.roteiroProducaoGrCor rp inner join rp.gradeCor gc inner join r.tiposProducaoSped t inner join t.tipoProducaoSped ts where gc.identificador=:grade and r.ativo = :ativo and r.principal = :sim and ts = :tipo order by r.identificador");
        q.setLong("grade", gradeCor.getIdentificador().longValue());
        q.setShort("ativo", (short)1);
        q.setShort("sim", (short)1);
        q.setEntity("tipo", (Object)tipoProducaoSped);
        return (RoteiroProducao)this.toUnique((Query)q);
    }

    public RoteiroProducao getByCodProdRevisao(Long idProduto, String revisao) {
        Criteria c = this.criteria();
        c.createAlias("roteiroProducaoGrCor", "rgc");
        c.createAlias("rgc.gradeCor", "gc");
        c.createAlias("gc.produtoGrade", "pg");
        c.createAlias("pg.produto", "p");
        return (RoteiroProducao)this.toUnique(this.restrictions(c, this.eq("p.identificador", idProduto), this.eq("ativo", (short)1), this.eq("revisao", revisao)));
    }

    public RoteiroProducao getByCodProdRevisao(String codigoAuxiliar, String revisao) {
        Criteria c = this.criteria();
        c.createAlias("roteiroProducaoGrCor", "rgc");
        c.createAlias("rgc.gradeCor", "gc");
        c.createAlias("gc.produtoGrade", "pg");
        c.createAlias("pg.produto", "p");
        return (RoteiroProducao)this.toUnique(this.restrictions(c, this.eq("p.codigoAuxiliar", codigoAuxiliar), this.eq("ativo", (short)1), this.eq("revisao", revisao)));
    }

    public List<RoteiroProducao> getRoteiroByIdGradeAtivo(Long idGradeCor) {
        Criteria c = this.criteria();
        c.createAlias("roteiroProducaoGrCor", "rp");
        c.createAlias("rp.gradeCor", "gc");
        c.add(this.eq("gc.identificador", idGradeCor));
        c.add(this.eq("ativo", EnumConstantsMentorSimNao.SIM.getValue()));
        this.order(c, "identificador");
        return c.list();
    }

    public List<RoteiroProducao> findRoteirosProdAtivos(GradeCor gc, Empresa empresa) {
        Criteria c = this.criteria();
        if (gc.getProdutoGrade().getProduto().getGrupoProdutos() != null) {
            c.createAlias("roteiroProducaoGrCor", "rr", JoinType.LEFT_OUTER_JOIN);
            c.createAlias("grupoProdutos", "g", JoinType.LEFT_OUTER_JOIN);
            c.createAlias("g.grupoProdutos", "gp", JoinType.LEFT_OUTER_JOIN);
            c.add(this.or(this.eq("rr.gradeCor", gc), this.eq("gp", gc.getProdutoGrade().getProduto().getGrupoProdutos())));
            c.add(this.eq("ativo", EnumConstStatusObjeto.ATIVO.getValue()));
            if (empresa != null) {
                c.add(this.eq("empresa", empresa));
            }
            this.orderDesc(c, "principal", "identificador");
        } else {
            c.createAlias("roteiroProducaoGrCor", "rr");
            c.add(this.eq("ativo", EnumConstStatusObjeto.ATIVO.getValue()));
            c.add(this.eq("rr.gradeCor", gc));
            if (empresa != null) {
                c.add(this.eq("empresa", empresa));
            }
            this.orderDesc(c, "principal", "identificador");
        }
        return c.list();
    }
}

