/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.modelorps.EnumConstStatusRPS;
import com.touchcomp.basementor.model.impl.DadosEstatisticosFaturamento;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemReinfNotas2020;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementor.model.vo.TomadorPrestadorRps;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.vo.centraldocsproprios.DTOCentralDocsPropriosNFSe;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Repository;

@Repository
public class DaoRpsImpl
extends DaoGenericEntityImpl<Rps, Long> {
    public DadosEstatisticosFaturamento getMaiorFaturamentoRps(TomadorPrestadorRps toma) {
        Query q = this.query(" select  r.valorLiquidoNfse as VALOR_NOTA_MAIOR_FATURA,  r.numeroNFse as NUMERO_NOTA_MAIOR_FATURA,  r.serie as SERIE_NOTA_MAIOR_FATURA,  r.dataEmissao as DATA_NOTA_MAIOR_FATURA  from Rps r  where  r.valorLiquidoNfse = (select max(r2.valorLiquidoNfse)  from Rps r2  where  r2.unidadeTomPrestRPS.tomadorPrestadorRPS = :tomador ) and r.unidadeTomPrestRPS.tomadorPrestadorRPS = :tomador");
        q.setEntity("tomador", (Object)toma);
        q.setMaxResults(1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        q.setMaxResults(1);
        Map m = (Map)q.uniqueResult();
        if (m != null) {
            DadosEstatisticosFaturamento e = new DadosEstatisticosFaturamento();
            e.setData((Date)m.get("DATA_NOTA_MAIOR_FATURA"));
            e.setValor((Double)m.get("VALOR_NOTA_MAIOR_FATURA"));
            e.setNumero(String.valueOf(m.get("NUMERO_NOTA_MAIOR_FATURA")));
            e.setSerie((String)m.get("SERIE_NOTA_MAIOR_FATURA"));
            return e;
        }
        return null;
    }

    public DadosEstatisticosFaturamento getUltimoFaturamentoRps(TomadorPrestadorRps toma) {
        Query q = this.query(" select  r.dataEmissao as DATA_EMISSAO_ULTIMA_NOTA, r.valorLiquidoNfse as VALOR_TOTAL_ULTIMA_FATURA,  r.numeroNFse as NUMERO_NOTA_ULTIMA_FATURA,  r.serie as SERIE_NOTA_ULTIMA_FATURA  from Rps r where  r.dataEmissao = (  select max(r2.dataEmissao)  from Rps r2  where r2.unidadeTomPrestRPS.tomadorPrestadorRPS = :tomador )");
        q.setEntity("tomador", (Object)toma);
        q.setMaxResults(1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        Map m = (Map)q.uniqueResult();
        if (m != null) {
            DadosEstatisticosFaturamento e = new DadosEstatisticosFaturamento();
            e.setData((Date)m.get("DATA_EMISSAO_ULTIMA_NOTA"));
            e.setValor((Double)m.get("VALOR_TOTAL_ULTIMA_FATURA"));
            e.setNumero(String.valueOf(m.get("NUMERO_NOTA_ULTIMA_FATURA")));
            e.setSerie((String)m.get("SERIE_NOTA_ULTIMA_FATURA"));
            return e;
        }
        return null;
    }

    public DadosEstatisticosFaturamento getPrimeiroFaturamentoRps(TomadorPrestadorRps toma) {
        Query q = this.query(" select  r.dataEmissao as DATA_EMISSAO_ULTIMA_NOTA, r.valorLiquidoNfse as VALOR_TOTAL_ULTIMA_FATURA,  r.numeroNFse as NUMERO_NOTA_ULTIMA_FATURA,  r.serie as SERIE_NOTA_ULTIMA_FATURA  from Rps r where  r.dataEmissao = (  select min(r2.dataEmissao)  from Rps r2  where r2.unidadeTomPrestRPS.tomadorPrestadorRPS = :tomador )");
        q.setEntity("tomador", (Object)toma);
        q.setMaxResults(1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        Map m = (Map)q.uniqueResult();
        if (m != null) {
            DadosEstatisticosFaturamento e = new DadosEstatisticosFaturamento();
            e.setData((Date)m.get("DATA_EMISSAO_ULTIMA_NOTA"));
            e.setValor((Double)m.get("VALOR_TOTAL_ULTIMA_FATURA"));
            e.setNumero(String.valueOf(m.get("NUMERO_NOTA_ULTIMA_FATURA")));
            e.setSerie((String)m.get("SERIE_NOTA_ULTIMA_FATURA"));
            return e;
        }
        return null;
    }

    public List<Rps> buscarRpsNoPeriodo(Date dataInicial, Date dataFinal) {
        String sql = "select distinct r from Rps r where r.dataEmissao between :dataInicial and :dataFinal and r.numeroNFse > 0 and r.status = :normal";
        Query query = this.query(sql);
        query.setParameter("dataInicial", (Object)dataInicial);
        query.setParameter("dataFinal", (Object)dataFinal);
        query.setParameter("normal", (Object)EnumConstStatusRPS.RPS_NORMAL.getValue());
        return query.getResultList();
    }

    public List<DTOCentralDocsPropriosNFSe> getNotasPropriasServico(Integer regsPerPage, Integer page, GrupoEmpresa grupoEmpresa, Pessoa pessoa, Short filtrarData, Date dataIn, Date dataFim, Short filtrarNr, Long numero) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jEmpresa = aux.join("empresa");
        Join jEmpresaDados = aux.join((From)jEmpresa, "empresaDados");
        Join jEmpresaPessoa = aux.join((From)jEmpresa, "pessoa");
        Join jEmpresaPessoaComp = aux.join((From)jEmpresaPessoa, "complemento");
        Join jUnidadeFatTomador = aux.join("unidadeTomPrestRPS");
        Join jTomador = aux.join((From)jUnidadeFatTomador, "tomadorPrestadorRPS");
        Join jTomadorPessoa = aux.join((From)jTomador, "pessoa");
        Join jTomadorPessoaComp = aux.join((From)jTomadorPessoa, "complemento");
        aux.equal((From)jEmpresaDados, "grupoEmpresa", grupoEmpresa);
        aux.equal((From)jTomador, "pessoa", pessoa);
        aux.equal("status", (short)1);
        aux.gt("numeroNFse", Long.valueOf(0L));
        if (TMethods.isAffirmative((Number)filtrarData)) {
            aux.between("dataEmissao", dataIn, (Comparable)ToolDate.getLastDateOnDay((Date)dataFim));
        }
        if (TMethods.isAffirmative((Number)filtrarNr)) {
            aux.equal("numeroNFse", numero);
        }
        aux.setMaxResults(regsPerPage);
        aux.setFirstResult(page * regsPerPage);
        aux.orderDesc("dataEmissao");
        aux.select(AuxCriteriaBuilder.pair("identificador", "F_ID_NOTA_PROPRIA"), AuxCriteriaBuilder.pair("numero", "F_NUMERO"), AuxCriteriaBuilder.pair("serie", "F_SERIE"), AuxCriteriaBuilder.pair("dataEmissao", "F_DATA_EMISSAO"), AuxCriteriaBuilder.pair("numeroNFse", "F_NUMERO_NFSE"), AuxCriteriaBuilder.pair("status", "F_STATUS"), AuxCriteriaBuilder.pair("valorServico", "F_VALOR"), AuxCriteriaBuilder.pair((From)jEmpresaPessoa, "nome", "F_EMITENTE"), AuxCriteriaBuilder.pair((From)jEmpresaPessoa, "nomeFantasia", "F_EMITENTE_NOME_FANTASIA"), AuxCriteriaBuilder.pair((From)jEmpresaPessoaComp, "cnpj", "F_CNPJ_EMITENTE"), AuxCriteriaBuilder.pair((From)jTomadorPessoa, "nome", "F_DESTINATARIO"), AuxCriteriaBuilder.pair((From)jTomadorPessoa, "nomeFantasia", "F_DEST_NOME_FANTASIA"), AuxCriteriaBuilder.pair((From)jTomadorPessoaComp, "cnpj", "F_CNPJ_DESTINATARIO"));
        List<Map<String, Object>> res = aux.getResultMap();
        LinkedList<DTOCentralDocsPropriosNFSe> ret = new LinkedList<DTOCentralDocsPropriosNFSe>();
        for (Map<String, Object> map : res) {
            DTOCentralDocsPropriosNFSe d = new DTOCentralDocsPropriosNFSe();
            d.setIdentificador((Long)map.get("F_ID_NOTA_PROPRIA"));
            d.setNumeroDoc((Number)map.get("F_NUMERO"));
            d.setSerieDoc((String)map.get("F_SERIE"));
            d.setDataEmissao((Date)map.get("F_DATA_EMISSAO"));
            d.setNumeroNFSe((Number)((Long)map.get("F_NUMERO_NFSE")));
            d.setValor((Double)map.get("F_VALOR"));
            d.setEmitente((String)map.get("F_EMITENTE"));
            d.setCnpjEmitente((String)map.get("F_CNPJ_EMITENTE"));
            d.setEmitenteNomeFantasia((String)map.get("F_EMITENTE_NOME_FANTASIA"));
            d.setCnpjTomador((String)map.get("F_CNPJ_DESTINATARIO"));
            d.setTomador((String)map.get("F_DESTINATARIO"));
            d.setTomadorNomeFantasia((String)map.get("F_DEST_NOME_FANTASIA"));
            d.setStatusSefaz((Short)map.get("F_STATUS"));
            d.setStatusSefazStr((String)map.get("F_STATUS_STR"));
            ret.add(d);
        }
        return ret;
    }

    public Rps findByNumeroAndSerie(Long numero, String serie) {
        return (Rps)this.toUnique(this.restrictions(this.eq("numero", numero), this.eq("serie", serie)));
    }

    public Rps findByNumeroNFSe(Long numeroNFse) {
        return (Rps)this.toUnique(this.restrictions(this.eq("numeroNFse", numeroNFse)));
    }

    public List<Rps> findNotasNaoApuradasReinf2020(GrupoEmpresa grupo, Date periodo, Boolean filtrarNotasRetidas) {
        CriteriaBuilder builder = this.criteriaBuilder(Rps.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root root = crit.from(Rps.class);
        Join jEmpresa = root.join("empresa", JoinType.INNER);
        Join jEmpresaDados = jEmpresa.join("empresaDados", JoinType.INNER);
        exps.add(builder.equal((Expression)jEmpresaDados.get("grupoEmpresa"), (Object)grupo));
        exps.add(builder.between((Expression)root.get("dataEmissao"), (Comparable)ToolDate.getDataInicial((Date)periodo), (Comparable)ToolDate.getDataFinal((Date)periodo)));
        exps.add(builder.notEqual((Expression)root.get("status"), (Object)2));
        if (filtrarNotasRetidas.booleanValue()) {
            exps.add(builder.greaterThan((Expression)root.get("valorInss"), (Comparable)Double.valueOf(0.0)));
        }
        Subquery subqueryReinf = crit.subquery(ItemReinfNotas2020.class);
        Root fromItemReinf = subqueryReinf.from(ItemReinfNotas2020.class);
        Join jRps = fromItemReinf.join("rps", JoinType.INNER);
        subqueryReinf.where((Expression)builder.equal((Expression)jRps.get("identificador"), (Expression)root.get("identificador")));
        subqueryReinf.select((Expression)fromItemReinf);
        exps.add(builder.not((Expression)builder.exists(subqueryReinf)));
        crit.select((Selection)root);
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }
}

