/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.SaidaNotas;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.Date;
import java.util.List;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoSaidaNotasImpl
extends DaoGenericEntityImpl<SaidaNotas, Long> {
    public SaidaNotas getSaidaNotasNaoIntegradasPorIdentificadorAndEmpresa(Long idSaida, Empresa empresa) {
        Query q = this.query(" select distinct s  from SaidaNotas n  where s.identificador = :idSaida  and s.empresa = :empresa and s.integradoEcommerce = :nao");
        q.setEntity("empresa", (Object)empresa);
        q.setLong("idSaida", idSaida.longValue());
        q.setShort("nao", (short)0);
        q.setMaxResults(1);
        return (SaidaNotas)q.uniqueResult();
    }

    public List<SaidaNotas> getSaidaNotasNaoIntegradasPorDataCadastroAndEmpresa(Date dataInicial, Date dataFinal, Empresa empresa) {
        Query q = this.query(" select distinct s  from SaidaNotas n  where s.dataCadastro between :dataInicial and :dataFinal  and s.empresa = :empresa  and s.integradoEcommerce = :nao");
        q.setEntity("empresa", (Object)empresa);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setShort("nao", (short)0);
        return q.list();
    }

    public List<SaidaNotas> getSaidaNotasNaoIntegradasPorEmpresa(Empresa empresa) {
        Query q = this.query(" select distinct s  from SaidaNotas n  where s.empresa = :empresa  and s.integradoEcommerce = :nao");
        q.setEntity("empresa", (Object)empresa);
        q.setShort("nao", (short)0);
        return q.list();
    }
}

