/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsNivelContaRet;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsOrdenacao;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsTipoSaldo;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsTipoSaldoNormalEnc;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsTipoSaldoRetorno;
import com.touchcomp.basementor.model.impl.SaldoContaContabil;
import com.touchcomp.basementorservice.dao.DaoGenericImpl;
import com.touchcomp.basementorservice.dao.resulttransformer.ResultTransfSaldoContabil;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Repository;

@Repository
public class DaoSaldoContaImpl
extends DaoGenericImpl {
    public List<SaldoContaContabil> findSaldosConta(Long idCentroResultadoInicial, Long idCentroResultadoFinal, String contaInicial, String contaFinal, Date dataInicial, Date dataFinal, Long grupoEmpresa, EnumConstantsTipoSaldoRetorno tipoSaldoRet, EnumConstantsTipoSaldo tipoSaldo, EnumConstantsNivelContaRet nivel, EnumConstantsOrdenacao ordenacao) {
        return this.findSaldoContaContabilGeral(contaInicial, contaFinal, dataInicial, dataFinal, grupoEmpresa, idCentroResultadoInicial, idCentroResultadoFinal, tipoSaldo, tipoSaldoRet, nivel, new ResultTransfSaldoContabil(), ordenacao, EnumConstantsTipoSaldoNormalEnc.TIPO_SALDO_NORMAL);
    }

    public List<SaldoContaContabil> findSaldosContaEnc(Long idCentroResultadoInicial, Long idCentroResultadoFinal, String contaInicial, String contaFinal, Date dataInicial, Date dataFinal, Long grupoEmpresa, EnumConstantsTipoSaldoRetorno tipoSaldoRet, EnumConstantsTipoSaldo tipoSaldo, EnumConstantsNivelContaRet nivel, EnumConstantsOrdenacao ordenacao) {
        return this.findSaldoContaContabilGeral(contaInicial, contaFinal, dataInicial, dataFinal, grupoEmpresa, idCentroResultadoInicial, idCentroResultadoFinal, tipoSaldo, tipoSaldoRet, nivel, new ResultTransfSaldoContabil(), ordenacao, EnumConstantsTipoSaldoNormalEnc.TIPO_SALDO_ENCERRAMENTO);
    }

    public List<SaldoContaContabil> findSaldosContaEncerramento(Long idCentroResultadoInicial, Long idCentroResultadoFinal, String contaInicial, String contaFinal, Date dataEncerramento, Long grupoEmpresa, EnumConstantsTipoSaldoRetorno tipoSaldoRet, EnumConstantsTipoSaldo tipoSaldo, EnumConstantsNivelContaRet nivel, EnumConstantsOrdenacao ordenacao) {
        return this.findSaldoContaContabilGeral(contaInicial, contaFinal, dataEncerramento, dataEncerramento, grupoEmpresa, idCentroResultadoInicial, idCentroResultadoFinal, tipoSaldo, tipoSaldoRet, nivel, new ResultTransfSaldoContabil(), ordenacao, EnumConstantsTipoSaldoNormalEnc.TIPO_SALDO_ENCERRAMENTO);
    }

    public List<Map> findSaldosContaMap(Long idCentroResultadoInicial, Long idCentroResultadoFinal, String contaInicial, String contaFinal, Date dataInicial, Date dataFinal, Long grupoEmpresa, EnumConstantsTipoSaldoRetorno tipoSaldoRet, EnumConstantsTipoSaldo tipoSaldo, EnumConstantsNivelContaRet nivel, EnumConstantsOrdenacao ordenacao) {
        return this.findSaldoContaContabilGeral(contaInicial, contaFinal, dataInicial, dataFinal, grupoEmpresa, idCentroResultadoInicial, idCentroResultadoFinal, tipoSaldo, tipoSaldoRet, nivel, new ResultTransfSaldoContabil(), ordenacao, EnumConstantsTipoSaldoNormalEnc.TIPO_SALDO_NORMAL);
    }

    public List<Map> findSaldosContaMapEncerramento(Long idCentroResultadoInicial, Long idCentroResultadoFinal, String contaInicial, String contaFinal, Date dataEncerramento, Long grupoEmpresa, EnumConstantsTipoSaldoRetorno tipoSaldoRetorno, EnumConstantsTipoSaldo tipoSaldo, EnumConstantsNivelContaRet nivel, EnumConstantsOrdenacao ordenacao) {
        return this.findSaldoContaContabilGeral(contaInicial, contaFinal, dataEncerramento, dataEncerramento, grupoEmpresa, idCentroResultadoInicial, idCentroResultadoFinal, tipoSaldo, tipoSaldoRetorno, nivel, new ResultTransfSaldoContabil(), ordenacao, EnumConstantsTipoSaldoNormalEnc.TIPO_SALDO_ENCERRAMENTO);
    }

    public SaldoContaContabil findSaldoContaUnica(Long idCentroResultadoInicial, Long idCentroResultadoFinal, String contaContabil, Date dataInicial, Date dataFinal, Long grupoEmpresa, EnumConstantsTipoSaldo tipoSaldo) {
        List<SaldoContaContabil> saldos = this.findSaldoContaContabilGeral(contaContabil, contaContabil, dataInicial, dataFinal, grupoEmpresa, idCentroResultadoInicial, idCentroResultadoFinal, tipoSaldo, EnumConstantsTipoSaldoRetorno.TODOS_SALDOS, EnumConstantsNivelContaRet.TODOS_NIVEIS_CONTAS, null);
        SaldoContaContabil res = null;
        if (saldos != null && saldos.size() > 0) {
            res = saldos.get(0);
        }
        if (res == null) {
            res = new SaldoContaContabil();
        }
        return res;
    }

    private List<SaldoContaContabil> findSaldoContaContabilGeral(String contaInicial, String contaFinal, Date dataInicial, Date dataFinal, Long identificador, Long idCentroResultadoInicial, Long idCentroResultadoFinal, EnumConstantsTipoSaldo tipoSaldo, EnumConstantsTipoSaldoRetorno tipoSaldoRet, EnumConstantsNivelContaRet nivel, EnumConstantsOrdenacao ordenacao) {
        return this.findSaldoContaContabilGeral(contaInicial, contaFinal, dataInicial, dataFinal, identificador, idCentroResultadoInicial, idCentroResultadoFinal, tipoSaldo, tipoSaldoRet, nivel, new ResultTransfSaldoContabil(), ordenacao, EnumConstantsTipoSaldoNormalEnc.TIPO_SALDO_NORMAL);
    }

    private List<SaldoContaContabil> findSaldoContaContabilGeralEncerramento(String contaInicial, String contaFinal, Date dataEncerramento, Long identificador, Long idCentroResultadoInicial, Long idCentroResultadoFinal, EnumConstantsTipoSaldo tipoSaldo, EnumConstantsTipoSaldoRetorno tipoSaldoRet, EnumConstantsNivelContaRet nivel, EnumConstantsOrdenacao ordenacao) {
        return this.findSaldoContaContabilGeral(contaInicial, contaFinal, dataEncerramento, dataEncerramento, identificador, idCentroResultadoInicial, idCentroResultadoFinal, tipoSaldo, tipoSaldoRet, nivel, new ResultTransfSaldoContabil(), ordenacao, EnumConstantsTipoSaldoNormalEnc.TIPO_SALDO_ENCERRAMENTO);
    }

    public SaldoContaContabil findSaldoContaUnicaEncerramento(Long idCentroResultadoInicial, Long idCentroResultadoFinal, String contaContabil, Date dataEncerramento, Long grupoEmpresa, EnumConstantsTipoSaldo tipoSaldo) {
        List<SaldoContaContabil> saldos = this.findSaldoContaContabilGeralEncerramento(contaContabil, contaContabil, dataEncerramento, grupoEmpresa, idCentroResultadoInicial, idCentroResultadoFinal, tipoSaldo, EnumConstantsTipoSaldoRetorno.TODOS_SALDOS, EnumConstantsNivelContaRet.TODOS_NIVEIS_CONTAS, null);
        SaldoContaContabil res = null;
        if (saldos != null && saldos.size() > 0) {
            res = saldos.get(0);
        }
        if (res == null) {
            res = new SaldoContaContabil();
        }
        return res;
    }

    private List findSaldoContaContabilGeral(String codContaInicial, String codContaFinal, Date dataIn, Date dataFim, Long idGrupoEmpresa, Long idCentroResultadoInicial, Long idCentroResultadoFinal, EnumConstantsTipoSaldo tipoSaldoPorContaCentroRes, EnumConstantsTipoSaldoRetorno tipoSaldoRet, EnumConstantsNivelContaRet nivelRet, ResultTransformer rs, EnumConstantsOrdenacao ordenacao, EnumConstantsTipoSaldoNormalEnc tipoSaldoNormalEnc) {
        if (dataIn == null) {
            dataIn = new Date();
        }
        if (dataFim == null) {
            dataFim = new Date();
        }
        if (tipoSaldoPorContaCentroRes == null) {
            tipoSaldoPorContaCentroRes = EnumConstantsTipoSaldo.TIPO_SALDO_GERAL;
        }
        if (tipoSaldoRet == null) {
            tipoSaldoRet = EnumConstantsTipoSaldoRetorno.TODOS_SALDOS;
        }
        if (nivelRet == null) {
            nivelRet = EnumConstantsNivelContaRet.TODOS_NIVEIS_CONTAS;
        }
        if (ordenacao == null) {
            ordenacao = EnumConstantsOrdenacao.ORDEM_NUMERICA;
        }
        Object query = "   select s.r_id_plano_conta as ID_PLANO_CONTA,     s.r_cod_conta         as COD,     s.r_descricao_conta   as DESCRICAO_CONTA,     s.r_marca             as MARCA,     s.r_saldo_anterior    as SALDO_ANTERIOR,     s.r_valor_debito      as VALOR_DEBITO,     s.r_valor_credito     as VALOR_CREDITO,     s.r_saldo_atual       as SALDO_ATUAL,     s.R_COD_NAT_PLANO_CONTA COD_NAT_PLANO_CONTA,     s.R_REDUZIDA          as REDUZIDA from proc_saldo_contabil(     :p_cod_inicial,     :p_cod_final,     :p_data_inicial,     :p_data_final,     :p_id_grupo_empresa_in,     :p_id_grupo_empresa_final,     :p_id_centro_resultado_in,     :p_id_centro_resultado_fim,     :p_tipo_saldo,     :p_tipo_ret_saldo,     :P_NIVEL_RET_CONTA,     :p_tipo_saldo_normal_enc) s ";
        query = ordenacao == EnumConstantsOrdenacao.ORDEM_ALFABETICA ? (String)query + " order by s.r_descricao_conta" : (String)query + " order by s.r_cod_conta";
        NativeQuery q = this.sqlQuery((String)query);
        q.setParameter("p_cod_inicial", (Object)codContaInicial);
        q.setParameter("p_cod_final", (Object)codContaFinal);
        q.setDate("p_data_inicial", (Date)new java.sql.Date(dataIn.getTime()));
        q.setDate("p_data_final", (Date)new java.sql.Date(dataFim.getTime()));
        q.setLong("p_id_grupo_empresa_in", idGrupoEmpresa.longValue());
        q.setLong("p_id_grupo_empresa_final", idGrupoEmpresa.longValue());
        q.setParameter("p_id_centro_resultado_in", (Object)idCentroResultadoInicial);
        q.setParameter("p_id_centro_resultado_fim", (Object)idCentroResultadoFinal);
        q.setInteger("p_tipo_saldo", tipoSaldoPorContaCentroRes.getValue());
        q.setInteger("p_tipo_ret_saldo", tipoSaldoRet.getValue());
        q.setInteger("P_NIVEL_RET_CONTA", nivelRet.getValue());
        q.setInteger("p_tipo_saldo_normal_enc", tipoSaldoNormalEnc.getValue());
        q.setResultTransformer(rs);
        return q.list();
    }
}

