/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.produto.EnumConstTipoProdutoEntradaSaida;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoCarregQtdeVlr;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldo;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldoQtde;
import com.touchcomp.basementor.constants.enums.situacaodocumento.EnumConstSituacaoDocumento;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeral;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeralBasico;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeralDetBasico;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.ClassificacaoAnaliseEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Especie;
import com.touchcomp.basementor.model.vo.Fabricante;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GrupoAnaliseEstoqueGC;
import com.touchcomp.basementor.model.vo.GrupoProdutos;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.SubEspecie;
import com.touchcomp.basementorservice.dao.DaoGenericImpl;
import com.touchcomp.basementorservice.dao.resulttransformer.SaldoBasicoDetResultTransformer;
import com.touchcomp.basementorservice.dao.resulttransformer.SaldoBasicoResultTransformer;
import com.touchcomp.basementorservice.dao.resulttransformer.SaldoResultTransformer;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.SaldoEstoqueParams;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Repository;

@Repository
public class DaoSaldoEstoqueImpl
extends DaoGenericImpl {
    private SaldoResultTransformer saldoResultTransformer;
    private SaldoBasicoResultTransformer saldoBasicoResultTransformer;

    public List<SaldoEstoqueGeral> getSaldoProdutoPorGradePorQtdeMaxMinRessuprimento(java.util.Date data, Long produtoInicial, Long produtoFinal, Long especieInicial, Long especieFinal, Long subEspecieInicial, Long subEspecieFinal, Long centroEstInicial, Long centroEstFinal, Long fabricanteInicial, Long fabricanteFinal, Long localizacaoInicial, Long localizacaoFinal, Integer tipoProdutoInicial, Integer tipoProdutoFinal, Short tipoPesquisa, Long idEmpresa, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoquePropTerc, Long idParceiro) {
        HashMap<String, Long> paramsAdic = new HashMap<String, Long>();
        paramsAdic.put("ID_ESPECIE_INICIAL", especieInicial);
        paramsAdic.put("ID_ESPECIE_FINAL", especieFinal);
        paramsAdic.put("ID_SUB_ESPECIE_INICIAL", subEspecieInicial);
        paramsAdic.put("ID_SUB_ESPECIE_FINAL", subEspecieFinal);
        paramsAdic.put("ID_LOCALIZACAO_INICIAL", localizacaoInicial);
        paramsAdic.put("ID_LOCALIZACAO_FINAL", localizacaoFinal);
        paramsAdic.put("ID_FABRICANTE_INICIAL", fabricanteInicial);
        paramsAdic.put("ID_FABRICANTE_FINAL", fabricanteFinal);
        List saldos = this.findSaldoEstoqueGeral(tipoProdutoInicial, tipoProdutoFinal, produtoInicial, produtoFinal, data, idEmpresa, idEmpresa, centroEstInicial, centroEstFinal, 0L, 9999999L, null, tipoSaldo, tipoQtde, tipoCarregamento, paramsAdic, tipoDisponibilidade, tipoEstoqueCentroEstoquePropTerc, idParceiro, this.getSaldoResultTransformer(), null, null);
        ArrayList<SaldoEstoqueGeral> lista = new ArrayList<SaldoEstoqueGeral>();
        if (saldos != null) {
            saldos.forEach(s -> {
                Double saldoQuantidade = s.getQuantidade();
                Produto p = s.getGradeCor().getProdutoGrade().getProduto();
                if (tipoPesquisa != null && tipoPesquisa == 0 && saldoQuantidade < p.getQtdMax()) {
                    lista.add((SaldoEstoqueGeral)s);
                } else if (tipoPesquisa != null && tipoPesquisa == 4 && saldoQuantidade > p.getQtdMax()) {
                    lista.add((SaldoEstoqueGeral)s);
                } else if (tipoPesquisa != null && tipoPesquisa == 1 && saldoQuantidade < p.getQtdMin()) {
                    lista.add((SaldoEstoqueGeral)s);
                } else if (tipoPesquisa != null && tipoPesquisa == 2) {
                    lista.add((SaldoEstoqueGeral)s);
                } else if (saldoQuantidade < p.getPontoRessupEstoque()) {
                    lista.add((SaldoEstoqueGeral)s);
                }
            });
        }
        return lista;
    }

    public List<SaldoEstoqueGeral> getSaldoProdutoPorGradeGrupoAnaliseEstoquePorQtdeMaxMinRessuprimento(java.util.Date dataSaldo, Long produtoInicial, Long produtoFinal, Long especieInicial, Long especieFinal, Long subEspecieInicial, Long subEspecieFinal, Long centroEstInicial, Long centroEstFinal, Long fabricanteInicial, Long fabricanteFinal, Long localizacaoInicial, Long localizacaoFinal, Integer tipoProdutoInicial, Integer tipoProdutoFinal, Short tipoPesquisa, Long idEmpresa, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoquePropTerc, Long idParceiro) {
        HashMap<String, Long> paramsAdic = new HashMap<String, Long>();
        paramsAdic.put("ID_ESPECIE_INICIAL", especieInicial);
        paramsAdic.put("ID_ESPECIE_FINAL", especieFinal);
        paramsAdic.put("ID_SUB_ESPECIE_INICIAL", subEspecieInicial);
        paramsAdic.put("ID_SUB_ESPECIE_FINAL", subEspecieFinal);
        paramsAdic.put("ID_LOCALIZACAO_INICIAL", localizacaoInicial);
        paramsAdic.put("ID_LOCALIZACAO_FINAL", localizacaoFinal);
        paramsAdic.put("ID_FABRICANTE_INICIAL", fabricanteInicial);
        paramsAdic.put("ID_FABRICANTE_FINAL", fabricanteFinal);
        List saldos = this.findSaldoEstoqueGeral(tipoProdutoInicial, tipoProdutoFinal, produtoInicial, produtoFinal, dataSaldo, idEmpresa, idEmpresa, centroEstInicial, centroEstFinal, 0L, 9999999L, null, tipoSaldo, tipoQtde, tipoCarregamento, paramsAdic, tipoDisponibilidade, tipoEstoqueCentroEstoquePropTerc, idParceiro, this.getSaldoResultTransformer(), null, null);
        ArrayList<SaldoEstoqueGeral> lista = new ArrayList<SaldoEstoqueGeral>();
        if (saldos != null) {
            saldos.forEach(s -> {
                Double saldoQuantidade = s.getQuantidade();
                GrupoAnaliseEstoqueGC grupoAnalise = this.findGrupoAnaliseEstoquePorGradeCor(s.getGradeCor());
                if (grupoAnalise != null) {
                    s.getGradeCor().getProdutoGrade().getProduto().setQtdMax(grupoAnalise.getEstoqueMaximo());
                    s.getGradeCor().getProdutoGrade().getProduto().setQtdMin(grupoAnalise.getEstoqueMinimo());
                    s.getGradeCor().getProdutoGrade().getProduto().setPontoRessupEstoque(grupoAnalise.getEstoqueRessuprimento());
                    if (tipoPesquisa != null && tipoPesquisa == 0 && (grupoAnalise.getEstoqueMaximo() == null || saldoQuantidade < grupoAnalise.getEstoqueMaximo())) {
                        lista.add((SaldoEstoqueGeral)s);
                    } else if (tipoPesquisa != null && tipoPesquisa == 4 && (grupoAnalise.getEstoqueMaximo() == null || saldoQuantidade > grupoAnalise.getEstoqueMaximo())) {
                        lista.add((SaldoEstoqueGeral)s);
                    } else if (tipoPesquisa != null && tipoPesquisa == 1 && (grupoAnalise.getEstoqueMinimo() == null || saldoQuantidade < grupoAnalise.getEstoqueMinimo())) {
                        lista.add((SaldoEstoqueGeral)s);
                    } else if (tipoPesquisa != null && tipoPesquisa == 2) {
                        lista.add((SaldoEstoqueGeral)s);
                    } else if (grupoAnalise.getEstoqueRessuprimento() == null || saldoQuantidade < grupoAnalise.getEstoqueRessuprimento()) {
                        lista.add((SaldoEstoqueGeral)s);
                    }
                }
            });
        }
        return lista;
    }

    private GrupoAnaliseEstoqueGC findGrupoAnaliseEstoquePorGradeCor(GradeCor gradeCor) {
        String query = "from GrupoAnaliseEstoqueGC g where g.gradeCor = :gradeCor";
        NativeQuery q = this.sqlQuery(query);
        q.setEntity("gradeCor", (Object)gradeCor);
        q.setMaxResults(1);
        return (GrupoAnaliseEstoqueGC)q.uniqueResult();
    }

    public List<LoteFabricacao> findLotesAbertos(Produto p, GradeCor g, Empresa e, EnumConstCentroEstTipoPropTerc tipoCentroEstoquePropTerc) {
        if (p == null && g != null) {
            p = g.getProdutoGrade().getProduto();
        }
        Long idProduto = p != null ? p.getIdentificador() : null;
        Long idGrade = g != null ? g.getIdentificador() : null;
        Long idEmpresa = e != null ? e.getIdentificador() : null;
        List<SaldoEstoqueGeral> saldos = this.findSaldoProdutoPorGradeCentroEstoqueLoteLista(idProduto, idProduto, new java.util.Date(), idEmpresa, idEmpresa, null, null, idGrade, idGrade, null, EnumConstSaldoEstTipoSaldo.TIPO_SALDO_LOTE_FABRICACAO, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_MAIOR_0, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_SOMENTE_QTD, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS, tipoCentroEstoquePropTerc, null);
        ArrayList<LoteFabricacao> lotes = new ArrayList<LoteFabricacao>();
        if (saldos != null) {
            saldos.stream().filter(s -> s.getLoteFabricacao() != null).forEachOrdered(s -> lotes.add(s.getLoteFabricacao()));
        }
        return lotes;
    }

    public LoteFabricacao findMelhorLote(GradeCor g, java.util.Date data, Empresa e, EnumConstCentroEstTipoPropTerc tipoCentroEstoquePropTerc) {
        Long idGrade;
        Long idEmpresa;
        Long idProduto = g != null ? g.getProdutoGrade().getProduto().getIdentificador() : null;
        SaldoEstoqueGeral s = this.findSaldoProdutoPorGradeCentroEstoqueLoteUnico(idProduto, idProduto, data, idEmpresa = e != null ? e.getIdentificador() : null, idEmpresa, null, null, idGrade = g != null ? g.getIdentificador() : null, idGrade, null, EnumConstSaldoEstTipoSaldo.TIPO_SALDO_LOTE_FABRICACAO, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_MAIOR_0, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_SOMENTE_QTD, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS, tipoCentroEstoquePropTerc, null);
        if (s != null && s.getLoteFabricacao() != null) {
            return s.getLoteFabricacao();
        }
        s = this.findSaldoProdutoPorGradeCentroEstoqueLoteUnico(idProduto, idProduto, data, idEmpresa, idEmpresa, null, null, idGrade, idGrade, null, EnumConstSaldoEstTipoSaldo.TIPO_SALDO_LOTE_FABRICACAO, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_TUDO, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_SOMENTE_QTD, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS, tipoCentroEstoquePropTerc, null);
        if (s != null && s.getLoteFabricacao() != null) {
            return s.getLoteFabricacao();
        }
        return null;
    }

    public LoteFabricacao findMelhorLotePorCentroEstoque(GradeCor g, java.util.Date data, Empresa e, CentroEstoque c, EnumConstCentroEstTipoPropTerc tipoCentroEstPropTerc) {
        Long idGrade;
        Long idCentroEstoque;
        Long idEmpresa;
        Long idProduto = g != null ? g.getProdutoGrade().getProduto().getIdentificador() : null;
        SaldoEstoqueGeral s = this.findSaldoProdutoPorGradeCentroEstoqueLoteUnico(idProduto, idProduto, data, idEmpresa = e != null ? e.getIdentificador() : null, idEmpresa, idCentroEstoque = c != null ? c.getIdentificador() : null, idCentroEstoque, idGrade = g != null ? g.getIdentificador() : null, idGrade, null, EnumConstSaldoEstTipoSaldo.TIPO_SALDO_LOTE_FABRICACAO, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_MAIOR_0, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_SOMENTE_QTD, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS, tipoCentroEstPropTerc, null);
        if (s != null && s.getLoteFabricacao() != null) {
            return s.getLoteFabricacao();
        }
        s = this.findSaldoProdutoPorGradeCentroEstoqueLoteUnico(idProduto, idProduto, data, idEmpresa, idEmpresa, idCentroEstoque, idCentroEstoque, idGrade, idGrade, null, EnumConstSaldoEstTipoSaldo.TIPO_SALDO_LOTE_FABRICACAO, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_TUDO, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_SOMENTE_QTD, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS, tipoCentroEstPropTerc, null);
        if (s != null && s.getLoteFabricacao() != null) {
            return s.getLoteFabricacao();
        }
        return null;
    }

    public List<LoteFabricacao> findLotes(Produto p, GradeCor g, Empresa e, EnumConstCentroEstTipoPropTerc tipoCentroEstoquePropTerc) {
        if (p == null && g != null) {
            p = g.getProdutoGrade().getProduto();
        }
        Long idProduto = p != null ? p.getIdentificador() : null;
        Long idGrade = g != null ? g.getIdentificador() : null;
        Long idEmpresa = e != null ? e.getIdentificador() : null;
        List<SaldoEstoqueGeral> saldos = this.findSaldoProdutoPorGradeCentroEstoqueLoteLista(idProduto, idProduto, new java.util.Date(), idEmpresa, idEmpresa, null, null, idGrade, idGrade, null, EnumConstSaldoEstTipoSaldo.TIPO_SALDO_LOTE_FABRICACAO, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_TUDO, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_SOMENTE_QTD, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS, tipoCentroEstoquePropTerc, null);
        ArrayList<LoteFabricacao> lotes = new ArrayList<LoteFabricacao>();
        if (saldos != null) {
            saldos.stream().filter(s -> s.getLoteFabricacao() != null && !lotes.contains(s.getLoteFabricacao())).forEachOrdered(s -> lotes.add(s.getLoteFabricacao()));
        }
        return lotes;
    }

    public List<LoteFabricacao> findLotesPorCentroEstoque(Produto produto, GradeCor gradeCor, Empresa empresa, CentroEstoque centroEstoque, EnumConstCentroEstTipoPropTerc tipoCentroEstPropTerc) {
        if (produto == null && gradeCor != null) {
            produto = gradeCor.getProdutoGrade().getProduto();
        }
        Long idProduto = produto != null ? produto.getIdentificador() : null;
        Long idGrade = gradeCor != null ? gradeCor.getIdentificador() : null;
        Long idEmpresa = empresa != null ? empresa.getIdentificador() : null;
        Long idCentroEstoque = centroEstoque != null ? centroEstoque.getIdentificador() : null;
        List<SaldoEstoqueGeral> saldos = this.findSaldoProdutoPorGradeCentroEstoqueLoteLista(idProduto, idProduto, new java.util.Date(), idEmpresa, idEmpresa, idCentroEstoque, idCentroEstoque, idGrade, idGrade, null, EnumConstSaldoEstTipoSaldo.TIPO_SALDO_LOTE_FABRICACAO, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_TUDO, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_SOMENTE_QTD, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS, tipoCentroEstPropTerc, null);
        ArrayList<LoteFabricacao> lotes = new ArrayList<LoteFabricacao>();
        if (saldos != null) {
            saldos.stream().filter(s -> s.getLoteFabricacao() != null).forEachOrdered(s -> lotes.add(s.getLoteFabricacao()));
        }
        return lotes;
    }

    public List<LoteFabricacao> findLotesAbertosPorCentroEstoque(Produto p, GradeCor g, Empresa e, CentroEstoque c, EnumConstCentroEstTipoPropTerc tipoCentroEstPropTerc) {
        if (p == null && g != null) {
            p = g.getProdutoGrade().getProduto();
        }
        Long idProduto = p != null ? p.getIdentificador() : null;
        Long idGrade = g != null ? g.getIdentificador() : null;
        Long idEmpresa = e != null ? e.getIdentificador() : null;
        Long idCentroEstoque = c != null ? c.getIdentificador() : null;
        List<SaldoEstoqueGeral> saldos = this.findSaldoProdutoPorGradeCentroEstoqueLoteLista(idProduto, idProduto, new java.util.Date(), idEmpresa, idEmpresa, idCentroEstoque, idCentroEstoque, idGrade, idGrade, null, EnumConstSaldoEstTipoSaldo.TIPO_SALDO_LOTE_FABRICACAO, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_MAIOR_0, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_SOMENTE_QTD, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS, tipoCentroEstPropTerc, null);
        ArrayList<LoteFabricacao> lotes = new ArrayList<LoteFabricacao>();
        if (saldos != null) {
            saldos.stream().filter(s -> s.getLoteFabricacao() != null).forEachOrdered(s -> lotes.add(s.getLoteFabricacao()));
        }
        return lotes;
    }

    public void reprocessarEstoque(java.util.Date dataBase, Long idProdInicial, Long idProdutoFinal) {
        NativeQuery q = this.sqlQuery("EXECUTE PROCEDURE PROCESSA_SALDO_ESTOQUE (:data,:id_inicial,:id_final)");
        q.setDate("data", dataBase);
        q.setParameter("id_inicial", (Object)idProdInicial);
        q.setParameter("id_final", (Object)idProdutoFinal);
        q.executeUpdate();
    }

    public List<Map> getSaldoProdutoEstoqueDisponivelOrNaoDisponivielProprioOrTerceiros(java.util.Date data, Long produtoInicial, Long produtoFinal, Long especieInicial, Long especieFinal, Long subEspecieInicial, Long subEspecieFinal, Long centroEstInicial, Long centroEstFinal, Long fabricanteInicial, Long fabricanteFinal, Long localizacaoInicial, Long localizacaoFinal, Long gradeInicial, Long gradeFinal, Integer tipoProdutoInicial, Integer tipoProdutoFinal, Short tipoPesquisa, Long idEmpresa, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoquePropTerc, Long idParceiro) {
        HashMap<String, Long> paramsAdic = new HashMap<String, Long>();
        paramsAdic.put("ID_ESPECIE_INICIAL", especieInicial);
        paramsAdic.put("ID_ESPECIE_FINAL", especieFinal);
        paramsAdic.put("ID_SUB_ESPECIE_INICIAL", subEspecieInicial);
        paramsAdic.put("ID_SUB_ESPECIE_FINAL", subEspecieFinal);
        paramsAdic.put("ID_FABRICANTE_INICIAL", fabricanteInicial);
        paramsAdic.put("ID_FABRICANTE_FINAL", fabricanteFinal);
        paramsAdic.put("ID_LOCALIZACAO_INICIAL", localizacaoInicial);
        paramsAdic.put("ID_LOCALIZACAO_FINAL", localizacaoFinal);
        List saldos = this.findSaldoEstoqueGeral(tipoProdutoInicial, tipoProdutoFinal, produtoInicial, produtoFinal, data, idEmpresa, idEmpresa, centroEstInicial, centroEstFinal, gradeInicial, gradeFinal, null, EnumConstSaldoEstTipoSaldo.TIPO_SALDO_GRADE, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_TUDO, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_SOMENTE_QTD, paramsAdic, tipoDisponibilidade, tipoEstoqueCentroEstoquePropTerc, idParceiro, this.getSaldoResultTransformer(), null, null);
        ArrayList<Map> lista = new ArrayList<Map>();
        if (saldos != null) {
            ArrayList temp = new ArrayList();
            saldos.forEach(s -> {
                Produto p = s.getGradeCor().getProdutoGrade().getProduto();
                Double saldoQtde = s.getQuantidade() != null ? s.getQuantidade() : 0.0;
                if (tipoPesquisa != null && tipoPesquisa == 0 && saldoQtde > p.getQtdMax()) {
                    temp.add(s);
                } else if (tipoPesquisa != null && tipoPesquisa == 1 && saldoQtde < p.getQtdMin()) {
                    temp.add(s);
                } else if (tipoPesquisa != null && tipoPesquisa == 2) {
                    temp.add(s);
                } else if (saldoQtde < p.getPontoRessupEstoque()) {
                    temp.add(s);
                }
            });
            temp.stream().map(s -> {
                HashMap<String, Object> h = new HashMap<String, Object>();
                h.put("SALDO_QTD", s.getQuantidade());
                h.put("SALDO_VALOR", s.getValor());
                h.put("VLR_PRECO_MEDIO", s.getValorMedio());
                h.put("GRADE", s.getGradeCor());
                h.put("ID_PRODUTO", s.getProduto().getIdentificador());
                h.put("CODIGO_AUXILIAR", s.getProduto().getCodigoAuxiliar());
                h.put("PRODUTO", s.getProduto());
                h.put("QTD_MIN", s.getProduto().getQtdMin());
                h.put("QTD_MAX", s.getProduto().getQtdMax());
                h.put("PTO_RESSUPRIMENTO", s.getProduto().getPontoRessupEstoque());
                h.put("UNIDADE_MEDIDA", s.getProduto().getUnidadeMedida());
                h.put("ID_GRADE_COR", s.getGradeCor().getIdentificador());
                h.put("ESPECIE", s.getProduto().getEspecie());
                h.put("SUBESPECIE", s.getProduto().getSubEspecie());
                return h;
            }).forEachOrdered(h -> lista.add((Map)h));
        }
        return lista;
    }

    public List<Map> getSaldoProdutoEstoqueDisponivelOrNaoDisponivielProprioOrTerceirosBasico(java.util.Date data, Long produtoInicial, Long produtoFinal, Long especieInicial, Long especieFinal, Long subEspecieInicial, Long subEspecieFinal, Long centroEstInicial, Long centroEstFinal, Long fabricanteInicial, Long fabricanteFinal, Long localizacaoInicial, Long localizacaoFinal, Long gradeInicial, Long gradeFinal, Integer tipoProdutoInicial, Integer tipoProdutoFinal, Short tipoPesquisa, Long idEmpresa, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoquePropTerc, Long idParceiro) {
        HashMap<String, Long> paramsAdic = new HashMap<String, Long>();
        paramsAdic.put("ID_ESPECIE_INICIAL", especieInicial);
        paramsAdic.put("ID_ESPECIE_FINAL", especieFinal);
        paramsAdic.put("ID_SUB_ESPECIE_INICIAL", subEspecieInicial);
        paramsAdic.put("ID_SUB_ESPECIE_FINAL", subEspecieFinal);
        paramsAdic.put("ID_FABRICANTE_INICIAL", fabricanteInicial);
        paramsAdic.put("ID_FABRICANTE_FINAL", fabricanteFinal);
        paramsAdic.put("ID_LOCALIZACAO_INICIAL", localizacaoInicial);
        paramsAdic.put("ID_LOCALIZACAO_FINAL", localizacaoFinal);
        List saldos = this.findSaldoEstoqueGeral(tipoProdutoInicial, tipoProdutoFinal, produtoInicial, produtoFinal, data, idEmpresa, idEmpresa, centroEstInicial, centroEstFinal, gradeInicial, gradeFinal, null, EnumConstSaldoEstTipoSaldo.TIPO_SALDO_GRADE, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_TUDO, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_SOMENTE_QTD, paramsAdic, tipoDisponibilidade, tipoEstoqueCentroEstoquePropTerc, idParceiro, this.getSaldoBasicoResultTransformer(), null, null);
        ServiceProdutoImpl serviceProduto = (ServiceProdutoImpl)ConfApplicationContext.getBean(ServiceProdutoImpl.class);
        ArrayList<Map> lista = new ArrayList<Map>();
        if (saldos != null) {
            for (SaldoEstoqueGeralBasico s : saldos) {
                Long idProduto = s.getIdProduto();
                Map h = serviceProduto.getDadosProdutoPontoEstoque(idProduto);
                h.put("SALDO_QTD", s.getQuantidade());
                h.put("SALDO_VALOR", s.getValor());
                h.put("VLR_PRECO_MEDIO", s.getValorMedio());
                h.put("ID_PRODUTO", s.getIdProduto());
                h.put("ID_GRADE_COR", s.getIdGradeCor());
                h.put("ID_CENTRO_ESTOQUE", s.getIdCentroEstoque());
                lista.add(h);
            }
        }
        return lista;
    }

    public List<SaldoEstoqueGeral> findSaldoProduto(Long idProdInicial, Long idProdFinal, java.util.Date dataIn, Long idEmpresaInicial, Long idEmpresaFinal, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoquePropTerc, Long idParceiro) {
        List saldos = this.findSaldoEstoqueGeral(0, 999999, idProdInicial, idProdFinal, dataIn, idEmpresaInicial, idEmpresaFinal, null, null, null, null, null, tipoSaldo, tipoQtde, tipoCarregamento, null, tipoDisponibilidade, tipoEstoqueCentroEstoquePropTerc, idParceiro, this.getSaldoResultTransformer(), null, null);
        if (saldos == null || saldos.isEmpty()) {
            return new ArrayList<SaldoEstoqueGeral>();
        }
        return saldos;
    }

    public List<SaldoEstoqueGeralBasico> findSaldoProdutoBasico(Long idProdInicial, Long idProdFinal, java.util.Date dataIn, Long idEmpresaInicial, Long idEmpresaFinal, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoquePropTerc, Long idParceiro) {
        List saldos = this.findSaldoEstoqueGeral(0, 999999, idProdInicial, idProdFinal, dataIn, idEmpresaInicial, idEmpresaFinal, null, null, null, null, null, tipoSaldo, tipoQtde, tipoCarregamento, null, tipoDisponibilidade, tipoEstoqueCentroEstoquePropTerc, idParceiro, this.getSaldoBasicoResultTransformer(), null, null);
        if (saldos == null || saldos.isEmpty()) {
            return new ArrayList<SaldoEstoqueGeralBasico>();
        }
        return saldos;
    }

    public SaldoEstoqueGeralBasico findSaldoProdutoUnicoBasico(Long idProduto, java.util.Date dataIn, Long idEmpresa, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoquePropTerc, Long idParceiro, Long idCentroInicial, Long idCentroFinal, Long idLote, Long idGradeIn, Long idGradeFim) {
        List saldos = this.findSaldoEstoqueGeral(0, 999999, idProduto, idProduto, dataIn, idEmpresa, idEmpresa, idCentroInicial, idCentroFinal, idGradeIn, idGradeFim, idLote, tipoSaldo, tipoQtde, tipoCarregamento, null, tipoDisponibilidade, tipoEstoqueCentroEstoquePropTerc, idParceiro, this.getSaldoBasicoResultTransformer(), null, null);
        if (saldos == null || saldos.isEmpty()) {
            return null;
        }
        return (SaldoEstoqueGeralBasico)saldos.get(0);
    }

    public SaldoEstoqueGeralBasico findSaldoProdutoUnicoBasico(Long idProduto, java.util.Date data, Long idEmpresa, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoquePropTerc, Long idParceiro) {
        return this.findSaldoProdutoUnicoBasico(idProduto, data, idEmpresa, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoquePropTerc, idParceiro, null, null, null, null, null);
    }

    public List<SaldoEstoqueGeral> findSaldoProdutoPorGrade(Long idProdInicial, Long idProdFinal, java.util.Date dataIn, Long idEmpresaInicial, Long idEmpresaFinal, Long idGradeInicial, Long idGradeFinal, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoquePropTerc, Long idParceiro) {
        List saldos = this.findSaldoEstoqueGeral(0, 999999, idProdInicial, idProdFinal, dataIn, idEmpresaInicial, idEmpresaFinal, null, null, idGradeInicial, idGradeFinal, null, tipoSaldo, tipoQtde, tipoCarregamento, null, tipoDisponibilidade, tipoEstoqueCentroEstoquePropTerc, idParceiro, this.getSaldoResultTransformer(), null, null);
        if (saldos == null || saldos.isEmpty()) {
            return new ArrayList<SaldoEstoqueGeral>();
        }
        return saldos;
    }

    public List<SaldoEstoqueGeralBasico> findSaldoProdutoPorGradeBasico(Long idProdInicial, Long idProdFinal, java.util.Date dataIn, Long idEmpresaInicial, Long idEmpresaFinal, Long idGradeInicial, Long idGradeFinal, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoquePropTerc, Long idParceiro) {
        List saldos = this.findSaldoEstoqueGeral(0, 999999, idProdInicial, idProdFinal, dataIn, idEmpresaInicial, idEmpresaFinal, null, null, idGradeInicial, idGradeFinal, null, tipoSaldo, tipoQtde, tipoCarregamento, null, tipoDisponibilidade, tipoEstoqueCentroEstoquePropTerc, idParceiro, this.getSaldoBasicoResultTransformer(), null, null);
        if (saldos == null || saldos.isEmpty()) {
            return new ArrayList<SaldoEstoqueGeralBasico>();
        }
        return saldos;
    }

    public SaldoEstoqueGeralBasico findSaldoProdutoPorGradeUnicoBasico(Long idProduto, java.util.Date dataIn, Long idEmpresa, Long idGrade, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoquePropTerc, Long idParceiro) {
        List saldos = this.findSaldoEstoqueGeral(0, 999999, idProduto, idProduto, dataIn, idEmpresa, idEmpresa, null, null, idGrade, idGrade, null, tipoSaldo, tipoQtde, tipoCarregamento, null, tipoDisponibilidade, tipoEstoqueCentroEstoquePropTerc, idParceiro, this.getSaldoBasicoResultTransformer(), null, null);
        if (saldos == null || saldos.isEmpty()) {
            return null;
        }
        return (SaldoEstoqueGeralBasico)saldos.get(0);
    }

    public SaldoEstoqueGeralBasico findSaldoProdutoPorGradeUnicoBasico(Long idProduto, java.util.Date dataIn, Long idEmpresa, Long idGrade, Long idCentroEstoque, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoquePropTerc, Long idParceiro) {
        List saldos = this.findSaldoEstoqueGeral(0, 999999, idProduto, idProduto, dataIn, idEmpresa, idEmpresa, idCentroEstoque, idCentroEstoque, idGrade, idGrade, null, tipoSaldo, tipoQtde, tipoCarregamento, null, tipoDisponibilidade, tipoEstoqueCentroEstoquePropTerc, idParceiro, this.getSaldoBasicoResultTransformer(), null, null);
        if (saldos == null || saldos.isEmpty()) {
            return null;
        }
        return (SaldoEstoqueGeralBasico)saldos.get(0);
    }

    public List<SaldoEstoqueGeralBasico> findSaldoProdutoPorGradeCentroEstoqueBasico(Long idProdInicial, Long idProdFinal, java.util.Date dataIn, Long idEmpresaInicial, Long idEmpresaFinal, Long idGradeInicial, Long idGradeFinal, Long idCentroEstoqueInicial, Long idCentroEstoqueFinal, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoquePropTerc, Long idParceiro) {
        List saldos = this.findSaldoEstoqueGeral(0, 999999, idProdInicial, idProdFinal, dataIn, idEmpresaInicial, idEmpresaFinal, idCentroEstoqueInicial, idCentroEstoqueFinal, idGradeInicial, idGradeFinal, null, tipoSaldo, tipoQtde, tipoCarregamento, null, tipoDisponibilidade, tipoEstoqueCentroEstoquePropTerc, idParceiro, this.getSaldoBasicoResultTransformer(), null, null);
        if (saldos == null || saldos.isEmpty()) {
            return new ArrayList<SaldoEstoqueGeralBasico>();
        }
        return saldos;
    }

    public SaldoEstoqueGeralBasico findSaldoProdutoPorGradeCentroEstoqueUnicoBasico(Long idProduto, java.util.Date dataIn, Long idEmpresa, Long idGrade, Long idCentroEstoque, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoquePropTerc, Long idParceiro) {
        List saldos = this.findSaldoEstoqueGeral(0, 999999, idProduto, idProduto, dataIn, idEmpresa, idEmpresa, idCentroEstoque, idCentroEstoque, idGrade, idGrade, null, tipoSaldo, tipoQtde, tipoCarregamento, null, tipoDisponibilidade, tipoEstoqueCentroEstoquePropTerc, idParceiro, this.getSaldoBasicoResultTransformer(), null, null);
        if (saldos == null || saldos.isEmpty()) {
            return null;
        }
        return (SaldoEstoqueGeralBasico)saldos.get(0);
    }

    public SaldoEstoqueGeral findSaldoProdutoPorGradeCentroEstoqueLoteUnico(Long idProdutoInicial, Long idProdutoFinal, java.util.Date data, Long idEmpresaInicial, Long idEmpresaFinal, Long centroInicial, Long centroFinal, Long idGradeCorInicial, Long idGradeCorFinal, Long idLoteFabricacao, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoquePropTerc, Long idParceiro) {
        List saldos = this.findSaldoEstoqueGeral(0, 999999, idProdutoInicial, idProdutoFinal, data, idEmpresaInicial, idEmpresaFinal, centroInicial, centroFinal, idGradeCorInicial, idGradeCorFinal, idLoteFabricacao, tipoSaldo, tipoQtde, tipoCarregamento, null, tipoDisponibilidade, tipoEstoqueCentroEstoquePropTerc, idParceiro, this.getSaldoResultTransformer(), null, null);
        if (saldos == null || saldos.isEmpty()) {
            SaldoEstoqueGeral sal = new SaldoEstoqueGeral();
            return sal;
        }
        return (SaldoEstoqueGeral)saldos.get(0);
    }

    public List<SaldoEstoqueGeral> findSaldoProdutoPorGradeCentroEstoqueLoteLista(Long idProdutoInicial, Long idProdutoFinal, java.util.Date data, Long idEmpresaInicial, Long idEmpresaFinal, Long centroInicial, Long centroFinal, Long idGradeCorInicial, Long idGradeCorFinal, Long idLoteFabricacao, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoquePropTerc, Long idParceiro) {
        List saldos = this.findSaldoEstoqueGeral(0, 999999, idProdutoInicial, idProdutoFinal, data, idEmpresaInicial, idEmpresaFinal, centroInicial, centroFinal, idGradeCorInicial, idGradeCorFinal, idLoteFabricacao, tipoSaldo, tipoQtde, tipoCarregamento, null, tipoDisponibilidade, tipoEstoqueCentroEstoquePropTerc, idParceiro, this.getSaldoResultTransformer(), null, null);
        if (saldos == null || saldos.isEmpty()) {
            return new ArrayList<SaldoEstoqueGeral>();
        }
        return saldos;
    }

    public List<SaldoEstoqueGeralBasico> findSaldoGradeCentroEstoqueLoteListaBasico(Long idProdutoInicial, Long idProdutoFinal, java.util.Date data, Long idEmpresaInicial, Long idEmpresaFinal, Long idCentroInicial, Long idCentroFinal, Long idGradeInicial, Long idGradeFinal, Long idLote, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoque, Long idParceiro) {
        List saldos = this.findSaldoEstoqueGeral(0, 999999, idProdutoInicial, idProdutoFinal, data, idEmpresaInicial, idEmpresaFinal, idCentroInicial, idCentroFinal, idGradeInicial, idGradeFinal, idLote, tipoSaldo, tipoQtde, tipoCarregamento, null, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro, this.getSaldoBasicoResultTransformer(), null, null);
        if (saldos == null || saldos.isEmpty()) {
            return new ArrayList<SaldoEstoqueGeralBasico>();
        }
        return saldos;
    }

    public List<SaldoEstoqueGeral> findSaldoProdutoPorGradeCentroEstoqueLoteParamAdicionaisLista(Long idProdutoInicial, Long idProdutoFinal, java.util.Date data, Long idEmpresaInicial, Long idEmpresaFinal, Long centroInicial, Long centroFinal, Long idGradeCorInicial, Long idGradeCorFinal, Long idLoteFabricacao, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, Long idEspecieInicial, Long idEspecieFinal, Long idSubEspecieInicial, Long idSubEspecieFinal, Long idLocalizacaoInicial, Long idLocalizacaoFinal, Long idFabricanteInicial, Long idFabricanteFinal, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoquePropTerc, Long idParceiro) {
        return this.findSaldoProdutoPorGradeCentroEstoqueLoteParamAdicionaisLista(idProdutoInicial, idProdutoFinal, data, idEmpresaInicial, idEmpresaFinal, centroInicial, centroFinal, idGradeCorInicial, idGradeCorFinal, idLoteFabricacao, tipoSaldo, tipoQtde, tipoCarregamento, idEspecieInicial, idEspecieFinal, idSubEspecieInicial, idSubEspecieFinal, idLocalizacaoInicial, idLocalizacaoFinal, idFabricanteInicial, idFabricanteFinal, tipoDisponibilidade, tipoEstoqueCentroEstoquePropTerc, idParceiro, null, null);
    }

    public List<SaldoEstoqueGeral> findSaldoProdutoPorGradeCentroEstoqueLoteParamAdicionaisLista(Long idProdutoInicial, Long idProdutoFinal, java.util.Date data, Long idEmpresaInicial, Long idEmpresaFinal, Long centroInicial, Long centroFinal, Long idGradeCorInicial, Long idGradeCorFinal, Long idLoteFabricacao, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, Long idEspecieInicial, Long idEspecieFinal, Long idSubEspecieInicial, Long idSubEspecieFinal, Long idLocalizacaoInicial, Long idLocalizacaoFinal, Long idFabricanteInicial, Long idFabricanteFinal, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoquePropTerc, Long idParceiro, Integer firstResult, Integer maxResult) {
        HashMap<String, Long> paramAdic = new HashMap<String, Long>();
        paramAdic.put("ID_ESPECIE_INICIAL", idEspecieInicial);
        paramAdic.put("ID_ESPECIE_FINAL", idEspecieFinal);
        paramAdic.put("ID_SUB_ESPECIE_INICIAL", idSubEspecieInicial);
        paramAdic.put("ID_SUB_ESPECIE_FINAL", idSubEspecieFinal);
        paramAdic.put("ID_LOCALIZACAO_INICIAL", idLocalizacaoInicial);
        paramAdic.put("ID_LOCALIZACAO_FINAL", idLocalizacaoFinal);
        paramAdic.put("ID_FABRICANTE_INICIAL", idFabricanteInicial);
        paramAdic.put("ID_FABRICANTE_FINAL", idFabricanteFinal);
        List saldos = this.findSaldoEstoqueGeral(0, 99999, idProdutoInicial, idProdutoFinal, data, idEmpresaInicial, idEmpresaFinal, centroInicial, centroFinal, idGradeCorInicial, idGradeCorFinal, idLoteFabricacao, tipoSaldo, tipoQtde, tipoCarregamento, paramAdic, tipoDisponibilidade, tipoEstoqueCentroEstoquePropTerc, idParceiro, this.getSaldoResultTransformer(), firstResult, maxResult);
        if (saldos == null || saldos.isEmpty()) {
            return new ArrayList<SaldoEstoqueGeral>();
        }
        return saldos;
    }

    public List<SaldoEstoqueGeralBasico> findSaldosProdAltTab(java.util.Date dataSaldo, java.util.Date lastSinc, Long idCentroEstoque, Long idEmpresa, Long idTabPrecoBase) {
        if (dataSaldo == null) {
            dataSaldo = new java.util.Date();
        }
        NativeQuery q = this.sqlQuery(" select  s.id_empresa as ID_EMPRESA, s.DATA_SALDO as DATA_SALDO, s.SALDO_QTD as SALDO_QTD, s.SALDO_VALOR as SALDO_VALOR, s.VALOR_PRECO_MEDIO as VALOR_PRECO_MEDIO, s.id_produto as ID_PRODUTO, s.id_lote_fabricacao as ID_LOTE_FABRICACAO, s.id_grade_cor as ID_GRADE_COR, s.id_c_estoque as ID_CENTRO_ESTOQUE, s.qtd_entrada_dia as  QTD_ENTRADA_DIA, s.qtd_saida_dia as QTD_SAIDA_DIA, s.qtd_entrada_dia_interno as  QTD_ENTRADA_DIA_INTERNO, s.qtd_saida_dia_interno as QTD_SAIDA_DIA_INTERNO, p.codigo_auxiliar as COD_AUX_PRODUTO,  p.COD_SINCRONIZACAO as COD_SINCRONIZACAO  from  saldo_produto_detalhado(:tipoInicial, :tipoFinal, :idProdInicial, :idProdFinal, :dataSaldo, :idGradeCorInicial, :idGradeCorFinal, :idEspecieInicial, :idEspecieFinal, :idSubEspecieInicial, :idSubEspecieFinal, :idLocalizacaoInicial, :idLocalizacaoFinal, :idFabricanteInicial, :idFabricanteFinal, :idEmpInicial, :idEmpFinal, :idCentroInicial, :idCentroFinal, :id_lote_fab, :tipo_saldo, :tipo_saldo_qtd, :tipo_carregamento, :tipo_disponibilidade, :tipo_estoque_c_estoque, :id_parceiro) s inner join produto p on s.id_produto = p.id_produto inner join TABELA_PRECO_BASE_PROD tp on tp.id_produto = p.id_produto where tp.ID_TABELA_PRECO_BASE=:ID_TABELA_PRECO_BASE and s.data_atualizacao>=:data_sincronizacao order by s.id_produto, s.id_grade_cor, s.data_fabricacao,s.LOTE");
        q.setParameter("idEmpInicial", (Object)idEmpresa);
        q.setParameter("idEmpFinal", (Object)idEmpresa);
        q.setDate("dataSaldo", dataSaldo);
        q.setParameter("idProdInicial", null);
        q.setParameter("idProdFinal", null);
        q.setParameter("idEspecieInicial", null);
        q.setParameter("idEspecieFinal", null);
        q.setParameter("idSubEspecieInicial", null);
        q.setParameter("idSubEspecieFinal", null);
        q.setParameter("idLocalizacaoInicial", null);
        q.setParameter("idLocalizacaoFinal", null);
        q.setParameter("idFabricanteInicial", null);
        q.setParameter("idFabricanteFinal", null);
        q.setParameter("idCentroInicial", (Object)idCentroEstoque);
        q.setParameter("idCentroFinal", (Object)idCentroEstoque);
        q.setParameter("tipoInicial", (Object)0);
        q.setParameter("tipoFinal", (Object)9999);
        q.setParameter("id_lote_fab", null);
        q.setParameter("tipo_saldo", (Object)EnumConstSaldoEstTipoSaldo.TIPO_SALDO_PRODUTO.getValue());
        q.setParameter("tipo_saldo_qtd", (Object)EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_TUDO.getValue());
        q.setParameter("tipo_carregamento", (Object)EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_SOMENTE_QTD.getValue());
        q.setParameter("tipo_disponibilidade", (Object)EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS.getValue());
        q.setParameter("tipo_estoque_c_estoque", (Object)EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue());
        q.setParameter("id_parceiro", null);
        q.setParameter("idGradeCorInicial", null);
        q.setParameter("idGradeCorFinal", null);
        q.setParameter("data_sincronizacao", (Object)lastSinc);
        q.setParameter("ID_TABELA_PRECO_BASE", (Object)idTabPrecoBase);
        q.setResultTransformer((ResultTransformer)new SaldoBasicoResultTransformer());
        return q.list();
    }

    private List findSaldoEstoqueGeral(Integer tipoInicial, Integer tipoFinal, Long idProdInicial, Long idProdFinal, java.util.Date dataIn, Long idEmpresaInicial, Long idEmpresaFinal, Long idCentroInicial, Long idCentroFinal, Long idGradeCorInicial, Long idGradeCorFinal, Long idLoteFabricacao, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoSaldoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, HashMap paramsAdicionais, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoquePropTercPropTerc, Long idParceiro, ResultTransformer result, Integer firstResult, Integer maxResults) {
        if (dataIn == null) {
            dataIn = new java.util.Date();
        }
        NativeQuery q = this.sqlQuery("select s.id_empresa as ID_EMPRESA, s.DATA_SALDO as DATA_SALDO, s.SALDO_QTD as SALDO_QTD, s.SALDO_VALOR as SALDO_VALOR, s.VALOR_PRECO_MEDIO as VALOR_PRECO_MEDIO, s.id_produto as ID_PRODUTO, s.id_lote_fabricacao as ID_LOTE_FABRICACAO, s.id_grade_cor as ID_GRADE_COR, s.id_c_estoque as ID_CENTRO_ESTOQUE, s.qtd_entrada_dia as  QTD_ENTRADA_DIA, s.qtd_saida_dia as QTD_SAIDA_DIA, s.qtd_entrada_dia_interno as  QTD_ENTRADA_DIA_INTERNO, s.qtd_saida_dia_interno as QTD_SAIDA_DIA_INTERNO, p.codigo_auxiliar as COD_AUX_PRODUTO, p.COD_SINCRONIZACAO as COD_SINCRONIZACAO  from  saldo_produto_detalhado(:tipoInicial, :tipoFinal, :idProdInicial, :idProdFinal, :dataSaldo, :idGradeCorInicial, :idGradeCorFinal, :idEspecieInicial, :idEspecieFinal, :idSubEspecieInicial, :idSubEspecieFinal, :idLocalizacaoInicial, :idLocalizacaoFinal, :idFabricanteInicial, :idFabricanteFinal, :idEmpInicial, :idEmpFinal, :idCentroInicial, :idCentroFinal, :id_lote_fab, :tipo_saldo, :tipo_saldo_qtd, :tipo_carregamento, :tipo_disponibilidade, :tipo_estoque_c_estoque, :id_parceiro) s inner join produto p on s.id_produto = p.id_produto order by s.id_produto, s.id_grade_cor, s.data_fabricacao,s.LOTE");
        q.setParameter("idEmpInicial", (Object)idEmpresaInicial);
        q.setParameter("idEmpFinal", (Object)idEmpresaFinal);
        q.setDate("dataSaldo", dataIn);
        q.setParameter("idProdInicial", (Object)idProdInicial);
        q.setParameter("idProdFinal", (Object)idProdFinal);
        if (idCentroInicial != null && idCentroFinal != null) {
            q.setParameter("idCentroInicial", (Object)idCentroInicial);
            q.setParameter("idCentroFinal", (Object)idCentroFinal);
        } else {
            q.setParameter("idCentroInicial", null);
            q.setParameter("idCentroFinal", null);
        }
        q.setParameter("tipoInicial", (Object)tipoInicial);
        q.setParameter("tipoFinal", (Object)tipoFinal);
        q.setParameter("id_lote_fab", (Object)idLoteFabricacao);
        q.setParameter("tipo_saldo", (Object)tipoSaldo.getValue());
        q.setParameter("tipo_saldo_qtd", (Object)tipoSaldoQtde.getValue());
        if (tipoCarregamento == null) {
            tipoCarregamento = EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_TUDO;
        }
        q.setInteger("tipo_carregamento", tipoCarregamento.getValue());
        if (tipoDisponibilidade == null) {
            tipoDisponibilidade = EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS;
        }
        q.setParameter("tipo_disponibilidade", (Object)tipoDisponibilidade.getValue());
        if (tipoEstoqueCentroEstoquePropTercPropTerc == null) {
            tipoEstoqueCentroEstoquePropTercPropTerc = EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO;
        }
        q.setShort("tipo_estoque_c_estoque", tipoEstoqueCentroEstoquePropTercPropTerc.getValue().shortValue());
        q.setParameter("id_parceiro", (Object)idParceiro);
        if (idGradeCorInicial != null && idGradeCorFinal != null) {
            q.setLong("idGradeCorInicial", idGradeCorInicial.longValue());
            q.setLong("idGradeCorFinal", idGradeCorFinal.longValue());
        } else {
            q.setParameter("idGradeCorInicial", null);
            q.setParameter("idGradeCorFinal", null);
        }
        if (paramsAdicionais != null) {
            q.setParameter("idEspecieInicial", (Object)((Long)paramsAdicionais.get("ID_ESPECIE_INICIAL")));
            q.setParameter("idEspecieFinal", (Object)((Long)paramsAdicionais.get("ID_ESPECIE_FINAL")));
            q.setParameter("idSubEspecieInicial", (Object)((Long)paramsAdicionais.get("ID_SUB_ESPECIE_INICIAL")));
            q.setParameter("idSubEspecieFinal", (Object)((Long)paramsAdicionais.get("ID_SUB_ESPECIE_FINAL")));
            q.setParameter("idLocalizacaoInicial", (Object)((Long)paramsAdicionais.get("ID_LOCALIZACAO_INICIAL")));
            q.setParameter("idLocalizacaoFinal", (Object)((Long)paramsAdicionais.get("ID_LOCALIZACAO_FINAL")));
            q.setParameter("idFabricanteInicial", (Object)((Long)paramsAdicionais.get("ID_FABRICANTE_INICIAL")));
            q.setParameter("idFabricanteFinal", (Object)((Long)paramsAdicionais.get("ID_FABRICANTE_FINAL")));
        } else {
            q.setParameter("idEspecieInicial", null);
            q.setParameter("idEspecieFinal", null);
            q.setParameter("idSubEspecieInicial", null);
            q.setParameter("idSubEspecieFinal", null);
            q.setParameter("idLocalizacaoInicial", null);
            q.setParameter("idLocalizacaoFinal", null);
            q.setParameter("idFabricanteInicial", null);
            q.setParameter("idFabricanteFinal", null);
        }
        if (ToolMethods.isWithData((Number)firstResult)) {
            q.setFirstResult(firstResult.intValue());
        }
        if (ToolMethods.isWithData((Number)maxResults)) {
            q.setMaxResults(maxResults.intValue());
        }
        q.setResultTransformer(result);
        return q.list();
    }

    public List<SaldoEstoqueGeralBasico> findSaldoEstoqueGeralBasico(SaldoEstoqueParams params) {
        return this.findSaldoEstoqueGeral(params, new SaldoBasicoResultTransformer());
    }

    public List<SaldoEstoqueGeral> findSaldoEstoqueGeral(SaldoEstoqueParams params) {
        return this.findSaldoEstoqueGeral(params, new SaldoResultTransformer());
    }

    public List<SaldoEstoqueGeralDetBasico> findSaldoEstoqueDetBasico(SaldoEstoqueParams params) {
        return this.findSaldoEstoqueGeral(params, new SaldoBasicoDetResultTransformer());
    }

    public List findSaldoEstoqueGeral(SaldoEstoqueParams params, ResultTransformer result) {
        NativeQuery q = this.sqlQuery("select s.id_empresa as ID_EMPRESA, s.DATA_SALDO as DATA_SALDO, s.SALDO_QTD as SALDO_QTD, s.SALDO_VALOR as SALDO_VALOR, s.VALOR_PRECO_MEDIO as VALOR_PRECO_MEDIO, s.id_produto as ID_PRODUTO, s.id_lote_fabricacao as ID_LOTE_FABRICACAO, s.DATA_FABRICACAO as DATA_FABRICACAO, s.DATA_VALIDADE as DATA_VALIDADE, s.LOTE as LOTE_FABRICACAO, s.id_grade_cor as ID_GRADE_COR, s.id_c_estoque as ID_CENTRO_ESTOQUE, s.qtd_entrada_dia as  QTD_ENTRADA_DIA, s.qtd_saida_dia as QTD_SAIDA_DIA, s.qtd_entrada_dia_interno as  QTD_ENTRADA_DIA_INTERNO, s.qtd_saida_dia_interno as QTD_SAIDA_DIA_INTERNO, p.codigo_auxiliar as COD_AUX_PRODUTO, p.nome as PRODUTO, p.COD_SINCRONIZACAO as COD_SINCRONIZACAO, u.sigla as UNIDADE_MEDIDA  from  saldo_produto_detalhado(:tipoInicial, :tipoFinal, :idProdInicial, :idProdFinal, :dataSaldo, :idGradeCorInicial, :idGradeCorFinal, :idEspecieInicial, :idEspecieFinal, :idSubEspecieInicial, :idSubEspecieFinal, :idLocalizacaoInicial, :idLocalizacaoFinal, :idFabricanteInicial, :idFabricanteFinal, :idEmpInicial, :idEmpFinal, :idCentroInicial, :idCentroFinal, :id_lote_fab, :tipo_saldo, :tipo_saldo_qtd, :tipo_carregamento, :tipo_disponibilidade, :tipo_estoque_c_estoque, :id_parceiro) s inner join produto p on s.id_produto = p.id_produto inner join unidade_medida u on p.ID_UNIDADE_MEDIDA = u.ID_UNIDADE_MEDIDA order by s.id_produto, s.id_grade_cor, s.data_fabricacao,s.LOTE");
        q.setParameter("idEmpInicial", (Object)params.getIdEmpresaInicial());
        q.setParameter("idEmpFinal", (Object)params.getIdEmpresaFinal());
        q.setDate("dataSaldo", params.getDataPosicaoSaldo());
        q.setParameter("idProdInicial", (Object)params.getIdProdInicial());
        q.setParameter("idProdFinal", (Object)params.getIdProdFinal());
        q.setParameter("idCentroInicial", (Object)params.getIdCentroInicial());
        q.setParameter("idCentroFinal", (Object)params.getIdCentroFinal());
        q.setParameter("tipoInicial", (Object)params.getTipoInicial());
        q.setParameter("tipoFinal", (Object)params.getTipoFinal());
        q.setParameter("id_lote_fab", (Object)params.getIdLoteFabricacao());
        q.setParameter("tipo_saldo", (Object)params.getTipoSaldo().getValue());
        q.setParameter("tipo_saldo_qtd", (Object)params.getTipoSaldoQtde().getValue());
        q.setInteger("tipo_carregamento", params.getTipoCarregamento().getValue());
        q.setParameter("tipo_disponibilidade", (Object)params.getTipoDisponibilidade().getValue());
        q.setShort("tipo_estoque_c_estoque", params.getTipoEstoqueCentroEstoquePropTercPropTerc().getValue().shortValue());
        q.setParameter("id_parceiro", (Object)params.getIdParceiro());
        q.setParameter("idGradeCorInicial", (Object)params.getIdGradeCorInicial());
        q.setParameter("idGradeCorFinal", (Object)params.getIdGradeCorFinal());
        q.setParameter("idEspecieInicial", (Object)params.getIdEspecieInicial());
        q.setParameter("idEspecieFinal", (Object)params.getIdEspecieFinal());
        q.setParameter("idSubEspecieInicial", (Object)params.getIdSubEspecieInicial());
        q.setParameter("idSubEspecieFinal", (Object)params.getIdSubEspecieFinal());
        q.setParameter("idLocalizacaoInicial", (Object)params.getIdLocalizacaoInicial());
        q.setParameter("idLocalizacaoFinal", (Object)params.getIdLocalizacaoFinal());
        q.setParameter("idFabricanteInicial", (Object)params.getIdFabricanteInicial());
        q.setParameter("idFabricanteFinal", (Object)params.getIdFabricanteFinal());
        if (ToolMethods.isWithData((Number)params.getFirstResult())) {
            q.setFirstResult(params.getFirstResult().intValue());
        }
        if (ToolMethods.isWithData((Number)params.getMaxResults())) {
            q.setMaxResults(params.getMaxResults().intValue());
        }
        q.setResultTransformer(result);
        return q.list();
    }

    private SaldoResultTransformer getSaldoResultTransformer() {
        if (this.saldoResultTransformer == null) {
            this.saldoResultTransformer = new SaldoResultTransformer();
        }
        return this.saldoResultTransformer;
    }

    public SaldoBasicoResultTransformer getSaldoBasicoResultTransformer() {
        if (this.saldoBasicoResultTransformer == null) {
            this.saldoBasicoResultTransformer = new SaldoBasicoResultTransformer();
        }
        return this.saldoBasicoResultTransformer;
    }

    public List<HashMap> findSaldosEstoqueTerceiros(Long idPessoaInicial, Long idPessoaFinal, Short tipoEstoque, java.util.Date dataSaldo, Long idEmpresa, Long idProduto, Long idTipoMovimento) {
        NativeQuery q = this.sqlQuery("SELECT pe.id_pessoa                                                                  AS ID_PESSOA, pe.nome                                                                       AS NOME_PESSOA, co.cnpj                                                                       AS CNPJ_PESSOA, pr.id_produto                                                                 AS ID_PRODUTO, pr.nome                                                                       AS NOME_PRODUTO, pr.codigo_auxiliar                                                            AS CODIGO_AUXILIAR_PRODUTO, um.sigla                                                                      AS UNIDADE_MEDIDA, np.id_nota_propria                                                            AS ID_NOTA_PROPRIA, np.serie                                                                      AS SERIE_NOTA_PROPRIA, np.numero_nota                                                                AS NUMERO_NOTA_PROPRIA, np.data_emissao                                                               AS DATA_EMISSAO_NOTA_PROPRIA, op.numero_dias                                                                AS NUMERO_DIAS_NOTA_PROPRIA, gp.quantidade                                                                 AS QUANTIDADE_NOTA_PROPRIA, ip.valor_unitario                                                             AS VALOR_UNITARIO_NOTA_PROPRIA, CAST(ip.valor_unitario AS NUMERIC(12,6)) * s.qtd_saldo                        AS VALOR_TOTAL_NOTA_PROPRIA, ep.id_estoque_terceiros                                                       AS ID_ESTOQUE_TERC_NOTA_PROPRIA, gp.id_lote_fabricacao                                                         AS ID_LOTE_FAB_NOTA_PROPRIA, nt.id_nota_terceiros                                                          AS ID_NOTA_TERCEIROS, nt.serie                                                                      AS SERIE_NOTA_TERCEIROS, nt.numero_nota                                                                AS NUMERO_NOTA_TERCEIROS, nt.data_entrada_saida                                                         AS DATA_ENT_SAIDA_NOTA_TERCEIROS, ot.numero_dias                                                                AS NUMERO_DIAS_NOTA_TERCEIROS, gt.quantidade                                                                 AS QUANTIDADE_NOTA_TERCEIROS, it.valor_unitario / it.fator_conversao                                        AS VALOR_UNITARIO_NOTA_TERCEIROS, CAST((it.valor_unitario / it.fator_conversao) AS NUMERIC(12,6)) * s.qtd_saldo AS VALOR_TOTAL_NOTA_TERCEIROS, et.id_estoque_terceiros                                                       AS ID_ESTOQUE_TERC_NOTA_TERCEIROS, gt.id_lote_fabricacao                                                         AS ID_LOTE_FAB_NOTA_TERCEIROS, s.qtd_saldo                                                                   AS QUANTIDADE_SALDO FROM SALDO_ESTOQUE_TERCEIROS(:idPessoaInicial, :idPessoaFinal, :tipoEstoque, :dataSaldo, :idEmpresa, :idTipoMovimento) s INNER JOIN pessoa                    pe ON pe.id_pessoa                    = s.id_pessoa INNER JOIN complemento               co ON co.id_complemento               = pe.id_complemento LEFT  JOIN grade_item_nota_propria   gp ON gp.id_grade_item_nota_propria   = s.id_grade_item_nota_propria LEFT  JOIN grade_item_nota_terceiros gt ON gt.id_grade_item_nota_terceiros = s.id_grade_item_nota_terceiros LEFT  JOIN item_nota_propria         ip ON ip.id_item_nota_propria         = gp.id_item_nota_fiscal_propria LEFT  JOIN item_nota_terceiros       it ON it.id_item_nota_terceiros       = gt.id_item_nota_terceiros LEFT  JOIN nota_propria              np ON np.id_nota_propria              = ip.id_nota_fiscal_propria LEFT  JOIN nota_terceiros            nt ON nt.id_nota_terceiros            = it.id_nota_terceiros LEFT  JOIN natureza_operacao         op ON op.id_natureza_operacao         = np.id_natureza_operacao LEFT  JOIN natureza_operacao         ot ON ot.id_natureza_operacao         = it.id_natureza_operacao LEFT  JOIN estoque_terceiros         ep ON ep.id_grade_item_nota_propria   = gp.id_grade_item_nota_propria LEFT  JOIN estoque_terceiros         et ON et.id_grade_item_nota_terceiros = gt.id_grade_item_nota_terceiros INNER JOIN produto                   pr ON (pr.id_produto        = ip.id_produto)        OR (pr.id_produto        = it.id_produto) INNER JOIN unidade_medida            um ON (um.id_unidade_medida = ip.id_unidade_medida) OR (um.id_unidade_medida = it.id_unidade_medida) WHERE CAST(s.qtd_saldo AS NUMERIC(12,6)) > 0 AND   pr.id_produto                      = :idProduto ORDER BY pe.id_pessoa,          pr.id_produto,          np.data_emissao,          np.numero_nota,          nt.data_entrada_saida,          nt.numero_nota");
        q.setParameter("idPessoaInicial", (Object)idPessoaInicial);
        q.setParameter("idPessoaFinal", (Object)idPessoaFinal);
        q.setParameter("tipoEstoque", (Object)tipoEstoque);
        q.setParameter("dataSaldo", (Object)dataSaldo);
        q.setParameter("idEmpresa", (Object)idEmpresa);
        q.setParameter("idProduto", (Object)idProduto);
        q.setParameter("idTipoMovimento", (Object)idTipoMovimento);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public List<HashMap> getNotasByFornecedorTipoEstoque(Long idPessoa, Short tipoEstoque, java.util.Date dataInicial, java.util.Date dataFinal, Long idEmpresa, Long idProduto, Long idTipoMovimento) {
        NativeQuery q = this.sqlQuery("SELECT DISTINCT pf.id_pessoa                       AS ID_PESSOA, pf.nome                            AS NOME_PESSOA, cf.cnpj                            AS CNPJ_PESSOA, pt.id_produto                      AS ID_PRODUTO, pt.nome                            AS NOME_PRODUTO, pt.codigo_auxiliar                 AS CODIGO_AUXILIAR_PRODUTO, ut.sigla                           AS UNIDADE_MEDIDA, nt.id_nota_terceiros               AS ID_NOTA_TERCEIROS, nt.serie                           AS SERIE_NOTA_TERCEIROS, nt.numero_nota                     AS NUMERO_NOTA_TERCEIROS, nt.data_entrada_saida              AS DATA_ENT_SAIDA_NOTA_TERCEIROS, na.numero_dias                     AS NUMERO_DIAS_NOTA_TERCEIROS, gt.quantidade * it.fator_conversao AS QUANTIDADE_NOTA_TERCEIROS, it.valor_unitario                  AS VALOR_UNITARIO_NOTA_TERCEIROS, it.valor_unitario * gt.quantidade  AS VALOR_TOTAL_NOTA_TERCEIROS, et.id_estoque_terceiros            AS ID_ESTOQUE_TERC_NOTA_TERCEIROS, gt.id_lote_fabricacao              AS ID_LOTE_FAB_NOTA_TERCEIROS, NULL                               AS ID_NOTA_PROPRIA, NULL                               AS SERIE_NOTA_PROPRIA, NULL                               AS NUMERO_NOTA_PROPRIA, NULL                               AS DATA_EMISSAO_NOTA_PROPRIA, NULL                               AS NUMERO_DIAS_NOTA_PROPRIA, NULL                               AS QUANTIDADE_NOTA_PROPRIA, NULL                               AS VALOR_UNITARIO_NOTA_PROPRIA, NULL                               AS VALOR_TOTAL_NOTA_PROPRIA, NULL                               AS ID_ESTOQUE_TERC_NOTA_PROPRIA, NULL                               AS ID_LOTE_FAB_NOTA_PROPRIA, gt.quantidade * it.fator_conversao AS QUANTIDADE_SALDO FROM item_nota_terceiros             it INNER JOIN nota_terceiros            nt ON nt.id_nota_terceiros            = it.id_nota_terceiros INNER JOIN unidade_fat_forn          uf ON uf.id_unidade_fat_forn          = nt.id_unidade_fat_forn INNER JOIN fornecedor                fo ON fo.id_fornecedor                = uf.id_fornecedor INNER JOIN pessoa                    pf ON pf.id_pessoa                    = fo.id_pessoa INNER JOIN complemento               cf ON cf.id_complemento               = pf.id_complemento INNER JOIN natureza_operacao         na ON na.id_natureza_operacao         = it.id_natureza_operacao INNER JOIN grade_item_nota_terceiros gt ON gt.id_item_nota_terceiros       = it.id_item_nota_terceiros INNER JOIN estoque_terceiros         et ON et.id_grade_item_nota_terceiros = gt.id_grade_item_nota_terceiros INNER JOIN situacao_documento        sd ON sd.id_situacao_documento        = nt.id_situacao_documento INNER JOIN produto                   pt ON pt.id_produto                   = it.id_produto INNER JOIN unidade_medida            ut ON ut.id_unidade_medida            = it.id_unidade_medida WHERE pf.id_pessoa                = :idPessoa AND   na.tipo_estoque             = :tipoEstoque AND   nt.data_entrada_saida BETWEEN :dataInicial AND :dataFinal AND   nt.id_empresa               = :idEmpresa AND   it.id_produto               = :idProduto AND   na.id_tipo_movimento        = :idTipoMovimento AND   (et.desativa_mov_terceiros  = 0 OR et.desativa_mov_terceiros IS NULL) AND   sd.codigo                  <> :situacaoDocumento1 AND   sd.codigo                  <> :situacaoDocumento2 UNION ALL SELECT DISTINCT pc.id_pessoa                      AS ID_PESSOA, pc.nome                           AS NOME_PESSOA, cc.cnpj                           AS CNPJ_PESSOA, pp.id_produto                     AS ID_PRODUTO, pp.nome                           AS NOME_PRODUTO, pp.codigo_auxiliar                AS CODIGO_AUXILIAR_PRODUTO, up.sigla                          AS UNIDADE_MEDIDA, NULL                              AS ID_NOTA_TERCEIROS, NULL                              AS SERIE_NOTA_TERCEIROS, NULL                              AS NUMERO_NOTA_TERCEIROS, NULL                              AS DATA_ENT_SAIDA_NOTA_TERCEIROS, NULL                              AS NUMERO_DIAS_NOTA_TERCEIROS, NULL                              AS QUANTIDADE_NOTA_TERCEIROS, NULL                              AS VALOR_UNITARIO_NOTA_TERCEIROS, NULL                              AS VALOR_TOTAL_NOTA_TERCEIROS, NULL                              AS ID_ESTOQUE_TERC_NOTA_TERCEIROS, NULL                              AS ID_LOTE_FAB_NOTA_TERCEIROS, np.id_nota_propria                AS ID_NOTA_PROPRIA, np.serie                          AS SERIE_NOTA_PROPRIA, np.numero_nota                    AS NUMERO_NOTA_PROPRIA, np.data_emissao                   AS DATA_EMISSAO_NOTA_PROPRIA, nr.numero_dias                    AS NUMERO_DIAS_NOTA_PROPRIA, gp.quantidade                     AS QUANTIDADE_NOTA_PROPRIA, ip.valor_unitario                 AS VALOR_UNITARIO_NOTA_PROPRIA, ip.valor_unitario * gp.quantidade AS VALOR_TOTAL_NOTA_PROPRIA, ep.id_estoque_terceiros           AS ID_ESTOQUE_TERC_NOTA_PROPRIA, gp.id_lote_fabricacao             AS ID_LOTE_FAB_NOTA_PROPRIA, gp.quantidade                     AS QUANTIDADE_SALDO FROM item_nota_propria             ip INNER JOIN nota_propria            np ON np.id_nota_propria             = ip.id_nota_fiscal_propria INNER JOIN unidade_fat_cliente     uc ON uc.id_unidade_fat_cliente      = np.id_unidade_fat_cliente INNER JOIN cliente                 cl ON cl.id_cliente                  = uc.id_cliente INNER JOIN pessoa                  pc ON pc.id_pessoa                   = cl.id_pessoa INNER JOIN complemento             cc ON cc.id_complemento              = pc.id_complemento INNER JOIN natureza_operacao       nr ON nr.id_natureza_operacao        = np.id_natureza_operacao INNER JOIN grade_item_nota_propria gp ON gp.id_item_nota_fiscal_propria = ip.id_item_nota_propria INNER JOIN estoque_terceiros       ep ON ep.id_grade_item_nota_propria  = gp.id_grade_item_nota_propria INNER JOIN situacao_documento      sp ON sp.id_situacao_documento       = np.id_situacao_documento INNER JOIN produto                 pp ON pp.id_produto                  = ip.id_produto INNER JOIN unidade_medida          up ON up.id_unidade_medida           = ip.id_unidade_medida WHERE pc.id_pessoa               = :idPessoa AND   nr.tipo_estoque            = :tipoEstoque AND   np.data_emissao      BETWEEN :dataInicial AND :dataFinal AND   np.id_empresa              = :idEmpresa AND   ip.id_produto              = :idProduto AND   nr.id_tipo_movimento       = :idTipoMovimento AND   (ep.desativa_mov_terceiros = 0 OR ep.desativa_mov_terceiros IS NULL) AND   sp.codigo                 <> :situacaoDocumento1 AND   sp.codigo                 <> :situacaoDocumento2 AND   sp.codigo                 <> :situacaoDocumento3");
        q.setParameter("idPessoa", (Object)idPessoa);
        q.setParameter("tipoEstoque", (Object)tipoEstoque);
        q.setParameter("dataInicial", (Object)dataInicial);
        q.setParameter("dataFinal", (Object)dataFinal);
        q.setParameter("idEmpresa", (Object)idEmpresa);
        q.setParameter("idProduto", (Object)idProduto);
        q.setParameter("idTipoMovimento", (Object)idTipoMovimento);
        q.setParameter("situacaoDocumento1", (Object)EnumConstSituacaoDocumento.CANCELADO.getValue());
        q.setParameter("situacaoDocumento2", (Object)EnumConstSituacaoDocumento.CANCELADO_EXTEMPORANEO.getValue());
        q.setParameter("situacaoDocumento3", (Object)EnumConstSituacaoDocumento.DENEGADO.getValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public List<HashMap> getMovimentacoesEntradaSaidaPorPeriodoAndGradeQuantitativo(java.util.Date dataIn, java.util.Date dataFim, Long idEmpresa, Short filtrarProduto, Long idProdutoInicial, Long idProdutoFinal, Short tipoCentroEstPropTerc, Long idCentroEstoqueInicial, Long idCentroEstoqueFinal) {
        String query = "select coalesce(s.qtd_entrada_dia,0) as QUANTIDADE_ENTRADA, coalesce(s.qtd_saida_dia,0)   as QUANTIDADE_SAIDA, s.id_produto as ID_PRODUTO, s.id_grade_cor as ID_GRADE_COR, s.id_centro_estoque as ID_CENTRO_ESTOQUE, s.data_saldo        as DATA_SALDO, s.id_saldo_est_proprio   as ID_SALDO_EST_PROPRIO from saldo_est_proprio s where (s.data_saldo between :data_inicial and :data_final)  and (s.id_centro_estoque between :idCentroEstoqueInicial and :idCentroEstoqueFinal)  and (s.id_empresa = :id_empresa)  and (:filtrarProduto = 0 or s.id_produto between :id_produto_inicial and :id_produto_final) and s.tipo_saldo=:tipoCentroEstPropTerc";
        NativeQuery q = this.sqlQuery(query);
        q.setDate("data_inicial", dataIn);
        q.setDate("data_final", dataFim);
        q.setLong("id_empresa", idEmpresa.longValue());
        q.setShort("filtrarProduto", filtrarProduto.shortValue());
        q.setLong("id_produto_inicial", idProdutoInicial.longValue());
        q.setLong("id_produto_final", idProdutoFinal.longValue());
        q.setShort("tipoCentroEstPropTerc", tipoCentroEstPropTerc.shortValue());
        q.setLong("idCentroEstoqueInicial", idCentroEstoqueInicial.longValue());
        q.setLong("idCentroEstoqueFinal", idCentroEstoqueFinal.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        return lista;
    }

    public List dadosRelatorioConfEstoque(Long idProdInicial, Long idProdFinal, java.util.Date dataSaldo, Long idLocalizacaoInicial, Long idLocalizacaoFinal, Long idCentroEstoqueInicial, Long idCentroEstoqueFinal, Long idFabricanteInicial, Long idFabricanteFinal, Long idEspecieInicial, Long idEspecieFinal, Long idSubEspecieInicial, Long idSubEspecieFinal, Long idGradeCorInicial, Long idGradeCorFinal, Integer tipoProdutoInicial, Integer tipoProdutoFinal, Long idEmpresa, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoque) {
        String sql = "SELECT DISTINCT l.id_localizacao AS F_ID_LOCALIZACAO, \n        l.nome                    AS F_NOME_LOCALIZACAO, \n        pr.id_produto             AS F_ID_PROD, \n        pr.codigo_auxiliar        AS F_CODIGO_AUX, \n        pr.nome                   AS F_NOME_PRODUTO, \n        u.sigla                   AS F_NOME_SIGLA, \n        n.codigo                  AS F_CODIGO, \n        S.saldo_qtd               AS F_SALDO_QTD, \n        S.id_c_estoque            AS F_ID_CENTRO_ESTOQUE, \n        c.descricao               AS F_NOME_CENTRO_ESTOQUE, \n        pr.observacao             AS F_OBS_PRODUTO, \n        pr.qtd_min                AS F_QTD_MIN, \n        e.id_especie              AS F_ID_ESPECIE, \n        e.nome                    AS F_NOME_ESPECIE, \n        sb.id_sub_especie         AS F_ID_SUB_ESPECIE, \n        sb.nome                   AS F_NOME_SUB_ESPECIE \nFROM SALDO_PRODUTO_DETALHADO( :ID_TIPO_INICIAL, :ID_TIPO_FINAL,    :ID_PROD_INICIAL, :ID_PROD_FINAL,    :DATA_SALDO,    :ID_GRADE_COR_INICIAL, :ID_GRADE_COR_FINAL,    :ID_ESPECIE_INICIAL, :ID_ESPECIE_FINAL,    :ID_SUB_ESPECIE_INICIAL, :ID_SUB_ESPECIE_FINAL,    :ID_LOCALIZACAO_INICIAL, :ID_LOCALIZACAO_FINAL,    :ID_FABRICANTE_INICIAL, :ID_FABRICANTE_FINAL,    :ID_EMPRESA, :ID_EMPRESA,    :ID_CENTRO_ESTOQUE_INICIAL, :ID_CENTRO_ESTOQUE_FINAL,    :ID_LOTE_FAB,    :TIPO_SALDO,    :TIPO_SALDO_QUANTIDADE,    :TIPO_CARREGAMENTO,    :TIPO_DISPONIBILIDADE,    :TIPO_ESTOQUE_C_ESTOQUE,    :ID_PARCEIRO ) s \nINNER JOIN produto pr ON pr.id_produto = s.id_produto \nINNER JOIN localizacao l ON l.id_localizacao = pr.id_localizacao \nINNER JOIN unidade_medida u ON u.id_unidade_medida = pr.id_unidade_medida \nINNER JOIN especie e ON e.id_especie = pr.id_especie \nINNER JOIN sub_especie sb ON sb.id_sub_especie = pr.id_sub_especie \nLEFT JOIN centro_estoque c ON c.id_centro_estoque = s.id_c_estoque \nLEFT JOIN ncm n ON n.id_ncm = pr.id_ncm \nWHERE (pr.id_fabricante BETWEEN :ID_FABRICANTE_INICIAL AND :ID_FABRICANTE_FINAL) \n";
        if (tipoEstoqueCentroEstoque == null) {
            tipoEstoqueCentroEstoque = EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO;
        }
        NativeQuery q = this.sqlQuery(sql);
        q.setParameter("ID_TIPO_INICIAL", (Object)tipoProdutoInicial);
        q.setParameter("ID_TIPO_FINAL", (Object)tipoProdutoFinal);
        q.setParameter("ID_PROD_INICIAL", (Object)idProdInicial);
        q.setParameter("ID_PROD_FINAL", (Object)idProdFinal);
        q.setParameter("DATA_SALDO", (Object)dataSaldo);
        q.setParameter("ID_GRADE_COR_INICIAL", (Object)idGradeCorInicial);
        q.setParameter("ID_GRADE_COR_FINAL", (Object)idGradeCorFinal);
        q.setParameter("ID_ESPECIE_INICIAL", (Object)idEspecieInicial);
        q.setParameter("ID_ESPECIE_FINAL", (Object)idEspecieFinal);
        q.setParameter("ID_SUB_ESPECIE_INICIAL", (Object)idSubEspecieInicial);
        q.setParameter("ID_SUB_ESPECIE_FINAL", (Object)idSubEspecieFinal);
        q.setParameter("ID_LOCALIZACAO_INICIAL", (Object)idLocalizacaoInicial);
        q.setParameter("ID_LOCALIZACAO_FINAL", (Object)idLocalizacaoFinal);
        q.setParameter("ID_FABRICANTE_INICIAL", (Object)idFabricanteInicial);
        q.setParameter("ID_FABRICANTE_FINAL", (Object)idFabricanteFinal);
        q.setParameter("ID_EMPRESA", (Object)idEmpresa);
        q.setParameter("ID_CENTRO_ESTOQUE_INICIAL", (Object)idCentroEstoqueInicial);
        q.setParameter("ID_CENTRO_ESTOQUE_FINAL", (Object)idCentroEstoqueFinal);
        q.setParameter("TIPO_SALDO", (Object)3);
        q.setParameter("TIPO_SALDO_QUANTIDADE", (Object)1);
        q.setParameter("TIPO_CARREGAMENTO", (Object)2);
        q.setParameter("ID_LOTE_FAB", null);
        q.setParameter("TIPO_DISPONIBILIDADE", null);
        q.setParameter("TIPO_ESTOQUE_C_ESTOQUE", (Object)tipoEstoqueCentroEstoque.getValue());
        q.setParameter("ID_PARCEIRO", null);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public List<HashMap> getProdutosSemMovimentacoes(Short filtrarProduto, Long idProdutoInicial, Long idProdutoFinal, java.util.Date dataInicial) {
        Object sql = " select p.id_produto as ID_PRODUTO, p.nome as NOME from  grade_cor g  inner join produto_grade pg on pg.id_produto_grade = g.id_produto_grade inner join produto p on p.id_produto = pg.id_produto where not exists      (select gc.id_grade_cor       from saldo_est_proprio ss       inner join grade_cor gc on gc.id_grade_cor = ss.id_grade_cor      where gc.id_grade_cor = g.id_grade_cor";
        if (dataInicial != null) {
            sql = (String)sql + " and ss.DATA_SALDO > :dataInicial";
        }
        sql = (String)sql + ")";
        if (filtrarProduto == 1) {
            sql = (String)sql + " and p.id_produto between :idProdIni and :idProdFin";
        }
        NativeQuery q = this.sqlQuery((String)sql);
        if (filtrarProduto == 1) {
            q.setLong("idProdIni", idProdutoInicial.longValue());
            q.setLong("idProdFin", idProdutoFinal.longValue());
        }
        if (dataInicial != null) {
            q.setDate("dataInicial", dataInicial);
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        return lista;
    }

    public List<HashMap> getProdutosMovimentosDataInicialFinalEmpresas(GradeCor gradeCor, java.util.Date dataInicial, java.util.Date dataFinal, List<Empresa> empresas) {
        NativeQuery q = this.sqlQuery("SELECT s.data_saldo AS DATA_MOVIMENTACAO, SUM((s.qtd_saida_dia - s.qtd_saida_dia_interno)) AS QUANTIDADE FROM saldo_est_proprio s WHERE s.id_grade_cor = :gradeCor AND s.data_saldo BETWEEN :dataInicial AND :dataFinal AND s.id_empresa IN(:empresas) GROUP BY s.data_saldo having SUM((s.qtd_saida_dia - s.qtd_saida_dia_interno))>0 ORDER BY s.data_saldo");
        q.setLong("gradeCor", gradeCor.getIdentificador().longValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setParameterList("empresas", empresas);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List aux = q.list();
        aux.forEach(i -> i.put("QUANTIDADE", ((Number)i.get("QUANTIDADE")).doubleValue()));
        return aux;
    }

    public List<SaldoEstoqueGeralDetBasico> findSaldoTodosProdutosProprioNCMInicialFinal(java.util.Date dataConsultaEstoque, List<Map> ncms, Empresa emp, long idProdInicial, long idProdFinal, EnumConstCentroEstTipoPropTerc tipoCentroEstoque) {
        Object query = "SELECT p.ID_PRODUTO as ID_PRODUTO, p.ID_EMPRESA as ID_EMPRESA, pr.CODIGO_AUXILIAR as COD_AUX_PRODUTO, pr.NOME as PRODUTO, u.sigla as UNIDADE_MEDIDA, N.CODIGO AS NCM, p.QTD_ENTRADA_DIA as QTD_ENTRADA_DIA, p.QTD_SAIDA_DIA as QTD_SAIDA_DIA, p.SALDO_QTD as SALDO_QTD,  p.SALDO_VALOR as SALDO_VALOR,  p.SALDO_QTD_ANTERIOR as SALDO_QTD_ANTERIOR, p.SALDO_VALOR_ANTERIOR as SALDO_VALOR_ANTERIOR, p.VALOR_PRECO_MEDIO as VALOR_PRECO_MEDIO,  p.DATA_SALDO as DATA_SALDO FROM SALDO_PRODUTO_DETALHADO(null,null,null, null, :data, :gradeIn, :gradeFim, null, null, null, null, null, null, null, null, :idEmp, :idEmpFinal,:idCentroEstoqueIn,:idCentroEstoqueFin,null, :tipoSaldo, :tipoSaldoQtde, :tipoCarregamento, null, :tipoCentroEstPropTerc, null ) p inner join produto pr on pr.id_produto = p.id_produto inner join ncm n on n.id_ncm = pr.id_ncm  LEFT JOIN UNIDADE_MEDIDA U ON u.id_unidade_medida=pr.id_unidade_medida";
        if (!ncms.isEmpty()) {
            query = (String)query + " where ( ";
        }
        int i = 0;
        int size = ncms.size();
        for (Map o : ncms) {
            HashMap h = (HashMap)o;
            query = (String)query + " cast(n.codigo as bigint) between :ni" + i + " and :nii" + i;
            if (i < size - 1) {
                query = (String)query + " or ";
            }
            ++i;
        }
        if (!ncms.isEmpty()) {
            query = (String)query + " )";
        }
        NativeQuery q = this.sqlQuery((String)query);
        if (dataConsultaEstoque == null) {
            dataConsultaEstoque = new java.util.Date();
        }
        q.setDate("data", (java.util.Date)new Date(dataConsultaEstoque.getTime()));
        q.setLong("idEmp", emp.getIdentificador().longValue());
        q.setLong("idEmpFinal", emp.getIdentificador().longValue());
        q.setParameter("gradeIn", null);
        q.setParameter("gradeFim", null);
        q.setParameter("idCentroEstoqueIn", null);
        q.setParameter("idCentroEstoqueFin", null);
        q.setInteger("tipoSaldo", 1);
        q.setInteger("tipoSaldoQtde", 2);
        q.setInteger("tipoCarregamento", 3);
        q.setInteger("tipoCentroEstPropTerc", (int)tipoCentroEstoque.getValue().shortValue());
        i = 0;
        for (Map o : ncms) {
            HashMap h = (HashMap)o;
            Long ncmIn = (Long)h.get("NCM_INICIAL");
            Long ncmFim = (Long)h.get("NCM_FINAL");
            q.setParameter("ni" + i, (Object)ncmIn);
            q.setParameter("nii" + i, (Object)ncmFim);
            ++i;
        }
        q.setResultTransformer((ResultTransformer)new SaldoBasicoDetResultTransformer());
        return q.list();
    }

    public List getSaldoProdutoNecessidadeCompraProduto(java.util.Date data, Long produtoInicial, Long produtoFinal, Long especieInicial, Long especieFinal, Long subEspecieInicial, Long subEspecieFinal, Long centroEstInicial, Long centroEstFinal, Long fabricanteInicial, Long fabricanteFinal, Long gradeInicial, Long gradeFinal, Long idGrupoProdutos, Integer tipoProdutoInicial, Integer tipoProdutoFinal, Short tipoPesquisa, Long idEmpresa, Short produtosSemMovimentacao, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoCentroEstPropTerc) {
        ArrayList lista = new ArrayList();
        lista.addAll(this.getSaldoProdutoNecessidadeCompraProdutoComMovimentacoes(data, produtoInicial, produtoFinal, especieInicial, especieFinal, subEspecieInicial, subEspecieFinal, centroEstInicial, centroEstFinal, fabricanteInicial, fabricanteFinal, gradeInicial, gradeFinal, idGrupoProdutos, tipoProdutoInicial, tipoProdutoFinal, tipoPesquisa, idEmpresa, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoCentroEstPropTerc));
        lista.addAll(this.getSaldoProdutoNecessidadeCompraProdutoSemMovimentacoes(especieInicial != null ? especieInicial : 0L, especieFinal != null ? especieFinal : 9999999L, subEspecieInicial != null ? subEspecieInicial : 0L, subEspecieFinal != null ? subEspecieFinal : 9999999L, fabricanteInicial != null ? fabricanteInicial : 0L, fabricanteFinal != null ? fabricanteFinal : 9999999L, idGrupoProdutos, tipoProdutoInicial, (short)3, produtosSemMovimentacao));
        return lista;
    }

    public List<HashMap> findProdutosRessuprimentoEstoque(java.util.Date dataRessuprimento, Fabricante fabricante, Especie especie, SubEspecie subEspecie, GrupoProdutos grupoProdutos, ClassificacaoAnaliseEstoque classificacao, Empresa empresa, Short tipoProduto, Short tipoCentroEstoquePropTerc) {
        NativeQuery q = this.sqlQuery(" SELECT       gc.ID_GRADE_COR           AS ID_GRADE_COR, COALESCE(S.SALDO_QTD,0)         AS SALDO_QTD, COALESCE(S.SALDO_VALOR,0)       AS SALDO_VALOR, GC.LEAD_TIME             AS LEAD_TIME, GC.ESTOQUE_MAXIMO        AS ESTOQUE_MAXIMO, GC.ESTOQUE_MINIMO        AS ESTOQUE_MINIMO, GC.ESTOQUE_RESSUPRIMENTO AS ESTOQUE_RESSUPRIMENTO  FROM GRUPO_ANALISE_ESTOQUE_GC GC INNER JOIN GRADE_COR G ON G.ID_GRADE_COR=GC.ID_GRADE_COR  INNER JOIN PRODUTO_GRADE PG ON PG.ID_PRODUTO_GRADE=G.ID_PRODUTO_GRADE  INNER JOIN PRODUTO P ON P.ID_PRODUTO = PG.ID_PRODUTO  INNER JOIN PRODUTO_TIPO_COMPRA PT ON P.id_produto_tipo_compra = PT.id_produto_tipo_compra  INNER JOIN GRUPO_ANALISE_ESTOQUE GE ON GC.ID_GRUPO_ANALISE_ESTOQUE = GE.ID_GRUPO_ANALISE_ESTOQUE INNER JOIN GRUPO_ANAL_ESTOQUE_EMP GEMP ON GEMP.ID_GRUPO_ANALISE_ESTOQUE = GE.ID_GRUPO_ANALISE_ESTOQUE left JOIN SALDO_PRODUTO_DETALHADO(:tipoProduto, :tipoProduto,            0, 9999999,            :DATA_RESSUPRIMENTO,            0, 9999999,\n            :ESPECIE_INICIAL, :ESPECIE_FINAL,            :SUB_ESPECIE_INICIAL, :SUB_ESPECIE_FINAL,            0, 9999999,            :FABRICANTE_INICIAL, :FABRICANTE_FINAL,            :EMP, :EMP,            0, 9999999,            null,            :tipoSaldo,            :tipoSaldoQtde,            :tipoCarregamento,            :tipoDisponibilidade,            :tipoCentroEstoquePropTerc,            null) S ON GC.ID_GRADE_COR  = S.ID_GRADE_COR AND GEMP.ID_EMPRESA = :EMP AND (PT.TIPO = :ponto_estoque or pt.tipo=:indifere) and(:tipoProduto is null or(P.ENTRADA_SAIDA = :tipoProduto)) and(:idGrupoProdutos is null or (p.id_grupo_produtos = :idGrupoProdutos)) and(:idClassificacao is null or (GE.ID_CLASSIFI_ANALISE_ESTOQUE = :idClassificacao)) WHERE (p.ID_FABRICANTE BETWEEN :FABRICANTE_INICIAL AND :FABRICANTE_FINAL) AND (P.ID_ESPECIE BETWEEN :ESPECIE_INICIAL AND :ESPECIE_FINAL) AND (P.ID_SUB_ESPECIE BETWEEN :SUB_ESPECIE_INICIAL AND :SUB_ESPECIE_FINAL)");
        if (tipoProduto != null && tipoProduto.shortValue() != EnumConstTipoProdutoEntradaSaida.TODOS.getValue()) {
            q.setParameter("tipoProduto", (Object)tipoProduto);
        } else {
            q.setParameter("tipoProduto", null);
        }
        if (grupoProdutos != null) {
            q.setParameter("idGrupoProdutos", (Object)grupoProdutos.getIdentificador().intValue());
        } else {
            q.setParameter("idGrupoProdutos", null);
        }
        if (classificacao != null) {
            q.setParameter("idClassificacao", (Object)classificacao.getIdentificador().intValue());
        } else {
            q.setParameter("idClassificacao", null);
        }
        q.setParameter("ponto_estoque", (Object)1);
        q.setParameter("indifere", (Object)2);
        q.setParameter("DATA_RESSUPRIMENTO", (Object)dataRessuprimento);
        q.setParameter("EMP", (Object)empresa.getIdentificador());
        q.setParameter("ESPECIE_INICIAL", (Object)(especie != null ? especie.getIdentificador().intValue() : 0));
        q.setParameter("ESPECIE_FINAL", (Object)(especie != null ? especie.getIdentificador().intValue() : 9999999));
        q.setParameter("SUB_ESPECIE_INICIAL", (Object)(subEspecie != null ? subEspecie.getIdentificador().intValue() : 0));
        q.setParameter("SUB_ESPECIE_FINAL", (Object)(subEspecie != null ? subEspecie.getIdentificador().intValue() : 9999999));
        q.setParameter("FABRICANTE_INICIAL", (Object)(fabricante != null ? fabricante.getIdentificador().intValue() : 0));
        q.setParameter("FABRICANTE_FINAL", (Object)(fabricante != null ? fabricante.getIdentificador().intValue() : 9999999));
        q.setParameter("tipoSaldo", (Object)2);
        q.setParameter("tipoSaldoQtde", (Object)1);
        q.setParameter("tipoCarregamento", (Object)EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_SOMENTE_QTD.getValue());
        q.setParameter("tipoDisponibilidade", (Object)EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_DISPONIVEL.getValue());
        q.setParameter("tipoCentroEstoquePropTerc", (Object)tipoCentroEstoquePropTerc);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List getSaldoProdutoNecessidadeCompraProdutoComMovimentacoes(java.util.Date data, Long produtoInicial, Long produtoFinal, Long especieInicial, Long especieFinal, Long subEspecieInicial, Long subEspecieFinal, Long centroEstInicial, Long centroEstFinal, Long fabricanteInicial, Long fabricanteFinal, Long gradeInicial, Long gradeFinal, Long idGrupoProdutos, Integer tipoProdutoInicial, Integer tipoProdutoFinal, Short tipoPesquisa, Long idEmpresa, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoCentroEstPropTerc) {
        HashMap<String, Long> paramsAdic = new HashMap<String, Long>();
        paramsAdic.put("ID_ESPECIE_INICIAL", especieInicial);
        paramsAdic.put("ID_ESPECIE_FINAL", especieFinal);
        paramsAdic.put("ID_SUB_ESPECIE_INICIAL", subEspecieInicial);
        paramsAdic.put("ID_SUB_ESPECIE_FINAL", subEspecieFinal);
        paramsAdic.put("ID_FABRICANTE_INICIAL", fabricanteInicial);
        paramsAdic.put("ID_FABRICANTE_FINAL", fabricanteFinal);
        List saldos = this.findSaldoEstoqueGeral(tipoProdutoInicial, tipoProdutoFinal, produtoInicial, produtoFinal, data, idEmpresa, idEmpresa, centroEstInicial, centroEstFinal, gradeInicial, gradeFinal, null, tipoSaldo, tipoQtde, tipoCarregamento, paramsAdic, tipoDisponibilidade, tipoCentroEstPropTerc, null, this.getSaldoResultTransformer(), null, null);
        ArrayList<SaldoEstoqueGeral> lista = new ArrayList<SaldoEstoqueGeral>();
        ArrayList retorno = new ArrayList();
        if (TMethods.isNull((Object)saldos).booleanValue()) {
            return retorno;
        }
        for (SaldoEstoqueGeral s : saldos) {
            Produto p = s.getGradeCor().getProdutoGrade().getProduto();
            if (TMethods.isNotNull((Object)idGrupoProdutos).booleanValue() && TMethods.isNull((Object)p.getGrupoProdutos()).booleanValue() || TMethods.isNotNull((Object)idGrupoProdutos).booleanValue() && TMethods.isNotNull((Object)p.getGrupoProdutos()).booleanValue() && !TMethods.isEquals((Object)p.getGrupoProdutos().getIdentificador(), (Object)idGrupoProdutos) || !TMethods.isNotNull((Object)p.getProdutoTipoCompra()).booleanValue() || !TMethods.isEquals((Object)p.getProdutoTipoCompra().getTipo(), (Object)1) && !TMethods.isEquals((Object)p.getProdutoTipoCompra().getTipo(), (Object)2)) continue;
            if (TMethods.isNotNull((Object)tipoPesquisa).booleanValue() && TMethods.isEquals((Object)tipoPesquisa, (Object)0) && (TMethods.isNull((Object)s.getQuantidade()) != false && p.getQtdMax() > 0.0 || s.getQuantidade() > p.getQtdMax())) {
                lista.add(s);
                continue;
            }
            if (TMethods.isNotNull((Object)tipoPesquisa).booleanValue() && TMethods.isEquals((Object)tipoPesquisa, (Object)1) && (TMethods.isNull((Object)s.getQuantidade()) != false && p.getQtdMin() > 0.0 || s.getQuantidade() < p.getQtdMin())) {
                lista.add(s);
                continue;
            }
            if (!(TMethods.isNull((Object)s.getQuantidade()) != false && p.getPontoRessupEstoque() > 0.0) && !(s.getQuantidade() < p.getPontoRessupEstoque())) continue;
            lista.add(s);
        }
        for (SaldoEstoqueGeral s : lista) {
            if (!TMethods.isAffirmative((Number)s.getGradeCor().getProdutoGrade().getProduto().getAtivo())) continue;
            HashMap<String, Number> h = new HashMap<String, Number>();
            h.put("ID_GRADE_COR", s.getGradeCor().getIdentificador().intValue());
            h.put("SALDO_QTD", s.getQuantidade());
            h.put("QTD_MAX", s.getGradeCor().getProdutoGrade().getProduto().getQtdMax());
            h.put("QTD_MIN", s.getGradeCor().getProdutoGrade().getProduto().getQtdMin());
            h.put("ID_TIPO_ITEM_SPED", s.getGradeCor().getProdutoGrade().getProduto().getTipoIemSped().getIdentificador());
            h.put("PONTO_RESSUPRIMENTO", s.getGradeCor().getProdutoGrade().getProduto().getPontoRessupEstoque());
            h.put("ID_PRODUTO", s.getGradeCor().getProdutoGrade().getProduto().getIdentificador());
            retorno.add(h);
        }
        return retorno;
    }

    private List getSaldoProdutoNecessidadeCompraProdutoSemMovimentacoes(Long especieInicial, Long especieFinal, Long subEspecieInicial, Long subEspecieFinal, Long fabricanteInicial, Long fabricanteFinal, Long idGrupoProdutos, Integer tipoProdutoInicial, Short tipoPesquisa, Short produtosSemMovimentacao) {
        if (TMethods.isAffirmative((Number)produtosSemMovimentacao)) {
            Object st = " select  p.id_produto as ID_PRODUTO, p.codigo_auxiliar as CODIGO_AUXILIAR, p.nome as PRODUTO, p.qtd_min as QTD_MIN, p.qtd_max as QTD_MAX, p.ponto_resuprimento_est as PONTO_RESSUPRIMENTO, u.sigla as UNIDADE_MEDIDA, g.id_grade_cor as ID_GRADE_COR, e.nome as ESPECIE, su.nome as SUB_ESPECIE, p.id_tipo_item_sped as ID_TIPO_ITEM_SPED from  produto p  inner join produto_grade pg  on pg.id_produto = p.id_produto inner join grade_cor g on g.id_produto_grade = pg.id_produto_grade  inner join especie e        on e.id_especie = p.id_especie inner join SUB_ESPECIE su   on su.id_SUB_ESPECIE = p.id_SUB_ESPECIE inner join unidade_medida u on p.id_unidade_medida = u.id_unidade_medida where  (:tipo_inicial is null or p.entrada_saida=:tipo_inicial) and p.ativo = :sim and p.id_especie between :id_especie_inicial and :id_especie_final and p.id_sub_especie between :id_subespecie_inicial and :id_subespecie_final and (:id_grupo_produtos is null or p.id_grupo_produtos = :id_grupo_produtos) and (p.id_fabricante is null or p.id_fabricante between :id_fabricante_inicial and :id_fabricante_final) and not exists (select ss.id_grade_cor from saldo_est_proprio ss where ss.id_grade_cor = g.id_grade_cor)";
            st = TMethods.isNotNull((Object)tipoPesquisa) != false && TMethods.isEquals((Object)tipoPesquisa, (Object)0) ? (String)st + " and (p.qtd_max>0)" : (TMethods.isNotNull((Object)tipoPesquisa) != false && TMethods.isEquals((Object)tipoPesquisa, (Object)1) ? (String)st + " and (p.qtd_min>0)" : (String)st + " and (p.ponto_resuprimento_est >0)");
            st = (String)st + " order by p.nome";
            NativeQuery q = this.sqlQuery((String)st);
            q.setParameter("tipo_inicial", (Object)tipoProdutoInicial);
            q.setParameter("id_especie_inicial", (Object)especieInicial);
            q.setParameter("id_especie_final", (Object)especieFinal);
            q.setParameter("id_subespecie_inicial", (Object)subEspecieInicial);
            q.setParameter("id_subespecie_final", (Object)subEspecieFinal);
            q.setParameter("id_fabricante_inicial", (Object)fabricanteInicial);
            q.setParameter("id_fabricante_final", (Object)fabricanteFinal);
            q.setParameter("sim", (Object)EnumConstantsMentorSimNao.SIM.getValue());
            if (TMethods.isNotNull((Object)idGrupoProdutos).booleanValue()) {
                q.setParameter("id_grupo_produtos", (Object)idGrupoProdutos.intValue());
            } else {
                q.setParameter("id_grupo_produtos", null);
            }
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List lista = q.list();
            if (TMethods.isWithData((Collection)lista)) {
                for (HashMap h : lista) {
                    Integer valor = 0;
                    h.put("SALDO_QTD", valor);
                    h.put("SALDO_VALOR", valor);
                    h.put("VLR_PRECO_MEDIO", valor);
                }
            }
            return lista;
        }
        return new ArrayList();
    }
}

