/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.saldotitulos.EnumConstSaldoTitPagRec;
import com.touchcomp.basementor.constants.enums.saldotitulos.EnumConstSaldoTitPessoaGrupoPessoa;
import com.touchcomp.basementor.constants.enums.saldotitulos.EnumConstSaldoTitProvReal;
import com.touchcomp.basementor.constants.enums.saldotitulos.EnumConstSaldoTitTipoRet;
import com.touchcomp.basementor.model.impl.SaldoFinanceiroPessoa;
import com.touchcomp.basementor.model.impl.SaldoFinanceiroTituloPessoa;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorservice.dao.DaoGenericImpl;
import com.touchcomp.basementorservice.dao.resulttransformer.SaldoFinanceiroPessoaResultTransformer;
import com.touchcomp.basementorservice.dao.resulttransformer.SaldoFinanceiroPessoaTituloResultTransformer;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Date;
import java.util.List;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Repository;

@Repository
public class DaoSaldoTitulosImpl
extends DaoGenericImpl {
    private final SaldoFinanceiroPessoaResultTransformer SALDO_FINANCEIRO_PESSOA_RES_TRANSFORMER = new SaldoFinanceiroPessoaResultTransformer();
    private final SaldoFinanceiroPessoaTituloResultTransformer SALDO_FINANCEIRO_PESSOA_TITULO_RES_TRANSFORMER = new SaldoFinanceiroPessoaTituloResultTransformer();

    public SaldoFinanceiroPessoa getSaldoAbertoPessoa(Date dataSaldo, Date dataInicioEmissao, Long idPessoa, Long idCarteiraIn, Long idCarteiraFim, Date dataVencIn, Date dataVencFim, Long idEmpresaIn, Long idEmpresaFim, Long idGrupoEmpresa, EnumConstSaldoTitPagRec pagRec, EnumConstSaldoTitPessoaGrupoPessoa tipoPessoaGrupo) {
        List<SaldoFinanceiroPessoa> ret = this.getResumoFinanceiroPessoas(dataSaldo = dataSaldo != null ? dataSaldo : new Date(), dataInicioEmissao, idPessoa, idPessoa, idCarteiraIn, idCarteiraFim, dataVencIn, dataVencFim, idEmpresaIn, idEmpresaFim, idGrupoEmpresa, null, null, pagRec, EnumConstSaldoTitProvReal.TIPO_TITULO_REALIZADO, EnumConstSaldoTitTipoRet.TIPO_SALDO_ABERTO, null, null, tipoPessoaGrupo);
        if (ret != null && !ret.isEmpty()) {
            return ret.get(0);
        }
        SaldoFinanceiroPessoa s = new SaldoFinanceiroPessoa();
        s.setIdPessoa(idPessoa);
        return s;
    }

    public List<SaldoFinanceiroPessoa> getSaldoAbertoPessoas(Date dataSaldo, Date dataInicioEmissao, Long idPessoaIn, Long idPessoaFim, Long idCarteiraIn, Long idCarteiraFim, Date dataVencIn, Date dataVencFim, Long idEmpresaIn, Long idEmpresaFim, Long idGrupoEmpresa, EnumConstSaldoTitPagRec pagRec, EnumConstSaldoTitPessoaGrupoPessoa tipoPessoaGrupo) {
        dataSaldo = dataSaldo != null ? dataSaldo : new Date();
        return this.getResumoFinanceiroPessoas(dataSaldo, dataInicioEmissao, idPessoaIn, idPessoaFim, idCarteiraIn, idCarteiraFim, dataVencIn, dataVencFim, idEmpresaIn, idEmpresaFim, idGrupoEmpresa, null, null, pagRec, EnumConstSaldoTitProvReal.TIPO_TITULO_REALIZADO, EnumConstSaldoTitTipoRet.TIPO_SALDO_ABERTO, null, null, tipoPessoaGrupo);
    }

    public List<SaldoFinanceiroPessoa> getSaldoAbertoPessoas(Date dataSaldo, Date dataInicioEmissao, Long idPessoaIn, Long idPessoaFim, Long idCarteiraIn, Long idCarteiraFim, Date dataVencIn, Date dataVencFim, Long idEmpresaIn, Long idEmpresaFim, Long idGrupoEmpresa, EnumConstSaldoTitPagRec pagRec, Integer firstReg, Integer maxReg, EnumConstSaldoTitPessoaGrupoPessoa tipoPessoaGrupoPessoa) {
        dataSaldo = dataSaldo != null ? dataSaldo : new Date();
        return this.getResumoFinanceiroPessoas(dataSaldo, dataInicioEmissao, idPessoaIn, idPessoaFim, idCarteiraIn, idCarteiraFim, dataVencIn, dataVencFim, idEmpresaIn, idEmpresaFim, idGrupoEmpresa, null, null, pagRec, EnumConstSaldoTitProvReal.TIPO_TITULO_REALIZADO, EnumConstSaldoTitTipoRet.TIPO_SALDO_ABERTO, firstReg, maxReg, tipoPessoaGrupoPessoa);
    }

    public List<SaldoFinanceiroPessoa> getSaldosAbertoVencidoPessoas(Date dataInicioEmissao, Long idPessoaIn, Long idPessoaFim, Long idCarteiraIn, Long idCarteiraFim, Long idEmpresaIn, Long idEmpresaFim, Long idGrupoEmpresa, EnumConstSaldoTitPagRec pagRec, Date dataCompIn, Date dataCompFim, Integer diasTolerancia, EnumConstSaldoTitPessoaGrupoPessoa tipoPessoaGrupoPessoa) {
        Date vencInicial = ToolDate.strToDate((String)"01/01/0001");
        Date vencFinal = ToolDate.previousDays((Date)new Date(), (int)(1 + diasTolerancia));
        return this.getResumoFinanceiroPessoas(new Date(), dataInicioEmissao, idPessoaIn, idPessoaFim, idCarteiraIn, idCarteiraFim, vencInicial, vencFinal, idEmpresaIn, idEmpresaFim, idGrupoEmpresa, dataCompIn, dataCompFim, pagRec, EnumConstSaldoTitProvReal.TIPO_TITULO_REALIZADO, EnumConstSaldoTitTipoRet.TIPO_SALDO_ABERTO, null, null, tipoPessoaGrupoPessoa);
    }

    public SaldoFinanceiroPessoa getSaldoAbertoVencidoPessoa(Date dataInicioEmissao, Long idPessoa, Long idCarteiraIn, Long idCarteiraFim, Long idEmpresaIn, Long idEmpresaFim, Long idGrupoEmpresa, EnumConstSaldoTitPagRec pagRec, Date dataCompIn, Date dataCompFim, Integer diasTolerancia, EnumConstSaldoTitPessoaGrupoPessoa tipoPessoaGrupoPessoa) {
        Date vencInicial = ToolDate.strToDate((String)"01/01/0001");
        Date vencFinal = new Date();
        List<SaldoFinanceiroPessoa> ret = this.getResumoFinanceiroPessoas(new Date(), dataInicioEmissao, idPessoa, idPessoa, idCarteiraIn, idCarteiraFim, vencInicial, vencFinal = ToolDate.previousDays((Date)vencFinal, (int)(1 + diasTolerancia)), idEmpresaIn, idEmpresaFim, idGrupoEmpresa, dataCompIn, dataCompFim, pagRec, EnumConstSaldoTitProvReal.TIPO_TITULO_REALIZADO, EnumConstSaldoTitTipoRet.TIPO_SALDO_ABERTO, null, null, tipoPessoaGrupoPessoa);
        if (ret != null && !ret.isEmpty()) {
            return ret.get(0);
        }
        SaldoFinanceiroPessoa s = new SaldoFinanceiroPessoa();
        s.setIdPessoa(idPessoa);
        return s;
    }

    public List<SaldoFinanceiroPessoa> getSaldosAbertoVencidoPessoas(Date dataInicioEmissao, Long idPessoaIn, Long idPessoaFim, Long idCarteiraIn, Long idCarteiraFim, Long idEmpresaIn, Long idEmpresaFim, Long idGrupoEmpresa, EnumConstSaldoTitPagRec pagRec, Date dataCompIn, Date dataCompFim, Integer firstRes, Integer maxResult, Integer diasTolerancia, EnumConstSaldoTitPessoaGrupoPessoa tipoPessoaGrupoPessoa) {
        Date vencInicial = ToolDate.strToDate((String)"01/01/0001");
        Date vencFinal = ToolDate.previousDays((Date)new Date(), (int)(1 + diasTolerancia));
        return this.getResumoFinanceiroPessoas(new Date(), dataInicioEmissao, idPessoaIn, idPessoaFim, idCarteiraIn, idCarteiraFim, vencInicial, vencFinal, idEmpresaIn, idEmpresaFim, idGrupoEmpresa, dataCompIn, dataCompFim, pagRec, EnumConstSaldoTitProvReal.TIPO_TITULO_REALIZADO, EnumConstSaldoTitTipoRet.TIPO_SALDO_ABERTO, firstRes, maxResult, tipoPessoaGrupoPessoa);
    }

    public List<SaldoFinanceiroPessoa> getSaldosAbertoPessoasComp(Date dataSaldo, Date dataInicioEmissao, Long idPessoaIn, Long idPessoaFim, Long idCarteiraIn, Long idCarteiraFim, Long idEmpresaIn, Long idEmpresaFim, Long idGrupoEmpresa, EnumConstSaldoTitPagRec pagRec, Date dataCompIn, Date dataCompFim, Date dataEntSaiIn, Date dataEntSaiFim, Integer diasTolerancia, EnumConstSaldoTitPessoaGrupoPessoa tipoPessoaGrupoPessoa) {
        return this.getResumoFinanceiroPessoas(dataSaldo, dataInicioEmissao, idPessoaIn, idPessoaFim, idCarteiraIn, idCarteiraFim, null, null, idEmpresaIn, idEmpresaFim, idGrupoEmpresa, dataCompIn, dataCompFim, dataEntSaiIn, dataEntSaiFim, pagRec, EnumConstSaldoTitProvReal.TIPO_TITULO_REALIZADO, EnumConstSaldoTitTipoRet.TIPO_SALDO_ABERTO, null, null, tipoPessoaGrupoPessoa);
    }

    private List<SaldoFinanceiroPessoa> getResumoFinanceiroPessoas(Date dataSaldo, Date dataInicioEmissao, Long idPessoaIn, Long idPessoaFim, Long idCarteiraIn, Long idCarteiraFim, Date dataVencIn, Date dataVencFim, Long idEmpresaIn, Long idEmpresaFim, Long idGrupoEmpresa, Date dataCompIn, Date dataCompFim, EnumConstSaldoTitPagRec tipoPagRec, EnumConstSaldoTitProvReal provReal, EnumConstSaldoTitTipoRet tipoSaldoRet, Integer firstRegister, Integer maxResult, EnumConstSaldoTitPessoaGrupoPessoa tipoPessoaGrupo) {
        return this.getResumoFinanceiroPessoas(dataSaldo, dataInicioEmissao, idPessoaIn, idPessoaFim, idCarteiraIn, idCarteiraFim, dataVencIn, dataVencFim, idEmpresaIn, idEmpresaFim, idGrupoEmpresa, dataCompIn, dataCompFim, null, null, tipoPagRec, provReal, tipoSaldoRet, firstRegister, maxResult, tipoPessoaGrupo);
    }

    private List<SaldoFinanceiroPessoa> getResumoFinanceiroPessoas(Date dataSaldo, Date dataInicioEmissao, Long idPessoaIn, Long idPessoaFim, Long idCarteiraIn, Long idCarteiraFim, Date dataVencIn, Date dataVencFim, Long idEmpresaIn, Long idEmpresaFim, Long idGrupoEmpresa, Date dataCompIn, Date dataCompFim, Date dataEntSaiIn, Date dataEntSaiFim, EnumConstSaldoTitPagRec tipoPagRec, EnumConstSaldoTitProvReal provReal, EnumConstSaldoTitTipoRet tipoSaldoRet, Integer firstRegister, Integer maxResult, EnumConstSaldoTitPessoaGrupoPessoa tipoPessoaGrupo) {
        if (tipoSaldoRet == null) {
            tipoSaldoRet = EnumConstSaldoTitTipoRet.TIPO_SALDO_TODOS;
        }
        if (provReal == null) {
            provReal = EnumConstSaldoTitProvReal.TIPO_TITULO_TODOS;
        }
        if (tipoPagRec == null) {
            tipoPagRec = EnumConstSaldoTitPagRec.TIPO_TITULO_TODOS;
        }
        dataInicioEmissao = ToolDate.strToDate((String)"01/01/0001");
        Object query = "select    s.R_ID_PESSOA_GRUPO as F_ID_PESSOA,    s.R_NOME as F_NOME_PESSOA,    sum(s.R_VALOR_TITULO) as F_VALOR_TITULO,    sum(s.R_DESCONTO_FINANCEIRO) AS F_VALOR_DESC_FINANCEIRO,    sum(s.R_VALOR_BAIXA) as F_VALOR_BAIXA,    sum(s.R_VR_JUROS) as F_VALOR_JUROS,    sum(s.R_VR_DESCONTO) as F_VALOR_DESCONTO,    sum(s.R_VR_ATUALIZACAO_MONETARIA) as F_VALOR_AT_MONETARIA,    sum(s.R_VR_DESP_BANCARIA_PAGA) as F_VALOR_DESP_BANCARIA_PAG,    sum(s.R_VR_DESP_BANCARIA_REC) as F_VALOR_DESP_BANCARIA_REC,    sum(s.R_VR_MULTA) AS F_VALOR_MULTA,    sum(s.R_VR_PIS) AS F_VALOR_PIS,    sum(s.R_VR_COFINS) AS F_VALOR_COFINS,    sum(s.R_VR_OPERACAO) AS F_VALOR_OPERACAO,    sum(s.R_VR_CONTRIB_SOCIAL) AS F_VALOR_CONTRIB_SOCIAL,    sum(s.R_VALOR_SALDO) AS F_VALOR_SALDO,    sum(s.R_VALOR_JUROS_ATRAS) AS F_VALOR_JUROS_ATRAS,    sum(s.R_VALOR_DESCONTO_ADIAN)AS F_VALOR_DESCONTO_ADIAN,    sum(s.R_VALOR_SALDO_LIQUIDO) AS F_VALOR_SALDO_LIQUIDO,    sum(s.R_VALOR_BAIXA_RENEGOCIACAO) AS F_VALOR_BAIXA_RENEGOCIACAO from proc_saldo_titulos( :dataSaldo, :dataInicioEmissao, :idPessoaIn,:idPessoaFim, :idCartIn,:idCartFim, :dataVencIn, :dataVencFim, :idEmpIn, :idEmpFim, :idGrupoEmp, :dataCompIn,:dataCompFim, :provReal,:pagRec, :tipoRetorno, :tipoPessoaGrupoPessoa)s";
        if (dataEntSaiIn != null && dataEntSaiFim != null) {
            query = (String)query + " where s.r_data_ent_saida between :dataEntSaiIn and :dataEntSaiFim";
        }
        query = (String)query + " group by s.R_ID_PESSOA_GRUPO, s.r_nome";
        NativeQuery q = this.sqlQuery((String)query);
        q.setDate("dataSaldo", dataSaldo);
        q.setDate("dataInicioEmissao", dataInicioEmissao);
        q.setParameter("idPessoaIn", (Object)idPessoaIn);
        q.setParameter("idPessoaFim", (Object)idPessoaFim);
        q.setParameter("idCartIn", (Object)idCarteiraIn);
        q.setParameter("idCartFim", (Object)idCarteiraFim);
        q.setParameter("dataVencIn", (Object)dataVencIn);
        q.setParameter("dataVencFim", (Object)dataVencFim);
        q.setParameter("idEmpIn", (Object)idEmpresaIn);
        q.setParameter("idEmpFim", (Object)idEmpresaFim);
        q.setParameter("idGrupoEmp", (Object)idGrupoEmpresa);
        q.setParameter("dataCompIn", (Object)dataCompIn);
        q.setParameter("dataCompFim", (Object)dataCompFim);
        q.setParameter("provReal", (Object)provReal.value);
        q.setParameter("pagRec", (Object)tipoPagRec.value);
        q.setParameter("tipoRetorno", (Object)tipoSaldoRet.value);
        q.setParameter("tipoPessoaGrupoPessoa", (Object)tipoPessoaGrupo.value);
        if (dataEntSaiIn != null && dataEntSaiFim != null) {
            q.setParameter("dataEntSaiIn", (Object)dataEntSaiIn);
            q.setParameter("dataEntSaiFim", (Object)dataEntSaiFim);
        }
        q.setResultTransformer((ResultTransformer)this.SALDO_FINANCEIRO_PESSOA_RES_TRANSFORMER);
        if (firstRegister != null && firstRegister > 0 && maxResult != null && maxResult > 0) {
            q.setFirstResult(firstRegister.intValue());
            q.setMaxResults(maxResult.intValue());
        }
        return q.list();
    }

    public List<SaldoFinanceiroTituloPessoa> getSaldoTitulosPessoas(Date dataSaldo, Date dataInicioEmissao, Long idPessoaIn, Long idPessoaFim, Long idCarteiraIn, Long idCarteiraFim, Date dataVencIn, Date dataVencFim, Long idEmpresaIn, Long idEmpresaFim, Long idGrupoEmpresa, Date dataCompIn, Date dataCompFim, EnumConstSaldoTitPagRec tipoPagRec, EnumConstSaldoTitProvReal provReal, EnumConstSaldoTitTipoRet tipoSaldoRet, Integer firstRegister, Integer maxResult, EnumConstSaldoTitPessoaGrupoPessoa tipoPessoaGrupo) {
        if (tipoSaldoRet == null) {
            tipoSaldoRet = EnumConstSaldoTitTipoRet.TIPO_SALDO_TODOS;
        }
        if (provReal == null) {
            provReal = EnumConstSaldoTitProvReal.TIPO_TITULO_TODOS;
        }
        if (tipoPagRec == null) {
            tipoPagRec = EnumConstSaldoTitPagRec.TIPO_TITULO_TODOS;
        }
        dataInicioEmissao = ToolDate.strToDate((String)"01/01/0001");
        String query = "select    s.R_ID_TITULO as F_ID_TITULO,    s.R_ID_PESSOA_GRUPO as F_ID_PESSOA,    s.R_NOME as F_NOME_PESSOA,    s.R_DATA_VENCIMENTO as F_DATA_VENCIMENTO,    sum(s.R_VALOR_TITULO) as F_VALOR_TITULO,    sum(s.R_DESCONTO_FINANCEIRO) AS F_VALOR_DESC_FINANCEIRO,    sum(s.R_VALOR_BAIXA) as F_VALOR_BAIXA,    sum(s.R_VR_JUROS) as F_VALOR_JUROS,    sum(s.R_VR_DESCONTO) as F_VALOR_DESCONTO,    sum(s.R_VR_ATUALIZACAO_MONETARIA) as F_VALOR_AT_MONETARIA,    sum(s.R_VR_DESP_BANCARIA_PAGA) as F_VALOR_DESP_BANCARIA_PAG,    sum(s.R_VR_DESP_BANCARIA_REC) as F_VALOR_DESP_BANCARIA_REC,    sum(s.R_VR_MULTA) AS F_VALOR_MULTA,    sum(s.R_VR_PIS) AS F_VALOR_PIS,    sum(s.R_VR_COFINS) AS F_VALOR_COFINS,    sum(s.R_VR_OPERACAO) AS F_VALOR_OPERACAO,    sum(s.R_VR_CONTRIB_SOCIAL) AS F_VALOR_CONTRIB_SOCIAL,    sum(s.R_VALOR_SALDO) AS F_VALOR_SALDO,    sum(s.R_VALOR_JUROS_ATRAS) AS F_VALOR_JUROS_ATRAS,    sum(s.R_VALOR_DESCONTO_ADIAN)AS F_VALOR_DESCONTO_ADIAN,    sum(s.R_VALOR_SALDO_LIQUIDO) AS F_VALOR_SALDO_LIQUIDO,    sum(s.R_VALOR_BAIXA_RENEGOCIACAO) AS F_VALOR_BAIXA_RENEGOCIACAO from proc_saldo_titulos( :dataSaldo, :dataInicioEmissao, :idPessoaIn,:idPessoaFim, :idCartIn,:idCartFim, :dataVencIn, :dataVencFim, :idEmpIn, :idEmpFim, :idGrupoEmp, :dataCompIn,:dataCompFim, :provReal,:pagRec, :tipoRetorno, :tipoPessoaGrupoPessoa)s group by s.R_ID_PESSOA_GRUPO, s.r_nome,s.R_ID_TITULO, s.R_DATA_VENCIMENTO";
        NativeQuery q = this.sqlQuery(query);
        q.setDate("dataSaldo", dataSaldo);
        q.setDate("dataInicioEmissao", dataInicioEmissao);
        q.setParameter("idPessoaIn", (Object)idPessoaIn);
        q.setParameter("idPessoaFim", (Object)idPessoaFim);
        q.setParameter("idCartIn", (Object)idCarteiraIn);
        q.setParameter("idCartFim", (Object)idCarteiraFim);
        q.setParameter("dataVencIn", (Object)dataVencIn);
        q.setParameter("dataVencFim", (Object)dataVencFim);
        q.setParameter("idEmpIn", (Object)idEmpresaIn);
        q.setParameter("idEmpFim", (Object)idEmpresaFim);
        q.setParameter("idGrupoEmp", (Object)idGrupoEmpresa);
        q.setParameter("dataCompIn", (Object)dataCompIn);
        q.setParameter("dataCompFim", (Object)dataCompFim);
        q.setParameter("provReal", (Object)provReal.value);
        q.setParameter("pagRec", (Object)tipoPagRec.value);
        q.setParameter("tipoRetorno", (Object)tipoSaldoRet.value);
        q.setParameter("tipoPessoaGrupoPessoa", (Object)tipoPessoaGrupo.value);
        q.setResultTransformer((ResultTransformer)this.SALDO_FINANCEIRO_PESSOA_TITULO_RES_TRANSFORMER);
        if (firstRegister != null && firstRegister > 0 && maxResult != null && maxResult > 0) {
            q.setFirstResult(firstRegister.intValue());
            q.setMaxResults(maxResult.intValue());
        }
        return q.list();
    }

    public SaldoFinanceiroPessoa getSaldoTitulosAVencer(Date dataInicioEmissao, Long idPessoa, Long idCarteiraIn, Long idCarteiraFim, Long idEmpresaIn, Long idEmpresaFim, Long idGrupoEmpresa, EnumConstSaldoTitPagRec pagRec, Date dataCompIn, Date dataCompFim, Integer diasTolerancia, EnumConstSaldoTitPessoaGrupoPessoa tipoPessoaGrupoPessoa) {
        Date vencFinal;
        Date vencInicial = ToolDate.nextDays((Date)new Date(), (int)1);
        List<SaldoFinanceiroPessoa> ret = this.getResumoFinanceiroPessoas(new Date(), dataInicioEmissao, idPessoa, idPessoa, idCarteiraIn, idCarteiraFim, vencInicial, vencFinal = ToolDate.strToDate((String)"01/01/2999"), idEmpresaIn, idEmpresaFim, idGrupoEmpresa, dataCompIn, dataCompFim, pagRec, EnumConstSaldoTitProvReal.TIPO_TITULO_REALIZADO, EnumConstSaldoTitTipoRet.TIPO_SALDO_ABERTO, null, null, tipoPessoaGrupoPessoa);
        if (ret != null && !ret.isEmpty()) {
            return ret.get(0);
        }
        SaldoFinanceiroPessoa s = new SaldoFinanceiroPessoa();
        s.setIdPessoa(idPessoa);
        return s;
    }

    public Double getSaldoTitulo(Titulo titulo, Date dataConsulta) {
        Query q = this.query("select (sum(b.valor)) from BaixaTitulo  b inner join b.grupoDeBaixaFormas gf     inner join gf.grupoDeBaixa g where b.titulo =:titulo and g.dataLiquidacao <=:dataConsulta");
        q.setEntity("titulo", (Object)titulo);
        q.setDate("dataConsulta", dataConsulta);
        Double valorBaixa = (Double)q.uniqueResult();
        valorBaixa = valorBaixa == null ? 0.0 : valorBaixa;
        return titulo.getValor() - valorBaixa;
    }

    public Double getSaldoTitulo(Titulo titulo) {
        return this.getSaldoTitulo(titulo, new Date());
    }

    public List<Titulo> getTitulosAbertosPorPessoa(Long idPessoa, EnumConstSaldoTitPagRec pagRec, EnumConstSaldoTitProvReal provisionado, EnumConstSaldoTitPessoaGrupoPessoa tipoPessoaGrupo) {
        if (tipoPessoaGrupo.getValue() == EnumConstSaldoTitPessoaGrupoPessoa.TIPO_PESSOA.getValue()) {
            Query q = this.query("select distinct b from Titulo  b where b.pessoa.identificador =:idPessoa and b.pagRec = :pagRec and b.provisao = :provisao and b.valorSaldo > 0");
            q.setLong("idPessoa", idPessoa.longValue());
            q.setInteger("pagRec", pagRec.getValue());
            q.setInteger("provisao", provisionado.getValue());
            return q.list();
        }
        Query q = this.query("select distinct b from Titulo  b inner join b.pessoa p  inner join p.grupoPessoas g  where g.identificador =:idGrupoPessoa and b.pagRec = :pagRec and b.provisao = :provisao and b.valorSaldo > 0");
        q.setLong("idGrupoPessoa", idPessoa.longValue());
        q.setInteger("pagRec", pagRec.getValue());
        q.setInteger("provisao", provisionado.getValue());
        return q.list();
    }

    public List<SaldoFinanceiroTituloPessoa> getSaldoTitulosPessoas(Date dataSaldo, Date dataInicioEmissao, Long idPessoaIn, Long idPessoaFim, String carteiras, Date dataIn, Date dataFim, Long idEmpresaIn, Long idEmpresaFim, Long idGrupoEmpresa, Date dataVencIn, Date dataVencFim, EnumConstSaldoTitPagRec tipoPagRel, EnumConstSaldoTitProvReal tipoProvRel, EnumConstSaldoTitTipoRet tipoSaldoRet, Integer firstReg, Integer nrReg, EnumConstSaldoTitPessoaGrupoPessoa tipoSaldoPessoaGrupo) {
        if (tipoSaldoRet == null) {
            tipoSaldoRet = EnumConstSaldoTitTipoRet.TIPO_SALDO_ABERTO;
        }
        if (tipoProvRel == null) {
            tipoProvRel = EnumConstSaldoTitProvReal.TIPO_TITULO_TODOS;
        }
        if (tipoPagRel == null) {
            tipoPagRel = EnumConstSaldoTitPagRec.TIPO_TITULO_TODOS;
        }
        dataInicioEmissao = ToolDate.strToDate((String)"01/01/0001");
        Object query = "select    s.R_ID_TITULO as F_ID_TITULO,    s.R_ID_PESSOA_GRUPO as F_ID_PESSOA,    s.R_NOME as F_NOME_PESSOA,    s.R_ID_CARTEIRA as F_ID_CARTEIRA,    sum(s.R_VALOR_TITULO) as F_VALOR_TITULO,    sum(s.R_DESCONTO_FINANCEIRO) AS F_VALOR_DESC_FINANCEIRO,    sum(s.R_VALOR_BAIXA) as F_VALOR_BAIXA,    sum(s.R_VR_JUROS) as F_VALOR_JUROS,    sum(s.R_VR_DESCONTO) as F_VALOR_DESCONTO,    sum(s.R_VR_ATUALIZACAO_MONETARIA) as F_VALOR_AT_MONETARIA,    sum(s.R_VR_DESP_BANCARIA_PAGA) as F_VALOR_DESP_BANCARIA_PAG,    sum(s.R_VR_DESP_BANCARIA_REC) as F_VALOR_DESP_BANCARIA_REC,    sum(s.R_VR_MULTA) AS F_VALOR_MULTA,    sum(s.R_VR_PIS) AS F_VALOR_PIS,    sum(s.R_VR_COFINS) AS F_VALOR_COFINS,    sum(s.R_VR_OPERACAO) AS F_VALOR_OPERACAO,    sum(s.R_VR_CONTRIB_SOCIAL) AS F_VALOR_CONTRIB_SOCIAL,    sum(s.R_VALOR_SALDO) AS F_VALOR_SALDO,    sum(s.R_VALOR_JUROS_ATRAS) AS F_VALOR_JUROS_ATRAS,    sum(s.R_VALOR_DESCONTO_ADIAN)AS F_VALOR_DESCONTO_ADIAN,    sum(s.R_VALOR_SALDO_LIQUIDO) AS F_VALOR_SALDO_LIQUIDO,    sum(s.R_VALOR_BAIXA_RENEGOCIACAO) AS F_VALOR_BAIXA_RENEGOCIACAO from proc_saldo_titulos( :dataSaldo, :dataInicioEmissao, :idPessoaIn,:idPessoaFim, :idCartIn,:idCartFim, :dataVencIn, :dataVencFim, :idEmpIn, :idEmpFim, :idGrupoEmp, :dataCompIn,:dataCompFim, :provReal,:pagRec, :tipoRetorno, :tipoPessoaGrupoPessoa)s";
        Object[] carteirasInt = ToolString.splitStringAsInteger((String)carteiras, (char[])new char[0]);
        if (carteirasInt.length > 0) {
            query = (String)query + " where s.R_ID_CARTEIRA in(:carteiras) ";
        }
        try {
            query = (String)query + " group by s.R_ID_PESSOA_GRUPO, s.r_nome,s.R_ID_TITULO, s.R_ID_CARTEIRA";
            NativeQuery q = this.sqlQuery((String)query);
            q.setDate("dataSaldo", dataSaldo);
            q.setDate("dataInicioEmissao", dataInicioEmissao);
            q.setParameterList("carteiras", carteirasInt);
            q.setParameter("idPessoaIn", (Object)idPessoaIn);
            q.setParameter("idPessoaFim", (Object)idPessoaFim);
            q.setParameter("idCartIn", null);
            q.setParameter("idCartFim", null);
            q.setParameter("dataVencIn", (Object)dataVencIn);
            q.setParameter("dataVencFim", (Object)dataVencFim);
            q.setParameter("idEmpIn", (Object)idEmpresaIn);
            q.setParameter("idEmpFim", (Object)idEmpresaFim);
            q.setParameter("idGrupoEmp", (Object)idGrupoEmpresa);
            q.setParameter("dataCompIn", null);
            q.setParameter("dataCompFim", null);
            q.setParameter("provReal", (Object)tipoProvRel.getValue());
            q.setParameter("pagRec", (Object)tipoPagRel.getValue());
            q.setParameter("tipoRetorno", (Object)tipoSaldoRet.getValue());
            q.setParameter("tipoPessoaGrupoPessoa", (Object)tipoSaldoPessoaGrupo.getValue());
            q.setResultTransformer((ResultTransformer)new SaldoFinanceiroPessoaTituloResultTransformer());
            if (firstReg != null && firstReg > 0 && nrReg != null && nrReg > 0) {
                q.setFirstResult(firstReg.intValue());
                q.setMaxResults(nrReg.intValue());
            }
            return q.list();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }
}

