/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.ServicoRPS;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.Criteria;
import org.springframework.stereotype.Repository;

@Repository
public class DaoServicoRPSImpl
extends DaoGenericEntityImpl<ServicoRPS, Long> {
    public List<ServicoRPS> findServicosRpsFromModeloRPS(Long idModeloRps) {
        CriteriaBuilder builder = this.criteriaBuilder(ServicoRPS.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root fromServicoRPS = crit.from(ServicoRPS.class);
        Join jModeloRPS = fromServicoRPS.join("modeloRPS", JoinType.INNER);
        crit.select((Selection)fromServicoRPS);
        exps.add(builder.equal((Expression)jModeloRPS.get("identificador"), (Object)idModeloRps));
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }

    public ServicoRPS findServicoRpsByCodigoServico(String codigoServico, String codigoTributacaoMunicipio) {
        Criteria criteria = this.criteria();
        criteria.createAlias("grupoServicoRPS", "grupo");
        criteria.add(this.eq("grupo.codigoServico", codigoServico));
        criteria.add(this.eq("grupo.codigoTributos", codigoTributacaoMunicipio));
        criteria.setMaxResults(1);
        return (ServicoRPS)criteria.uniqueResult();
    }

    public ServicoRPS findServicosRpsFromProduto(Long idProduto) {
        return (ServicoRPS)this.query("SELECT s FROM ServicoRPS s INNER JOIN s.produtoFaturamentoRPS p WHERE p.produto.identificador = :idProduto").setParameter("idProduto", (Object)idProduto).setMaxResults(1).uniqueResult();
    }
}

