/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EventoOsProdSobEnc;
import com.touchcomp.basementor.model.vo.SubdivisaoOSProdSobEnc;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchvomodel.vo.ossobencomenda.DTOSubOsSobEncomendaRes;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.springframework.stereotype.Repository;

@Repository
public class DaoSubdivisaoOSProdSobEncImpl
extends DaoGenericEntityImpl<SubdivisaoOSProdSobEnc, Long> {
    public DTOSubOsSobEncomendaRes getDadosBasicosOSAbertaCodBarras(String codigo, Empresa empresa, EnumConstantsMentorSimNao filtrarEmpresa) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        if (filtrarEmpresa == null || ToolMethods.isAffirmative((Number)filtrarEmpresa.getValue())) {
            Join jOS = aux.join("ordemServicoProdSobEnc");
            return this.getDadosBasicosOSCodBarrasBuilder(aux, aux.equal((From)jOS, "empresa", empresa), aux.equal("codigoBarras", codigo), aux.isNull("dataFechamento"));
        }
        return this.getDadosBasicosOSCodBarrasBuilder(aux, aux.equal("codigoBarras", codigo), aux.isNull("dataFechamento"));
    }

    public DTOSubOsSobEncomendaRes getDadosBasicosAbertaOS(Long codigoOs, Short codigoSubOs, Empresa empresa, EnumConstantsMentorSimNao filtrarEmpresa) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jOS = aux.join("ordemServicoProdSobEnc");
        if (filtrarEmpresa == null || ToolMethods.isAffirmative((Number)filtrarEmpresa.getValue())) {
            return this.getDadosBasicosOSCodBarrasBuilder(aux, aux.equal("nrOrdem", codigoSubOs), aux.equal((From)jOS, "empresa", empresa), aux.isNull("dataFechamento"), aux.equal((From)jOS, "codigo", codigoOs));
        }
        return this.getDadosBasicosOSCodBarrasBuilder(aux, aux.equal("nrOrdem", codigoSubOs), aux.isNull("dataFechamento"), aux.equal((From)jOS, "codigo", codigoOs));
    }

    private DTOSubOsSobEncomendaRes getDadosBasicosOSCodBarrasBuilder(AuxCriteriaBuilder aux, Predicate ... preds) {
        Join jOS = aux.join("ordemServicoProdSobEnc");
        Join jGradeCor = aux.join((From)jOS, "gradeCor");
        Join jCor = aux.join((From)jGradeCor, "cor");
        Join jProdGrade = aux.join((From)jGradeCor, "produtoGrade");
        Join jProd = aux.join((From)jProdGrade, "produto");
        Join jProdUN = aux.join((From)jProd, "unidadeMedida");
        Join jFaseProd = aux.join("faseProdutiva");
        Join jCelProd = aux.join((From)jFaseProd, "celulaProdutiva");
        aux.where(preds);
        AuxCriteriaBuilder.Pair[] pairArray = new AuxCriteriaBuilder.Pair[13];
        pairArray[0] = AuxCriteriaBuilder.pair("codigoBarras", "CODIGO_BARRAS");
        pairArray[1] = AuxCriteriaBuilder.pair((From)jOS, "codigo", "CODIGO_OS");
        pairArray[2] = AuxCriteriaBuilder.pair((From)jProd, "codigoAuxiliar", "CODIGO_PRODUTO");
        pairArray[3] = AuxCriteriaBuilder.pair("nrOrdem", "CODIGO_SUB_OS");
        pairArray[4] = AuxCriteriaBuilder.pair("dataPrevFechamento", "DATA_PREVISAO");
        pairArray[5] = AuxCriteriaBuilder.pair((From)jCor, "nome", "GRADE_COR");
        pairArray[6] = AuxCriteriaBuilder.pair("identificador", "ID_SUB_OS");
        pairArray[7] = AuxCriteriaBuilder.pair((From)jGradeCor, "identificador", "ID_GRADE_COR");
        pairArray[8] = AuxCriteriaBuilder.pair((From)jProd, "identificador", "ID_PRODUTO");
        pairArray[9] = AuxCriteriaBuilder.pair((From)jProd, "nome", "PRODUTO");
        pairArray[10] = AuxCriteriaBuilder.pair((From)jProdUN, "sigla", "UN");
        pairArray[11] = AuxCriteriaBuilder.pair((From)jFaseProd, "descricaoAuxiliar", "DESC_AUXILIAR");
        pairArray[12] = AuxCriteriaBuilder.pair((From)jCelProd, "descricao", "CELULA");
        aux.select(pairArray);
        Map data = aux.getUniqueResultMap();
        if (data == null) {
            return null;
        }
        DTOSubOsSobEncomendaRes dto = new DTOSubOsSobEncomendaRes();
        dto.setCodigoBarras((String)data.get("CODIGO_BARRAS"));
        dto.setCodigoOS((Long)data.get("CODIGO_OS"));
        dto.setCodigoAuxiliarProduto((String)data.get("CODIGO_PRODUTO"));
        dto.setCodigoSubOS((Short)data.get("CODIGO_SUB_OS"));
        dto.setDataPrevisao((Date)data.get("DATA_PREVISAO"));
        dto.setGradeCor((String)data.get("GRADE_COR"));
        dto.setIdentificador((Long)data.get("ID_SUB_OS"));
        dto.setIdentificadorGradeCor((Long)data.get("ID_GRADE_COR"));
        dto.setIdentificadorProduto((Long)data.get("ID_PRODUTO"));
        dto.setProduto((String)data.get("PRODUTO"));
        dto.setUnidadeMedidaProduto((String)data.get("UN"));
        dto.setCelulaProdutiva((String)data.get("CELULA"));
        dto.setDescricaoAuxFaseProd((String)data.get("DESC_AUXILIAR"));
        return dto;
    }

    public List<Map<String, Object>> getEquipamentos(Short pesquisaDinamica, Long idSubOS, String query) {
        CriteriaBuilder builder = this.criteriaBuilder(SubdivisaoOSProdSobEnc.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root root = crit.from(SubdivisaoOSProdSobEnc.class);
        Join jFaseProdutiva = root.join("faseProdutiva", JoinType.INNER);
        Join jEquipamentos = jFaseProdutiva.join("equipamentos", JoinType.INNER);
        Join jCelProdutivaEquip = jEquipamentos.join("celProdutivaEquip", JoinType.INNER);
        Join jEquipamento = jCelProdutivaEquip.join("equipamento", JoinType.INNER);
        exps.add(builder.equal((Expression)root.get("identificador"), (Object)idSubOS));
        exps.add(builder.equal((Expression)jCelProdutivaEquip.get("ativo"), (Object)EnumConstantsMentorSimNao.SIM.getValue()));
        exps.add(builder.equal((Expression)jEquipamento.get("ativo"), (Object)EnumConstantsMentorSimNao.SIM.getValue()));
        if (ToolMethods.isAffirmative((Number)pesquisaDinamica)) {
            if (ToolString.isALongNumber((String)query)) {
                exps.add(builder.equal((Expression)jEquipamento.get("identificador"), (Object)Long.valueOf(query)));
            } else {
                exps.add(builder.or((Expression)builder.like((Expression)jEquipamento.get("codigo"), "%" + query.toUpperCase() + "%"), (Expression)builder.like((Expression)jEquipamento.get("nome"), "%" + query.toUpperCase() + "%")));
            }
        }
        Subquery subquery = crit.subquery(EventoOsProdSobEnc.class);
        Root rootSub = subquery.from(EventoOsProdSobEnc.class);
        Join jSubEquipamentos = rootSub.join("equipamentos", JoinType.INNER);
        Join jSubFaseProdutivaEquip = jSubEquipamentos.join("faseProdutivaEquip", JoinType.INNER);
        Join jSubCelProdutivaEquip = jSubFaseProdutivaEquip.join("celProdutivaEquip", JoinType.INNER);
        Join jSubEquipamento = jSubCelProdutivaEquip.join("equipamento", JoinType.INNER);
        subquery.where((Expression)builder.and(new Predicate[]{builder.equal((Expression)jEquipamento.get("identificador"), (Expression)jSubEquipamento.get("identificador")), builder.isNull((Expression)rootSub.get("dataFechamento")), builder.equal((Expression)jSubCelProdutivaEquip.get("naoPermitirMultiplaVinculacao"), (Object)EnumConstantsMentorSimNao.SIM.getValue())}));
        subquery.select((Expression)rootSub);
        exps.add(builder.not((Expression)builder.exists(subquery)));
        crit.multiselect(new Selection[]{jEquipamento.get("identificador").alias("identificadorEquipamento"), jEquipamento.get("codigo").alias("codigoEquipamento"), jEquipamento.get("nome").alias("nomeEquipamento")}).distinct(true);
        crit.where(exps.toArray(new Predicate[0]));
        List result = this.getEntityManager().createQuery(crit).getResultList();
        LinkedList<Map<String, Object>> aux = new LinkedList<Map<String, Object>>();
        if (result != null) {
            for (Object[] i : result) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("identificadorEquipamento", i[0]);
                map.put("codigoEquipamento", i[1]);
                map.put("nomeEquipamento", i[2]);
                aux.add(map);
            }
        }
        return aux;
    }

    public SubdivisaoOSProdSobEnc getByCodigoBarras(String codBarras) {
        return (SubdivisaoOSProdSobEnc)this.toUnique(this.restrictions(this.eq("codigoBarras", codBarras)));
    }
}

