/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.tipoproducao.EnumConstTipoProducao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EventoOsProducaoLinhaProd;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.PlanejamentoProdLinhaProd;
import com.touchcomp.basementor.model.vo.SubdivisaoOSProdLinhaProd;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.oslinhaprod.DTOSubOsLinhaProdRes;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository
public class DaoSubdivisaoOsProdLinProdImpl
extends DaoGenericEntityImpl<SubdivisaoOSProdLinhaProd, Long> {
    public Double getQuantidadeApontada(EnumConstTipoProducao enumConstTipoProducao, SubdivisaoOSProdLinhaProd subdivisaoOSProd) {
        org.hibernate.query.Query q = this.query("select sum(g.quantidade) from EventoOsProducaoLinhaProd e inner join e.comunicadoProducao c inner join c.itemComunicadoProducao i inner join i.gradeItemComunicadoProducao g where g.gradeCor = :gradeCor and e.subdivisaoOSProd = :sub and i.tipoProducao.tipo = :tipo ");
        q.setEntity("gradeCor", (Object)subdivisaoOSProd.getGradeCor());
        q.setEntity("sub", (Object)subdivisaoOSProd);
        q.setShort("tipo", enumConstTipoProducao.getValue());
        Double d = (Double)q.uniqueResult();
        return d != null ? d : 0.0;
    }

    public SubdivisaoOSProdLinhaProd getSubDivOsProducao(Long codOs, Short codSubOs, GradeCor gradeCor) {
        org.hibernate.query.Query q = this.query("SELECT s FROM SubdivisaoOSProdLinhaProd s INNER JOIN s.ordemServicoProdLinhaProd o WHERE o.codigo = :codOs AND s.nrOrdem = :codSubOs AND s.gradeCor = :gradeCor");
        q.setLong("codOs", codOs.longValue());
        q.setShort("codSubOs", codSubOs.shortValue());
        q.setEntity("gradeCor", (Object)gradeCor);
        return (SubdivisaoOSProdLinhaProd)q.uniqueResult();
    }

    public SubdivisaoOSProdLinhaProd getSubOsProducaoEmpresa(Long codOs, Short codSubOs, Empresa empresa) {
        org.hibernate.query.Query q = this.query("SELECT s FROM SubdivisaoOSProdLinhaProd s INNER JOIN s.ordemServicoProdLinhaProd o WHERE o.codigo = :codOs AND s.nrOrdem = :codSubOs AND o.empresa = :empresa");
        q.setLong("codOs", codOs.longValue());
        q.setShort("codSubOs", codSubOs.shortValue());
        q.setEntity("empresa", (Object)empresa);
        return (SubdivisaoOSProdLinhaProd)q.uniqueResult();
    }

    public List<SubdivisaoOSProdLinhaProd> getAltCriadas(Date lastDateSync, Long idGrupoProdutos) {
        Criteria crit = this.criteria();
        crit.createAlias("ordemServicoProdLinhaProd", "os");
        Disjunction d = Restrictions.or((Criterion[])new Criterion[0]);
        if (ToolMethods.isWithData((Number)idGrupoProdutos)) {
            crit.createAlias("gradeCor", "gc");
            crit.createAlias("gc.produtoGrade", "pg");
            crit.createAlias("pg.produto", "p");
            crit.createAlias("p.grupoProdutosRel", "gpr");
            crit.createAlias("gpr.grupoProdutosRel", "gp");
            crit.add(this.eq("gp.identificador", idGrupoProdutos));
            d.add(this.greatherEqual("gpr.dataAtualizacao", lastDateSync));
            d.add(this.greatherEqual("gp.dataAtualizacao", lastDateSync));
        }
        d.add(this.greatherEqual("dataAtualizacao", lastDateSync));
        d.add(this.greatherEqual("os.dataAtualizacao", lastDateSync));
        crit.add((Criterion)d);
        crit.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return crit.list();
    }

    public List<SubdivisaoOSProdLinhaProd> getSubOS(Date dataInicial, Date dataFinal, Empresa empresa) {
        org.hibernate.query.Query q = this.query("select s from SubdivisaoOSProdLinhaProd s inner join s.ordemServicoProdLinhaProd o where cast(s.dataFechamento as date) between :dataInicial and :dataFinal and o.empresa = :empresa");
        q.setParameter("empresa", (Object)empresa);
        q.setParameter("dataInicial", (Object)dataInicial);
        q.setParameter("dataFinal", (Object)dataFinal);
        return q.list();
    }

    public List<EventoOsProducaoLinhaProd> pesquisarEventosSubOS(SubdivisaoOSProdLinhaProd subDivisaoOSProd) {
        org.hibernate.query.Query q = this.query("SELECT e FROM EventoOsProducaoLinhaProd e WHERE e.subdivisaoOSProd = :subDivisaoOSProd");
        q.setEntity("subDivisaoOSProd", (Object)subDivisaoOSProd);
        return q.list();
    }

    public SubdivisaoOSProdLinhaProd getByGradeCor(GradeCor gradeCor) {
        return (SubdivisaoOSProdLinhaProd)this.toUnique(this.restrictions(this.eq("gradeCor", gradeCor)));
    }

    public SubdivisaoOSProdLinhaProd getSubOSAberta(GradeCor gradeCor) {
        return (SubdivisaoOSProdLinhaProd)this.toUnique(this.restrictions(this.eq("gradeCor", gradeCor), this.isNull("dataFechamento")));
    }

    public SubdivisaoOSProdLinhaProd getByCodigoBarras(String codBarrasLinha) {
        return (SubdivisaoOSProdLinhaProd)this.toUnique(this.restrictions(this.eq("codigoBarras", codBarrasLinha)));
    }

    public DTOSubOsLinhaProdRes getDadosBasicosOSAbertaCodBarras(String codigo, Empresa empresa) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jOS = aux.join("ordemServicoProdLinhaProd");
        return this.getDadosBasicosOSCodBarrasBuilder(aux, aux.equal((From)jOS, "empresa", empresa), aux.equal("codigoBarras", codigo), aux.isNull("dataFechamento"));
    }

    public DTOSubOsLinhaProdRes getDadosBasicosAbertaOS(Long codigoOs, Short codigoSubOs, Empresa empresa) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jOS = aux.join("ordemServicoProdLinhaProd");
        return this.getDadosBasicosOSCodBarrasBuilder(aux, aux.equal("nrOrdem", codigoSubOs), aux.isNull("dataFechamento"), aux.equal((From)jOS, "empresa", empresa), aux.equal((From)jOS, "codigo", codigoOs));
    }

    private DTOSubOsLinhaProdRes getDadosBasicosOSCodBarrasBuilder(AuxCriteriaBuilder aux, Predicate ... preds) {
        Join jOS = aux.join("ordemServicoProdLinhaProd");
        Join jGradeCor = aux.join((From)jOS, "gradeCor");
        Join jCor = aux.join((From)jGradeCor, "cor");
        Join jProdGrade = aux.join((From)jGradeCor, "produtoGrade");
        Join jProd = aux.join((From)jProdGrade, "produto");
        Join jProdUN = aux.join((From)jProd, "unidadeMedida");
        Join jRotProducao = aux.join("roteiroProducao");
        Join jRotProdFases = aux.join((From)jRotProducao, "fasesProdutivas");
        Join jRotProducaoFasesCel = aux.join((From)jRotProdFases, "celulaProdutiva");
        aux.where(preds);
        AuxCriteriaBuilder.Pair[] pairArray = new AuxCriteriaBuilder.Pair[14];
        pairArray[0] = AuxCriteriaBuilder.pair("codigoBarras", "CODIGO_BARRAS");
        pairArray[1] = AuxCriteriaBuilder.pair((From)jOS, "codigo", "CODIGO_OS");
        pairArray[2] = AuxCriteriaBuilder.pair((From)jProd, "codigoAuxiliar", "CODIGO_PRODUTO");
        pairArray[3] = AuxCriteriaBuilder.pair("nrOrdem", "CODIGO_SUB_OS");
        pairArray[4] = AuxCriteriaBuilder.pair("dataPrevisao", "DATA_PREVISAO");
        pairArray[5] = AuxCriteriaBuilder.pair((From)jCor, "nome", "GRADE_COR");
        pairArray[6] = AuxCriteriaBuilder.pair("identificador", "ID_SUB_OS");
        pairArray[7] = AuxCriteriaBuilder.pair((From)jGradeCor, "identificador", "ID_GRADE_COR");
        pairArray[8] = AuxCriteriaBuilder.pair((From)jProd, "identificador", "ID_PRODUTO");
        pairArray[9] = AuxCriteriaBuilder.pair((From)jProd, "nome", "PRODUTO");
        pairArray[10] = AuxCriteriaBuilder.pair((From)jProdUN, "sigla", "UN");
        pairArray[11] = AuxCriteriaBuilder.pair((From)jRotProdFases, "identificador", "ID_FASE_PRODUTIVA");
        pairArray[12] = AuxCriteriaBuilder.pair((From)jRotProducaoFasesCel, "descricao", "CELULA_PRODUTIVA");
        pairArray[13] = AuxCriteriaBuilder.pair((From)jRotProdFases, "descricaoAuxiliar", "DESC_AUXILIAR_FASE");
        aux.select(pairArray);
        List<Map<String, Object>> res = aux.getResultMap();
        if (res == null) {
            return null;
        }
        DTOSubOsLinhaProdRes dto = null;
        for (Map<String, Object> data : res) {
            if (dto == null) {
                dto = new DTOSubOsLinhaProdRes();
                dto.setCodigoBarras((String)data.get("CODIGO_BARRAS"));
                dto.setCodigoOS((Long)data.get("CODIGO_OS"));
                dto.setCodigoAuxiliarProduto((String)data.get("CODIGO_PRODUTO"));
                dto.setCodigoSubOS((Short)data.get("CODIGO_SUB_OS"));
                dto.setDataPrevisao((Date)data.get("DATA_PREVISAO"));
                dto.setGradeCor((String)data.get("GRADE_COR"));
                dto.setIdentificador((Long)data.get("ID_SUB_OS"));
                dto.setIdentificadorGradeCor((Long)data.get("ID_GRADE_COR"));
                dto.setIdentificadorProduto((Long)data.get("ID_PRODUTO"));
                dto.setProduto((String)data.get("PRODUTO"));
                dto.setUnidadeMedidaProduto((String)data.get("UN"));
            }
            DTOSubOsLinhaProdRes.DTOFaseProdutiva faseProd = new DTOSubOsLinhaProdRes.DTOFaseProdutiva();
            faseProd.setDescricao((String)data.get("CELULA_PRODUTIVA"));
            faseProd.setFaseProdutiva((String)data.get("DESC_AUXILIAR_FASE"));
            faseProd.setIdentificadorFaseProdutiva((Long)data.get("ID_FASE_PRODUTIVA"));
            dto.getFasesProdutivas().add(faseProd);
        }
        return dto;
    }

    public List<Map<String, Object>> getEquipamentos(Long idSubOS, Long idFaseProdutiva) {
        org.hibernate.query.Query q = this.query("   SELECT eq.identificador as identificadorEquipamento,                eq.codigo as codigoEquipamento,                eq.nome as nomeEquipamento         FROM SubdivisaoOSProdLinhaProd s         inner join s.roteiroProducao r         inner join r.fasesProdutivas fp         inner join fp.equipamentos e         inner join e.celProdutivaEquip cpe         inner join cpe.equipamento eq         WHERE s.identificador = :idSubOS               and fp.identificador = :idFaseProdutiva               and cpe.ativo = :SIM               and eq.ativo = :SIM         and not exists(                         SELECT evt.identificador                         FROM EventoOsProducaoLinhaProd evt                         inner join evt.equipamentos evtEquips                          inner join evtEquips.faseProdutivaEquip evef                         inner join evef.celProdutivaEquip celulaEquipamento                         inner join celulaEquipamento.equipamento equip                          WHERE eq.identificador = equip.identificador and evt.dataFechamento is null and celulaEquipamento.naoPermitirMultiplaVinculacao = :SIM )");
        q.setLong("idSubOS", idSubOS.longValue());
        q.setLong("idFaseProdutiva", idFaseProdutiva.longValue());
        q.setShort("SIM", EnumConstantsMentorSimNao.SIM.getValue());
        return this.toHashList((Query)q);
    }

    public List<Map<String, Object>> getFormProdPSubOS(Short filtraProduto, Long prodInicial, Long prodFinal, Short filtraData, Date dataInicial, Date dataFinal, Short filtraEspecie, Long especieInicial, Long especieFinal, Short filtraSubEspecie, Long subEspecieInicial, Long subEspecieFinal, Short filtraFabricante, Long fabricanteInicial, Long fabricanteFinal, Long periodoProducao, PlanejamentoProdLinhaProd pl) {
        Object st = "select pr.identificador as ID_PRODUTO, pr.codigoAuxiliar as CODIGO_AUXILIAR, pr.nome as PRODUTO, cor.nome as GRADE, gc.identificador as ID_GRADE_COR, sum(((cast(itForm.percAdicional as double)/100 * cast(itForm.quantidade as double)) +itForm.quantidade) * s.quantidadeRefPrevProd) as QUANTIDADE, pr.qtdMin as QTD_MIN, pr.qtdMax as QTD_MAX, esp.nome as ESPECIE, sub.nome as SUB_ESPECIE, unid.sigla as UNIDADE_MEDIDA, pr.pontoRessupEstoque as PTO_RESSUPRIMENTO, parc.identificador as PARCEIRO  from SubdivisaoOSProdLinhaProd s inner join s.gradeFormulaProduto form inner join form.itemGradeFormulaProduto itForm inner join itForm.gradeCor gc inner join gc.cor cor inner join gc.produtoGrade pg inner join pg.produto pr inner join pr.unidadeMedida unid inner join pr.especie esp inner join pr.subEspecie sub inner join pr.fabricante fab inner join s.ordemServicoProdLinhaProd o inner join o.periodoProducao periodo left join o.pessoaParceiro parc left join o.itemPlanProducaoOSLinProd i left join i.itemPlanejamentoProducao ip left join ip.planejamentoProdLinProd p where s.dataFechamento is null and periodo.identificador = :periodo ";
        if (TMethods.isAffirmative((Number)filtraData)) {
            st = (String)st + " and s.dataPrevisao between :dataInicial and :dataFinal";
        }
        if (TMethods.isAffirmative((Number)filtraProduto)) {
            st = (String)st + " and pr.identificador between :idInicial and :idFinal";
        }
        if (TMethods.isAffirmative((Number)filtraEspecie)) {
            st = (String)st + " and esp.identificador between :idEspecieInicial and :idEspecieFinal";
        }
        if (TMethods.isAffirmative((Number)filtraSubEspecie)) {
            st = (String)st + " and sub.identificador between :idSubEspecieInicial and :idSubEspecieFinal";
        }
        if (TMethods.isAffirmative((Number)filtraFabricante)) {
            st = (String)st + " and fab.identificador between :idFabricanteInicial and :idFabricanteFinal";
        }
        if (pl != null && pl.getIdentificador() > 0L) {
            st = (String)st + " and p.identificador<>:planejamento";
        }
        st = (String)st + " group by pr.identificador, pr.codigoAuxiliar, pr.nome, cor.nome, gc.identificador, pr.qtdMin, pr.qtdMax, pr.pontoRessupEstoque, esp.nome, unid.sigla, sub.nome, parc.identificador";
        st = (String)st + " order by pr.nome";
        org.hibernate.query.Query q = this.query((String)st);
        q.setParameter("periodo", (Object)periodoProducao);
        if (TMethods.isAffirmative((Number)filtraData)) {
            q.setParameter("dataInicial", (Object)dataInicial);
            q.setParameter("dataFinal", (Object)dataFinal);
        }
        if (TMethods.isAffirmative((Number)filtraProduto)) {
            q.setParameter("idInicial", (Object)prodInicial);
            q.setParameter("idFinal", (Object)prodFinal);
        }
        if (TMethods.isAffirmative((Number)filtraEspecie)) {
            q.setParameter("idEspecieInicial", (Object)especieInicial);
            q.setParameter("idEspecieFinal", (Object)especieFinal);
        }
        if (TMethods.isAffirmative((Number)filtraSubEspecie)) {
            q.setParameter("idSubEspecieInicial", (Object)subEspecieInicial);
            q.setParameter("idSubEspecieFinal", (Object)subEspecieFinal);
        }
        if (TMethods.isAffirmative((Number)filtraFabricante)) {
            q.setParameter("idFabricanteInicial", (Object)fabricanteInicial);
            q.setParameter("idFabricanteFinal", (Object)fabricanteFinal);
        }
        if (pl != null && pl.getIdentificador() > 0L) {
            q.setParameter("planejamento", (Object)pl.getIdentificador());
        }
        return this.toHashList((Query)q);
    }

    public List<Map<String, Object>> getPrevQtdProdFormProdPSubOS(Short filtraProduto, Long prodInicial, Long prodFinal, Short filtraData, Date dataInicial, Date dataFinal, Short filtraEspecie, Long especieInicial, Long especieFinal, Short filtraSubEspecie, Long subEspecieInicial, Long subEspecieFinal, Short filtraFabricante, Long fabricanteInicial, Long fabricanteFinal, Long periodoProducao) {
        Object st = "select p.identificador as ID_PRODUTO, p.codigoAuxiliar as CODIGO_AUXILIAR, p.nome as PRODUTO, c.nome as GRADE, gc.identificador as ID_GRADE_COR, sum(s.quantidadeRefPrevProd) as QTD_PREV_PRODUCAO, p.qtdMin as QTD_MIN, p.qtdMax as QTD_MAX, e.nome as ESPECIE, su.nome as SUB_ESPECIE, un.sigla as UNIDADE_MEDIDA, p.pontoRessupEstoque as PTO_RESSUPRIMENTO from SubdivisaoOSProdLinhaProd s inner join s.gradeFormulaProduto form inner join s.gradeCor gc inner join gc.cor c inner join gc.produtoGrade pg inner join pg.produto p inner join p.especie e inner join p.subEspecie su inner join p.fabricante f inner join p.unidadeMedida un inner join s.ordemServicoProdLinhaProd os inner join os.periodoProducao pp where s.dataFechamento is null and pp.identificador = :periodo ";
        if (TMethods.isAffirmative((Number)filtraData)) {
            st = (String)st + " and s.dataPrevisao between :dataInicial and :dataFinal";
        }
        if (TMethods.isAffirmative((Number)filtraProduto)) {
            st = (String)st + " and p.identificador between :idInicial and :idFinal";
        }
        if (TMethods.isAffirmative((Number)filtraEspecie)) {
            st = (String)st + " and e.identificador between :idEspecieInicial and :idEspecieFinal";
        }
        if (TMethods.isAffirmative((Number)filtraSubEspecie)) {
            st = (String)st + " and su.identificador between :idSubEspecieInicial and :idSubEspecieFinal";
        }
        if (TMethods.isAffirmative((Number)filtraFabricante)) {
            st = (String)st + " and f.identificador between :idFabricanteInicial and :idFabricanteFinal";
        }
        st = (String)st + " group by p.identificador, p.codigoAuxiliar, p.nome, c.nome, gc.identificador, p.qtdMin, p.qtdMax, p.pontoRessupEstoque, e.nome, un.sigla, su.nome";
        st = (String)st + " order by gc.identificador";
        org.hibernate.query.Query q = this.query((String)st);
        q.setParameter("periodo", (Object)periodoProducao);
        if (TMethods.isAffirmative((Number)filtraData)) {
            q.setParameter("dataInicial", (Object)dataInicial);
            q.setParameter("dataFinal", (Object)dataFinal);
        }
        if (TMethods.isAffirmative((Number)filtraProduto)) {
            q.setParameter("idInicial", (Object)prodInicial);
            q.setParameter("idFinal", (Object)prodFinal);
        }
        if (TMethods.isAffirmative((Number)filtraEspecie)) {
            q.setParameter("idEspecieInicial", (Object)especieInicial);
            q.setParameter("idEspecieFinal", (Object)especieFinal);
        }
        if (TMethods.isAffirmative((Number)filtraSubEspecie)) {
            q.setParameter("idSubEspecieInicial", (Object)subEspecieInicial);
            q.setParameter("idSubEspecieFinal", (Object)subEspecieFinal);
        }
        if (TMethods.isAffirmative((Number)filtraFabricante)) {
            q.setParameter("idFabricanteInicial", (Object)fabricanteInicial);
            q.setParameter("idFabricanteFinal", (Object)fabricanteFinal);
        }
        return this.toHashList((Query)q);
    }
}

