/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.TabelaINSS;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.Date;
import java.util.LinkedList;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoTabelaINSSImpl
extends DaoGenericEntityImpl<TabelaINSS, Long> {
    public Boolean verificarPeriodo(Date dataInicial, Date dataFinal, Long idINSS) {
        org.hibernate.query.Query q = this.query(" select t2.identificador from TabelaINSS t2 where :dataFinal >=  t2.dataInicial and :dataInicial <= t2.dataFinal and t2.identificador != :idINSS ");
        q.setParameter("dataInicial", (Object)dataInicial);
        q.setParameter("dataFinal", (Object)dataFinal);
        q.setParameter("idINSS", (Object)idINSS);
        return this.toUnique((Query)q) != null;
    }

    public TabelaINSS getTabelaInssPorPeriodoFolha(Date periodoFolha) {
        try {
            CriteriaBuilder builder = this.criteriaBuilder(TabelaINSS.class);
            CriteriaQuery crit = builder.createQuery();
            LinkedList<Predicate> exps = new LinkedList<Predicate>();
            Root fromTabelaINSS = crit.from(TabelaINSS.class);
            crit.select((Selection)fromTabelaINSS);
            exps.add(builder.between(builder.literal((Object)periodoFolha), (Expression)fromTabelaINSS.get("dataInicial"), (Expression)fromTabelaINSS.get("dataFinal")));
            crit.where(exps.toArray(new Predicate[0]));
            return (TabelaINSS)this.getEntityManager().createQuery(crit).getSingleResult();
        }
        catch (Exception e) {
            return null;
        }
    }

    public TabelaINSS getTabelaInssPorDataInicialFinal(Date dataInicial, Date dataFinal) {
        try {
            CriteriaBuilder builder = this.criteriaBuilder(TabelaINSS.class);
            CriteriaQuery crit = builder.createQuery();
            LinkedList<Predicate> exps = new LinkedList<Predicate>();
            Root fromTabelaINSS = crit.from(TabelaINSS.class);
            crit.select((Selection)fromTabelaINSS);
            exps.add(builder.lessThanOrEqualTo((Expression)fromTabelaINSS.get("dataInicial"), (Comparable)dataInicial));
            exps.add(builder.greaterThanOrEqualTo((Expression)fromTabelaINSS.get("dataFinal"), (Comparable)dataFinal));
            crit.where(exps.toArray(new Predicate[0]));
            return (TabelaINSS)this.getEntityManager().createQuery(crit).getSingleResult();
        }
        catch (Exception e) {
            return null;
        }
    }
}

