/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.TabelaIRRF;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.Date;
import java.util.LinkedList;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoTabelaIRRFImpl
extends DaoGenericEntityImpl<TabelaIRRF, Long> {
    public Boolean verificarPeriodo(Date dataInicial, Date dataFinal, Long idIRRF) {
        org.hibernate.query.Query q = this.query(" select t2.identificador from TabelaIRRF t2 where :dataFinal >=  t2.dataInicial and :dataInicial <= t2.dataFinal and t2.identificador != :idIRRF ");
        q.setParameter("dataInicial", (Object)dataInicial);
        q.setParameter("dataFinal", (Object)dataFinal);
        q.setParameter("idIRRF", (Object)idIRRF);
        return this.toUnique((Query)q) != null;
    }

    public TabelaIRRF getTabelaIrrfPorDataPagamento(Date dataPagamento) {
        try {
            CriteriaBuilder builder = this.criteriaBuilder(TabelaIRRF.class);
            CriteriaQuery crit = builder.createQuery();
            LinkedList<Predicate> exps = new LinkedList<Predicate>();
            Root fromTabelaIRRF = crit.from(TabelaIRRF.class);
            crit.select((Selection)fromTabelaIRRF);
            exps.add(builder.between(builder.literal((Object)dataPagamento), (Expression)fromTabelaIRRF.get("dataInicial"), (Expression)fromTabelaIRRF.get("dataFinal")));
            crit.where(exps.toArray(new Predicate[0]));
            return (TabelaIRRF)this.getEntityManager().createQuery(crit).getSingleResult();
        }
        catch (Exception e) {
            return null;
        }
    }
}

